/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.ide.actions.runAnything.RunAnythingAction;
import com.intellij.lang.javascript.buildTools.base.JsbtExecutor;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskSet;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import java.lang.ref.WeakReference;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsbtTaskRunAction
extends DumbAwareAction {
    private final WeakReference<Project> myProject;
    private final JsbtService myService;
    private final JsbtTaskSet myTaskSet;

    public JsbtTaskRunAction(@NotNull Project project, @NotNull JsbtService service, @NotNull JsbtTaskSet taskSet) {
        if (project == null) {
            JsbtTaskRunAction.$$$reportNull$$$0(0);
        }
        if (service == null) {
            JsbtTaskRunAction.$$$reportNull$$$0(1);
        }
        if (taskSet == null) {
            JsbtTaskRunAction.$$$reportNull$$$0(2);
        }
        super(null, null, service.getIcon());
        Presentation presentation = this.getTemplatePresentation();
        presentation.setText("Run '" + taskSet.getName() + "' " + service.getSearchEverywhereDescription(), false);
        this.myProject = new WeakReference<Project>(project);
        this.myService = service;
        this.myTaskSet = taskSet;
    }

    @Nullable
    public Project getProject() {
        return (Project)this.myProject.get();
    }

    @NotNull
    public JsbtTaskSet getTaskSet() {
        JsbtTaskSet jsbtTaskSet = this.myTaskSet;
        if (jsbtTaskSet == null) {
            JsbtTaskRunAction.$$$reportNull$$$0(3);
        }
        return jsbtTaskSet;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            JsbtTaskRunAction.$$$reportNull$$$0(4);
        }
        e.getPresentation().setEnabledAndVisible(e.getProject() == this.myProject.get());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            JsbtTaskRunAction.$$$reportNull$$$0(5);
        }
        if ((project = (Project)this.myProject.get()) != null && e.getProject() == project) {
            Executor executor = (Executor)e.getDataContext().getData(RunAnythingAction.EXECUTOR_KEY);
            executor = (Executor)ObjectUtils.notNull((Object)executor, (Object)DefaultRunExecutor.getRunExecutorInstance());
            new JsbtExecutor(project, this.myService, this.myTaskSet).execute(executor);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        JsbtTaskRunAction action = (JsbtTaskRunAction)((Object)o);
        return Objects.equals(this.myTaskSet, action.myTaskSet);
    }

    public int hashCode() {
        return Objects.hash(this.myTaskSet);
    }

    public void setIcon(@Nullable Icon icon) {
        this.getTemplatePresentation().setIcon(icon);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskSet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskRunAction";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskRunAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTaskSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

