/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.ecmascript6.psi.ES6ImportCall;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.TypeScriptAnnotatorCheckerProvider;
import com.intellij.lang.javascript.ecmascript6.TypeScriptMemberInfo;
import com.intellij.lang.javascript.ecmascript6.TypeScriptModifiersUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.ecmascript6.TypescriptConstructorChecker;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.highlighting.JSSemanticHighlightingUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDestructuringArrayRestElement;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSPsiReferenceElement;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGenericOrMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTupleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypePredicate;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.validation.JSAnnotatingVisitor;
import com.intellij.lang.javascript.validation.JSAnnotatorProblemReporter;
import com.intellij.lang.javascript.validation.JSConstructorChecker;
import com.intellij.lang.javascript.validation.TypedJSAnnotatingVisitor;
import com.intellij.lang.javascript.validation.fixes.ReplacePsiElementFix;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptAnnotatingVisitor
extends TypedJSAnnotatingVisitor {
    public TypeScriptAnnotatingVisitor(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(1);
        }
        super(psiElement, holder);
    }

    @Override
    @NotNull
    protected JSConstructorChecker createConstructorChecker() {
        TypescriptConstructorChecker typescriptConstructorChecker = new TypescriptConstructorChecker(this.myProblemReporter);
        if (typescriptConstructorChecker == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(2);
        }
        return typescriptConstructorChecker;
    }

    @Override
    @NotNull
    protected JSAnnotatorProblemReporter createProblemReporter(PsiElement context) {
        TypeScriptAnnotatorCheckerProvider provider2 = TypeScriptAnnotatorCheckerProvider.getCheckerProvider(context);
        JSAnnotatorProblemReporter jSAnnotatorProblemReporter = provider2.getProblemReporter(this.myHolder);
        if (jSAnnotatorProblemReporter == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(3);
        }
        return jSAnnotatorProblemReporter;
    }

    @Override
    public void visitComment(PsiComment comment) {
        super.visitComment(comment);
        if (comment.getNode().getElementType() == JSTokenTypes.END_OF_LINE_COMMENT) {
            this.checkReferences((PsiElement)comment, ProblemHighlightType.ERROR);
            JSFixFactory.getInstance().typeScriptReferencePathValidator().checkReferences(comment, this.myHolder, !TypeScriptAnnotatingVisitor.skipTypeChecking((PsiElement)comment));
        }
    }

    @Override
    protected boolean checkReferences(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(4);
        }
        if (TypeScriptPsiUtil.isLiteralModuleAugmentationName(element) || element.getParent() instanceof ES6ImportCall) {
            return false;
        }
        return super.checkReferences(element);
    }

    @Override
    protected void checkImplementedMethods(@NotNull JSClass jsClass, JSAnnotatingVisitor.ErrorReportingClient reportingClient) {
        Map<TypeScriptMemberInfo, JSClass> membersToImplement;
        if (jsClass == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(5);
        }
        if ((membersToImplement = TypeScriptUtil.getUnimplementedMembers(jsClass, false)).isEmpty()) {
            return;
        }
        boolean isAbstractClass = TypeScriptPsiUtil.isAbstractElement((JSAttributeListOwner)jsClass);
        IntentionAction implementAllFix = JSFixFactory.getInstance().typeScriptImplementMembersFix(jsClass);
        IntentionAction implementAbstractFix = JSFixFactory.getInstance().typeScriptImplementMembersAbstractFix(jsClass);
        for (Map.Entry<TypeScriptMemberInfo, JSClass> entry : membersToImplement.entrySet()) {
            ASTNode classKeyword;
            JSClass containerClass = entry.getValue();
            String interfaceName = containerClass.getName();
            JSElement memberToImplement = entry.getKey().getElement();
            String message = TypeScriptAnnotatingVisitor.getErrorMessageForNotImplementedError(containerClass, interfaceName, memberToImplement);
            assert (message != null);
            PsiElement nameIdentifier = jsClass.getNameIdentifier();
            if (nameIdentifier == null && (classKeyword = jsClass.getNode().findChildByType(JSTokenTypes.CLASS_KEYWORD)) != null) {
                nameIdentifier = classKeyword.getPsi();
            }
            if (nameIdentifier == null) {
                nameIdentifier = jsClass.getFirstChild();
            }
            if (isAbstractClass) {
                this.myProblemReporter.registerProblem(nameIdentifier, message, ProblemHighlightType.GENERIC_ERROR, implementAllFix, implementAbstractFix);
                continue;
            }
            this.myProblemReporter.registerProblem(nameIdentifier, message, ProblemHighlightType.GENERIC_ERROR, implementAllFix);
        }
    }

    @Nullable
    private static String getErrorMessageForNotImplementedError(@NotNull JSClass containerClass, @Nullable String interfaceName, @NotNull JSElement memberToImplement) {
        if (containerClass == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(6);
        }
        if (memberToImplement == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(7);
        }
        boolean isFunction = TypeScriptUtil.isTypeScriptMethod((PsiElement)memberToImplement);
        boolean isProperty = TypeScriptUtil.isTypeScriptProperty((PsiElement)memberToImplement);
        if (isFunction || isProperty || memberToImplement instanceof JSLocalImplicitElementImpl) {
            String messageId = TypeScriptAnnotatingVisitor.getMessageIdForNotImplementedError(containerClass, isFunction);
            return JSBundle.message((String)messageId, (Object[])new Object[]{memberToImplement.getName(), interfaceName});
        }
        if (memberToImplement instanceof TypeScriptCallSignature) {
            return JSBundle.message((String)"javascript.validation.message.interface.call.signature.not.implemented", (Object[])new Object[]{interfaceName});
        }
        if (memberToImplement instanceof TypeScriptIndexSignature) {
            return JSBundle.message((String)"javascript.validation.message.interface.index.signature.not.implemented", (Object[])new Object[]{interfaceName});
        }
        return null;
    }

    @NotNull
    private static String getMessageIdForNotImplementedError(@NotNull JSClass containerClass, boolean isFunction) {
        if (containerClass == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(8);
        }
        if (isFunction) {
            if (containerClass instanceof TypeScriptClass) {
                if ("javascript.validation.message.class.method.not.implemented" == null) {
                    TypeScriptAnnotatingVisitor.$$$reportNull$$$0(9);
                }
                return "javascript.validation.message.class.method.not.implemented";
            }
            if ("javascript.validation.message.interface.method.not.implemented" == null) {
                TypeScriptAnnotatingVisitor.$$$reportNull$$$0(10);
            }
            return "javascript.validation.message.interface.method.not.implemented";
        }
        if (containerClass instanceof TypeScriptClass) {
            if ("javascript.validation.message.class.property.not.implemented" == null) {
                TypeScriptAnnotatingVisitor.$$$reportNull$$$0(11);
            }
            return "javascript.validation.message.class.property.not.implemented";
        }
        if ("javascript.validation.message.interface.property.not.implemented" == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(12);
        }
        return "javascript.validation.message.interface.property.not.implemented";
    }

    @Override
    protected void checkSetterReturnType(@NotNull JSFunction function) {
        PsiElement returnTypeElement;
        if (function == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(13);
        }
        if ((returnTypeElement = function.getReturnTypeElement()) != null) {
            this.myProblemReporter.registerGenericError(returnTypeElement, JSBundle.message((String)"javascript.validation.message.class.setter.cannot.have.return.type", (Object[])new Object[0]), new IntentionAction[0]);
        }
    }

    @Override
    protected void validateSetter(@NotNull JSFunction setter, @NotNull JSFunction getter, JSParameterListElement param, JSType setterType, JSType retType) {
        if (setter == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(14);
        }
        if (getter == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(15);
        }
        this.checkAccessorAccessTypeMatch(setter, getter, "typescript.validation.message.getter.and.setter.must.have.same.access.type");
    }

    @Override
    protected void validateGetter(@NotNull JSFunction getter, @Nullable JSFunction setter, JSType type) {
        if (getter == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(16);
        }
        if (setter != null) {
            this.checkAccessorAccessTypeMatch(getter, setter, "typescript.validation.message.getter.and.setter.must.have.same.access.type");
        }
    }

    public void visitTypeScriptIndexSignature(TypeScriptIndexSignature indexSignature) {
        JSSemanticHighlightingUtil.highlight(indexSignature, this.myHighlighter, this.myHolder);
        PsiElement nameElement = indexSignature.getParameterNameElement();
        JSTypeDeclaration parameterType = indexSignature.getParameterType();
        if (nameElement != null) {
            if (parameterType == null) {
                this.myProblemReporter.registerGenericError(nameElement, JSBundle.message((String)"javascript.validation.message.index.no.type", (Object[])new Object[0]), new IntentionAction[0]);
            } else {
                JSSemanticHighlightingUtil.highlight(indexSignature, this.myHighlighter, this.myHolder);
                String parameterTypeText = parameterType.getText();
                if (!TypeScriptIndexSignature.POSSIBLE_TYPES.contains(parameterTypeText)) {
                    this.myProblemReporter.registerGenericError((PsiElement)parameterType, JSBundle.message((String)"javascript.validation.message.index.wrong.type", (Object[])new Object[]{StringUtil.join((Collection)TypeScriptIndexSignature.POSSIBLE_TYPES, (String)", ")}), new IntentionAction[0]);
                }
            }
        }
    }

    public void visitTypeScriptPropertySignature(TypeScriptPropertySignature propertySignature) {
        JSSemanticHighlightingUtil.highlight(propertySignature, this.myHighlighter, this.myHolder);
    }

    public void visitTypeScriptFunctionSignature(TypeScriptFunctionSignature functionSignature) {
        JSSemanticHighlightingUtil.highlight(functionSignature, this.myHighlighter, this.myHolder);
    }

    public void visitTypeScriptTypeParameter(TypeScriptTypeParameter typeParameter) {
        JSSemanticHighlightingUtil.highlight((TypeScriptGenericOrMappedTypeParameter)typeParameter, this.myHighlighter, this.myHolder);
    }

    public void visitTypeScriptMappedTypeParameter(TypeScriptMappedTypeParameter typeParameter) {
        JSSemanticHighlightingUtil.highlight((TypeScriptGenericOrMappedTypeParameter)typeParameter, this.myHighlighter, this.myHolder);
    }

    @Override
    protected void checkOverriddenMethods(@NotNull JSClass aClass) {
        if (aClass == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(17);
        }
        JSRecordType aClassInstanceType = TypeScriptTypeParser.buildTypeFromClass(aClass, false, false);
        JSRecordType aClassConstructorType = TypeScriptTypeParser.buildTypeFromClass(aClass, true, false);
        MultiMap checkedMembersInstance = MultiMap.createSet();
        MultiMap checkedMembersConstructor = MultiMap.createSet();
        for (JSClass<?> parentClass : TypeScriptUtil.getNonStrictParents(aClass, aClass instanceof TypeScriptInterface)) {
            if (parentClass == aClass) continue;
            this.checkOverride(aClass, aClassInstanceType, parentClass, false, (MultiMap<JSRecordType.PropertySignature, JSClass>)checkedMembersInstance);
            this.checkOverride(aClass, aClassConstructorType, parentClass, true, (MultiMap<JSRecordType.PropertySignature, JSClass>)checkedMembersConstructor);
        }
    }

    private void checkOverride(@NotNull JSClass aClass, @NotNull JSRecordType aClassType, @NotNull JSClass parentClass, boolean isStatic, @NotNull MultiMap<JSRecordType.PropertySignature, JSClass> checkedMembers) {
        if (aClass == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(18);
        }
        if (aClassType == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(19);
        }
        if (parentClass == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(20);
        }
        if (checkedMembers == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(21);
        }
        JSRecordType parentClassInstanceType = TypeScriptTypeParser.buildTypeFromClass(parentClass, isStatic, false);
        ProcessingContext contextWithCache = JSTypeComparingContextService.getProcessingContextWithCache((PsiElement)aClass);
        for (JSRecordType.PropertySignature parentClassPropertySignature : parentClassInstanceType.getProperties()) {
            JSType type;
            String name = parentClassPropertySignature.getMemberName();
            JSRecordType.PropertySignature aClassPropertySignature = aClassType.findPropertySignature(name);
            if (aClassPropertySignature == null) continue;
            Collection classes = checkedMembers.get((Object)aClassPropertySignature);
            if (!classes.isEmpty()) {
                boolean wasCheckedForHierarchy = false;
                for (JSClass checkedClass : classes) {
                    if (!JSInheritanceUtil.isParentClass(checkedClass, parentClass)) continue;
                    wasCheckedForHierarchy = true;
                    break;
                }
                if (wasCheckedForHierarchy) {
                    continue;
                }
            } else {
                checkedMembers.putValue((Object)aClassPropertySignature, (Object)parentClass);
            }
            if ((type = parentClassPropertySignature.getType()) == null || (type = JSTypeUtils.hasForeignGenericParameter(type) ? TypeScriptUtil.applyGenericsToType(type, aClass, parentClass) : type).isDirectlyAssignableType(aClassPropertySignature.getType(), contextWithCache)) continue;
            for (JSNamedElement classMember : TypeScriptUtil.getNamedMembers(aClass)) {
                ASTNode nameIdentifier;
                if (!name.equals(classMember.getName())) continue;
                boolean isStaticMember = false;
                if (classMember instanceof JSAttributeListOwner) {
                    JSAttributeList attributeList = ((JSAttributeListOwner)classMember).getAttributeList();
                    boolean bl = isStaticMember = attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.STATIC);
                }
                if (isStaticMember != isStatic || (nameIdentifier = classMember.findNameIdentifier()) == null) continue;
                this.myProblemReporter.registerGenericError(nameIdentifier, JSBundle.message((String)"javascript.validation.message.incompatible.override", (Object[])new Object[]{parentClass.getName()}), new IntentionAction[0]);
            }
        }
    }

    @Override
    protected boolean needsInitializer(JSParameterListElement parameter) {
        return false;
    }

    @Override
    protected ProblemHighlightType getHighlightTypeForTypeOrSignatureProblem(@NotNull PsiElement node) {
        if (node == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(22);
        }
        if (node instanceof JSCallExpression) {
            node = ((JSCallExpression)node).getMethodExpression();
        }
        return node instanceof JSReferenceExpression && !TypeScriptUtil.resolveIsStrict((JSReferenceExpression)node) ? ProblemHighlightType.LIKE_UNKNOWN_SYMBOL : ProblemHighlightType.GENERIC_ERROR;
    }

    @Override
    protected boolean checkExtendsRef(JSClass jsClass, JSClass referencedClass, JSExpression expr) {
        return true;
    }

    @Override
    protected boolean checkImplementsRef(JSClass jsClass, JSExpression expr) {
        return true;
    }

    public void visitTypeScriptImportStatement(TypeScriptImportStatement importStatement) {
        PsiElement identifier;
        TypeScriptExternalModuleReference externalModuleReference = importStatement.getExternalModuleReference();
        if (externalModuleReference != null) {
            String referenceNodeText;
            ASTNode referenceNode = externalModuleReference.findReferenceNode();
            String string = referenceNodeText = referenceNode != null ? StringUtil.unquoteString((String)referenceNode.getText()) : null;
            if (referenceNodeText != null && referenceNodeText.endsWith(".ts")) {
                this.myProblemReporter.registerGenericError(referenceNode, JSBundle.message((String)"typescript.validation.module.reference.with.extension", (Object[])new Object[0]), new IntentionAction[0]);
            }
        }
        if ((identifier = importStatement.getNameIdentifier()) != null) {
            PsiElement meaningfulElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement((PsiElement)importStatement);
            JSSemanticHighlightingUtil.highlight(identifier, meaningfulElement, this.myHighlighter, this.myHolder);
        }
        super.visitTypeScriptImportStatement(importStatement);
    }

    @Override
    protected void checkFunctionDeclaration(@NotNull JSFunction node) {
        JSClass parentClass;
        if (node == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(23);
        }
        if ((parentClass = TypeScriptPsiUtil.getParentClass((PsiElement)node)) != null) {
            this.validateClassMember(node, parentClass);
        }
        this.validateSignatureFunction(node, parentClass);
        super.checkFunctionDeclaration(node);
    }

    private void validateSignatureFunction(JSFunction node, JSClass parentClass) {
        if (!(node instanceof TypeScriptFunction) || node instanceof JSFunctionExpression) {
            return;
        }
        TypeScriptFunction function = (TypeScriptFunction)node;
        boolean noBody = function.getBody().length == 0;
        boolean isOverload = function.isOverloadDeclaration();
        boolean isAbstract = TypeScriptPsiUtil.isAbstractElement((JSAttributeListOwner)function);
        boolean isOptional = function.isOptional();
        boolean isAmbient = TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)function);
        if (!(!noBody || isOverload || isOptional || isAbstract || isAmbient)) {
            ArrayList intentions = ContainerUtil.newArrayList();
            TypeScriptAnnotatingVisitor.addMakeMethodAbstractIntention(parentClass, function, intentions);
            this.myProblemReporter.registerGenericError(function.getNameIdentifier(), JSBundle.message((String)"typescript.validation.message.function.implementation.missing", (Object[])new Object[0]), intentions.toArray(IntentionAction.EMPTY_ARRAY));
            return;
        }
        if (function.isGenerator()) {
            if (isOverload) {
                ASTNode multNode = JSUtils.getStarFromGenerator((JSFunction)function);
                this.myProblemReporter.registerGenericError(multNode, JSBundle.message((String)"typescript.validation.generators.overload", (Object[])new Object[0]), new IntentionAction[0]);
                return;
            }
            if (isAmbient) {
                ASTNode multNode = JSUtils.getStarFromGenerator((JSFunction)function);
                this.myProblemReporter.registerGenericError(multNode, JSBundle.message((String)"typescript.validation.generators.ambient", (Object[])new Object[0]), new IntentionAction[0]);
                return;
            }
        }
        if (isOverload || isAmbient) {
            return;
        }
        List overloadDeclarations = function.getOverloadDeclarations();
        if (overloadDeclarations.size() > 0 && parentClass != null) {
            HashSet abstracts = ContainerUtil.newHashSet();
            if (isAbstract) {
                abstracts.add(function);
            }
            for (TypeScriptFunction declaration : overloadDeclarations) {
                if (!TypeScriptPsiUtil.isAbstractElement((JSAttributeListOwner)declaration)) continue;
                abstracts.add(declaration);
            }
            if (abstracts.size() != overloadDeclarations.size() + 1) {
                for (TypeScriptFunction anAbstract : abstracts) {
                    JSAttributeList list = anAbstract.getAttributeList();
                    PsiElement element = list != null ? list.findModifierElement(JSAttributeList.ModifierType.ABSTRACT) : null;
                    if (element == null) continue;
                    this.myProblemReporter.registerGenericError(element, JSBundle.message((String)"typescript.validation.message.abstract.overload", (Object[])new Object[0]), new IntentionAction[0]);
                }
            }
        }
    }

    private static void addMakeMethodAbstractIntention(JSClass parentClass, TypeScriptFunction function, Collection<IntentionAction> intentions) {
        JSAttributeList methodAttributeList;
        JSAttributeList list;
        if (parentClass instanceof TypeScriptClass && parentClass.getAttributeList() != null && (list = parentClass.getAttributeList()).hasModifier(JSAttributeList.ModifierType.ABSTRACT) && (methodAttributeList = function.getAttributeList()) != null && !methodAttributeList.hasModifier(JSAttributeList.ModifierType.STATIC)) {
            intentions.add((IntentionAction)JSFixFactory.getInstance().insertModifier((JSAttributeListOwner)function, JSAttributeList.ModifierType.ABSTRACT));
        }
    }

    private void validateClassMember(JSFunction member, JSClass parentClass) {
        PsiElement element;
        JSAttributeList list;
        PsiElement identifier;
        if (TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)member) && member.getBody().length > 0 && (identifier = member.getNameIdentifier()) != null) {
            this.myProblemReporter.registerGenericError(identifier, JSBundle.message((String)"javascript.ambient.declaration.should.have.no.body", (Object[])new Object[0]), new IntentionAction[0]);
        }
        if ((list = member.getAttributeList()) != null && (element = list.findModifierElement(JSAttributeList.ModifierType.ABSTRACT)) != null) {
            if (list.getExplicitAccessType() == JSAttributeList.AccessType.PRIVATE) {
                this.myProblemReporter.registerGenericError(element, JSBundle.message((String)"typescript.validation.message.abstract.cannot.be.used", (Object[])new Object[]{"private"}), new IntentionAction[0]);
            } else if (list.hasModifier(JSAttributeList.ModifierType.STATIC)) {
                this.myProblemReporter.registerGenericError(element, JSBundle.message((String)"typescript.validation.message.abstract.cannot.be.used", (Object[])new Object[]{"static"}), new IntentionAction[0]);
            }
            if (member.isConstructor()) {
                this.myProblemReporter.registerGenericError(element, JSBundle.message((String)"typescript.validation.message.constructor.cannot.be.abstract", (Object[])new Object[0]), TypeScriptAnnotatingVisitor.createRemoveAbstractKeywordFix(element));
            } else if (member.getBody().length > 0) {
                this.myProblemReporter.registerGenericError(member.getNameIdentifier(), JSBundle.message((String)"typescript.validation.message.abstract.cannot.have.body", (Object[])new Object[0]), TypeScriptAnnotatingVisitor.createRemoveAbstractKeywordFix(element));
            } else {
                JSAttributeList attrList = parentClass.getAttributeList();
                if (attrList == null || !attrList.hasModifier(JSAttributeList.ModifierType.ABSTRACT)) {
                    this.myProblemReporter.registerGenericError(element, JSBundle.message((String)"typescript.validation.message.abstract.class.should.be", (Object[])new Object[0]), new IntentionAction[]{JSFixFactory.getInstance().insertModifier((JSAttributeListOwner)parentClass, JSAttributeList.ModifierType.ABSTRACT)});
                }
            }
        }
    }

    private static IntentionAction createRemoveAbstractKeywordFix(PsiElement element) {
        return JSFixFactory.getInstance().removeASTNodeFix("javascript.fix.remove.abstract.keyword", element.getNode());
    }

    @Override
    public void visitJSAttributeList(JSAttributeList attributeList) {
        PsiElement container = attributeList.getParent();
        PsiElement place = TypeScriptPsiUtil.getParentOverDefaultAssignable(container);
        boolean isTopLevel = TypeScriptPsiUtil.isTopLevelContainer(place);
        ASTNode[] children = attributeList.getNode().getChildren(JSTokenTypes.MODIFIERS);
        if (children.length == 0) {
            return;
        }
        HashSet modifiers = ContainerUtil.newHashSet();
        for (ASTNode child : children) {
            IElementType elementType = child.getElementType();
            boolean isAllow = container instanceof JSClass ? TypeScriptModifiersUtil.isAllowClassModifier((JSClass)container, elementType, isTopLevel) : (container instanceof JSVariable || container instanceof JSVarStatement ? TypeScriptModifiersUtil.isAllowVariableModifier(container, elementType, isTopLevel) : (container instanceof JSFunction ? TypeScriptModifiersUtil.isAllowFunctionModifier((JSFunction)container, elementType, isTopLevel) : (container instanceof TypeScriptImportStatement ? TypeScriptModifiersUtil.isAllowImportModifier(container, elementType, isTopLevel) : (container instanceof TypeScriptTypeMember ? TypeScriptModifiersUtil.isAllowTypeSignature((TypeScriptTypeMember)container, elementType, isTopLevel) : TypeScriptModifiersUtil.isAllowCommon(container, elementType, isTopLevel)))));
            if (!isAllow) {
                this.myProblemReporter.registerGenericError(child, TypeScriptModifiersUtil.getModifierErrorMessage(child, isTopLevel), new IntentionAction[]{JSFixFactory.getInstance().removeASTNodeFix("javascript.fix.remove.modifier", child)});
                continue;
            }
            if (modifiers.add(child.getElementType())) continue;
            this.myProblemReporter.registerGenericError(child, JSBundle.message((String)"typescript.validation.message.duplicate.modifier", (Object[])new Object[]{child.getText()}), new IntentionAction[]{JSFixFactory.getInstance().removeASTNodeFix("javascript.fix.remove.modifier", child)});
        }
        super.visitJSAttributeList(attributeList);
    }

    @Override
    protected void validateRestParameterType(JSParameterListElement parameter) {
        JSType type;
        PsiElement typeElement = parameter.getTypeElement();
        if (!(typeElement == null || JSTypeUtils.isIndexableType(type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)((TypeScriptType)typeElement)))) || type instanceof JSGenericParameterImpl && JSTypeUtils.getIndexableComponentType(((JSGenericParameterImpl)type).getConstraintType()) != null)) {
            String newTypeText = new JSArrayTypeImpl(type, type.getSource()).getTypeText(JSType.TypeTextFormat.CODE);
            ReplacePsiElementFix fix = new ReplacePsiElementFix(typeElement, (PsiElement)JSChangeUtil.createTypeScriptType(newTypeText, (PsiElement)parameter), "typescript.validation.message.unexpected.type.for.rest.parameter.fix");
            this.myProblemReporter.registerGenericError(typeElement, JSBundle.message((String)"typescript.validation.message.unexpected.type.for.rest.parameter", (Object[])new Object[0]), fix);
        }
    }

    @Override
    public void visitJSVariable(JSVariable var) {
        JSClass grandParent = JSUtils.getMemberContainingClass((PsiElement)var);
        if (grandParent != null && !(grandParent instanceof TypeScriptEnum) && TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)grandParent) && var.hasInitializer()) {
            this.myProblemReporter.registerGenericError((PsiElement)var.getInitializer(), JSBundle.message((String)"javascript.ambient.declaration.should.have.no.initializer", (Object[])new Object[0]), new IntentionAction[0]);
        }
        super.visitJSVariable(var);
    }

    public void visitTypeScriptExportAssignment(TypeScriptExportAssignment exportAssignment) {
        PsiElement parent = exportAssignment.getParent();
        if (parent instanceof TypeScriptModule && ((TypeScriptModule)parent).isInternal()) {
            this.myProblemReporter.registerGenericError(exportAssignment.getNode(), JSBundle.message((String)"typescript.export.assignment.cannot.be.used.in.internal.modules", (Object[])new Object[0]), new IntentionAction[0]);
        }
        super.visitTypeScriptExportAssignment(exportAssignment);
    }

    public void visitTypeScriptSingleType(TypeScriptSingleType singleType) {
        super.visitTypeScriptSingleType(singleType);
        JSReferenceExpression referenceExpression = singleType.getReferenceExpression();
        TypeScriptTypeArgumentList arguments = singleType.getTypeArgumentList();
        if (arguments == null) {
            return;
        }
        JSTypeDeclaration[] declarations = singleType.getTypeArguments();
        if (referenceExpression == null || declarations.length <= 0) {
            return;
        }
        ResolveResult[] results = referenceExpression.multiResolve(false);
        String name = StringUtil.notNullize((String)singleType.getQualifiedTypeName());
        for (ResolveResult result2 : results) {
            PsiElement element = result2.getElement();
            if (!(element instanceof JSClass) && !(element instanceof TypeScriptTypeParameter)) continue;
            if (element instanceof TypeScriptTypeParameterListOwner) {
                TypeScriptTypeParameterList expectedList = ((TypeScriptTypeParameterListOwner)element).getTypeParameterList();
                if (expectedList != null && expectedList.getTypeParameters().length != 0) continue;
                this.myProblemReporter.registerGenericError((PsiElement)arguments, JSBundle.message((String)"typescript.generics.should.not.be", (Object[])new Object[]{name}), new IntentionAction[0]);
                break;
            }
            this.myProblemReporter.registerGenericError((PsiElement)arguments, JSBundle.message((String)"typescript.generics.should.not.be", (Object[])new Object[]{name}), new IntentionAction[0]);
        }
    }

    public void visitTypeScriptTypePredicate(@NotNull TypeScriptTypePredicate predicate) {
        PsiElement parent;
        if (predicate == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(24);
        }
        if (!this.checkTypePredicateShouldBeReturnType(predicate, parent = predicate.getParent())) {
            JSType guardType;
            if ("this".equals(predicate.getParameterName())) {
                return;
            }
            JSParameter parameter = predicate.getParameterMatchName();
            if (parameter == null) {
                PsiElement anchor = predicate.getNameIdentifier();
                if (anchor == null) {
                    anchor = predicate;
                }
                this.myProblemReporter.registerGenericError(anchor.getNode(), JSBundle.message((String)"typescript.type.predicate.not.match.name", (Object[])new Object[]{predicate.getParameterName()}), new IntentionAction[0]);
                return;
            }
            if (parameter.isRest()) {
                this.myProblemReporter.registerGenericError(predicate.getNameIdentifier(), JSBundle.message((String)"typescript.type.predicate.rest", (Object[])new Object[0]), new IntentionAction[0]);
                return;
            }
            PsiElement nameParent = parameter.getParent();
            if (nameParent instanceof JSDestructuringContainer || nameParent instanceof JSDestructuringProperty || nameParent instanceof JSDestructuringArrayRestElement) {
                this.myProblemReporter.registerGenericError(predicate.getNameIdentifier(), JSBundle.message((String)"typescript.type.predicate.destructuring", (Object[])new Object[0]), new IntentionAction[0]);
                return;
            }
            JSType parameterType = parameter.getType();
            if (parameterType != null && (guardType = predicate.getGuardType()) != null && !parameterType.isDirectlyAssignableType(guardType, JSTypeComparingContextService.getProcessingContextWithCache((PsiElement)predicate))) {
                this.myProblemReporter.registerGenericError((PsiElement)predicate, JSBundle.message((String)"typescript.type.predicate.incompatible.types", (Object[])new Object[]{parameterType.getTypeText(JSType.TypeTextFormat.PRESENTABLE)}), new IntentionAction[0]);
            }
        }
        super.visitTypeScriptTypePredicate(predicate);
    }

    private boolean checkTypePredicateShouldBeReturnType(@NotNull TypeScriptTypePredicate predicate, @NotNull PsiElement parent) {
        boolean isParentCorrectFunction;
        if (predicate == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(25);
        }
        if (parent == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(26);
        }
        boolean bl = isParentCorrectFunction = parent instanceof TypeScriptFunction && !((TypeScriptFunction)parent).isConstructor() && ((TypeScriptFunction)parent).getReturnTypeElement() == predicate;
        if (isParentCorrectFunction) {
            return false;
        }
        if (predicate.isThisType()) {
            if (parent instanceof JSField && ((JSField)parent).getTypeElement() == predicate) {
                return false;
            }
            this.myProblemReporter.registerGenericError(predicate.getNode(), JSBundle.message((String)"typescript.type.this.predicate.not.return", (Object[])new Object[0]), new IntentionAction[0]);
            return true;
        }
        this.myProblemReporter.registerGenericError(predicate.getNode(), JSBundle.message((String)"typescript.type.predicate.not.return", (Object[])new Object[0]), new IntentionAction[0]);
        return true;
    }

    public void visitTypeScriptTupleType(TypeScriptTupleType tupleType) {
        if (tupleType.getElements().length == 0) {
            this.myProblemReporter.registerGenericError((PsiElement)tupleType, JSBundle.message((String)"typescript.tuple.type.list.cannot.be.empty", (Object[])new Object[0]), new IntentionAction[0]);
        }
        super.visitTypeScriptTupleType(tupleType);
    }

    @Override
    public void visitJSParameterList(JSParameterList node) {
        boolean hasOptional = false;
        for (JSParameterListElement parameter : node.getParameters()) {
            if (hasOptional && !parameter.isOptional() && !parameter.isRest()) {
                this.myProblemReporter.registerGenericError((PsiElement)parameter, JSBundle.message((String)"javascript.validation.message.parameter.non.optional.after.optional", (Object[])new Object[0]), new IntentionAction[0]);
            }
            if (parameter.isRest() && parameter.isOptional()) {
                this.myProblemReporter.registerGenericError((PsiElement)parameter, JSBundle.message((String)"javascript.validation.message.parameter.rest.optional", (Object[])new Object[0]), new IntentionAction[0]);
            }
            hasOptional = hasOptional || parameter.isOptional();
        }
        super.visitJSParameterList(node);
    }

    @Override
    @Nullable
    protected LocalQuickFix[] getQuickFixesForReferenceProblem(@NotNull PsiReference ref, @Nullable String message) {
        if (ref == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(27);
        }
        if (ref instanceof ES6ImportExportSpecifier && message != null) {
            ResolveResult[] results;
            for (ResolveResult result2 : results = ((ES6ImportExportSpecifier)ref).multiResolve(false)) {
                if (!(result2 instanceof JSResolveResult) || ((JSResolveResult)result2).getResolveProblemKey() != "javascript.element.need.to.be.included.to.config") continue;
                return JSFixFactory.getInstance().typeScriptConfigFixes((JSElement)ref, result2.getElement()).toArray(LocalQuickFix.EMPTY_ARRAY);
            }
        }
        return super.getQuickFixesForReferenceProblem(ref, message);
    }

    private static boolean skipTypeChecking(@NotNull PsiElement context) {
        if (context == null) {
            TypeScriptAnnotatingVisitor.$$$reportNull$$$0(28);
        }
        return TypeScriptAnnotatorCheckerProvider.getCheckerProvider(context).skipErrors();
    }

    public void visitTypeScriptEntityName(TypeScriptEntityName entityName) {
        JSSemanticHighlightingUtil.highlight((JSPsiReferenceElement)entityName, this.myHighlighter, this.myHolder);
        super.visitTypeScriptEntityName(entityName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatingVisitor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberToImplement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setter";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClassType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkedMembers";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatingVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstructorChecker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createProblemReporter";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageIdForNotImplementedError";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkReferences";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkImplementedMethods";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessageForNotImplementedError";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMessageIdForNotImplementedError";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkSetterReturnType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "validateSetter";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "validateGetter";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkOverriddenMethods";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkOverride";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightTypeForTypeOrSignatureProblem";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "checkFunctionDeclaration";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptTypePredicate";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "checkTypePredicateShouldBeReturnType";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixesForReferenceProblem";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "skipTypeChecking";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

