/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.lsp;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.lang.javascript.flow.FlowJSSettings;
import com.intellij.lang.javascript.flow.FlowJSSettingsManager;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.lang.javascript.flow.lsp.FlowJSLanguageClient;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceConnector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.LinkedHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.RemoteEndpoint;
import org.eclipse.lsp4j.jsonrpc.json.MessageJsonHandler;
import org.eclipse.lsp4j.jsonrpc.json.MethodProvider;
import org.eclipse.lsp4j.jsonrpc.json.StreamMessageConsumer;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.messages.RequestMessage;
import org.eclipse.lsp4j.jsonrpc.services.ServiceEndpoints;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSLanguageServerConnector
implements JSLanguageServiceConnector {
    @NotNull
    protected final Project myProject;
    @NotNull
    private final FlowJSConfig myConfig;
    @NotNull
    private final FlowJSLanguageClient myLanguageClient;
    @Nullable
    private String myInitializeError;
    @Nullable
    private LanguageServer myServer;

    public FlowJSLanguageServerConnector(@NotNull Project project, @NotNull FlowJSConfig config2, @NotNull FlowJSLanguageClient client) {
        if (project == null) {
            FlowJSLanguageServerConnector.$$$reportNull$$$0(0);
        }
        if (config2 == null) {
            FlowJSLanguageServerConnector.$$$reportNull$$$0(1);
        }
        if (client == null) {
            FlowJSLanguageServerConnector.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myConfig = config2;
        this.myLanguageClient = client;
    }

    @NotNull
    private GeneralCommandLine createCommandLine() {
        FlowJSSettings.FlowJSExecutable executable = this.getFlowExecutable();
        if (executable == null) {
            this.myInitializeError = "Can't find flow executable";
            throw new RuntimeException(this.myInitializeError);
        }
        GeneralCommandLine line = executable.createCommandLine(this.myProject);
        line.addParameter("lsp");
        line.setWorkDirectory(this.myConfig.getConfigDirectory().getPath());
        GeneralCommandLine generalCommandLine = line;
        if (generalCommandLine == null) {
            FlowJSLanguageServerConnector.$$$reportNull$$$0(3);
        }
        return generalCommandLine;
    }

    @Override
    @Nullable
    public ProcessHandler connect() throws Exception {
        GeneralCommandLine line = this.createCommandLine();
        return new OSProcessHandler(line);
    }

    @Override
    public boolean awaitReadyNotification(@NotNull ProcessHandler _processHandler) {
        LanguageServer remoteProxy;
        if (_processHandler == null) {
            FlowJSLanguageServerConnector.$$$reportNull$$$0(4);
        }
        OSProcessHandler processHandler = (OSProcessHandler)_processHandler;
        this.myServer = remoteProxy = this.createLanguageServer(processHandler);
        processHandler.startNotify();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        InitializeParams params = new InitializeParams();
        params.setRootUri(this.myConfig.getConfigDirectory().getPath());
        remoteProxy.initialize(params).thenAccept(initializeResult -> countDownLatch.countDown());
        try {
            countDownLatch.await(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            JSLanguageServiceQueue.LOGGER.debug("Process interrupted while waiting for 'initialize' response.");
        }
        return true;
    }

    @NotNull
    private LanguageServer createLanguageServer(OSProcessHandler processHandler) {
        LinkedHashMap supportedMethods = new LinkedHashMap(ServiceEndpoints.getSupportedMethods(LanguageServer.class));
        supportedMethods.putAll(ServiceEndpoints.getSupportedMethods(this.myLanguageClient.getClass()));
        final MessageJsonHandler jsonHandler = new MessageJsonHandler(supportedMethods);
        Object outGoingMessageStream = new StreamMessageConsumer(processHandler.getProcessInput(), jsonHandler);
        if (JSLanguageServiceQueue.LOGGER.isDebugEnabled()) {
            StreamMessageConsumer baseStream = outGoingMessageStream;
            outGoingMessageStream = new MessageConsumer((MessageConsumer)baseStream){
                final /* synthetic */ MessageConsumer val$baseStream;
                {
                    this.val$baseStream = messageConsumer;
                }

                public void consume(Message message) {
                    if (!JSLanguageServiceQueue.LOGGER.isTraceEnabled() && message instanceof RequestMessage) {
                        JSLanguageServiceQueue.LOGGER.debug("Request method: " + ((RequestMessage)message).getMethod());
                    }
                    if (JSLanguageServiceQueue.LOGGER.isTraceEnabled()) {
                        JSLanguageServiceQueue.LOGGER.trace("Request: " + jsonHandler.serialize(message));
                    }
                    this.val$baseStream.consume(message);
                }
            };
        }
        final RemoteEndpoint serverEndpoint = new RemoteEndpoint((MessageConsumer)outGoingMessageStream, ServiceEndpoints.toEndpoint((Object)this.myLanguageClient));
        jsonHandler.setMethodProvider((MethodProvider)serverEndpoint);
        LanguageServer remoteProxy = (LanguageServer)ServiceEndpoints.toServiceObject((Endpoint)serverEndpoint, LanguageServer.class);
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                String text;
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (outputType == ProcessOutputTypes.STDOUT && (text = event.getText()).startsWith("{")) {
                    Message message = jsonHandler.parseMessage((CharSequence)text);
                    serverEndpoint.consume(message);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/flow/lsp/FlowJSLanguageServerConnector$2";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        LanguageServer languageServer = remoteProxy;
        if (languageServer == null) {
            FlowJSLanguageServerConnector.$$$reportNull$$$0(5);
        }
        return languageServer;
    }

    @Override
    @Nullable
    public String getInitializeError() {
        return this.myInitializeError;
    }

    @Nullable
    LanguageServer getServer() {
        return this.myServer;
    }

    @Nullable
    private FlowJSSettings.FlowJSExecutable getFlowExecutable() {
        return FlowJSSettingsManager.getInstance(this.myProject).getRawSettings().getFlowExecutable();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flow/lsp/FlowJSLanguageServerConnector";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_processHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flow/lsp/FlowJSLanguageServerConnector";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createLanguageServer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "awaitReadyNotification";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

