/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.frameworks.react.JSXPropTypesUtil;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ReactComponent {
    @NotNull
    private final String myNamespace;
    @NotNull
    private final XmlTag myTag;
    @NotNull
    private final Collection<? extends PsiElement> myElements;
    private final boolean myIsWeakResolve;
    private final boolean myIsResolvedComponent;
    @NotNull
    private final NullableLazyValue<JSRecordType> myProps;

    ReactComponent(@NotNull XmlTag tag, @NotNull Collection<? extends PsiElement> elements, @NotNull String namespace, boolean isWeakResolve, boolean isResolvedComponent) {
        if (tag == null) {
            ReactComponent.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            ReactComponent.$$$reportNull$$$0(1);
        }
        if (namespace == null) {
            ReactComponent.$$$reportNull$$$0(2);
        }
        this.myProps = NullableLazyValue.createValue(() -> this.resolvePropsNoCache());
        this.myTag = tag;
        this.myElements = elements;
        this.myNamespace = namespace;
        this.myIsWeakResolve = isWeakResolve;
        this.myIsResolvedComponent = isResolvedComponent;
    }

    public boolean isWeakResolve() {
        return this.myIsWeakResolve;
    }

    public boolean isResolvedComponent() {
        return this.myIsResolvedComponent;
    }

    @NotNull
    public Collection<? extends PsiElement> getElements() {
        Collection<? extends PsiElement> collection = this.myElements;
        if (collection == null) {
            ReactComponent.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    public String getNamespace() {
        String string = this.myNamespace;
        if (string == null) {
            ReactComponent.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public JSRecordType getProps() {
        return (JSRecordType)this.myProps.getValue();
    }

    @Nullable
    private JSRecordType resolvePropsNoCache() {
        JSRecordType signatureType = ReactComponent.asPropsResult(JSXPropTypesUtil.getGenericPropType(this.myTag, this));
        if (ReactComponent.isAcceptableResult(signatureType)) {
            return ReactComponent.asPropsResult((JSType)signatureType);
        }
        boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)this.myTag);
        if (isTypeScript && this.myElements.isEmpty()) {
            return null;
        }
        GlobalSearchScope scope = this.getPropsNamespaceScope();
        Collection<JSPsiElementBase> propsNamespaceMembers = JSClassResolver.getInstance().findNamespaceMembers(this.getNamespace(), scope);
        Stream<JSPsiElementBase> resolvedNamespaceMembers = JSXPropTypesUtil.resolveNamespacePropTypes(this, scope);
        Stream<JSPsiElementBase> propsStream = Stream.concat(propsNamespaceMembers.stream(), resolvedNamespaceMembers);
        LinkedHashMap result2 = ContainerUtil.newLinkedHashMap();
        if (signatureType != null) {
            signatureType.getProperties().forEach(el -> {
                String name = el.getMemberName();
                if (!el.isOptional() && this.myIsWeakResolve) {
                    el = new JSRecordTypeImpl.PropertySignatureImpl(name, el.getType(), true, el.getMemberSource());
                }
                result2.put(el.getMemberName(), el);
            });
        }
        this.mergeProperties(result2, propsStream);
        return result2.isEmpty() ? null : new JSRecordTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)this.myTag, true), ContainerUtil.newArrayList(result2.values()));
    }

    private void mergeProperties(@NotNull Map<String, JSRecordType.PropertySignature> result2, @NotNull Stream<JSPsiElementBase> propsStream) {
        if (result2 == null) {
            ReactComponent.$$$reportNull$$$0(5);
        }
        if (propsStream == null) {
            ReactComponent.$$$reportNull$$$0(6);
        }
        propsStream.filter(el -> el.getName() != null).forEach(el -> {
            if (result2 == null) {
                ReactComponent.$$$reportNull$$$0(11);
            }
            String name = el.getName();
            JSRecordType.PropertySignature oldSignature = (JSRecordType.PropertySignature)result2.get(name);
            JSRecordTypeImpl.PropertySignatureImpl newSignature = this.createSignature((JSPsiElementBase)el);
            if (oldSignature != null && (newSignature.isOptional() || ReactComponent.isNullOrAny(newSignature.getType()))) {
                return;
            }
            result2.put(name, newSignature);
        });
    }

    private static boolean isNullOrAny(@Nullable JSType oldType) {
        return oldType == null || oldType instanceof JSAnyType;
    }

    private static boolean isAcceptableResult(@Nullable JSRecordType type) {
        if (type == null || !type.hasProperties() || !type.getSource().isStrict()) {
            return false;
        }
        int size = type.getProperties().size();
        int extendedMin = type.hasProperty("children") ? 1 : 0;
        return size > extendedMin;
    }

    @NotNull
    private JSRecordTypeImpl.PropertySignatureImpl createSignature(@NotNull JSPsiElementBase el) {
        if (el == null) {
            ReactComponent.$$$reportNull$$$0(7);
        }
        JSRecordTypeImpl.PropertySignatureImpl propertySignatureImpl = new JSRecordTypeImpl.PropertySignatureImpl(Objects.requireNonNull(el.getName()), ReactXmlExtension.getPropType((PsiElement)el), this.isWeakResolve(), (PsiElement)el);
        if (propertySignatureImpl == null) {
            ReactComponent.$$$reportNull$$$0(8);
        }
        return propertySignatureImpl;
    }

    @Nullable
    private static JSRecordType asPropsResult(@Nullable JSType type) {
        return type != null ? type.asRecordType() : null;
    }

    private GlobalSearchScope getPropsNamespaceScope() {
        if (this.useRestrictedByFilePropsNamespaceScope()) {
            return this.getRestrictedByFilePropsNamespaceScope();
        }
        return JSResolveUtil.getResolveScope((PsiElement)this.myTag);
    }

    private boolean useRestrictedByFilePropsNamespaceScope() {
        if (DialectDetector.isTypeScript((PsiElement)this.myTag)) {
            return true;
        }
        if (!this.isResolvedComponent() || this.getElements().isEmpty()) {
            return false;
        }
        for (PsiElement psiElement : this.getElements()) {
            PsiFile psiFile = psiElement.getContainingFile();
            if (!(psiFile instanceof JSFile)) {
                return false;
            }
            JSFile jsFile = (JSFile)psiFile;
            if (!jsFile.isCommonJSModule()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private GlobalSearchScope getRestrictedByFilePropsNamespaceScope() {
        GlobalSearchScope defaultScope = JSResolveUtil.getResolveScope((PsiElement)this.myTag);
        final List files = this.getElements().stream().map(el -> PsiUtilCore.getVirtualFile((PsiElement)el)).filter(el -> el != null).collect(Collectors.toList());
        if (files.isEmpty()) {
            GlobalSearchScope globalSearchScope = defaultScope;
            if (globalSearchScope == null) {
                ReactComponent.$$$reportNull$$$0(9);
            }
            return globalSearchScope;
        }
        final PsiManager manager = this.myTag.getManager();
        DelegatingGlobalSearchScope delegatingGlobalSearchScope = new DelegatingGlobalSearchScope(defaultScope){

            public boolean contains(@NotNull VirtualFile candidate) {
                if (candidate == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!super.contains(candidate)) {
                    return false;
                }
                PsiFile psiFile = manager.findFile(candidate);
                if (!(psiFile instanceof JSFile)) {
                    return false;
                }
                JSFile jsCandidateFile = (JSFile)psiFile;
                return !jsCandidateFile.isCommonJSModule() || files.contains(candidate);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/lang/javascript/frameworks/react/ReactComponent$1", "contains"));
            }
        };
        if (delegatingGlobalSearchScope == null) {
            ReactComponent.$$$reportNull$$$0(10);
        }
        return delegatingGlobalSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/react/ReactComponent";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propsStream";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/ReactComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createSignature";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRestrictedByFilePropsNamespaceScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "mergeProperties";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createSignature";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$mergeProperties$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

