/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react.references;

import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.javascript.frameworks.react.references.JSXResolveUtil;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSReferenceSet;
import com.intellij.lang.javascript.psi.impl.JSReferenceSetElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class JSXNamespaceReference
extends JSReferenceSetElement {
    private static final String THIS_QUALIFIER = "this";

    public JSXNamespaceReference(@NotNull JSReferenceSet set, @NotNull String s, @NotNull TextRange rangeInElement) {
        if (set == null) {
            JSXNamespaceReference.$$$reportNull$$$0(0);
        }
        if (s == null) {
            JSXNamespaceReference.$$$reportNull$$$0(1);
        }
        if (rangeInElement == null) {
            JSXNamespaceReference.$$$reportNull$$$0(2);
        }
        super(set, s, rangeInElement);
    }

    @Override
    @NotNull
    protected ResolveResult[] doResolve() {
        PsiElement element = this.getElement();
        if (this.isPrimary()) {
            if (THIS_QUALIFIER.equals(this.myCanonicalText)) {
                JSClass context = JSResolveUtil.getClassOfContext(element);
                ResolveResult[] resolveResultArray = JSResolveResult.toResolveResults(ContainerUtil.createMaybeSingletonList((Object)context));
                if (resolveResultArray == null) {
                    JSXNamespaceReference.$$$reportNull$$$0(3);
                }
                return resolveResultArray;
            }
            Collection<? extends PsiElement> candidates = JSXResolveUtil.resolveTopLevelName(element, this.myCanonicalText);
            ResolveResult[] resolveResultArray = JSResolveResult.toResolveResults(JSXNamespaceReference.resolveSpecifiers(candidates));
            if (resolveResultArray == null) {
                JSXNamespaceReference.$$$reportNull$$$0(4);
            }
            return resolveResultArray;
        }
        PsiReference qualifier = this.getQualifier();
        if (!(qualifier instanceof JSXNamespaceReference)) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                JSXNamespaceReference.$$$reportNull$$$0(5);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        JSXNamespaceReference parentReference = (JSXNamespaceReference)qualifier;
        Collection<PsiElement> elements = JSXResolveUtil.expandReferenceElements(element, parentReference);
        if (elements.isEmpty()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                JSXNamespaceReference.$$$reportNull$$$0(6);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        Collection<PsiElement> results = JSXResolveUtil.resolveNestedName(element, this.myCanonicalText, elements, parentReference);
        ResolveResult[] resolveResultArray = JSResolveResult.toResolveResults(JSXNamespaceReference.resolveSpecifiers(results));
        if (resolveResultArray == null) {
            JSXNamespaceReference.$$$reportNull$$$0(7);
        }
        return resolveResultArray;
    }

    @NotNull
    private static Collection<PsiElement> resolveSpecifiers(@NotNull Collection<? extends PsiElement> candidates) {
        if (candidates == null) {
            JSXNamespaceReference.$$$reportNull$$$0(8);
        }
        Collection collection = candidates.stream().flatMap(el -> {
            if (el instanceof ES6ImportSpecifier) {
                return JSResolveResult.toElements(((ES6ImportSpecifier)el).resolveOverAliases()).stream();
            }
            return Stream.of(el);
        }).collect(Collectors.toList());
        if (collection == null) {
            JSXNamespaceReference.$$$reportNull$$$0(9);
        }
        return collection;
    }

    public boolean isThisQualifier() {
        return this.isPrimary() && THIS_QUALIFIER.equals(this.getCanonicalText());
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            JSXNamespaceReference.$$$reportNull$$$0(10);
        }
        if (THIS_QUALIFIER.equals(this.myCanonicalText)) {
            return null;
        }
        String result2 = StringUtil.join((Object[])this.getSet().getReferences(), el -> {
            if (newElementName == null) {
                JSXNamespaceReference.$$$reportNull$$$0(11);
            }
            if (el == this) {
                return newElementName;
            }
            return el.getCanonicalText();
        }, (String)".");
        PsiElement element = this.getElement();
        if (!(element instanceof XmlTag)) {
            return null;
        }
        String qualifiedName = result2 + "." + ((XmlTag)element).getLocalName();
        return ((XmlTag)element).setName(qualifiedName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/react/references/JSXNamespaceReference";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/references/JSXNamespaceReference";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolve";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSpecifiers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolveSpecifiers";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$handleElementRename$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

