/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.generation;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.generation.BaseJSGenerateHandler;
import com.intellij.lang.javascript.generation.JSChooserElementNode;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMembersFix;
import com.intellij.lang.javascript.validation.fixes.TypeScriptImplementMemberUtil;
import com.intellij.lang.javascript.validation.fixes.TypeScriptImplementMembersFix;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class TypeScriptImplementMembersHandler
extends BaseJSGenerateHandler {
    private final boolean myImplementAbstract;
    private JCheckBox myImplementAbstractOptionBox;

    public TypeScriptImplementMembersHandler() {
        this.myImplementAbstract = false;
    }

    public TypeScriptImplementMembersHandler(boolean skipMemberChooserDialog, boolean selectAllElements, boolean implementAbstract) {
        super(skipMemberChooserDialog, selectAllElements);
        this.myImplementAbstract = implementAbstract;
    }

    @Override
    protected void collectCandidates(PsiElement clazz, Collection<JSChooserElementNode> candidates) {
        TypeScriptImplementMemberUtil.addUnimplementedMemberCandidates(clazz, candidates, k -> k instanceof JSFunction || k instanceof JSField || k instanceof JSProperty || k instanceof TypeScriptIndexSignature || k instanceof JSLocalImplicitElementImpl);
    }

    @Override
    @Nullable
    protected JComponent getOptionsComponent(PsiElement jsClass, Collection<JSChooserElementNode> candidates) {
        if (!(jsClass instanceof JSClass)) {
            return null;
        }
        if (!TypeScriptPsiUtil.isAbstractElement((JSAttributeListOwner)((JSClass)jsClass))) {
            return null;
        }
        this.myImplementAbstractOptionBox = new JCheckBox("Implement members abstract", this.myImplementAbstract);
        this.myImplementAbstractOptionBox.setFocusable(false);
        this.myImplementAbstractOptionBox.setMnemonic('A');
        return this.myImplementAbstractOptionBox;
    }

    @Override
    protected String getTitleKey() {
        return "members.to.implement.chooser.title";
    }

    @Override
    protected String getNoCandidatesMessage() {
        return JSBundle.message((String)"no.members.to.implement", (Object[])new Object[0]);
    }

    @Override
    protected BaseCreateMembersFix createFix(PsiElement clazz) {
        boolean implementAbstract = this.mySkipMemberChooserDialog || ApplicationManager.getApplication().isUnitTestMode() ? this.myImplementAbstract && clazz instanceof JSClass && TypeScriptPsiUtil.isAbstractElement((JSAttributeListOwner)((JSClass)clazz)) : this.myImplementAbstractOptionBox != null && this.myImplementAbstractOptionBox.isSelected();
        return new TypeScriptImplementMembersFix(clazz, implementAbstract);
    }

    @Override
    protected String getProductivityFeatureId() {
        return "codeassists.overrideimplement";
    }
}

