/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6MakeFunctionAsyncFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String myText;

    public ES6MakeFunctionAsyncFix(@NotNull JSFunction element) {
        if (element == null) {
            ES6MakeFunctionAsyncFix.$$$reportNull$$$0(0);
        }
        super((PsiElement)element);
        this.myText = ES6MakeFunctionAsyncFix.getQuickFixText(element);
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            ES6MakeFunctionAsyncFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.possibly.async.function.quick.fix.family.name", (Object[])new Object[0]);
        if (string == null) {
            ES6MakeFunctionAsyncFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            ES6MakeFunctionAsyncFix.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            ES6MakeFunctionAsyncFix.$$$reportNull$$$0(4);
        }
        if (startElement == null) {
            ES6MakeFunctionAsyncFix.$$$reportNull$$$0(5);
        }
        if (endElement == null) {
            ES6MakeFunctionAsyncFix.$$$reportNull$$$0(6);
        }
        JSFunction function = (JSFunction)startElement;
        JSAttributeList attributeList = function.getAttributeList();
        JSAttributeListWrapper wrapper = new JSAttributeListWrapper(attributeList);
        wrapper.overrideModifier(JSAttributeList.ModifierType.ASYNC, true);
        wrapper.applyTo((JSAttributeListOwner)function);
        function.replace(ES6MakeFunctionAsyncFix.psiFromText(function, function.getText()));
    }

    private static PsiElement psiFromText(@NotNull JSFunction context, @NotNull String text) {
        if (context == null) {
            ES6MakeFunctionAsyncFix.$$$reportNull$$$0(7);
        }
        if (text == null) {
            ES6MakeFunctionAsyncFix.$$$reportNull$$$0(8);
        }
        if (context.getParent() instanceof JSClass) {
            return JSChangeUtil.createClassMemberPsiFromTextWithContext(text, (PsiElement)context, PsiElement.class);
        }
        if (context instanceof JSFunctionProperty) {
            JSObjectLiteralExpression objectLiteralNode = JSChangeUtil.createExpressionPsiWithContext("{" + text + "}", (PsiElement)context, JSObjectLiteralExpression.class);
            assert (objectLiteralNode != null) : text;
            return objectLiteralNode.getFirstProperty();
        }
        if (context instanceof JSFunctionExpression) {
            JSExpression expression = JSChangeUtil.createExpressionPsiWithContext(text, (PsiElement)context, JSExpression.class);
            assert (expression != null) : text;
            return expression;
        }
        JSElement astNode = JSChangeUtil.createStatementPsiFromTextWithContext(text, (PsiElement)context, JSElement.class);
        assert (astNode != null) : text;
        return astNode;
    }

    @NotNull
    private static String getQuickFixText(@NotNull JSFunction function) {
        String name;
        if (function == null) {
            ES6MakeFunctionAsyncFix.$$$reportNull$$$0(9);
        }
        String string = (name = function.getName()) != null ? JSBundle.message((String)"js.possibly.async.function.quick.fix", (Object[])new Object[]{name}) : JSBundle.message((String)"js.possibly.async.function.quick.fix.family.name", (Object[])new Object[0]);
        if (string == null) {
            ES6MakeFunctionAsyncFix.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6MakeFunctionAsyncFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6MakeFunctionAsyncFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 10: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "psiFromText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

