/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.validation.fixes.ES6InsertAwaitFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6MissingAwaitInspection
extends JSInspection {
    public static final String SHORT_NAME = ES6MissingAwaitInspection.calcShortNameFromClass(ES6MissingAwaitInspection.class);

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSCallExpression(JSCallExpression node) {
                PsiElement nodeParent;
                ResolveResult[] results;
                if (!DialectDetector.hasFeature((PsiElement)node, JSLanguageFeature.ASYNC_AWAIT)) {
                    return;
                }
                super.visitJSCallExpression(node);
                JSExpression parent = JSPsiImplUtils.getTopmostParenthesizedOrSelf((JSExpression)node);
                if (!ES6MissingAwaitInspection.needProcess(parent, parent.getParent())) {
                    return;
                }
                PsiElement scope = JSPsiImplUtils.getExecutionScope((PsiElement)node);
                if (!(scope instanceof JSFunction)) {
                    return;
                }
                if (!ES6PsiUtil.isAsyncContext((JSFunction)scope)) {
                    return;
                }
                boolean ownIsAsyncGenerator = ES6PsiUtil.isGeneratorContext((JSFunction)scope);
                JSExpression methodExpression = node.getMethodExpression();
                boolean isAsyncFunctionCall = false;
                boolean sourceIsAsyncGenerator = false;
                if (!(methodExpression instanceof JSReferenceExpression)) {
                    return;
                }
                for (ResolveResult result2 : results = ((JSReferenceExpression)methodExpression).multiResolve(false)) {
                    JSType jsType;
                    if (!result2.isValidResult()) continue;
                    PsiElement source = result2.getElement();
                    if (source != null && !(source instanceof JSFunction)) {
                        source = JSPsiImplUtils.calculatePossibleFunction(source, (PsiElement)methodExpression, true);
                    }
                    if (source instanceof JSFunction && ES6PsiUtil.isAsyncContext((JSFunction)source) && (jsType = JSResolveUtil.getExpressionJSType(methodExpression)) != null && (jsType.getSource().isStrict() || ES6MissingAwaitInspection.isSimpleFunctionType(jsType))) {
                        isAsyncFunctionCall = true;
                        sourceIsAsyncGenerator = ES6PsiUtil.isGeneratorContext((JSFunction)source);
                        continue;
                    }
                    return;
                }
                if (!isAsyncFunctionCall) {
                    return;
                }
                if (sourceIsAsyncGenerator && ownIsAsyncGenerator && (nodeParent = parent.getParent()) instanceof JSYieldExpression && ((JSYieldExpression)nodeParent).isIterable()) {
                    return;
                }
                holder.registerProblem((PsiElement)node, JSBundle.message((String)(sourceIsAsyncGenerator && parent.getParent() instanceof JSForInStatement ? "js.missing.await.symbol.inspection.for.generator.name" : "js.missing.await.symbol.inspection.name"), (Object[])new Object[0]), new LocalQuickFix[]{new ES6InsertAwaitFix(node, sourceIsAsyncGenerator)});
            }
        };
        if (jSElementVisitor == null) {
            ES6MissingAwaitInspection.$$$reportNull$$$0(0);
        }
        return jSElementVisitor;
    }

    private static boolean isSimpleFunctionType(@Nullable JSType jsType) {
        return jsType instanceof JSTypeImpl && ((JSTypeImpl)jsType).inheritsFunction();
    }

    private static boolean needProcess(@NotNull JSExpression expression, @Nullable PsiElement parent) {
        if (expression == null) {
            ES6MissingAwaitInspection.$$$reportNull$$$0(1);
        }
        if (parent == null || parent instanceof JSArgumentList || parent instanceof JSAssignmentExpression || parent instanceof JSReferenceExpression || parent instanceof JSFile) {
            return false;
        }
        if (parent instanceof JSForInStatement && ((JSForInStatement)parent).isForAwait() && ((JSForInStatement)parent).getCollectionExpression() == expression) {
            return false;
        }
        if (ES6PsiUtil.isAwaitExpression(parent)) {
            return false;
        }
        if (parent instanceof JSVariable && ((JSVariable)parent).getTypeElement() != null) {
            return false;
        }
        if (parent instanceof JSArrayLiteralExpression) {
            return ES6MissingAwaitInspection.needProcess(expression, JSUtils.getParentSkipParentheses(parent));
        }
        if (parent instanceof JSConditionalExpression) {
            JSConditionalExpression conditionalExpression = (JSConditionalExpression)parent;
            if (conditionalExpression.getCondition() == expression) {
                return true;
            }
            return ES6MissingAwaitInspection.needProcess(expression, JSUtils.getParentSkipParentheses(parent));
        }
        return true;
    }

    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.missing.await.symbol.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            ES6MissingAwaitInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6MissingAwaitInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6MissingAwaitInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "needProcess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

