/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint;

import com.google.common.collect.ImmutableMap;
import com.intellij.lang.javascript.linter.jshint.JSHintUtil;
import com.intellij.lang.javascript.linter.option.Option;
import com.intellij.lang.javascript.linter.option.OptionType;
import com.intellij.lang.javascript.linter.option.OptionTypes;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum JSHintOption implements Option
{
    BITWISE(OptionTypes.BOOLEAN, false, "Warn about using bitwise operators"),
    CAMELCASE(OptionTypes.BOOLEAN, false, "Warn about variable naming"),
    CURLY(OptionTypes.BOOLEAN, false, "Warn when blocks omit <code>{}</code>"),
    ENFORCEALL(OptionTypes.BOOLEAN, false, "Warn when code doesn't follow the most strict configuration"),
    EQEQEQ(OptionTypes.BOOLEAN, false, "Warn about unsafe comparisons"),
    ES3(OptionTypes.BOOLEAN, false, "Warn about incompatibilities with the ES3 specification"),
    ES5(OptionTypes.BOOLEAN, false, "Warn about incompatibilities with the ES5 specification"),
    FORIN(OptionTypes.BOOLEAN, false, "Warn about unsafe <code>for..in</code>"),
    FREEZE(OptionTypes.BOOLEAN, false, "Warn about overwriting prototypes of native objects"),
    IMMED(OptionTypes.BOOLEAN, false, "Warn about the use of immediate function invocations without wrapping them in parentheses"),
    NEWCAP(OptionTypes.BOOLEAN, false, "Warn about the use of a uncapitalized constructor"),
    NOARG(OptionTypes.BOOLEAN, false, "Warn about <code>arguments.caller</code> and <code>.callee</code>"),
    NOCOMMA(OptionTypes.BOOLEAN, false, "Warn about the use of the comma operator"),
    NOEMPTY(OptionTypes.BOOLEAN, false, "Warn about empty blocks"),
    NONBSP(OptionTypes.BOOLEAN, false, "Warn about \"non-breaking whitespace\" characters"),
    NONEW(OptionTypes.BOOLEAN, false, "Warn about <code>new</code> usage for side effects"),
    PLUSPLUS(OptionTypes.BOOLEAN, false, "Warn about the use of unary increment and decrement operators"),
    UNDEF(OptionTypes.BOOLEAN, false, "Warn when variable is undefined"),
    VARSTMT(OptionTypes.BOOLEAN, false, "Warn about the use of VariableStatements"),
    ESVERSION(OptionTypes.INTEGER, null, "Warn about incompatibilities with the specified ECMAScript version"),
    STRICT(OptionTypes.BOOLEAN, false, "Warn when code is not in strict mode"),
    TRAILING(OptionTypes.BOOLEAN, false, "Warn about trailing whitespace"),
    LATEDEF(JSHintUtil.LATEDEF_TYPE, false, "Warn about the use of a variable before it was defined"),
    UNUSED(JSHintUtil.UNUSED_TYPE, false, "Warn about unused variables"),
    INDENT(OptionTypes.INTEGER, null, "Indentation"),
    QUOTMARK(JSHintUtil.QUOTMARK_TYPE, false, "Quotation marks"),
    MAXPARAMS(OptionTypes.INTEGER, null, "Max number of formal parameter in function"),
    MAXDEPTH(OptionTypes.INTEGER, null, "Max depth of your blocks"),
    MAXSTATEMENTS(OptionTypes.INTEGER, null, "Max number of statements in function"),
    MAXCOMPLEXITY(OptionTypes.INTEGER, null, "Max cyclomatic complexity throughout your code"),
    MAXLEN(OptionTypes.INTEGER, null, "Max length of a line"),
    ASI(OptionTypes.BOOLEAN, false, "Suppress warnings about missing semicolons"),
    BOSS(OptionTypes.BOOLEAN, false, "Suppress warnings about assignments inside <code>if/for/...</code>"),
    DEBUG(OptionTypes.BOOLEAN, false, "Suppress warnings about debugging code"),
    ELISION(OptionTypes.BOOLEAN, false, "Suppress warnings about ES3 array elision elements"),
    EQNULL(OptionTypes.BOOLEAN, false, "Suppress warnings about <code>== null</code>"),
    ESNEXT(OptionTypes.BOOLEAN, false, "EcmaScript.next"),
    EVIL(OptionTypes.BOOLEAN, false, "Suppress warnings about <code>eval</code>"),
    EXPR(OptionTypes.BOOLEAN, false, "Suppress warnings about the use of expressions as statements"),
    FUNCSCOPE(OptionTypes.BOOLEAN, false, "Suppress warnings about variable usage outside of its declared block"),
    FUTUREHOSTILE(OptionTypes.BOOLEAN, false, "Warns about the use of identifiers which are defined in future versions of JavaScript"),
    GCL(OptionTypes.BOOLEAN, false, "Makes JSHint compatible with Google Closure Compiler"),
    GLOBALSTRICT(OptionTypes.BOOLEAN, false, "Suppress warnings about the use of global strict mode"),
    ITERATOR(OptionTypes.BOOLEAN, false, "Suppress warnings about the <code>__iterator__</code> property"),
    LASTSEMIC(OptionTypes.BOOLEAN, false, "Suppress warnings about missing semicolons, but only when the semicolon is omitted for the last statement in a one-line block"),
    LAXBREAK(OptionTypes.BOOLEAN, false, "Suppress warnings about unsafe line breaks"),
    LAXCOMMA(OptionTypes.BOOLEAN, false, "Suppress warnings about comma-first coding style"),
    LOOPFUNC(OptionTypes.BOOLEAN, false, "Suppress warnings about functions inside loops"),
    MOZ(OptionTypes.BOOLEAN, false, "Check if your code uses Mozilla JavaScript extensions"),
    MULTISTR(OptionTypes.BOOLEAN, false, "Suppress warnings about multi-line strings"),
    NOTYPEOF(OptionTypes.BOOLEAN, false, "Suppress warnings about invalid <code>typeof</code> operator values"),
    PROTO(OptionTypes.BOOLEAN, false, "Suppress warnings about the <code>__proto__</code> property"),
    SCRIPTURL(OptionTypes.BOOLEAN, false, "Suppress warnings about the use of script-targeted URLs"),
    SMARTTABS(OptionTypes.BOOLEAN, false, "Suppress warnings about mixed tabs and spaces when the latter are used for alignment only"),
    SHADOW(OptionTypes.BOOLEAN, false, "Suppress warnings about variable shadowing"),
    SINGLEGROUPS("singleGroups", OptionTypes.BOOLEAN, false, "Prohibits the use of the grouping operator when it is not strictly required"),
    SUB(OptionTypes.BOOLEAN, false, "Suppress warnings about using <code>[]</code> notation when it can be expressed in dot notation"),
    SUPERNEW(OptionTypes.BOOLEAN, false, "Suppress warnings about \"weird\" constructions"),
    VALIDTHIS(OptionTypes.BOOLEAN, false, "Suppress warnings about possible strict violations"),
    WITHSTMT(OptionTypes.BOOLEAN, false, "Suppresses warnings about the use of the with statement"),
    NOYIELD(OptionTypes.BOOLEAN, false, "Suppress warnings about generator functions with no yield statement in them"),
    BROWSER(OptionTypes.BOOLEAN, false, "Browser"),
    BROWSERIFY(OptionTypes.BOOLEAN, false, "Browserify"),
    COUCH(OptionTypes.BOOLEAN, false, "CouchDB"),
    DEVEL(OptionTypes.BOOLEAN, false, "Development"),
    DOJO(OptionTypes.BOOLEAN, false, "Dojo Toolkit"),
    JASMINE(OptionTypes.BOOLEAN, false, "Jasmine"),
    JQUERY(OptionTypes.BOOLEAN, false, "jQuery"),
    MOCHA(OptionTypes.BOOLEAN, false, "Mocha"),
    MODULE(OptionTypes.BOOLEAN, false, "ECMAScript 6 module"),
    MOOTOOLS(OptionTypes.BOOLEAN, false, "MooTools"),
    NODE(OptionTypes.BOOLEAN, false, "Node.js"),
    NONSTANDARD(OptionTypes.BOOLEAN, false, "escape and unescape"),
    PHANTOM(OptionTypes.BOOLEAN, false, "PhantomJS"),
    PROTOTYPEJS(OptionTypes.BOOLEAN, false, "Prototype"),
    QUNIT(OptionTypes.BOOLEAN, false, "QUnit"),
    RHINO(OptionTypes.BOOLEAN, false, "Rhino"),
    SHELLJS(OptionTypes.BOOLEAN, false, "ShellJS"),
    TYPED(OptionTypes.BOOLEAN, false, "Typed arrays"),
    WORKER(OptionTypes.BOOLEAN, false, "Web Worker"),
    WSH(OptionTypes.BOOLEAN, false, "Windows Script Host"),
    YUI(OptionTypes.BOOLEAN, false, "YUI"),
    NOMEN(OptionTypes.BOOLEAN, false, "Disallow the use of _ in variables"),
    ONEVAR(OptionTypes.BOOLEAN, false, "One var statement per function"),
    PASSFAIL(OptionTypes.BOOLEAN, false, "Stop on first error"),
    WHITE(OptionTypes.BOOLEAN, false, "Disallow messy white space"),
    MAXERR(OptionTypes.INTEGER, 50, "Maximum number of errors"),
    PREDEF(OptionTypes.STRING, null, "Predefined ( , separated)", "globals");

    private static final ImmutableMap<String, JSHintOption> OPTION_BY_KEY_MAP;
    private final OptionType<Object> myType;
    private final Object myDefaultValue;
    private final String myKey;
    private final List<Fragment> myShortDescriptionFragments;
    private final String myShortDescription;
    private final String myKeyAlias;

    private JSHintOption(@NotNull OptionType<?> type, Object defaultValue, String rawShortDescription) {
        if (type == null) {
            JSHintOption.$$$reportNull$$$0(0);
        }
        if (rawShortDescription == null) {
            JSHintOption.$$$reportNull$$$0(1);
        }
        this(type, defaultValue, rawShortDescription, null);
    }

    private JSHintOption(@Nullable String key, @NotNull OptionType<?> type, Object defaultValue, String rawShortDescription) {
        if (key == null) {
            JSHintOption.$$$reportNull$$$0(2);
        }
        if (type == null) {
            JSHintOption.$$$reportNull$$$0(3);
        }
        if (rawShortDescription == null) {
            JSHintOption.$$$reportNull$$$0(4);
        }
        this(key, type, defaultValue, rawShortDescription, null);
    }

    private JSHintOption(@NotNull OptionType<?> type, @Nullable Object defaultValue, String rawShortDescription, String keyAlias) {
        if (type == null) {
            JSHintOption.$$$reportNull$$$0(5);
        }
        if (rawShortDescription == null) {
            JSHintOption.$$$reportNull$$$0(6);
        }
        this(null, type, defaultValue, rawShortDescription, keyAlias);
    }

    private JSHintOption(@Nullable String key, @NotNull OptionType<?> type, @Nullable Object defaultValue, String rawShortDescription, String keyAlias) {
        if (type == null) {
            JSHintOption.$$$reportNull$$$0(7);
        }
        if (rawShortDescription == null) {
            JSHintOption.$$$reportNull$$$0(8);
        }
        this.myType = type;
        this.myDefaultValue = defaultValue;
        this.myKey = key != null ? key : this.name().toLowerCase(Locale.ENGLISH);
        this.myKeyAlias = keyAlias;
        this.myShortDescriptionFragments = JSHintOption.parseTextFragments(rawShortDescription);
        this.myShortDescription = JSHintOption.join(this.myShortDescriptionFragments);
        if (defaultValue != null && !this.myType.isValidValue(defaultValue)) {
            throw new RuntimeException("Illegal default value '" + defaultValue + "' for key '" + this.myKey + "'");
        }
    }

    @Override
    @NotNull
    public String getKey() {
        String string = this.myKey;
        if (string == null) {
            JSHintOption.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public OptionType<Object> getType() {
        OptionType<Object> optionType = this.myType;
        if (optionType == null) {
            JSHintOption.$$$reportNull$$$0(10);
        }
        return optionType;
    }

    @Nullable
    public Object fromString(@Nullable String valueStr) {
        Object parsed = null;
        if (valueStr != null) {
            parsed = this.myType.fromString(valueStr);
        }
        return parsed != null ? parsed : this.myDefaultValue;
    }

    @NotNull
    public String getShortDescription() {
        String string = this.myShortDescription;
        if (string == null) {
            JSHintOption.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    public String getKeyAlias() {
        return this.myKeyAlias;
    }

    @NotNull
    public List<Fragment> getShortDescriptionFragments() {
        List<Fragment> list = this.myShortDescriptionFragments;
        if (list == null) {
            JSHintOption.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Nullable
    public static JSHintOption findByName(@NotNull String optionName) {
        if (optionName == null) {
            JSHintOption.$$$reportNull$$$0(13);
        }
        return (JSHintOption)OPTION_BY_KEY_MAP.get((Object)optionName);
    }

    public String toString() {
        return this.name() + ", type: " + this.getType();
    }

    @Nullable
    public Object getDefaultValue() {
        return this.myDefaultValue;
    }

    @NotNull
    private static List<Fragment> parseTextFragments(@NotNull String text) {
        if (text == null) {
            JSHintOption.$$$reportNull$$$0(14);
        }
        ArrayList fragments = ContainerUtil.newArrayList();
        int unprocessedIndex = 0;
        String startTag = "<code>";
        String endTag = "</code>";
        while (unprocessedIndex < text.length()) {
            int endIndex;
            int startIndex = text.indexOf(startTag, unprocessedIndex);
            boolean hasCodeFragment = false;
            if (startIndex >= 0 && (endIndex = text.indexOf(endTag, startIndex)) >= 0) {
                fragments.add(new Fragment(text.substring(unprocessedIndex, startIndex), false));
                fragments.add(new Fragment(text.substring(startIndex + startTag.length(), endIndex), true));
                unprocessedIndex = endIndex + endTag.length();
                hasCodeFragment = true;
            }
            if (hasCodeFragment) continue;
            fragments.add(new Fragment(text.substring(unprocessedIndex), false));
            unprocessedIndex = text.length();
        }
        ArrayList arrayList = fragments;
        if (arrayList == null) {
            JSHintOption.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    private static String join(@NotNull List<Fragment> fragments) {
        if (fragments == null) {
            JSHintOption.$$$reportNull$$$0(16);
        }
        StringBuilder out = new StringBuilder();
        for (Fragment fragment : fragments) {
            out.append(fragment.getText());
        }
        return out.toString();
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (JSHintOption option : JSHintOption.values()) {
            builder.put((Object)option.getKey(), (Object)option);
            String keyAlias = option.getKeyAlias();
            if (keyAlias == null) continue;
            builder.put((Object)keyAlias, (Object)option);
        }
        OPTION_BY_KEY_MAP = builder.build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawShortDescription";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/jshint/JSHintOption";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/jshint/JSHintOption";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortDescription";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortDescriptionFragments";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTextFragments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findByName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseTextFragments";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Fragment {
        private final String myText;
        private final boolean myCode;

        private Fragment(@NotNull String text, boolean code) {
            if (text == null) {
                Fragment.$$$reportNull$$$0(0);
            }
            this.myText = text;
            this.myCode = code;
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                Fragment.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isCode() {
            return this.myCode;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/jshint/JSHintOption$Fragment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/jshint/JSHintOption$Fragment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

