/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSVarStatementBase;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSVarStatementStub;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSVarStatementImpl
extends JSVarStatementBase {
    private static final Function<ASTNode, List<ASTNode>> GET_VARS = variable -> {
        ASTNode[] children = variable.getChildren(VARIABLES_AND_DESTRUCTURING_CONTAINERS);
        return Arrays.asList(children);
    };
    private static final Function<ASTNode, JSVariable> TO_VAR = var -> {
        PsiElement psi = var.getPsi();
        return psi instanceof JSVariable ? (JSVariable)psi : null;
    };
    private static final Function<StubBasedPsiElementBase, List<StubBasedPsiElementBase>> GET_STUB_SAFE_VARS = variable -> {
        PsiElement[] children = variable.getStubOrPsiChildren(VARIABLES_AND_DESTRUCTURING_CONTAINERS, StubBasedPsiElementBase[]::new);
        return Arrays.asList((StubBasedPsiElementBase[])children);
    };
    private static final Function<StubBasedPsiElementBase, JSVariable> TO_STUB_SAFE_VAR = var -> var instanceof JSVariable ? (JSVariable)var : null;

    public JSVarStatementImpl(ASTNode node) {
        super(node);
    }

    public JSVarStatementImpl(JSVarStatementStub node) {
        super(node, (IStubElementType)JSStubElementTypes.VAR_STATEMENT);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            JSVarStatementImpl.$$$reportNull$$$0(0);
        }
        if (state == null) {
            JSVarStatementImpl.$$$reportNull$$$0(1);
        }
        if (place == null) {
            JSVarStatementImpl.$$$reportNull$$$0(2);
        }
        if (ActionScriptResolveUtil.weShouldSkipResolveBecauseOfImplicitClass((PsiElement)this)) {
            return true;
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    @NotNull
    public JSInitializerOwner[] getDeclarations() {
        ASTNode[] nodes = this.getNode().getChildren(TOP_LEVEL_DECLARATIONS);
        JSInitializerOwner[] declarations = (JSInitializerOwner[])JSInitializerOwner.ARRAY_FACTORY.create(nodes.length);
        for (int i = 0; i < declarations.length; ++i) {
            declarations[i] = (JSInitializerOwner)nodes[i].getPsi();
        }
        if (declarations == null) {
            JSVarStatementImpl.$$$reportNull$$$0(3);
        }
        return declarations;
    }

    @NotNull
    public JSVariable[] getVariables() {
        JSVariable[] jSVariableArray = JSVarStatementImpl.calcVariables(this.getNode(), GET_VARS, TO_VAR);
        if (jSVariableArray == null) {
            JSVarStatementImpl.$$$reportNull$$$0(4);
        }
        return jSVariableArray;
    }

    @NotNull
    public JSVariable[] getStubSafeVariables() {
        JSVariable[] jSVariableArray = JSVarStatementImpl.calcVariables(this, GET_STUB_SAFE_VARS, TO_STUB_SAFE_VAR);
        if (jSVariableArray == null) {
            JSVarStatementImpl.$$$reportNull$$$0(5);
        }
        return jSVariableArray;
    }

    private static <T> JSVariable[] calcVariables(T root, Function<T, List<T>> getChildren, Function<T, JSVariable> toVar) {
        ArrayDeque<Object> candidates = new ArrayDeque<Object>();
        candidates.add(root);
        ArrayList result2 = ContainerUtil.newArrayList();
        while (!candidates.isEmpty()) {
            Object poll = candidates.poll();
            JSVariable jsVariable = (JSVariable)toVar.fun(poll);
            if (jsVariable != null) {
                result2.add(jsVariable);
                continue;
            }
            List children = (List)getChildren.fun(poll);
            for (int i = children.size() - 1; i >= 0; --i) {
                candidates.addFirst(children.get(i));
            }
        }
        return result2.toArray(JSVariable.EMPTY_ARRAY);
    }

    @Override
    protected boolean shouldDirectProcessVariables(@NotNull PsiScopeProcessor processor, PsiElement lastParent) {
        if (processor == null) {
            JSVarStatementImpl.$$$reportNull$$$0(6);
        }
        if (super.shouldDirectProcessVariables(processor, lastParent)) {
            return true;
        }
        JSVarStatement.VarKeyword keyword = this.getVarKeyword();
        return keyword == JSVarStatement.VarKeyword.LET || keyword == JSVarStatement.VarKeyword.CONST;
    }

    @Override
    public JSVarStatement.VarKeyword getVarKeyword() {
        JSVarStatementStub stub = (JSVarStatementStub)this.getGreenStub();
        if (stub != null) {
            return stub.getVarKeyword();
        }
        ASTNode keyword = this.getNode().findChildByType(JSTokenTypes.VAR_MODIFIERS);
        if (keyword == null) {
            return null;
        }
        IElementType elementType = keyword.getElementType();
        if (elementType == JSTokenTypes.VAR_KEYWORD) {
            return JSVarStatement.VarKeyword.VAR;
        }
        if (elementType == JSTokenTypes.LET_KEYWORD) {
            return JSVarStatement.VarKeyword.LET;
        }
        if (elementType == JSTokenTypes.CONST_KEYWORD) {
            return JSVarStatement.VarKeyword.CONST;
        }
        assert (false) : "unsupported var keyword " + keyword.getElementType().toString();
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSVarStatementImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSVarStatementImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarations";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariables";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubSafeVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "shouldDirectProcessVariables";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

