/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.actionscript.ActionScriptElementTypes;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSIncludeDirective;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionScriptResolveUtil {
    public static final String AS3_NAMESPACE = "AS3";
    @NonNls
    private static final String SCRIPT_TAG_NAME = "Script";
    public static final String ADD_EVENT_LISTENER_METHOD = "addEventListener";
    public static final String REMOVE_EVENT_LISTENER_METHOD = "removeEventListener";
    private static final List<Class<? extends JSElement>> ANONYMOUS_EVENT_LISTENER_CLASSES = Arrays.asList(JSFunctionExpression.class, JSParenthesizedExpression.class, JSCallExpression.class, JSExpressionStatement.class, JSFile.class);
    private static final TokenSet mainDeclaredElementTokenSet = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.CLASS, ActionScriptElementTypes.FUNCTION_DECLARATION, JSStubElementTypes.NAMESPACE_DECLARATION}), JSElementTypes.VAR_STATEMENTS});
    @NonNls
    public static final String FLASH_EVENTS_IEVENT_DISPATCHER = "flash.events.IEventDispatcher";

    public static boolean isAnonymousEventHandlerTag(JSFile jsFile) {
        PsiElement context = jsFile.getContext();
        return context instanceof XmlText && !SCRIPT_TAG_NAME.equals(((XmlTag)context.getParent()).getLocalName());
    }

    public static boolean isAnonymousEventHandlerAttribute(JSFile jsFile) {
        PsiElement context = jsFile.getContext();
        return context instanceof XmlAttributeValue;
    }

    public static boolean isAnonymousEventHandler(JSFunctionExpression expr) {
        JSFile file2 = (JSFile)ActionScriptResolveUtil.iterateUp((PsiElement)expr, ANONYMOUS_EVENT_LISTENER_CLASSES);
        return file2 != null && (ActionScriptResolveUtil.isAnonymousEventHandlerTag(file2) || ActionScriptResolveUtil.isAnonymousEventHandlerAttribute(file2));
    }

    public static boolean isInsideAnonymousEventHandler(PsiElement element) {
        return ActionScriptResolveUtil.computeIfInsideAnonymousEventHandler(element, new ConstantFunction((Object)Boolean.TRUE)) != null;
    }

    @Nullable
    public static <T> T computeIfInsideAnonymousEventHandler(PsiElement psiElement, Function<? super JSFunctionExpression, ? extends T> function) {
        while (psiElement instanceof JSExpression) {
            psiElement = psiElement.getParent();
        }
        if (psiElement instanceof JSArgumentList) {
            JSExpression methodExpression = ((JSCallExpression)psiElement.getParent()).getMethodExpression();
            if (methodExpression instanceof JSParenthesizedExpression) {
                methodExpression = ((JSParenthesizedExpression)methodExpression).getInnerExpression();
            }
            if (methodExpression instanceof JSFunctionExpression && ActionScriptResolveUtil.isAnonymousEventHandler((JSFunctionExpression)methodExpression)) {
                return (T)function.fun((Object)((JSFunctionExpression)methodExpression));
            }
        }
        return null;
    }

    @Nullable
    private static PsiElement iterateUp(PsiElement element, List<Class<? extends JSElement>> classes) {
        Iterator<Class<? extends JSElement>> i = classes.iterator();
        while (i.hasNext()) {
            if (element == null || !i.next().isInstance(element)) {
                return null;
            }
            if (!i.hasNext()) continue;
            element = element.getParent();
        }
        return element;
    }

    public static <E extends PsiElement> void processIncludedFiles(TokenSet filter, JSFile file2, ArrayList<E> result2, Collection<? super JSFile> visited) {
        if (visited.contains(file2)) {
            return;
        }
        visited.add((JSFile)file2);
        for (PsiElement element : JSResolveUtil.getStubbedChildren((PsiElement)file2, filter)) {
            if (element instanceof JSIncludeDirective) {
                PsiFile includedFile = ((JSIncludeDirective)element).resolveFile();
                if (!(includedFile instanceof JSFile)) continue;
                ActionScriptResolveUtil.processIncludedFiles(filter, (JSFile)includedFile, result2, visited);
                continue;
            }
            result2.add(element);
        }
    }

    public static boolean isImplicitlyDeclaringEventDispatcher(JSAttributeList attributeList) {
        return attributeList != null && attributeList.getAttributesByName("Bindable").length != 0;
    }

    public static String replaceInternalName(String name) {
        return "Vector$object".equals(name) ? "Vector" : name;
    }

    public static boolean checkProcessFunctionPreconditions(@NotNull JSFunction function, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        boolean resolvingNewExpressionInOtherASClass;
        if (function == null) {
            ActionScriptResolveUtil.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            ActionScriptResolveUtil.$$$reportNull$$$0(1);
        }
        if (state == null) {
            ActionScriptResolveUtil.$$$reportNull$$$0(2);
        }
        if (place == null) {
            ActionScriptResolveUtil.$$$reportNull$$$0(3);
        }
        if (!Boolean.TRUE.equals(state.get(XmlBackedJSClass.PROCESS_XML_BACKED_CLASS_MEMBERS_HINT)) && ActionScriptResolveUtil.weShouldSkipResolveBecauseOfImplicitClass((PsiElement)function)) {
            return true;
        }
        boolean bl = resolvingNewExpressionInOtherASClass = DialectDetector.isActionScript((PsiElement)function.getContainingFile()) && processor instanceof ResolveProcessor && ((ResolveProcessor)processor).isTypeContext() && place instanceof JSReferenceExpression && place.getParent() instanceof JSNewExpression && JSResolveUtil.getClassOfContext(place) != JSResolveUtil.getClassOfContext((PsiElement)function);
        return resolvingNewExpressionInOtherASClass && function.isConstructor();
    }

    public static boolean hasExcludeClassMetadata(@NotNull JSAttributeListOwner attributeListOwner) {
        JSAttributeList attributeList;
        if (attributeListOwner == null) {
            ActionScriptResolveUtil.$$$reportNull$$$0(4);
        }
        return (attributeList = attributeListOwner.getAttributeList()) != null && attributeList.findAttributeByName("ExcludeClass") != null;
    }

    public static boolean processMetaAttributesForClass(PsiElement jsClass, MetaDataProcessor processor) {
        return ActionScriptResolveUtil.processMetaAttributesForClass(jsClass, processor, true);
    }

    public static boolean processMetaAttributesForClass(PsiElement jsClass, MetaDataProcessor processor, boolean withIncludedFiles) {
        return ActionScriptResolveUtil.doProcessMetaAttributesForClass(jsClass, processor, null, true, withIncludedFiles);
    }

    private static boolean doProcessMetaAttributesForClass(PsiElement jsClass, MetaDataProcessor processor, PsiElement lastParent, boolean forward, boolean withIncludedFiles) {
        int i;
        PsiElement[] elements;
        if (jsClass instanceof JSClass) {
            PsiElement current;
            int ind;
            if ("Object".equals(((JSClass)jsClass).getQualifiedName())) {
                return true;
            }
            elements = JSResolveUtil.getStubbedChildren(jsClass.getContext());
            for (ind = elements.length - 1; ind >= 0 && elements[ind] != jsClass; --ind) {
            }
            --ind;
            while (ind >= 0 && (current = elements[ind]) instanceof JSIncludeDirective) {
                if (withIncludedFiles && !ActionScriptResolveUtil.processIncludeDirective(processor, jsClass, (JSIncludeDirective)current, false)) {
                    return false;
                }
                --ind;
            }
            JSAttributeList attributeList = ((JSClass)jsClass).getAttributeList();
            if (attributeList != null && !ActionScriptResolveUtil.processAttributeList(processor, jsClass, attributeList, true, withIncludedFiles)) {
                return false;
            }
        }
        elements = JSResolveUtil.getStubbedChildren(jsClass);
        Ref continuePassElement = new Ref();
        int n = i = forward ? 0 : elements.length - 1;
        while (i < elements.length && i >= 0) {
            PsiElement el = elements[i];
            if (el instanceof JSIncludeDirective) {
                if (withIncludedFiles && !ActionScriptResolveUtil.processIncludeDirective(processor, lastParent, (JSIncludeDirective)el, forward)) {
                    return false;
                }
            } else if (el instanceof JSAttributeList) {
                if (!ActionScriptResolveUtil.processAttributeList(processor, lastParent, (JSAttributeList)el, forward, withIncludedFiles)) {
                    return false;
                }
            } else {
                JSAttributeList attributeList;
                continuePassElement.set(null);
                if (!processor.handleOtherElement(el, jsClass, (Ref<PsiElement>)continuePassElement)) {
                    return false;
                }
                PsiElement nextEl = (PsiElement)continuePassElement.get();
                if (nextEl instanceof JSAttributeListOwner && (attributeList = ((JSAttributeListOwner)nextEl).getAttributeList()) != null && !ActionScriptResolveUtil.processAttributeList(processor, nextEl, attributeList, forward, withIncludedFiles)) {
                    return false;
                }
            }
            i += forward ? 1 : -1;
        }
        return true;
    }

    private static boolean processIncludeDirective(MetaDataProcessor processor, PsiElement lastParent, JSIncludeDirective el, boolean forward) {
        PsiFile file2 = el.resolveFile();
        return !(file2 instanceof JSFile) || ActionScriptResolveUtil.doProcessMetaAttributesForClass((PsiElement)file2, processor, lastParent, forward, true);
    }

    public static boolean processAttributeList(MetaDataProcessor processor, PsiElement el, JSAttributeList attributeList, boolean forward, boolean withIncludedFiles) {
        int i;
        PsiElement[] elements = JSResolveUtil.getStubbedChildren((PsiElement)attributeList);
        int n = i = forward ? 0 : elements.length - 1;
        while (i < elements.length && i >= 0) {
            PsiElement cur = elements[i];
            if (cur instanceof JSIncludeDirective) {
                if (withIncludedFiles && !ActionScriptResolveUtil.processIncludeDirective(processor, el, (JSIncludeDirective)cur, forward)) {
                    return false;
                }
            } else if (cur instanceof JSAttribute) {
                if (!processor.process((JSAttribute)cur)) {
                    return false;
                }
            } else if (cur instanceof JSNamedElement) break;
            i += forward ? 1 : -1;
        }
        return processor.handleOtherElement((PsiElement)attributeList, el, null);
    }

    public static boolean fieldIsImplicitAccessorMethod(JSFunction fun, JSVariable var) {
        JSAttributeList clazzAttributeList;
        if (!fun.isGetProperty() && !fun.isSetProperty()) {
            return false;
        }
        PsiElement funParent = JSResolveUtil.findParent((PsiElement)fun);
        if (!(funParent instanceof JSClass) || !((JSClass)funParent).isInterface()) {
            return false;
        }
        PsiElement parent = JSResolveUtil.findParent((PsiElement)var);
        if (!(parent instanceof JSClass)) {
            return false;
        }
        JSAttributeList attributeList = var.getAttributeList();
        if (attributeList == null || attributeList.getAccessType() != JSAttributeList.AccessType.PUBLIC) {
            return false;
        }
        JSClass clazz = (JSClass)parent;
        if (attributeList.findAttributeByName("Bindable") == null && ((clazzAttributeList = clazz.getAttributeList()) == null || clazzAttributeList.findAttributeByName("Bindable") == null)) {
            return false;
        }
        for (JSClass c : clazz.getImplementedInterfaces()) {
            if (c != funParent) continue;
            return true;
        }
        return false;
    }

    public static boolean weShouldSkipResolveBecauseOfImplicitClass(PsiElement elt) {
        if (elt == null) {
            return false;
        }
        PsiElement responsibleElement = elt instanceof JSFile ? elt : elt.getParent();
        return responsibleElement instanceof JSFile && DialectDetector.isActionScript(responsibleElement) && responsibleElement.getContext() != null;
    }

    public static String findPackageForMxml(PsiElement expression) {
        String s = null;
        PsiFile containingFile = expression.getContainingFile();
        if (containingFile.getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4 && containingFile.getContext() != null) {
            PsiFile contextContainigFile = containingFile.getContext().getContainingFile();
            VirtualFile file2 = contextContainigFile.getOriginalFile().getVirtualFile();
            s = JSResolveUtil.getExpectedPackageNameFromFile(file2, containingFile.getProject());
        }
        return s;
    }

    @Nullable
    public static JSNamedElement findMainDeclaredElement(@NotNull PsiFileImpl file2) {
        if (file2 == null) {
            ActionScriptResolveUtil.$$$reportNull$$$0(5);
        }
        JSNamedElement mainDeclaredElement = null;
        StubElement stub = file2.getStub();
        if (stub != null) {
            StubElement packageStub = stub.findChildStubByType(JSStubElementTypes.PACKAGE_STATEMENT);
            if (packageStub != null) {
                StubElement qualifiedElement = packageStub.findChildStubByType((IStubElementType)JSStubElementTypes.CLASS);
                if (qualifiedElement == null) {
                    qualifiedElement = packageStub.findChildStubByType(ActionScriptElementTypes.FUNCTION_DECLARATION);
                }
                if (qualifiedElement == null) {
                    qualifiedElement = packageStub.findChildStubByType(JSStubElementTypes.NAMESPACE_DECLARATION);
                }
                if (qualifiedElement == null && (qualifiedElement = packageStub.findChildStubByType(JSStubElementTypes.VAR_STATEMENT)) != null) {
                    qualifiedElement = qualifiedElement.findChildStubByType(ActionScriptElementTypes.VARIABLE);
                }
                if (qualifiedElement != null) {
                    mainDeclaredElement = (JSNamedElement)qualifiedElement.getPsi();
                }
            }
        } else {
            JSPackageStatement statement = (JSPackageStatement)file2.findChildByClass(JSPackageStatement.class);
            if (statement != null) {
                ASTNode node = statement.getNode().findChildByType(mainDeclaredElementTokenSet);
                if (node != null && node.getElementType() == JSStubElementTypes.VAR_STATEMENT) {
                    node = node.findChildByType(ActionScriptElementTypes.VARIABLE);
                }
                if (node != null) {
                    mainDeclaredElement = (JSNamedElement)node.getPsi();
                }
            }
        }
        return mainDeclaredElement;
    }

    public static boolean isSpecialCallResolveCaseEcmaScript(PsiElement place, PsiElement lastParent) {
        return lastParent instanceof JSCallExpression && place instanceof JSReferenceExpression && ((JSCallExpression)lastParent).getMethodExpression() == place && ((JSReferenceExpression)place).getQualifier() == null && lastParent.getContainingFile().getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4);
    }

    public static boolean isFileLocalSymbol(PsiElement element) {
        JSAttributeList attrList;
        if (element instanceof XmlBackedJSClass) {
            return false;
        }
        JSPackageStatement packageStatement = (JSPackageStatement)PsiTreeUtil.getContextOfType((PsiElement)element, JSPackageStatement.class, (boolean)false);
        if (packageStatement != null) {
            return false;
        }
        PsiFile file2 = element.getContainingFile();
        if (!(file2 instanceof JSFile)) {
            return false;
        }
        if (file2.getLanguage() != JavaScriptSupportLoader.ECMA_SCRIPT_L4) {
            return false;
        }
        if (file2.getContext() != null) {
            return false;
        }
        String qName = element instanceof JSQualifiedNamedElement ? ((JSQualifiedNamedElement)element).getQualifiedName() : null;
        JSAttributeList jSAttributeList = attrList = element instanceof JSAttributeListOwner ? ((JSAttributeListOwner)element).getAttributeList() : null;
        if (attrList != null) {
            if (attrList.getExplicitAccessType() == JSAttributeList.AccessType.PUBLIC) {
                return !attrList.hasModifier(JSAttributeList.ModifierType.NATIVE) && (qName == null || qName.indexOf(46) == -1);
            }
            if (attrList.getNamespace() != null || qName != null && qName.indexOf(46) != -1) {
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeListOwner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/ActionScriptResolveUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkProcessFunctionPreconditions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hasExcludeClassMetadata";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findMainDeclaredElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface MetaDataProcessor {
        public boolean process(@NotNull JSAttribute var1);

        public boolean handleOtherElement(PsiElement var1, PsiElement var2, @Nullable Ref<PsiElement> var3);
    }
}

