/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSClassBase;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class JSCollectMembersToImplementProcessor
extends ResolveProcessor {
    private final boolean myProcessAll;
    private final NotNullLazyValue<SinkResolveProcessor<?>> myInterfacesProcessor = new NotNullLazyValue<SinkResolveProcessor<?>>(){

        @NotNull
        protected SinkResolveProcessor<?> compute() {
            SinkResolveProcessor sinkResolveProcessor = JSCollectMembersToImplementProcessor.this.createProcessor(JSCollectMembersToImplementProcessor.this.createResultSink());
            if (sinkResolveProcessor == null) {
                1.$$$reportNull$$$0(0);
            }
            return sinkResolveProcessor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSCollectMembersToImplementProcessor$1", "compute"));
        }
    };

    public JSCollectMembersToImplementProcessor(PsiElement context, boolean processAll) {
        super(null, context);
        this.myProcessAll = processAll;
        this.setToSkipClassDeclarationsOnce(true);
        this.setToProcessHierarchy(true);
        this.setToProcessMembers(false);
        this.setTypeContext(true);
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            JSCollectMembersToImplementProcessor.$$$reportNull$$$0(0);
        }
        if (state == null) {
            JSCollectMembersToImplementProcessor.$$$reportNull$$$0(1);
        }
        if (!(element instanceof JSClass)) {
            return true;
        }
        JSClass jsClass = (JSClass)element;
        if (!this.shouldProcessClass(jsClass)) {
            return false;
        }
        SinkResolveProcessor processor = (SinkResolveProcessor)this.myInterfacesProcessor.getValue();
        List implicitlyImplemented = element instanceof JSClassBase ? ((JSClassBase)element).getImplicitlyDeclaredInterfaces() : Collections.emptyList();
        for (JSClass implementedInterface : jsClass.getImplementedInterfaces()) {
            boolean toProcessNext;
            if (JSClassUtils.isAllowImplementation(implementedInterface, this.place) && !implicitlyImplemented.contains(implementedInterface) && !(toProcessNext = implementedInterface.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), (PsiElement)implementedInterface, (PsiElement)implementedInterface)) && !this.myProcessAll) break;
        }
        List<PsiElement> results = processor.getResults();
        if (results != null) {
            this.processMembers(results);
            return false;
        }
        return DialectDetector.isTypeScript((PsiElement)jsClass);
    }

    protected boolean shouldProcessClass(@NotNull JSClass jsClass) {
        if (jsClass == null) {
            JSCollectMembersToImplementProcessor.$$$reportNull$$$0(2);
        }
        return true;
    }

    @NotNull
    private SinkResolveProcessor<ResultSink> createProcessor(@NotNull ResultSink sink) {
        if (sink == null) {
            JSCollectMembersToImplementProcessor.$$$reportNull$$$0(3);
        }
        SinkResolveProcessor<ResultSink> sinkResolveProcessor = new SinkResolveProcessor<ResultSink>(sink){
            {
                this.setToProcessHierarchy(true);
                this.setSkipImplicitDeclarations(true);
            }

            @Override
            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (element instanceof JSFunction) {
                    JSClass containingClass = JSUtils.getMemberContainingClass(element);
                    if (containingClass != null && "Object".equals(containingClass.getQualifiedName()) || ((JSFunction)element).isConstructor()) {
                        return true;
                    }
                } else if (element instanceof TypeScriptPropertySignature) {
                    if (this.place instanceof JSFunction) {
                        JSTypeDeclaration type = ((TypeScriptPropertySignature)element).getTypeDeclaration();
                        if (!JSPsiImplUtils.isGetterOrSetter((JSFunction)this.place)) {
                            return !(type instanceof JSFunction) || super.execute((PsiElement)type, state);
                        }
                    }
                } else {
                    return true;
                }
                return super.execute(element, state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/resolve/JSCollectMembersToImplementProcessor$2";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (sinkResolveProcessor == null) {
            JSCollectMembersToImplementProcessor.$$$reportNull$$$0(4);
        }
        return sinkResolveProcessor;
    }

    protected abstract void processMembers(@NotNull List<PsiElement> var1);

    @NotNull
    protected abstract ResultSink createResultSink();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSCollectMembersToImplementProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSCollectMembersToImplementProcessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcessClass";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createProcessor";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

