/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.ASTNode;
import com.intellij.lang.actionscript.psi.impl.ActionScriptFunctionImpl;
import com.intellij.lang.actionscript.psi.impl.ActionScriptVariableImpl;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSIncludeDirective;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSUseNamespaceDirective;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSClassBase;
import com.intellij.lang.javascript.psi.impl.JSFileBaseImpl;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSAttributeListStub;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSDirectiveCommentUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringTokenizer;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSScopeNamesCache {
    private static final Key<CachedValue<TIntObjectHashMap<Object>>> CACHED_DEFS_KEY = Key.create((String)"JS.CachedDefs");
    public static final Key<CachedValue<TIntObjectHashMap<Object>>> STUBBED_CACHED_DEFS_KEY = Key.create((String)"Stubbed.JS.CachedDefs");

    @NotNull
    public static TIntObjectHashMap<Object> getOrCreateNamesForScope(@NotNull JSElement scope) {
        if (scope == null) {
            JSScopeNamesCache.$$$reportNull$$$0(0);
        }
        if (scope instanceof JSFileBaseImpl && ((JSFileBaseImpl)scope).getStub() != null) {
            TIntObjectHashMap<Object> tIntObjectHashMap = JSScopeNamesCache.getOrCreateNamesForStubScope((PsiElement)scope);
            if (tIntObjectHashMap == null) {
                JSScopeNamesCache.$$$reportNull$$$0(1);
            }
            return tIntObjectHashMap;
        }
        TIntObjectHashMap tIntObjectHashMap = (TIntObjectHashMap)CachedValuesManager.getCachedValue((PsiElement)scope, CACHED_DEFS_KEY, () -> {
            if (scope == null) {
                JSScopeNamesCache.$$$reportNull$$$0(15);
            }
            TIntObjectHashMap relevantDefs = new TIntObjectHashMap();
            JSNamesCacheVisitor elementVisitor = new JSNamesCacheVisitor(scope, (TIntObjectHashMap<Object>)relevantDefs);
            elementVisitor.startVisiting(scope);
            return new CachedValueProvider.Result((Object)relevantDefs, new Object[]{scope});
        });
        if (tIntObjectHashMap == null) {
            JSScopeNamesCache.$$$reportNull$$$0(2);
        }
        return tIntObjectHashMap;
    }

    @NotNull
    public static TIntObjectHashMap<Object> getOrCreateNamesForStubScope(@NotNull PsiElement scope) {
        if (scope == null) {
            JSScopeNamesCache.$$$reportNull$$$0(3);
        }
        TIntObjectHashMap tIntObjectHashMap = (TIntObjectHashMap)CachedValuesManager.getCachedValue((PsiElement)scope, STUBBED_CACHED_DEFS_KEY, () -> {
            if (scope == null) {
                JSScopeNamesCache.$$$reportNull$$$0(14);
            }
            TIntObjectHashMap<Object> relevantDefs = JSStubBasedPsiTreeUtil.buildStubBasedNamesMap(scope);
            return new CachedValueProvider.Result(relevantDefs, new Object[]{scope});
        });
        if (tIntObjectHashMap == null) {
            JSScopeNamesCache.$$$reportNull$$$0(4);
        }
        return tIntObjectHashMap;
    }

    @NotNull
    public static List<JSElement> findNamedElementsInStubScope(@NotNull String name, @NotNull PsiElement scope) {
        if (name == null) {
            JSScopeNamesCache.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            JSScopeNamesCache.$$$reportNull$$$0(6);
        }
        TIntObjectHashMap<Object> defs = JSScopeNamesCache.getOrCreateNamesForStubScope(scope);
        List<JSElement> list = JSScopeNamesCache.getElementsWithName(name, defs);
        if (list == null) {
            JSScopeNamesCache.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public static List<JSElement> getElementsWithName(@NotNull String name, TIntObjectHashMap<Object> defsMap) {
        Object defs;
        if (name == null) {
            JSScopeNamesCache.$$$reportNull$$$0(8);
        }
        if ((defs = defsMap.get(name.hashCode())) instanceof JSElement) {
            List<JSElement> list = Collections.singletonList((JSElement)defs);
            if (list == null) {
                JSScopeNamesCache.$$$reportNull$$$0(9);
            }
            return list;
        }
        if (defs instanceof JSElement[]) {
            List<JSElement> list = Arrays.asList((JSElement[])defs);
            if (list == null) {
                JSScopeNamesCache.$$$reportNull$$$0(10);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            JSScopeNamesCache.$$$reportNull$$$0(11);
        }
        return list;
    }

    public static void addElementCompact(@NotNull TIntObjectHashMap<Object> defs, @NotNull JSElement node, int key) {
        Object o;
        if (defs == null) {
            JSScopeNamesCache.$$$reportNull$$$0(12);
        }
        if (node == null) {
            JSScopeNamesCache.$$$reportNull$$$0(13);
        }
        if ((o = defs.get(key)) == null) {
            defs.put(key, (Object)node);
        } else if (o instanceof JSElement) {
            JSElement[] newO = new JSElement[]{(JSElement)o, node};
            defs.put(key, (Object)newO);
        } else {
            JSElement[] oldO = (JSElement[])o;
            JSElement[] newO = new JSElement[oldO.length + 1];
            System.arraycopy(oldO, 0, newO, 0, oldO.length);
            newO[oldO.length] = node;
            defs.put(key, (Object)newO);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSScopeNamesCache";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defs";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSScopeNamesCache";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateNamesForScope";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateNamesForStubScope";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findNamedElementsInStubScope";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsWithName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateNamesForScope";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateNamesForStubScope";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findNamedElementsInStubScope";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getElementsWithName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addElementCompact";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getOrCreateNamesForStubScope$1";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getOrCreateNamesForScope$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class JSNamesCacheVisitor
    extends JSRecursiveWalkingElementVisitor {
        private Set<JSFile> visitedIncludes;
        private final TIntObjectHashMap<Object> myRelevantDefs;
        private final JSElement myBase;
        private JSElement context;
        private final boolean isTypeScript;
        private final boolean isActionScript;

        public JSNamesCacheVisitor(JSElement base, TIntObjectHashMap<Object> relevantDefs) {
            this.myRelevantDefs = relevantDefs;
            this.myBase = base;
            this.context = base;
            this.isTypeScript = DialectDetector.isTypeScript((PsiElement)base);
            this.isActionScript = DialectDetector.isActionScript((PsiElement)base);
        }

        public void startVisiting(JSElement jsElement) {
            PsiElement first = null;
            PsiElement[] arrayElementsToScan = null;
            if (jsElement instanceof JSFunction) {
                JSSourceElement[] bodyOrSourceElements;
                JSSourceElement[] jSSourceElementArray = bodyOrSourceElements = this.isTypeScript ? JSResolveUtil.getSourceElements((PsiElement)jsElement) : ((JSFunction)jsElement).getBody();
                if (bodyOrSourceElements.length > 0) {
                    if (bodyOrSourceElements[0] instanceof JSBlockStatement) {
                        ASTNode node = bodyOrSourceElements[0].getNode().getFirstChildNode();
                        first = node != null ? node.getPsi() : null;
                    } else {
                        arrayElementsToScan = bodyOrSourceElements;
                    }
                }
            } else if (jsElement instanceof TypeScriptInterface) {
                TypeScriptObjectType body = ((TypeScriptInterface)jsElement).getBody();
                if (body != null) {
                    arrayElementsToScan = new PsiElement[]{body};
                }
            } else if (jsElement instanceof JSClass || jsElement instanceof JSPackageStatement || jsElement instanceof TypeScriptModule) {
                arrayElementsToScan = JSResolveUtil.getSourceElements((PsiElement)jsElement);
            } else if (jsElement instanceof TypeScriptVariable) {
                PsiElement[] typeElement = ((TypeScriptVariable)jsElement).getTypeElement();
                if (typeElement instanceof TypeScriptObjectType) {
                    arrayElementsToScan = new PsiElement[]{typeElement};
                }
            } else if (jsElement instanceof JSVariable) {
                arrayElementsToScan = PsiElement.EMPTY_ARRAY;
            } else if (jsElement instanceof JSObjectLiteralExpression) {
                arrayElementsToScan = ((JSObjectLiteralExpression)jsElement).getProperties();
            } else if (jsElement instanceof JSFile && (this.isActionScript || this.isTypeScript)) {
                arrayElementsToScan = JSResolveUtil.getSourceElements((PsiElement)jsElement);
            } else if (jsElement instanceof JSVarStatement) {
                arrayElementsToScan = this.isActionScript || this.isTypeScript ? ((JSVarStatement)jsElement).getStubSafeVariables() : ((JSVarStatement)jsElement).getVariables();
            } else {
                first = jsElement.getFirstChild();
            }
            if (arrayElementsToScan != null) {
                for (PsiElement elt : arrayElementsToScan) {
                    elt.accept((PsiElementVisitor)this);
                }
            } else {
                for (PsiElement e = first; e != null; e = e.getNextSibling()) {
                    if (!(e instanceof JSSourceElement) && !(e instanceof JSVariable) && !(e instanceof JSProperty) && !(e instanceof JSDestructuringContainer) && !(e instanceof PsiComment)) continue;
                    e.accept((PsiElementVisitor)this);
                }
            }
            if (jsElement instanceof JSClassBase && !((JSClass)jsElement).isInterface() && !this.myRelevantDefs.containsKey("prototype".hashCode())) {
                this.addRelevantDef((JSElement)JSClassUtils.getImplicitPrototypeProperty((JSClassBase)jsElement));
            }
        }

        public void visitJSDefinitionExpression(JSDefinitionExpression node) {
        }

        public void visitJSExpressionStatement(JSExpressionStatement node) {
            JSExpression expression = node.getExpression();
            if (expression instanceof JSLiteralExpression && ("'use strict'".equals(expression.getText()) || "\"use strict\"".equals(expression.getText()))) {
                this.addRelevantDef((JSElement)new ImplicitJSVariableImpl("use strict", (JSType)null, (PsiElement)node));
            }
            if (expression != null) {
                this.visitJSExpression(expression);
            }
        }

        public void visitJSVariable(JSVariable node) {
            if (node.hasBlockScope()) {
                return;
            }
            if (node instanceof ActionScriptVariableImpl && ((ActionScriptVariableImpl)node).hasQualifiedName()) {
                return;
            }
            this.processUseDirectiveInAttrList((JSAttributeListOwner)node);
            this.addRelevantDef((JSElement)node);
        }

        private void processUseDirectiveInAttrList(JSAttributeListOwner node) {
            JSAttributeList attributeList = node.getAttributeList();
            if (attributeList != null) {
                PsiElement elt;
                JSAttributeListStub stub = (JSAttributeListStub)attributeList.getStub();
                if (stub != null) {
                    StubElement useNamespaceDirectiveInStub = stub.findChildStubByType(JSStubElementTypes.USE_NAMESPACE_DIRECTIVE);
                    elt = useNamespaceDirectiveInStub != null ? useNamespaceDirectiveInStub.getPsi() : null;
                } else {
                    ASTNode useNs = attributeList.getNode().findChildByType(JSStubElementTypes.USE_NAMESPACE_DIRECTIVE);
                    PsiElement psiElement = elt = useNs != null ? useNs.getPsi() : null;
                }
                if (elt != null) {
                    elt.accept((PsiElementVisitor)this);
                }
            }
        }

        public void visitJSIncludeDirective(JSIncludeDirective includeDirective) {
            PsiFile _file = includeDirective.resolveFile();
            if (!(_file instanceof JSFile) || this.myBase.getContainingFile() == _file) {
                return;
            }
            JSFile file2 = (JSFile)_file;
            if (this.visitedIncludes != null && this.visitedIncludes.contains(file2)) {
                return;
            }
            if (this.visitedIncludes == null) {
                this.visitedIncludes = new THashSet();
            }
            this.visitedIncludes.add(file2);
            JSElement prevContext = this.context;
            this.context = file2;
            this.context.putUserData(JSResolveUtil.contextKey, (Object)this.myBase);
            this.startVisiting((JSElement)file2);
            this.context = prevContext;
        }

        public void visitJSVarStatement(JSVarStatement node) {
            JSVariable[] variables;
            for (JSVariable var : variables = this.isActionScript || this.isTypeScript ? node.getStubSafeVariables() : node.getVariables()) {
                var.accept((PsiElementVisitor)this);
            }
        }

        public void visitES6ExportDefaultAssignment(ES6ExportDefaultAssignment node) {
            JSElement el = node.getStubSafeElement();
            if (el instanceof JSClass) {
                this.visitJSClass((JSClass)el);
            }
        }

        public void visitTypeScriptExportAssignment(TypeScriptExportAssignment exportAssignment) {
        }

        public void visitJSParameter(JSParameter node) {
        }

        public void visitJSFunctionExpression(JSFunctionExpression node) {
        }

        public void visitJSProperty(JSProperty node) {
            this.addRelevantDef((JSElement)node);
        }

        public void visitJSObjectLiteralExpression(JSObjectLiteralExpression node) {
        }

        public void visitJSClass(JSClass aClass) {
            this.processUseDirectiveInAttrList((JSAttributeListOwner)aClass);
            this.addRelevantDef((JSElement)aClass);
        }

        public void visitJSPackageStatement(JSPackageStatement packageStatement) {
        }

        public void visitTypeScriptModule(TypeScriptModule module) {
            this.addRelevantDef((JSElement)module);
        }

        public void visitJSFunctionDeclaration(JSFunction node) {
            if (node instanceof ActionScriptFunctionImpl && ((ActionScriptFunctionImpl)node).hasQualifiedName()) {
                return;
            }
            this.processUseDirectiveInAttrList((JSAttributeListOwner)node);
            this.addRelevantDef((JSElement)node);
            if (this.isTypeScript) {
                for (JSParameter parameter : node.getParameterVariables()) {
                    if (!TypeScriptPsiUtil.isClassMember(parameter)) continue;
                    this.addRelevantDef((JSElement)parameter);
                }
            }
        }

        public void visitJSNamespaceDeclaration(JSNamespaceDeclaration namespaceDeclaration) {
            this.addRelevantDef((JSElement)namespaceDeclaration);
        }

        public void visitJSImportStatement(JSImportStatement importStatement) {
        }

        public void visitTypeScriptImportStatement(TypeScriptImportStatement importStatement) {
            this.addRelevantDef((JSElement)importStatement);
        }

        public void visitTypeScriptObjectType(TypeScriptObjectType objectType) {
            for (TypeScriptTypeMember member : objectType.getTypeMembers()) {
                if (!(member instanceof JSNamedElement)) continue;
                this.addRelevantDef((JSElement)member);
            }
        }

        public void visitJSUseNamespaceDirective(JSUseNamespaceDirective useNamespaceDirective) {
            String namespaceToBeUsed = useNamespaceDirective.getNamespaceToBeUsed();
            if (namespaceToBeUsed != null) {
                this.addNamedElement((JSElement)useNamespaceDirective, namespaceToBeUsed.hashCode());
            }
        }

        public void visitES6ImportDeclaration(ES6ImportDeclaration importDeclaration) {
            ES6ImportedBinding[] bindings;
            for (ES6ImportedBinding eS6ImportedBinding : bindings = importDeclaration.getImportedBindings()) {
                this.addRelevantDef((JSElement)eS6ImportedBinding);
            }
            for (ES6ImportedBinding eS6ImportedBinding : importDeclaration.getImportSpecifiers()) {
                ES6ImportSpecifierAlias alias = eS6ImportedBinding.getAlias();
                if (alias != null) {
                    this.addRelevantDef((JSElement)alias);
                    continue;
                }
                this.addNamedElement((JSElement)eS6ImportedBinding, eS6ImportedBinding.getReferenceName().hashCode());
            }
        }

        public void visitES6ExportDeclaration(ES6ExportDeclaration exportDeclaration) {
            for (ES6ExportSpecifier specifier : exportDeclaration.getExportSpecifiers()) {
                ES6ExportSpecifierAlias alias = specifier.getAlias();
                if (alias != null) {
                    this.addRelevantDef((JSElement)alias);
                    continue;
                }
                this.addNamedElement((JSElement)specifier, specifier.getReferenceName().hashCode());
            }
            ES6ExportedDefaultBinding defaultBinding = exportDeclaration.getExportedDefaultBinding();
            if (defaultBinding != null) {
                this.addRelevantDef((JSElement)defaultBinding);
            }
        }

        public void visitComment(PsiComment comment) {
            if (!JSDirectiveCommentUtil.isDirectiveCommentTokenType(comment)) {
                return;
            }
            String text = comment.getText();
            int bodyStartIndex = JSDirectiveCommentUtil.getGlobalDirectiveBodyStartIndex(text);
            if (bodyStartIndex > 0 && bodyStartIndex <= text.length() - 2) {
                text = text.substring(bodyStartIndex, text.length() - 2);
                StringTokenizer t = new StringTokenizer(text, ",");
                while (t.hasMoreElements()) {
                    String s = t.nextElement();
                    int i = s.indexOf(58);
                    boolean readOnly = false;
                    if (i != -1) {
                        readOnly = StringUtil.equalsIgnoreCase((CharSequence)"false", (CharSequence)s.substring(i + 1).trim());
                        s = s.substring(0, i);
                    }
                    if (!StringUtil.isJavaIdentifier((String)(s = s.trim()))) continue;
                    EnumSet<JSImplicitElement.Property> properties = EnumSet.of(JSImplicitElement.Property.MinorImportance);
                    if (readOnly) {
                        properties.add(JSImplicitElement.Property.Constant);
                    }
                    JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(s, (PsiElement)comment).setProperties(properties).setType(JSImplicitElement.Type.Variable);
                    this.addRelevantDef((JSElement)new JSImplicitElementImpl(builder));
                }
            }
        }

        private void addRelevantDef(@NotNull JSElement node) {
            String name;
            if (node == null) {
                JSNamesCacheVisitor.$$$reportNull$$$0(0);
            }
            if ((name = node.getName()) != null) {
                int key = name.hashCode();
                this.addNamedElement(node, key);
            }
        }

        private void addNamedElement(JSElement node, int key) {
            JSScopeNamesCache.addElementCompact(this.myRelevantDefs, node, key);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/psi/resolve/JSScopeNamesCache$JSNamesCacheVisitor", "addRelevantDef"));
        }
    }
}

