/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptLiteralType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptStringLiteralType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptLiteralBasedPropertyElementImpl;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSDistributedType;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSRecordMemberSourceFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeUtil;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTaggedLiteralKeyTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTupleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeKeyTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.TypeScriptIndexedAccessJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptMappedTypeGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeOperatorJSTypeImpl;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptMappedJSTypeImpl
extends JSTypeBaseImpl
implements JSType.CompositeStructure,
JSTypeWithIncompleteSubstitution,
JSDistributedType,
JSEvaluableType {
    private static final Key<Map<JSResolvedTypeId, Set<JSResolvedTypeId>>> CONVERT_TO_INDEX_ACCESS_KEY = Key.create((String)"convert.as.index.key");
    private final boolean myReadonly;
    private final boolean myMinusReadonly;
    private final boolean myOptional;
    private final boolean myMinusOptional;
    @Nullable
    private final String myParameterName;
    @NotNull
    private final JSType myParameterType;
    @NotNull
    private final JSType myResultType;
    private static final int MAX_SOURCE_DEPTH = 10;

    public TypeScriptMappedJSTypeImpl(@NotNull JSTypeSource source, boolean isReadonly, boolean isOptional, boolean isMinusReadonly, boolean isMinusOptional, @Nullable String parameterName, @NotNull JSType parameterType, @NotNull JSType resultType) {
        if (source == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(0);
        }
        if (parameterType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(1);
        }
        if (resultType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(2);
        }
        super(source);
        this.myReadonly = isReadonly;
        this.myMinusReadonly = isMinusReadonly;
        this.myOptional = isOptional;
        this.myMinusOptional = isMinusOptional;
        this.myParameterName = parameterName;
        this.myParameterType = parameterType;
        this.myResultType = resultType;
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        boolean readonly = this.isReadonly();
        boolean minusReadonly = this.isMinusReadonly();
        if (readonly || minusReadonly) {
            builder.append(minusReadonly ? "-readonly " : "readonly ");
        }
        builder.append("[");
        String name = this.getParameterName();
        builder.append(name == null ? "MapParameter" : name);
        builder.append(" in ");
        builder.append(this.getParameterType().getTypeText(format));
        builder.append("]");
        boolean optional = this.isOptional();
        boolean minusOptional = this.isMinusOptional();
        if (optional || minusOptional) {
            builder.append(optional ? "?" : "-?");
        }
        builder.append(this.getTypeSeparator());
        builder.append(this.getResultType().getTypeText(format));
        builder.append("}");
        String string = builder.toString();
        if (string == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    protected int resolvedHashCodeImpl() {
        return Objects.hash(this.getClass(), this.getParameterType().resolvedHashCode(), this.getResultType().resolvedHashCode());
    }

    @Override
    @NotNull
    protected TypeScriptMappedJSTypeImpl copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        if (childTransform == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(4);
        }
        JSType newParameterType = JSTypeUtils.transformTypeHierarchySafe(this.getParameterType(), childTransform);
        JSType newResultType = JSTypeUtils.transformTypeHierarchySafe(this.getResultType(), childTransform);
        if (newParameterType == this.getParameterType() && newResultType == this.getResultType()) {
            TypeScriptMappedJSTypeImpl typeScriptMappedJSTypeImpl = this;
            if (typeScriptMappedJSTypeImpl == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(5);
            }
            return typeScriptMappedJSTypeImpl;
        }
        TypeScriptMappedJSTypeImpl typeScriptMappedJSTypeImpl = new TypeScriptMappedJSTypeImpl(this.getSource(), this.isReadonly(), this.isOptional(), this.isMinusReadonly(), this.isMinusOptional(), this.myParameterName, newParameterType, newResultType);
        if (typeScriptMappedJSTypeImpl == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(6);
        }
        return typeScriptMappedJSTypeImpl;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(7);
        }
        TypeScriptMappedJSTypeImpl typeScriptMappedJSTypeImpl = new TypeScriptMappedJSTypeImpl(source, this.myReadonly, this.myOptional, this.myMinusReadonly, this.myMinusOptional, this.myParameterName, this.myParameterType, this.myResultType);
        if (typeScriptMappedJSTypeImpl == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(8);
        }
        return typeScriptMappedJSTypeImpl;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSType substitute;
        if (elementType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(9);
        }
        if (processingContext == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(10);
        }
        if ((substitute = this.substitute()) != this) {
            return substitute.isDirectlyAssignableType(elementType, processingContext);
        }
        JSType paramType = this.getParameterType();
        if (JSTypeCastUtil.isTypeOperatorLikeType(paramType) && TypeScriptMappedJSTypeImpl.isDirectAssignableForMappedTypeWithTypeOperator(elementType, this, processingContext, false)) {
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    public static boolean isDirectAssignableForMappedTypeWithTypeOperator(@NotNull JSType operand, @NotNull TypeScriptMappedJSTypeImpl mappedType, @NotNull ProcessingContext processingContext, boolean isDirectComparing) {
        if (operand == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(11);
        }
        if (mappedType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(12);
        }
        if (processingContext == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(13);
        }
        String parameterName = mappedType.getParameterName();
        JSType paramType = mappedType.getParameterType();
        if (parameterName == null) {
            return false;
        }
        JSType nameAsType = JSNamedTypeFactory.createType(parameterName, mappedType.getSource(), JSTypeContext.INSTANCE);
        JSType typeForGuard = TypeScriptMappedJSTypeImpl.getSubstitutionTypeInIndexAccess(operand);
        return JSRecursiveTypeUtil.computeWithRecursiveTypes(typeForGuard.getResolvedTypeId(), nameAsType.getResolvedTypeId(), CONVERT_TO_INDEX_ACCESS_KEY, processingContext, (Getter<Boolean>)((Getter)() -> {
            JSType result2;
            TypeScriptIndexedAccessJSTypeImpl indexedType;
            if (operand == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(45);
            }
            if (mappedType == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(46);
            }
            if (processingContext == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(47);
            }
            if (!TypeScriptMappedJSTypeImpl.isAssignableDirectOrInverseType(indexedType = new TypeScriptIndexedAccessJSTypeImpl(operand, nameAsType, mappedType.getSource()), result2 = mappedType.getResultType(), processingContext, isDirectComparing)) {
                return false;
            }
            if (JSGenericTypesEvaluator.isGenericProcessingInProgress(processingContext) && paramType instanceof JSGenericParameterImpl) {
                TypeScriptTypeOperatorJSTypeImpl typeOperator = new TypeScriptTypeOperatorJSTypeImpl(operand, operand.getSource());
                TypeScriptMappedJSTypeImpl.isAssignableDirectOrInverseType(typeOperator, paramType, processingContext, isDirectComparing);
            }
            return true;
        }));
    }

    private static boolean isAssignableDirectOrInverseType(@NotNull JSType thisType, @NotNull JSType rType, @NotNull ProcessingContext context, boolean direct) {
        if (thisType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(14);
        }
        if (rType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(15);
        }
        if (context == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(16);
        }
        return direct ? thisType.isDirectlyAssignableType(rType, context) : rType.isDirectlyAssignableType(thisType, context);
    }

    @NotNull
    public static JSType getSubstitutionTypeInIndexAccess(@NotNull JSType elementType) {
        if (elementType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(17);
        }
        while (elementType instanceof TypeScriptIndexedAccessJSTypeImpl) {
            elementType = ((TypeScriptIndexedAccessJSTypeImpl)elementType).getOwner();
        }
        JSType jSType = elementType;
        if (jSType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(18);
        }
        return jSType;
    }

    @Override
    @NotNull
    public JSType substitute() {
        JSType jSType = this.substituteWithPreventingRecursion(false);
        if (jSType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(19);
        }
        return jSType;
    }

    @NotNull
    public JSType substituteCompletely() {
        JSType jSType = this.substituteWithPreventingRecursion(true);
        if (jSType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(20);
        }
        return jSType;
    }

    @NotNull
    public JSType substituteWithPreventingRecursion(boolean complete) {
        JSType type = (JSType)RecursionManager.doPreventingRecursion((Object)this.getResolvedTypeId(), (boolean)false, () -> this.substituteImpl(complete));
        TypeScriptMappedJSTypeImpl typeScriptMappedJSTypeImpl = type == null ? this : type;
        if (typeScriptMappedJSTypeImpl == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(21);
        }
        return typeScriptMappedJSTypeImpl;
    }

    private JSType substituteImpl(boolean complete) {
        return this.getLocalCachedType(() -> this.substituteInternal(complete), complete ? COMPLETENESS_TRUE : COMPLETENESS_FALSE);
    }

    @NotNull
    private JSType substituteInternal(boolean complete) {
        JSType distributeType = this.distributeType();
        if (distributeType != this) {
            JSType jSType = distributeType;
            if (jSType == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(22);
            }
            return jSType;
        }
        if (!complete && !this.canBeSubstituted()) {
            TypeScriptMappedJSTypeImpl typeScriptMappedJSTypeImpl = this;
            if (typeScriptMappedJSTypeImpl == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(23);
            }
            return typeScriptMappedJSTypeImpl;
        }
        JSType parameterType = this.getParameterType();
        JSType originalResultType = this.getResultType();
        JSType type = JSTypeUtils.getValuableType(parameterType);
        Collection<String> strings = TypeScriptIndexedAccessJSTypeImpl.getParameterStrings(type);
        String name = this.getParameterName();
        if (strings.isEmpty() || name == null) {
            JSAnyType jSAnyType = JSAnyType.getWithLanguage(this.getSource().getLanguage(), this.getSource().isStrict());
            if (jSAnyType == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(24);
            }
            return jSAnyType;
        }
        JSType resultType = JSTypeUtils.getValuableType(originalResultType, false);
        boolean hasOptionalKeyword = this.isOptional();
        boolean hasMinusOptionalKeyword = this.isMinusOptional();
        List result2 = ContainerUtil.newSmartList();
        JSRecordType originalType = TypeScriptMappedJSTypeImpl.getOriginalType(parameterType);
        if (resultType instanceof TypeScriptIndexedAccessJSTypeImpl && TypeScriptMappedJSTypeImpl.isParameter(name, ((TypeScriptIndexedAccessJSTypeImpl)resultType).getParameterType())) {
            TypeScriptIndexedAccessJSTypeImpl accessJSType = (TypeScriptIndexedAccessJSTypeImpl)resultType;
            JSRecordType ownerRecordType = accessJSType.getOwner().asRecordType();
            HashSet<String> propertyNames = new HashSet<String>(strings);
            for (JSRecordType.TypeMember member : ownerRecordType.getTypeMembers()) {
                JSRecordType.PropertySignature propertySignature;
                String memberName;
                if (!(member instanceof JSRecordType.PropertySignature) || !propertyNames.contains(memberName = (propertySignature = (JSRecordType.PropertySignature)member).getMemberName())) continue;
                JSRecordType.MemberSource source = this.computeCommonMemberSource(type, originalType, propertySignature, memberName);
                result2.add(new JSRecordTypeImpl.PropertySignatureImpl(memberName, propertySignature.getType(), !hasMinusOptionalKeyword && (hasOptionalKeyword || propertySignature.isOptional()), source));
            }
        } else {
            JSType keyBase = parameterType instanceof TypeScriptTypeOperatorJSTypeImpl ? ((TypeScriptTypeOperatorJSTypeImpl)parameterType).getReferencedType() : null;
            for (String string : strings) {
                JSType propertyType = JSTypeUtils.transformTypeHierarchySafe(originalResultType, (Function<JSType, JSType>)((Function)el -> {
                    if (TypeScriptMappedJSTypeImpl.isParameter(name, el)) {
                        return keyBase != null ? new JSTypeKeyTypeImpl(string, keyBase, el.getSource()) : new JSStringLiteralTypeImpl(string, false, el.getSource());
                    }
                    return el;
                }));
                propertyType = JSTypeUtils.getValuableType(propertyType);
                JSRecordType.MemberSource source = this.computeCommonMemberSource(type, originalType, null, string);
                PsiElement sourceSingleElement = source.getSingleElement();
                boolean propIsOptional = hasOptionalKeyword;
                if (sourceSingleElement instanceof JSRecordType.PropertySignature) {
                    propIsOptional |= ((JSRecordType.PropertySignature)sourceSingleElement).isOptional();
                }
                result2.add(new JSRecordTypeImpl.PropertySignatureImpl(string, propertyType, propIsOptional, source));
            }
        }
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(originalType != null ? originalType.getSource() : this.getSource(), result2);
        if (jSRecordTypeImpl == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(25);
        }
        return jSRecordTypeImpl;
    }

    public boolean canBeSubstituted() {
        return !JSTypeUtils.hasForeignGenericParameter(this);
    }

    @NotNull
    private static List<JSType> collectReferencedTypes(@Nullable JSType type, boolean expandTypeof) {
        JSResolvedTypeInfo info;
        JSType alias;
        if (type instanceof TypeScriptTypeOperatorJSTypeImpl) {
            List list = ContainerUtil.createMaybeSingletonList((Object)((TypeScriptTypeOperatorJSTypeImpl)type).getReferencedType());
            if (list == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(26);
            }
            return list;
        }
        if (type instanceof JSUnionOrIntersectionType) {
            ArrayList types = ContainerUtil.newArrayList();
            for (JSType part : ((JSUnionOrIntersectionType)type).getTypes()) {
                types.addAll(TypeScriptMappedJSTypeImpl.collectReferencedTypes(part, false));
            }
            ArrayList arrayList = types;
            if (arrayList == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(27);
            }
            return arrayList;
        }
        if (expandTypeof && type instanceof JSResolvableType && (alias = (info = ((JSResolvableType)type).resolveType()).getAliasedType()) != null) {
            List<JSType> list = TypeScriptMappedJSTypeImpl.collectReferencedTypes(alias, false);
            if (list == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(28);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(29);
        }
        return list;
    }

    @Nullable
    private static JSRecordType getOriginalType(@Nullable JSType type) {
        List<JSType> types = TypeScriptMappedJSTypeImpl.collectReferencedTypes(type, true);
        if (types.size() == 0) {
            return null;
        }
        if (types.size() == 1) {
            return types.get(0).asRecordType();
        }
        assert (type != null);
        return new JSCompositeTypeImpl(type.getSource(), types).asRecordType();
    }

    @NotNull
    private JSRecordType.MemberSource computeCommonMemberSource(JSType type, @Nullable JSRecordType originalType, @Nullable JSRecordType.PropertySignature propertySignature, String memberName) {
        JSRecordType.MemberSource originalSignatureSource;
        JSRecordType.PropertySignature originalSignature;
        JSRecordType.MemberSource source;
        JSRecordType.MemberSource memberSource = source = propertySignature == null ? JSRecordMemberSourceFactory.createEmptySource() : propertySignature.getMemberSource().copyWithKind(this.getMemberSourceKind());
        if (originalType != null && (originalSignature = originalType.findPropertySignature(memberName)) != null && !(originalSignatureSource = originalSignature.getMemberSource()).isEmpty()) {
            source = source.isEmpty() ? originalSignatureSource.copyWithKind(this.getMemberSourceKind()) : JSRecordMemberSourceFactory.createSource(ContainerUtil.concat((List)source.getAllSourceElements(), (List)originalSignatureSource.getAllSourceElements()), this.getMemberSourceKind());
        }
        HashSet sourceElements = ContainerUtil.newHashSet();
        TypeScriptMappedJSTypeImpl.addExtraSourceElements(type, memberName, sourceElements, 0);
        if (!source.isEmpty()) {
            sourceElements.addAll(source.getAllSourceElements());
        }
        JSRecordType.MemberSource memberSource2 = JSRecordMemberSourceFactory.createSource(ContainerUtil.newArrayList((Iterable)sourceElements), this.getMemberSourceKind());
        if (memberSource2 == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(30);
        }
        return memberSource2;
    }

    @NotNull
    private JSRecordType.MemberSourceKind getMemberSourceKind() {
        JSRecordType.MemberSourceKind memberSourceKind = JSRecordType.MemberSourceKind.getMappedKind((boolean)this.isOptional(), (boolean)this.isMinusOptional(), (boolean)this.isReadonly(), (boolean)this.isMinusReadonly());
        if (memberSourceKind == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(31);
        }
        return memberSourceKind;
    }

    private static void addExtraSourceElements(@Nullable JSType type, String memberName, @NotNull Set<PsiElement> sourceElements, int depth) {
        JSExpression expression;
        PsiElement element;
        JSType referencedType;
        JSRecordType recordType;
        JSRecordType.PropertySignature signature;
        if (sourceElements == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(32);
        }
        if (depth > 10) {
            return;
        }
        if (type instanceof JSTypeImpl) {
            JSExpression initializer;
            TypeScriptEnumField field;
            JSResolvedTypeInfo typeInfo = ((JSTypeImpl)type).resolveType();
            if (typeInfo.getDeclarationOfType(TypeScriptTypeAlias.class) != null) {
                TypeScriptMappedJSTypeImpl.addSourceElementsFromAliasedType(memberName, sourceElements, typeInfo.getAliasedType());
                return;
            }
            if (typeInfo.isEnumWithLiteralValues()) {
                TypeScriptEnum tsEnum = typeInfo.getDeclarationOfType(TypeScriptEnum.class);
                if (tsEnum != null) {
                    for (JSField field2 : tsEnum.getFields()) {
                        JSExpression initializer2 = field2.getInitializerOrStub();
                        if (!(initializer2 instanceof JSLiteralExpression) || !memberName.equals(((JSLiteralExpression)initializer2).getStringValue())) continue;
                        sourceElements.add((PsiElement)new TypeScriptLiteralBasedPropertyElementImpl(memberName, (PsiElement)initializer2));
                    }
                }
            } else if (typeInfo.isEnumLiteral() && (field = typeInfo.getDeclarationOfType(TypeScriptEnumField.class)) != null && (initializer = field.getInitializerOrStub()) instanceof JSLiteralExpression && memberName.equals(((JSLiteralExpression)initializer).getStringValue())) {
                sourceElements.add((PsiElement)new TypeScriptLiteralBasedPropertyElementImpl(memberName, (PsiElement)initializer));
            }
        }
        if ((type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type)) instanceof JSUnionOrIntersectionType) {
            for (JSType part : JSCompositeTypeBaseImpl.flattenTypes(((JSUnionOrIntersectionType)type).getTypes().stream(), type.getClass())) {
                TypeScriptMappedJSTypeImpl.addExtraSourceElements(part, memberName, sourceElements, depth + 1);
            }
        }
        if (type instanceof JSTypeKeyTypeImpl && (signature = (recordType = (referencedType = ((JSTypeKeyTypeImpl)type).getReferencedType()).asRecordType()).findPropertySignature(memberName)) != null) {
            sourceElements.addAll(signature.getMemberSource().getAllSourceElements());
        }
        if (type instanceof JSTaggedLiteralKeyTypeImpl && memberName.equals(((JSTaggedLiteralKeyTypeImpl)type).getLiteral()) && (element = type.getSource().getSourceElement()) instanceof TypeScriptStringLiteralType && (expression = ((TypeScriptStringLiteralType)element).getExpression()) != null) {
            sourceElements.add((PsiElement)new TypeScriptLiteralBasedPropertyElementImpl(((JSTaggedLiteralKeyTypeImpl)type).myUnquotedValue, (PsiElement)expression));
        }
    }

    private static void addSourceElementsFromAliasedType(String memberName, Set<PsiElement> sourceElements, JSType typedef) {
        JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)t -> {
            if (t instanceof JSStringLiteralTypeImpl && Objects.equals(((JSStringLiteralTypeImpl)t).getLiteral(), memberName)) {
                PsiElement element = t.getSource().getSourceElement();
                if (element instanceof TypeScriptLiteralType) {
                    JSExpression expression = ((TypeScriptLiteralType)element).getExpression();
                    if (expression != null) {
                        sourceElements.add((PsiElement)new TypeScriptLiteralBasedPropertyElementImpl(memberName, (PsiElement)expression));
                    }
                } else if ((element instanceof JSField || element instanceof JSProperty) && t instanceof JSTypeKeyTypeImpl) {
                    sourceElements.add(element);
                }
            }
            return true;
        }), typedef, false, true, true);
    }

    private static boolean isParameter(@NotNull String name, @NotNull JSType el) {
        if (name == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(33);
        }
        if (el == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(34);
        }
        return el instanceof TypeScriptMappedTypeGenericParameterImpl && name.equals(el.getTypeText(JSType.TypeTextFormat.SIMPLE));
    }

    public boolean isReadonly() {
        return this.myReadonly;
    }

    public boolean isMinusReadonly() {
        return this.myMinusReadonly;
    }

    public boolean isMinusOptional() {
        return this.myMinusOptional;
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type, ProcessingContext context, boolean allowResolve) {
        if (type == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(35);
        }
        TypeScriptMappedJSTypeImpl mappedType = (TypeScriptMappedJSTypeImpl)type;
        return this.isReadonly() == mappedType.isReadonly() && this.isMinusReadonly() == mappedType.isMinusReadonly() && this.isOptional() == mappedType.isOptional() && this.isMinusOptional() == mappedType.isMinusOptional() && this.getParameterType().isEquivalentTo(mappedType.getParameterType(), context, allowResolve) && this.getResultType().isEquivalentTo(mappedType.getResultType(), context, allowResolve);
    }

    @NotNull
    public JSType getParameterType() {
        JSType jSType = this.myParameterType;
        if (jSType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(36);
        }
        return jSType;
    }

    @NotNull
    public JSType getResultType() {
        JSType jSType = this.myResultType;
        if (jSType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(37);
        }
        return jSType;
    }

    public boolean isOptional() {
        return this.myOptional;
    }

    @Nullable
    public String getParameterName() {
        return this.myParameterName;
    }

    @Override
    public void acceptChildren(JSRecursiveTypeVisitor visitor) {
        this.myResultType.accept(visitor);
        this.myParameterType.accept(visitor);
    }

    @NotNull
    public JSType distributeType() {
        JSType parameterType = this.getParameterType();
        if (parameterType instanceof TypeScriptTypeOperatorJSTypeImpl) {
            JSType jSType = this.distributeByKey(((TypeScriptTypeOperatorJSTypeImpl)parameterType).getReferencedType());
            if (jSType == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(38);
            }
            return jSType;
        }
        TypeScriptMappedJSTypeImpl typeScriptMappedJSTypeImpl = this;
        if (typeScriptMappedJSTypeImpl == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(39);
        }
        return typeScriptMappedJSTypeImpl;
    }

    @NotNull
    private JSType distributeByKey(JSType keyType) {
        if (keyType instanceof JSPrimitiveType && !(keyType instanceof JSPrimitiveLiteralType)) {
            JSType jSType = keyType;
            if (jSType == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(40);
            }
            return jSType;
        }
        String parameterName = this.getParameterName();
        if (keyType instanceof JSUnionType) {
            List<JSType> types = ((JSUnionType)keyType).getTypes();
            ArrayList newTypes = ContainerUtil.newArrayListWithCapacity((int)types.size());
            JSType resultType = this.getResultType();
            for (JSType type : types) {
                newTypes.add(new TypeScriptMappedJSTypeImpl(this.getSource(), this.isReadonly(), this.isOptional(), this.isMinusReadonly(), this.isMinusOptional(), parameterName, new TypeScriptTypeOperatorJSTypeImpl(type, this.getSource()), TypeScriptMappedJSTypeImpl.transformForIndexer(keyType, parameterName, type, resultType, true)));
            }
            JSCompositeTypeImpl jSCompositeTypeImpl = new JSCompositeTypeImpl(this.getSource(), newTypes);
            if (jSCompositeTypeImpl == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(41);
            }
            return jSCompositeTypeImpl;
        }
        JSGenericTypeImpl genericArrayType = TypeScriptMappedJSTypeImpl.getGenericArrayType(keyType);
        if (parameterName != null && genericArrayType != null) {
            JSType arrayBase = genericArrayType.getType();
            JSType S = genericArrayType.getArguments().get(0);
            JSType X = this.getResultType();
            JSGenericTypeImpl jSGenericTypeImpl = new JSGenericTypeImpl(this.getSource(), arrayBase, TypeScriptMappedJSTypeImpl.transformForIndexer(keyType, parameterName, S, X, false));
            if (jSGenericTypeImpl == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(42);
            }
            return jSGenericTypeImpl;
        }
        if (parameterName != null && keyType instanceof JSTupleType) {
            List types = ((JSTupleType)keyType).getTypes();
            ArrayList newTypes = ContainerUtil.newArrayListWithCapacity((int)types.size());
            JSType X = this.getResultType();
            for (JSType type : types) {
                newTypes.add(TypeScriptMappedJSTypeImpl.transformForIndexer(keyType, parameterName, type, X, false));
            }
            JSTupleTypeImpl jSTupleTypeImpl = new JSTupleTypeImpl(this.getSource(), newTypes, keyType.isSourceStrict(), ((JSTupleType)keyType).getOptionalStart());
            if (jSTupleTypeImpl == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(43);
            }
            return jSTupleTypeImpl;
        }
        TypeScriptMappedJSTypeImpl typeScriptMappedJSTypeImpl = this;
        if (typeScriptMappedJSTypeImpl == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(44);
        }
        return typeScriptMappedJSTypeImpl;
    }

    private static JSType transformForIndexer(JSType keyType, String parameterName, JSType type, JSType x, boolean preserveIndexer) {
        return x.transformTypeHierarchy(t -> {
            if (t instanceof TypeScriptIndexedAccessJSTypeImpl) {
                JSType owner = ((TypeScriptIndexedAccessJSTypeImpl)t).getOwner();
                JSType parameterType = ((TypeScriptIndexedAccessJSTypeImpl)t).getParameterType();
                if (owner.isEquivalentTo(keyType, null, true) && TypeScriptMappedJSTypeImpl.isParameter(parameterName, parameterType)) {
                    return preserveIndexer ? new TypeScriptIndexedAccessJSTypeImpl(type, parameterType, t.getSource()) : type;
                }
            }
            return t;
        });
    }

    @Nullable
    private static JSGenericTypeImpl getGenericArrayType(@Nullable JSType keyType) {
        String typeText;
        JSType type;
        JSGenericTypeImpl genericArrayType = null;
        if (keyType instanceof JSArrayType) {
            genericArrayType = ((JSArrayType)keyType).asGenericType();
        } else if (keyType instanceof JSGenericTypeImpl && (type = ((JSGenericTypeImpl)keyType).getType()) instanceof JSNamedType && ("Array".equals(typeText = type.getTypeText(JSType.TypeTextFormat.SIMPLE)) || "ReadonlyArray".equals(typeText))) {
            genericArrayType = (JSGenericTypeImpl)keyType;
        }
        return genericArrayType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultType";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 10: 
            case 13: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 11: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
            case 12: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappedType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisType";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElements";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutionTypeInIndexAccess";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "substitute";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteCompletely";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteWithPreventingRecursion";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteInternal";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "collectReferencedTypes";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "computeCommonMemberSource";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberSourceKind";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterType";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultType";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "distributeType";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "distributeByKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isDirectAssignableForMappedTypeWithTypeOperator";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableDirectOrInverseType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutionTypeInIndexAccess";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "addExtraSourceElements";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isParameter";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isDirectAssignableForMappedTypeWithTypeOperator$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

