/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.flow.psi.impl.FlowJSTypePredicateImpl;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptAsExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCastExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.sixrr.inspectjs.utils.BinaryOperatorUtils;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParenthesesUtils {
    private static final int PARENTHESIZED_PRECEDENCE = 0;
    public static final int LITERAL_PRECEDENCE = 0;
    public static final int METHOD_CALL_PRECEDENCE = 1;
    public static final int POSTFIX_PRECEDENCE = 2;
    public static final int PREFIX_PRECEDENCE = 3;
    public static final int TYPE_CAST_PRECEDENCE = 4;
    public static final int EXPONENTIATION_PRECEDENCE = 5;
    public static final int MULTIPLICATIVE_PRECEDENCE = 6;
    private static final int ADDITIVE_PRECEDENCE = 7;
    public static final int SHIFT_PRECEDENCE = 8;
    private static final int RELATIONAL_PRECEDENCE = 9;
    private static final int EQUALITY_PRECEDENCE = 10;
    private static final int BINARY_AND_PRECEDENCE = 11;
    private static final int BINARY_XOR_PRECEDENCE = 12;
    private static final int BINARY_OR_PRECEDENCE = 13;
    public static final int AND_PRECEDENCE = 14;
    public static final int OR_PRECEDENCE = 15;
    public static final int CONDITIONAL_PRECEDENCE = 16;
    private static final int ASSIGNMENT_PRECEDENCE = 17;
    private static final int NUM_PRECEDENCES = 18;
    private static final Map<IElementType, Integer> s_binaryOperatorPrecedence = new HashMap<IElementType, Integer>(18);

    private ParenthesesUtils() {
    }

    public static int getPrecedence(JSExpression exp) {
        if (exp instanceof JSThisExpression || exp instanceof JSLiteralExpression || exp instanceof JSObjectLiteralExpression || exp instanceof JSArrayLiteralExpression || exp instanceof JSIndexedPropertyAccessExpression) {
            return 0;
        }
        if (exp instanceof JSReferenceExpression) {
            if (((JSReferenceExpression)exp).getQualifier() != null) {
                return 1;
            }
            return 0;
        }
        if (exp instanceof JSCallExpression || exp instanceof ES6TaggedTemplateExpression) {
            return 1;
        }
        if (exp instanceof JSPrefixExpression) {
            return 3;
        }
        if (exp instanceof JSPostfixExpression) {
            return 2;
        }
        if (exp instanceof TypeScriptCastExpression) {
            return exp instanceof TypeScriptAsExpression ? 9 : 4;
        }
        if (exp instanceof JSBinaryExpression && !(exp instanceof JSAssignmentExpression)) {
            IElementType sign = ((JSBinaryExpression)exp).getOperationSign();
            return ParenthesesUtils.precedenceForBinaryOperator(sign);
        }
        if (exp instanceof JSConditionalExpression) {
            return 16;
        }
        if (exp instanceof JSAssignmentExpression) {
            return 17;
        }
        if (exp instanceof JSParenthesizedExpression) {
            return 0;
        }
        return -1;
    }

    private static int precedenceForBinaryOperator(IElementType sign) {
        if (s_binaryOperatorPrecedence.containsKey(sign)) {
            return s_binaryOperatorPrecedence.get(sign);
        }
        return 17;
    }

    @Nullable
    @Contract(value="!null->!null")
    public static JSExpression stripParentheses(@Nullable JSExpression exp) {
        return JSUtils.unparenthesize(exp);
    }

    public static String removeParentheses(@NotNull JSExpression expression) {
        if (expression == null) {
            ParenthesesUtils.$$$reportNull$$$0(0);
        }
        if (expression instanceof JSCallExpression) {
            return ParenthesesUtils.removeParensFromFunctionCallExpression((JSCallExpression)expression);
        }
        if (expression instanceof ES6TaggedTemplateExpression) {
            return ParenthesesUtils.removeParensFromTaggedTemplateExpression((ES6TaggedTemplateExpression)expression);
        }
        if (expression instanceof JSReferenceExpression) {
            return ParenthesesUtils.removeParensFromReferenceExpression((JSReferenceExpression)expression);
        }
        if (expression instanceof JSAssignmentExpression) {
            return ParenthesesUtils.removeParensFromAssignmentExpression((JSAssignmentExpression)expression);
        }
        if (expression instanceof JSArrayLiteralExpression) {
            return ParenthesesUtils.removeParensFromArrayLiteralExpression((JSArrayLiteralExpression)expression);
        }
        if (expression instanceof JSPrefixExpression) {
            return ParenthesesUtils.removeParensFromPrefixExpression((JSPrefixExpression)expression);
        }
        if (expression instanceof JSPostfixExpression) {
            return ParenthesesUtils.removeParensFromPostfixExpression((JSPostfixExpression)expression);
        }
        if (expression instanceof JSBinaryExpression) {
            return ParenthesesUtils.removeParensFromBinaryExpression((JSBinaryExpression)expression);
        }
        if (expression instanceof JSConditionalExpression) {
            return ParenthesesUtils.removeParensFromConditionalExpression((JSConditionalExpression)expression);
        }
        if (expression instanceof JSParenthesizedExpression) {
            JSExpression innerExpression = ((JSParenthesizedExpression)expression).getInnerExpression();
            if (innerExpression instanceof JSCallExpression) {
                return innerExpression.getText();
            }
            return ParenthesesUtils.removeParensFromParenthesizedExpression((JSParenthesizedExpression)expression);
        }
        return expression.getText();
    }

    private static String removeParensFromReferenceExpression(@NotNull JSReferenceExpression expression) {
        JSExpression qualifier;
        if (expression == null) {
            ParenthesesUtils.$$$reportNull$$$0(1);
        }
        if ((qualifier = expression.getQualifier()) != null) {
            return ParenthesesUtils.removeParentheses(qualifier) + '.' + expression.getReferencedName();
        }
        return expression.getText();
    }

    private static String removeParensFromParenthesizedExpression(@NotNull JSParenthesizedExpression parenthesizedExp) {
        if (parenthesizedExp == null) {
            ParenthesesUtils.$$$reportNull$$$0(2);
        }
        if (!ParenthesesUtils.canRemoveParentheses(parenthesizedExp)) {
            return parenthesizedExp.getText();
        }
        JSExpression body = ParenthesesUtils.stripParentheses(parenthesizedExp.getInnerExpression());
        if (body != null) {
            return ParenthesesUtils.removeParentheses(body);
        }
        return parenthesizedExp.getText();
    }

    private static String removeParensFromConditionalExpression(@NotNull JSConditionalExpression conditionalExp) {
        if (conditionalExp == null) {
            ParenthesesUtils.$$$reportNull$$$0(3);
        }
        JSExpression condition = conditionalExp.getCondition();
        JSExpression thenBranch = conditionalExp.getThen();
        JSExpression elseBranch = conditionalExp.getElse();
        return ParenthesesUtils.removeParentheses(condition) + " ? " + ParenthesesUtils.removeParentheses(thenBranch) + " : " + ParenthesesUtils.removeParentheses(elseBranch);
    }

    private static String removeParensFromBinaryExpression(@NotNull JSBinaryExpression binaryExp) {
        if (binaryExp == null) {
            ParenthesesUtils.$$$reportNull$$$0(4);
        }
        JSExpression lhs = binaryExp.getLOperand();
        JSExpression rhs = binaryExp.getROperand();
        IElementType sign = binaryExp.getOperationSign();
        return ParenthesesUtils.removeParentheses(lhs) + ' ' + BinaryOperatorUtils.getOperatorText(sign) + ' ' + ParenthesesUtils.removeParentheses(rhs);
    }

    private static String removeParensFromPostfixExpression(@NotNull JSPostfixExpression postfixExp) {
        if (postfixExp == null) {
            ParenthesesUtils.$$$reportNull$$$0(5);
        }
        JSExpression body = postfixExp.getExpression();
        IElementType sign = postfixExp.getOperationSign();
        return ParenthesesUtils.removeParentheses(body) + BinaryOperatorUtils.getOperatorText(sign);
    }

    private static String removeParensFromPrefixExpression(@NotNull JSPrefixExpression prefixExp) {
        if (prefixExp == null) {
            ParenthesesUtils.$$$reportNull$$$0(6);
        }
        JSExpression body = prefixExp.getExpression();
        IElementType sign = prefixExp.getOperationSign();
        String bodyText = ParenthesesUtils.removeParentheses(body);
        assert (sign != null) : prefixExp.getText();
        String signText = BinaryOperatorUtils.getOperatorText(sign);
        if (sign == JSTokenTypes.TYPEOF_KEYWORD || sign == JSTokenTypes.DELETE_KEYWORD || sign == JSTokenTypes.AWAIT_KEYWORD) {
            signText = signText + " ";
        }
        return signText + bodyText;
    }

    private static String removeParensFromArrayLiteralExpression(@NotNull JSArrayLiteralExpression init) {
        if (init == null) {
            ParenthesesUtils.$$$reportNull$$$0(7);
        }
        JSExpression[] contents = init.getExpressions();
        String text = init.getText();
        int textLength = text.length();
        StringBuilder out = new StringBuilder(textLength);
        out.append('[');
        ParenthesesUtils.removeParenthesesFromCommaSeparatedExpressions(contents, out);
        return out.append(']').toString();
    }

    private static void removeParenthesesFromCommaSeparatedExpressions(@NotNull JSExpression[] contents, StringBuilder out) {
        if (contents == null) {
            ParenthesesUtils.$$$reportNull$$$0(8);
        }
        for (int index = 0; index < contents.length; ++index) {
            JSExpression arg = contents[index];
            if (index != 0) {
                out.append(',');
            }
            out.append(ParenthesesUtils.removeParentheses(arg));
        }
    }

    private static String removeParensFromAssignmentExpression(@NotNull JSAssignmentExpression assignment) {
        if (assignment == null) {
            ParenthesesUtils.$$$reportNull$$$0(9);
        }
        JSExpression lhs = assignment.getLOperand();
        JSExpression rhs = assignment.getROperand();
        IElementType sign = assignment.getOperationSign();
        return ParenthesesUtils.removeParentheses(lhs) + ' ' + BinaryOperatorUtils.getOperatorText(sign) + ' ' + ParenthesesUtils.removeParentheses(rhs);
    }

    private static String removeParensFromFunctionCallExpression(@NotNull JSCallExpression functionCall) {
        if (functionCall == null) {
            ParenthesesUtils.$$$reportNull$$$0(10);
        }
        JSExpression target = functionCall.getMethodExpression();
        JSExpression[] args = functionCall.getArguments();
        StringBuilder out = new StringBuilder(functionCall.getTextLength());
        String strippedTarget = ParenthesesUtils.removeParentheses(target);
        if (functionCall instanceof JSNewExpression) {
            out.append("new ");
        }
        out.append(strippedTarget);
        out.append('(');
        ParenthesesUtils.removeParenthesesFromCommaSeparatedExpressions(args, out);
        out.append(')');
        return out.toString();
    }

    private static String removeParensFromTaggedTemplateExpression(@NotNull ES6TaggedTemplateExpression expression) {
        JSStringTemplateExpression templateExpression;
        if (expression == null) {
            ParenthesesUtils.$$$reportNull$$$0(11);
        }
        JSExpression target = expression.getTag();
        StringBuilder out = new StringBuilder(expression.getTextLength());
        if (target != null) {
            out.append(ParenthesesUtils.removeParentheses(target));
        }
        if ((templateExpression = expression.getTemplateExpression()) != null) {
            out.append(templateExpression.getText());
        }
        return out.toString();
    }

    public static String getParenthesized(@NotNull JSExpression expression, int precedence) {
        if (expression == null) {
            ParenthesesUtils.$$$reportNull$$$0(12);
        }
        return ParenthesesUtils.getPrecedence(expression) > precedence ? '(' + expression.getText() + ')' : expression.getText();
    }

    public static boolean canRemoveParentheses(@NotNull JSParenthesizedExpression expression) {
        int childPrecedence;
        PsiElement expressionParent;
        if (expression == null) {
            ParenthesesUtils.$$$reportNull$$$0(13);
        }
        if (!((expressionParent = expression.getParent()) instanceof JSElement) || expressionParent instanceof FlowJSTypePredicateImpl) {
            return false;
        }
        JSElement parent = (JSElement)expressionParent;
        JSExpression body = expression.getInnerExpression();
        if (body == null) {
            return false;
        }
        if (!(parent instanceof JSExpression)) {
            JSDefinitionExpression definitionExpression;
            JSAssignmentExpression assignmentExpression;
            if (body instanceof JSCallExpression && ((JSCallExpression)body).getMethodExpression() instanceof JSFunctionExpression) {
                return false;
            }
            JSAssignmentExpression jSAssignmentExpression = assignmentExpression = body instanceof JSAssignmentExpression ? (JSAssignmentExpression)body : null;
            return assignmentExpression == null || (definitionExpression = assignmentExpression.getDefinitionExpression()) == null || PsiTreeUtil.getChildOfType((PsiElement)definitionExpression, JSObjectLiteralExpression.class) == null;
        }
        if (body instanceof JSParenthesizedExpression) {
            return true;
        }
        if (parent instanceof JSFunctionExpression) {
            return !JSPsiImplUtils.parensAroundArrowFunctionBodyRequired(body);
        }
        int parentPrecedence = ParenthesesUtils.getPrecedence((JSExpression)parent);
        if (parentPrecedence > (childPrecedence = ParenthesesUtils.getPrecedence(body))) {
            return !(body instanceof JSFunctionExpression);
        }
        if (parentPrecedence == childPrecedence && parent instanceof JSBinaryExpression && body instanceof JSBinaryExpression) {
            IElementType parentOperator = ((JSBinaryExpression)parent).getOperationSign();
            IElementType childOperator = ((JSBinaryExpression)body).getOperationSign();
            JSBinaryExpression binaryExpression = (JSBinaryExpression)parent;
            JSExpression lhs = binaryExpression.getLOperand();
            return lhs != null && lhs.equals(expression) && parentOperator.equals(childOperator);
        }
        return false;
    }

    static {
        s_binaryOperatorPrecedence.put(JSTokenTypes.PLUS, 7);
        s_binaryOperatorPrecedence.put(JSTokenTypes.MINUS, 7);
        s_binaryOperatorPrecedence.put(JSTokenTypes.MULT, 6);
        s_binaryOperatorPrecedence.put(JSTokenTypes.DIV, 6);
        s_binaryOperatorPrecedence.put(JSTokenTypes.PERC, 6);
        s_binaryOperatorPrecedence.put(JSTokenTypes.MULTMULT, 5);
        s_binaryOperatorPrecedence.put(JSTokenTypes.ANDAND, 14);
        s_binaryOperatorPrecedence.put(JSTokenTypes.OROR, 15);
        s_binaryOperatorPrecedence.put(JSTokenTypes.QUEST_QUEST, 15);
        s_binaryOperatorPrecedence.put(JSTokenTypes.AND, 11);
        s_binaryOperatorPrecedence.put(JSTokenTypes.OR, 13);
        s_binaryOperatorPrecedence.put(JSTokenTypes.XOR, 12);
        s_binaryOperatorPrecedence.put(JSTokenTypes.LTLT, 8);
        s_binaryOperatorPrecedence.put(JSTokenTypes.GTGT, 8);
        s_binaryOperatorPrecedence.put(JSTokenTypes.GTGTGT, 8);
        s_binaryOperatorPrecedence.put(JSTokenTypes.GT, 9);
        s_binaryOperatorPrecedence.put(JSTokenTypes.GE, 9);
        s_binaryOperatorPrecedence.put(JSTokenTypes.LT, 9);
        s_binaryOperatorPrecedence.put(JSTokenTypes.LE, 9);
        s_binaryOperatorPrecedence.put(JSTokenTypes.EQEQ, 10);
        s_binaryOperatorPrecedence.put(JSTokenTypes.EQEQEQ, 10);
        s_binaryOperatorPrecedence.put(JSTokenTypes.NE, 10);
        s_binaryOperatorPrecedence.put(JSTokenTypes.NEQEQ, 10);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parenthesizedExp";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditionalExp";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExp";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postfixExp";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixExp";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "init";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionCall";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/util/ParenthesesUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParentheses";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromReferenceExpression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromParenthesizedExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromConditionalExpression";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromBinaryExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromPostfixExpression";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromPrefixExpression";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromArrayLiteralExpression";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParenthesesFromCommaSeparatedExpressions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromAssignmentExpression";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromFunctionCallExpression";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromTaggedTemplateExpression";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getParenthesized";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "canRemoveParentheses";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

