/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.documentation;

import com.google.gson.Gson;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.actions.JSShowTypeInfoAction;
import com.intellij.lang.javascript.documentation.JavaScriptQuickNavigateBuilder;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.QuickInfoCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileLocationRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptQuickInfoResponse;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptQuickNavigateBuilder
extends JavaScriptQuickNavigateBuilder {
    public static final int TIMEOUT_MILLIS = 300;

    @Override
    @Nullable
    protected String getQuickNavigateInfoForNavigationElement(@NotNull PsiElement element, @NotNull PsiElement originalElement) {
        Future<String> future;
        String serviceResult;
        if (element == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(0);
        }
        if (originalElement == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(1);
        }
        if (!StringUtil.isEmpty((String)(serviceResult = JSLanguageServiceUtil.awaitFuture(future = TypeScriptQuickNavigateBuilder.requestServiceQuickInfo(element, originalElement), 300L)))) {
            return StringUtil.escapeXml((String)serviceResult);
        }
        return super.getQuickNavigateInfoForNavigationElement(element, originalElement);
    }

    @Nullable
    private static Future<String> requestServiceQuickInfo(@NotNull PsiElement element, @NotNull PsiElement originalElement) {
        if (element == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(2);
        }
        if (originalElement == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(3);
        }
        if (ApplicationManager.getApplication().isDispatchThread() && !ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(element.getProject());
        if (!settings.useService() || !settings.isUseServiceQuickNavigate()) {
            return null;
        }
        if (!DialectDetector.isTypeScript(originalElement)) {
            return null;
        }
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)originalElement);
        if (file2 == null) {
            return null;
        }
        TypeScriptCompilerService service = TypeScriptCompilerService.getServiceForFile(element.getProject(), file2);
        if (service == null || !service.isServiceCreated()) {
            return null;
        }
        if (originalElement instanceof PsiNameIdentifierOwner) {
            PsiElement identifier = ((PsiNameIdentifierOwner)originalElement).getNameIdentifier();
            originalElement = (PsiElement)ObjectUtils.coalesce((Object)identifier, (Object)originalElement);
        } else if (originalElement instanceof JSReferenceExpression) {
            originalElement = (PsiElement)ObjectUtils.coalesce((Object)((JSReferenceExpression)originalElement).getReferenceNameElement(), (Object)originalElement);
        }
        TextRange range = originalElement.getTextRange();
        int offset = range.getStartOffset();
        TypeScriptFileLocationRequestArgs location = new TypeScriptFileLocationRequestArgs();
        Document document = PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(originalElement.getContainingFile());
        if (document == null) {
            return null;
        }
        TypeScriptLanguageServiceUtil.fillFilePosition(location, file2, document, offset);
        QuickInfoCommand command = new QuickInfoCommand(location);
        return service.sendCommand(command, (serviceObject, answer) -> {
            Gson gson = JSLanguageServiceUtil.getGson(service);
            TypeScriptQuickInfoResponse response = TypeScriptLanguageServiceUtil.deserialize(gson, answer, TypeScriptQuickInfoResponse.class);
            return response == null ? null : response.displayString;
        });
    }

    @Override
    @NotNull
    protected String getVarPrefix(@NotNull JSVariable variable) {
        if (variable == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(4);
        }
        if (variable instanceof TypeScriptField || variable instanceof JSParameter) {
            if ("" == null) {
                TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(5);
            }
            return "";
        }
        String string = super.getVarPrefix(variable);
        if (string == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    protected void appendVariableInitializer(@NotNull JSVariable variable, @NotNull StringBuilder result2) {
        if (variable == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(7);
        }
        if (result2 == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(8);
        }
        if (variable instanceof TypeScriptVariable && variable.isConst()) {
            return;
        }
        String text = variable.getLiteralOrReferenceInitializerText();
        if (text != null) {
            super.appendVariableInitializer(variable, result2);
        }
    }

    @Override
    protected void appendClassExtendsAndImplements(@NotNull JSClass jsClass, @NotNull String packageNameOrEmptyString, @NotNull StringBuilder result2) {
        if (jsClass == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(9);
        }
        if (packageNameOrEmptyString == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(10);
        }
        if (result2 == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(11);
        }
        if (jsClass instanceof TypeScriptTypeAlias) {
            return;
        }
        super.appendClassExtendsAndImplements(jsClass, packageNameOrEmptyString, result2);
    }

    @Override
    protected JSType getVariableOrFieldType(@NotNull JSTypeDeclarationOwner variable) {
        if (variable == null) {
            TypeScriptQuickNavigateBuilder.$$$reportNull$$$0(12);
        }
        return JSShowTypeInfoAction.getTypeForDocumentation((PsiElement)variable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
            case 4: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/documentation/TypeScriptQuickNavigateBuilder";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageNameOrEmptyString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/documentation/TypeScriptQuickNavigateBuilder";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuickNavigateInfoForNavigationElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "requestServiceQuickInfo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getVarPrefix";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "appendVariableInitializer";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "appendClassExtendsAndImplements";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getVariableOrFieldType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

