/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.settings.exclude;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.javascript.TypeScriptFileType;
import com.intellij.lang.javascript.TypeScriptJSXFileType;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.typescript.settings.exclude.TypeScriptExcludeManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TypeScriptGeneratedFilesStartupActivity
implements StartupActivity {
    public static final String[] JS_AND_DTS_EXTENSIONS = new String[]{".js.map", ".js", ".jsx", ".d.ts"};

    public void runActivity(final @NotNull Project project) {
        TypeScriptExcludeManager generatedFilesManager;
        if (project == null) {
            TypeScriptGeneratedFilesStartupActivity.$$$reportNull$$$0(0);
        }
        if ((generatedFilesManager = TypeScriptExcludeManager.getInstance(project)) == null) {
            return;
        }
        if (!generatedFilesManager.isProjectProcessed()) {
            TypeScriptGeneratedFilesStartupActivity.addPlainJavaScriptAndDeclarationFilesToExclude(project, generatedFilesManager);
        }
        project.getMessageBus().connect((Disposable)project).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                List excludedFiles = null;
                for (VFileEvent vFileEvent : events) {
                    VirtualFile candidate;
                    if (!(vFileEvent instanceof VFileCreateEvent) || !TypeScriptGeneratedFilesStartupActivity.shouldExcludeFile(candidate = vFileEvent.getFile())) continue;
                    if (excludedFiles == null) {
                        excludedFiles = ContainerUtil.newSmartList();
                    }
                    excludedFiles.add(candidate);
                }
                if (excludedFiles != null) {
                    generatedFilesManager.addFiles(excludedFiles);
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (project == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        TypeScriptGeneratedFilesStartupActivity.updateProject(project, generatedFilesManager);
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "events";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesStartupActivity$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "after";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$after$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void updateProject(@NotNull Project project, TypeScriptExcludeManager generatedFilesManager) {
        if (project == null) {
            TypeScriptGeneratedFilesStartupActivity.$$$reportNull$$$0(1);
        }
        TransactionGuard.submitTransaction((Disposable)project, generatedFilesManager::updateProject);
    }

    private static void addPlainJavaScriptAndDeclarationFilesToExclude(@NotNull Project project, TypeScriptExcludeManager generatedFilesManager) {
        if (project == null) {
            TypeScriptGeneratedFilesStartupActivity.$$$reportNull$$$0(2);
        }
        Runnable runnable = () -> {
            if (project == null) {
                TypeScriptGeneratedFilesStartupActivity.$$$reportNull$$$0(3);
            }
            Runnable action = () -> {
                if (project == null) {
                    TypeScriptGeneratedFilesStartupActivity.$$$reportNull$$$0(4);
                }
                if (project.isDisposed() || !project.isOpen() || !generatedFilesManager.isExcludeGeneratedFiles()) {
                    return;
                }
                ArrayList toExcludeFiles = ContainerUtil.newArrayList();
                FileTypeIndex.processFiles((FileType)TypeScriptFileType.INSTANCE, file2 -> TypeScriptGeneratedFilesStartupActivity.addFileToExclude(toExcludeFiles, file2), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
                FileTypeIndex.processFiles((FileType)TypeScriptJSXFileType.INSTANCE, file2 -> TypeScriptGeneratedFilesStartupActivity.addFileToExclude(toExcludeFiles, file2), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
                generatedFilesManager.setFiles(toExcludeFiles);
                generatedFilesManager.updateVersion();
                if (!toExcludeFiles.isEmpty()) {
                    TypeScriptGeneratedFilesStartupActivity.updateProject(project, generatedFilesManager);
                }
            };
            DumbService.getInstance((Project)project).runReadActionInSmartMode(action);
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable.run();
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(runnable);
        }
    }

    private static boolean shouldExcludeFile(VirtualFile candidateToExclude) {
        if (candidateToExclude == null) {
            return false;
        }
        String name = candidateToExclude.getName();
        String jsExtension = JSFileReference.findExtension(name, JS_AND_DTS_EXTENSIONS);
        if (jsExtension == null) {
            return false;
        }
        String jsFileNameWithoutExtension = TypeScriptUtil.getNameWithoutExtension(name, jsExtension);
        VirtualFile directory = candidateToExclude.getParent();
        if (directory == null) {
            return false;
        }
        for (String ext : TypeScriptUtil.TYPESCRIPT_EXTENSIONS_WITHOUT_DTS) {
            VirtualFile child = directory.findChild(jsFileNameWithoutExtension + ext);
            if (child == null) continue;
            return true;
        }
        return false;
    }

    private static boolean addFileToExclude(ArrayList<VirtualFile> toExcludeFiles, VirtualFile file2) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        String fileName = file2.getName();
        String extension = JSFileReference.findExtension(fileName, TypeScriptUtil.TYPESCRIPT_EXTENSIONS_WITHOUT_DTS);
        if (StringUtil.isEmpty((String)extension)) {
            return true;
        }
        VirtualFile directory = file2.getParent();
        String tsFileNameWithoutExtension = TypeScriptUtil.getNameWithoutExtension(fileName, extension);
        if (!StringUtil.isEmpty((String)tsFileNameWithoutExtension)) {
            for (VirtualFile virtualFile : directory.getChildren()) {
                String jsFileNameWithoutExtension;
                String jsExtension;
                String jsCandidateName = virtualFile.getName();
                if (!jsCandidateName.startsWith(tsFileNameWithoutExtension) || (jsExtension = JSFileReference.findExtension(jsCandidateName, JS_AND_DTS_EXTENSIONS)) == null || !tsFileNameWithoutExtension.equals(jsFileNameWithoutExtension = TypeScriptUtil.getNameWithoutExtension(jsCandidateName, jsExtension))) continue;
                toExcludeFiles.add(virtualFile);
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesStartupActivity";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateProject";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addPlainJavaScriptAndDeclarationFilesToExclude";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$addPlainJavaScriptAndDeclarationFilesToExclude$3";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$2";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

