/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.editor.CssFormattingModelBuilder;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.less.LESSElementTypes;
import org.jetbrains.plugins.less.LESSLanguage;
import org.jetbrains.plugins.less.formatter.LESSMixinBlock;
import org.jetbrains.plugins.less.formatter.LESSRootBlock;
import org.jetbrains.plugins.less.formatter.LESSRulesetBlock;
import org.jetbrains.plugins.less.lexer.LESSTokenTypes;
import org.jetbrains.plugins.less.psi.LESSMixin;
import org.jetbrains.plugins.less.psi.LESSMixinInvocation;
import org.jetbrains.plugins.less.psi.LESSVariableDeclaration;
import org.jetbrains.plugins.less.psi.impl.LESSGuardImpl;
import org.jetbrains.plugins.less.psi.impl.LESSMixinName;
import org.jetbrains.plugins.less.psi.impl.LESSVariableImpl;
import org.jetbrains.plugins.less.psi.impl.LessPluginDeclaration;
import org.jetbrains.plugins.less.settings.LessCodeStyleSettings;

public class LessFormattingModelBuilder
extends CssFormattingModelBuilder {
    protected LessFormattingExtension createExtension(CodeStyleSettings settings) {
        return new LessFormattingExtension(settings.getCommonSettings((Language)LESSLanguage.INSTANCE), (LessCodeStyleSettings)settings.getCustomSettings(LessCodeStyleSettings.class));
    }

    protected static class LessFormattingExtension
    extends CssFormattingModelBuilder.CssFormattingExtension {
        public LessFormattingExtension(CommonCodeStyleSettings commonSettings, LessCodeStyleSettings customSettings) {
            super(commonSettings, (CssCodeStyleSettings)customSettings);
        }

        public boolean isLineComment(IElementType elementType) {
            return LESSTokenTypes.COMMENT == elementType || super.isLineComment(elementType);
        }

        public boolean isComment(IElementType elementType) {
            return LESSElementTypes.LESS_COMMENTS.contains(elementType) || super.isComment(elementType);
        }

        public boolean addSubBlocksOfExtendedLanguage(PsiElement element, int maxPropertyLength, List<Block> result) {
            Alignment alignment;
            IElementType parentType = element.getParent().getNode().getElementType();
            Indent indent = parentType == CssElementTypes.CSS_DECLARATION_BLOCK || parentType == CssElementTypes.CSS_KEYFRAMES_RULE ? Indent.getNormalIndent() : Indent.getNoneIndent();
            Object object = alignment = this.myCustomSettings.VALUE_ALIGNMENT == 2 || this.myCustomSettings.VALUE_ALIGNMENT == 1 ? Alignment.createAlignment((boolean)true) : null;
            if (element instanceof LESSGuardImpl) {
                result.add((Block)new CssFormattingModelBuilder.CssSimpleBlock(element.getNode(), Indent.getNoneIndent(), element.getTextLength(), (CssFormattingModelBuilder.CssFormattingExtension)this));
                return true;
            }
            if (element instanceof LESSVariableDeclaration || element instanceof LessPluginDeclaration) {
                result.add((Block)new CssFormattingModelBuilder.CssPropertyBlock(element.getNode(), indent, maxPropertyLength, (CssFormattingModelBuilder.CssFormattingExtension)this, element.getTextLength(), null, alignment));
                return true;
            }
            if (element instanceof LESSVariableImpl) {
                result.add((Block)new CssFormattingModelBuilder.CssSimpleBlock(element.getNode(), Indent.getNoneIndent(), maxPropertyLength, (CssFormattingModelBuilder.CssFormattingExtension)this));
                return true;
            }
            if (element instanceof LESSMixinInvocation) {
                result.add((Block)new CssFormattingModelBuilder.CssPropertyBlock(element.getNode(), indent, element.getTextLength(), (CssFormattingModelBuilder.CssFormattingExtension)this, element.getTextLength(), alignment, null));
                return true;
            }
            if (element instanceof LESSMixin) {
                result.add((Block)new LESSMixinBlock(element.getNode(), indent, maxPropertyLength, this));
                return true;
            }
            if (element instanceof LESSMixinName || LESSTokenTypes.GUARD_KEYWORDS.contains(element.getNode().getElementType())) {
                result.add((Block)new CssFormattingModelBuilder.LeafBlock(element.getNode(), Indent.getNoneIndent()));
                return true;
            }
            return false;
        }

        public CssFormattingModelBuilder.CssRootBlock createRootBlock(ASTNode _node, int maxPropertyLength, CssFormattingModelBuilder.CssFormattingExtension extension) {
            return new LESSRootBlock(_node, maxPropertyLength, extension);
        }

        public CssFormattingModelBuilder.CssRulesetBlock createRulesetBlock(ASTNode _node, Indent indent, int maxPropertyLength, CssFormattingModelBuilder.CssFormattingExtension extension, @Nullable Alignment alignment) {
            return new LESSRulesetBlock(_node, indent, maxPropertyLength, extension, alignment);
        }
    }
}

