/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitBinaryContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.diff.GitSubmoduleContentRevision;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.repo.GitSubmodule;
import git4idea.repo.GitSubmoduleKt;
import git4idea.util.GitFileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitContentRevision
implements ByteBackedContentRevision {
    @NotNull
    protected final FilePath myFile;
    @NotNull
    private final GitRevisionNumber myRevision;
    @NotNull
    private final Project myProject;
    @Nullable
    private final Charset myCharset;

    protected GitContentRevision(@NotNull FilePath file, @NotNull GitRevisionNumber revision, @NotNull Project project, @Nullable Charset charset) {
        if (file == null) {
            GitContentRevision.$$$reportNull$$$0(0);
        }
        if (revision == null) {
            GitContentRevision.$$$reportNull$$$0(1);
        }
        if (project == null) {
            GitContentRevision.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myFile = file;
        this.myRevision = revision;
        this.myCharset = charset;
    }

    @Nullable
    public String getContent() throws VcsException {
        byte[] bytes = this.getContentAsBytes();
        if (bytes == null) {
            return null;
        }
        return ContentRevisionCache.getAsString((byte[])bytes, (FilePath)this.myFile, (Charset)this.myCharset);
    }

    @Nullable
    public byte[] getContentAsBytes() throws VcsException {
        if (this.myFile.isDirectory()) {
            return null;
        }
        try {
            return ContentRevisionCache.getOrLoadAsBytes((Project)this.myProject, (FilePath)this.myFile, (VcsRevisionNumber)this.myRevision, (VcsKey)GitVcs.getKey(), (ContentRevisionCache.UniqueType)ContentRevisionCache.UniqueType.REPOSITORY_CONTENT, this::loadContent);
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private byte[] loadContent() throws VcsException {
        VirtualFile root = GitUtil.getGitRoot(this.myFile);
        return GitFileUtils.getFileContent(this.myProject, root, this.myRevision.getRev(), VcsFileUtil.relativePath((VirtualFile)root, (FilePath)this.myFile));
    }

    @NotNull
    public FilePath getFile() {
        FilePath filePath = this.myFile;
        if (filePath == null) {
            GitContentRevision.$$$reportNull$$$0(3);
        }
        return filePath;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        GitRevisionNumber gitRevisionNumber = this.myRevision;
        if (gitRevisionNumber == null) {
            GitContentRevision.$$$reportNull$$$0(4);
        }
        return gitRevisionNumber;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        GitContentRevision test = (GitContentRevision)obj;
        return this.myFile.equals(test.myFile) && this.myRevision.equals(test.myRevision);
    }

    public int hashCode() {
        return this.myFile.hashCode() + this.myRevision.hashCode();
    }

    @NotNull
    public static ContentRevision createRevision(@NotNull VirtualFile vcsRoot, @NotNull String path, @Nullable VcsRevisionNumber revisionNumber, Project project, boolean unescapePath) throws VcsException {
        if (vcsRoot == null) {
            GitContentRevision.$$$reportNull$$$0(5);
        }
        if (path == null) {
            GitContentRevision.$$$reportNull$$$0(6);
        }
        FilePath file = GitContentRevision.createPath(vcsRoot, path, unescapePath);
        ContentRevision contentRevision = GitContentRevision.createRevision(file, revisionNumber, project, null);
        if (contentRevision == null) {
            GitContentRevision.$$$reportNull$$$0(7);
        }
        return contentRevision;
    }

    @Nullable
    public static GitSubmodule getRepositoryIfSubmodule(@NotNull Project project, @NotNull FilePath path) {
        VirtualFile file;
        if (project == null) {
            GitContentRevision.$$$reportNull$$$0(8);
        }
        if (path == null) {
            GitContentRevision.$$$reportNull$$$0(9);
        }
        if ((file = path.getVirtualFile()) == null) {
            return null;
        }
        if (!file.isDirectory()) {
            return null;
        }
        GitRepositoryManager repositoryManager = GitRepositoryManager.getInstance(project);
        GitRepository candidate = (GitRepository)repositoryManager.getRepositoryForRoot(file);
        if (candidate == null) {
            return null;
        }
        return GitSubmoduleKt.asSubmodule(candidate);
    }

    @NotNull
    public static ContentRevision createRevisionForTypeChange(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull String path, @Nullable VcsRevisionNumber revisionNumber, boolean unescapePath) throws VcsException {
        FilePath filePath;
        if (project == null) {
            GitContentRevision.$$$reportNull$$$0(10);
        }
        if (vcsRoot == null) {
            GitContentRevision.$$$reportNull$$$0(11);
        }
        if (path == null) {
            GitContentRevision.$$$reportNull$$$0(12);
        }
        if (revisionNumber == null) {
            File file = new File(GitContentRevision.makeAbsolutePath(vcsRoot, path, unescapePath));
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
            filePath = virtualFile == null ? VcsUtil.getFilePath((File)file, (boolean)false) : VcsUtil.getFilePath((VirtualFile)virtualFile);
        } else {
            filePath = GitContentRevision.createPath(vcsRoot, path, unescapePath);
        }
        ContentRevision contentRevision = GitContentRevision.createRevision(filePath, revisionNumber, project, null);
        if (contentRevision == null) {
            GitContentRevision.$$$reportNull$$$0(13);
        }
        return contentRevision;
    }

    @NotNull
    public static FilePath createPath(@NotNull VirtualFile vcsRoot, @NotNull String path, boolean unescapePath) throws VcsException {
        if (vcsRoot == null) {
            GitContentRevision.$$$reportNull$$$0(14);
        }
        if (path == null) {
            GitContentRevision.$$$reportNull$$$0(15);
        }
        String absolutePath = GitContentRevision.makeAbsolutePath(vcsRoot, path, unescapePath);
        FilePath filePath = VcsUtil.getFilePath((String)absolutePath, (boolean)false);
        if (filePath == null) {
            GitContentRevision.$$$reportNull$$$0(16);
        }
        return filePath;
    }

    @NotNull
    private static String makeAbsolutePath(@NotNull VirtualFile vcsRoot, @NotNull String path, boolean unescapePath) throws VcsException {
        if (vcsRoot == null) {
            GitContentRevision.$$$reportNull$$$0(17);
        }
        if (path == null) {
            GitContentRevision.$$$reportNull$$$0(18);
        }
        String unescapedPath = unescapePath ? GitUtil.unescapePath(path) : path;
        String string = vcsRoot.getPath() + "/" + unescapedPath;
        if (string == null) {
            GitContentRevision.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public static ContentRevision createRevision(@NotNull VirtualFile file, @Nullable VcsRevisionNumber revisionNumber, @NotNull Project project) {
        if (file == null) {
            GitContentRevision.$$$reportNull$$$0(20);
        }
        if (project == null) {
            GitContentRevision.$$$reportNull$$$0(21);
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
        ContentRevision contentRevision = GitContentRevision.createRevision(filePath, revisionNumber, project, null);
        if (contentRevision == null) {
            GitContentRevision.$$$reportNull$$$0(22);
        }
        return contentRevision;
    }

    @NotNull
    public static ContentRevision createRevision(@NotNull FilePath filePath, @Nullable VcsRevisionNumber revisionNumber, @NotNull Project project, @Nullable Charset charset) {
        if (filePath == null) {
            GitContentRevision.$$$reportNull$$$0(23);
        }
        if (project == null) {
            GitContentRevision.$$$reportNull$$$0(24);
        }
        GitSubmodule submodule = GitContentRevision.getRepositoryIfSubmodule(project, filePath);
        if (revisionNumber != null && revisionNumber != VcsRevisionNumber.NULL) {
            if (submodule != null) {
                ContentRevision contentRevision = GitSubmoduleContentRevision.createRevision(submodule, revisionNumber);
                if (contentRevision == null) {
                    GitContentRevision.$$$reportNull$$$0(25);
                }
                return contentRevision;
            }
            GitContentRevision gitContentRevision = GitContentRevision.createRevisionImpl(filePath, (GitRevisionNumber)revisionNumber, project, charset);
            if (gitContentRevision == null) {
                GitContentRevision.$$$reportNull$$$0(26);
            }
            return gitContentRevision;
        }
        if (submodule != null) {
            ContentRevision contentRevision = GitSubmoduleContentRevision.createCurrentRevision(submodule.getRepository());
            if (contentRevision == null) {
                GitContentRevision.$$$reportNull$$$0(27);
            }
            return contentRevision;
        }
        ContentRevision contentRevision = CurrentContentRevision.create((FilePath)filePath);
        if (contentRevision == null) {
            GitContentRevision.$$$reportNull$$$0(28);
        }
        return contentRevision;
    }

    @NotNull
    private static GitContentRevision createRevisionImpl(@NotNull FilePath path, @NotNull GitRevisionNumber revisionNumber, @NotNull Project project, @Nullable Charset charset) {
        if (path == null) {
            GitContentRevision.$$$reportNull$$$0(29);
        }
        if (revisionNumber == null) {
            GitContentRevision.$$$reportNull$$$0(30);
        }
        if (project == null) {
            GitContentRevision.$$$reportNull$$$0(31);
        }
        if (path.getFileType().isBinary()) {
            GitBinaryContentRevision gitBinaryContentRevision = new GitBinaryContentRevision(path, revisionNumber, project);
            if (gitBinaryContentRevision == null) {
                GitContentRevision.$$$reportNull$$$0(32);
            }
            return gitBinaryContentRevision;
        }
        GitContentRevision gitContentRevision = new GitContentRevision(path, revisionNumber, project, charset);
        if (gitContentRevision == null) {
            GitContentRevision.$$$reportNull$$$0(33);
        }
        return gitContentRevision;
    }

    public String toString() {
        return this.myFile.getPath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 2: 
            case 8: 
            case 10: 
            case 21: 
            case 24: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/GitContentRevision";
                break;
            }
            case 5: 
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisionNumber";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/GitContentRevision";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevisionNumber";
                break;
            }
            case 7: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createRevision";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createRevisionForTypeChange";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createPath";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "makeAbsolutePath";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createRevisionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 33: {
                break;
            }
            case 5: 
            case 6: 
            case 20: 
            case 21: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createRevision";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryIfSubmodule";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createRevisionForTypeChange";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createPath";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "makeAbsolutePath";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createRevisionImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

