/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.branch.BranchData;
import com.intellij.vcs.branch.BranchStateProvider;
import com.intellij.vcs.branch.LinkedBranchDataImpl;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.repo.GitRepository;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lgit4idea/branch/GitBranchStateProvider;", "Lcom/intellij/vcs/branch/BranchStateProvider;", "project", "Lcom/intellij/openapi/project/Project;", "vcsManager", "Lcom/intellij/openapi/vcs/ProjectLevelVcsManager;", "repositoryManager", "Lcom/intellij/dvcs/repo/VcsRepositoryManager;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/ProjectLevelVcsManager;Lcom/intellij/dvcs/repo/VcsRepositoryManager;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRepositoryManager", "()Lcom/intellij/dvcs/repo/VcsRepositoryManager;", "getVcsManager", "()Lcom/intellij/openapi/vcs/ProjectLevelVcsManager;", "getCurrentBranch", "Lcom/intellij/vcs/branch/BranchData;", "path", "Lcom/intellij/openapi/vcs/FilePath;", "intellij.vcs.git"})
public final class GitBranchStateProvider
implements BranchStateProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final ProjectLevelVcsManager vcsManager;
    @NotNull
    private final VcsRepositoryManager repositoryManager;

    @Nullable
    public BranchData getCurrentBranch(@NotNull FilePath path) {
        LinkedBranchDataImpl linkedBranchDataImpl;
        GitRepository repository;
        Repository repository2;
        Repository repository3;
        VirtualFile it;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        if (!this.vcsManager.checkVcsIsActive("Git")) {
            return null;
        }
        VirtualFile virtualFile = ChangesUtil.findValidParentAccurately((FilePath)path);
        if (virtualFile != null) {
            it = object = virtualFile;
            repository3 = this.repositoryManager.getRepositoryForFile(it, true);
        } else {
            repository3 = repository2 = null;
        }
        if (!(repository3 instanceof GitRepository)) {
            repository2 = null;
        }
        GitRepository gitRepository = repository = (GitRepository)repository2;
        if (gitRepository != null) {
            GitBranch gitBranch;
            it = object = gitRepository;
            VirtualFile virtualFile2 = it.getRoot();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"it.root");
            String string = virtualFile2.getPresentableName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.root.presentableName");
            GitLocalBranch gitLocalBranch = it.getCurrentBranch();
            linkedBranchDataImpl = new LinkedBranchDataImpl(string, gitLocalBranch != null ? gitLocalBranch.getName() : null, (gitBranch = it.getCurrentBranch()) != null && (gitBranch = ((GitLocalBranch)gitBranch).findTrackedBranch((GitRepository)it)) != null ? gitBranch.getName() : null);
        } else {
            linkedBranchDataImpl = null;
        }
        return (BranchData)linkedBranchDataImpl;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ProjectLevelVcsManager getVcsManager() {
        return this.vcsManager;
    }

    @NotNull
    public final VcsRepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    public GitBranchStateProvider(@NotNull Project project, @NotNull ProjectLevelVcsManager vcsManager, @NotNull VcsRepositoryManager repositoryManager) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)vcsManager, (String)"vcsManager");
        Intrinsics.checkParameterIsNotNull((Object)repositoryManager, (String)"repositoryManager");
        this.project = project;
        this.vcsManager = vcsManager;
        this.repositoryManager = repositoryManager;
    }
}

