/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.LogDataImpl;
import com.intellij.vcs.log.util.StopWatch;
import git4idea.GitCommit;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandler;
import git4idea.commands.GitHandlerInputProcessorUtil;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitTextHandler;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitLogOutputSplitter;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogRecord;
import git4idea.history.GitLogRecordCollector;
import git4idea.history.GitLogUnorderedRecordCollector;
import git4idea.log.GitLogProvider;
import git4idea.log.GitRefManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitLogUtil {
    private static final Logger LOG = Logger.getInstance(GitLogUtil.class);
    public static final String GRAFTED = "grafted";
    public static final String REPLACED = "replaced";
    public static final List<String> LOG_ALL = Arrays.asList("HEAD", "--branches", "--remotes", "--tags");
    public static final String STDIN = "--stdin";

    @NotNull
    public static List<? extends VcsCommitMetadata> collectShortDetails(@NotNull Project project, @NotNull GitVcs vcs, @NotNull VirtualFile root, @NotNull List<String> hashes2) throws VcsException {
        VcsLogObjectsFactory factory;
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(0);
        }
        if (vcs == null) {
            GitLogUtil.$$$reportNull$$$0(1);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(2);
        }
        if (hashes2 == null) {
            GitLogUtil.$$$reportNull$$$0(3);
        }
        if ((factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project)) == null) {
            List list = Collections.emptyList();
            if (list == null) {
                GitLogUtil.$$$reportNull$$$0(4);
            }
            return list;
        }
        GitLineHandler h = GitLogUtil.createGitHandler(project, root);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.NONE, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.AUTHOR_TIME, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY);
        h.setSilent(true);
        h.addParameters(GitLogUtil.getNoWalkParameter(vcs));
        h.addParameters(parser.getPretty(), "--encoding=UTF-8");
        h.addParameters(STDIN);
        h.endOptions();
        GitLogUtil.sendHashesToStdin(vcs, hashes2, h);
        String output = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        List<GitLogRecord> records = parser.parse(output);
        List list = ContainerUtil.map(records, record -> {
            if (root == null) {
                GitLogUtil.$$$reportNull$$$0(98);
            }
            SmartList parents = new SmartList();
            for (String parent : record.getParentsHashes()) {
                parents.add(HashImpl.build((String)parent));
            }
            record.setUsedHandler(h);
            return factory.createCommitMetadata(HashImpl.build((String)record.getHash()), (List)parents, record.getCommitTime(), root, record.getSubject(), record.getAuthorName(), record.getAuthorEmail(), record.getFullMessage(), record.getCommitterName(), record.getCommitterEmail(), record.getAuthorTimeStamp());
        });
        if (list == null) {
            GitLogUtil.$$$reportNull$$$0(5);
        }
        return list;
    }

    public static void readTimedCommits(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> parameters, @NotNull Consumer<? super VcsUser> userConsumer, @NotNull Consumer<? super VcsRef> refConsumer, @NotNull Consumer<? super TimedVcsCommit> commitConsumer) throws VcsException {
        VcsLogObjectsFactory factory;
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(6);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(7);
        }
        if (parameters == null) {
            GitLogUtil.$$$reportNull$$$0(8);
        }
        if (userConsumer == null) {
            GitLogUtil.$$$reportNull$$$0(9);
        }
        if (refConsumer == null) {
            GitLogUtil.$$$reportNull$$$0(10);
        }
        if (commitConsumer == null) {
            GitLogUtil.$$$reportNull$$$0(11);
        }
        if ((factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project)) == null) {
            return;
        }
        GitLineHandler handler = GitLogUtil.createGitHandler(project, root, Collections.emptyList(), false);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.NONE, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.REF_NAMES);
        handler.setStdoutSuppressed(true);
        handler.addParameters(parser.getPretty(), "--encoding=UTF-8");
        handler.addParameters("--decorate=full");
        handler.addParameters(parameters);
        handler.endOptions();
        GitLogOutputSplitter handlerListener = new GitLogOutputSplitter(handler, parser, (Consumer<? super GitLogRecord>)((Consumer)record -> {
            if (commitConsumer == null) {
                GitLogUtil.$$$reportNull$$$0(94);
            }
            if (root == null) {
                GitLogUtil.$$$reportNull$$$0(95);
            }
            if (refConsumer == null) {
                GitLogUtil.$$$reportNull$$$0(96);
            }
            if (userConsumer == null) {
                GitLogUtil.$$$reportNull$$$0(97);
            }
            Hash hash = HashImpl.build((String)record.getHash());
            List<Hash> parents = GitLogUtil.getParentHashes(factory, record);
            commitConsumer.consume((Object)factory.createTimedCommit(hash, parents, record.getCommitTime()));
            for (VcsRef ref : GitLogUtil.parseRefs(record.getRefs(), hash, factory, root)) {
                refConsumer.consume((Object)ref);
            }
            userConsumer.consume((Object)factory.createUser(record.getAuthorName(), record.getAuthorEmail()));
        }));
        Git.getInstance().runCommandWithoutCollectingOutput(handler);
        handlerListener.reportErrors();
    }

    @NotNull
    private static Collection<VcsRef> parseRefs(@NotNull Collection<String> refs, @NotNull Hash hash, @NotNull VcsLogObjectsFactory factory, @NotNull VirtualFile root) {
        if (refs == null) {
            GitLogUtil.$$$reportNull$$$0(12);
        }
        if (hash == null) {
            GitLogUtil.$$$reportNull$$$0(13);
        }
        if (factory == null) {
            GitLogUtil.$$$reportNull$$$0(14);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(15);
        }
        List list = ContainerUtil.mapNotNull(refs, refName -> {
            if (factory == null) {
                GitLogUtil.$$$reportNull$$$0(91);
            }
            if (hash == null) {
                GitLogUtil.$$$reportNull$$$0(92);
            }
            if (root == null) {
                GitLogUtil.$$$reportNull$$$0(93);
            }
            if (refName.equals(GRAFTED) || refName.equals(REPLACED)) {
                return null;
            }
            VcsRefType type = GitRefManager.getRefType(refName);
            return (refName = GitBranchUtil.stripRefsPrefix(refName)).equals("origin/HEAD") ? null : factory.createRef(hash, refName, type, root);
        });
        if (list == null) {
            GitLogUtil.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    public static VcsLogProvider.DetailedLogData collectMetadata(@NotNull Project project, @NotNull VirtualFile root, boolean lowPriorityProcess, String ... params) throws VcsException {
        VcsLogObjectsFactory factory;
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(17);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(18);
        }
        if ((factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project)) == null) {
            LogDataImpl logDataImpl = LogDataImpl.empty();
            if (logDataImpl == null) {
                GitLogUtil.$$$reportNull$$$0(19);
            }
            return logDataImpl;
        }
        OpenTHashSet refs = new OpenTHashSet(GitLogProvider.DONT_CONSIDER_SHA);
        List<VcsCommitMetadata> commits2 = GitLogUtil.collectMetadata(project, root, lowPriorityProcess, (NullableFunction<GitLogRecord, VcsCommitMetadata>)((NullableFunction)arg_0 -> GitLogUtil.lambda$collectMetadata$4(project, root, factory, (Set)refs, arg_0)), params);
        LogDataImpl logDataImpl = new LogDataImpl((Set)refs, commits2);
        if (logDataImpl == null) {
            GitLogUtil.$$$reportNull$$$0(20);
        }
        return logDataImpl;
    }

    @NotNull
    private static List<VcsCommitMetadata> collectMetadata(@NotNull Project project, @NotNull VirtualFile root, boolean lowPriorityProcess, @NotNull NullableFunction<GitLogRecord, VcsCommitMetadata> converter, String ... parameters) throws VcsException {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(21);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(22);
        }
        if (converter == null) {
            GitLogUtil.$$$reportNull$$$0(23);
        }
        ArrayList commits2 = ContainerUtil.newArrayList();
        try {
            GitLineHandler handler = GitLogUtil.createGitHandler(project, root, GitLogUtil.createConfigParameters(false, false, DiffRenameLimit.GIT_CONFIG), lowPriorityProcess);
            GitLogUtil.readRecordsFromHandler(project, root, true, false, (Consumer<GitLogRecord>)((Consumer)record -> {
                if (converter == null) {
                    GitLogUtil.$$$reportNull$$$0(88);
                }
                commits2.add(converter.fun(record));
            }), handler, parameters);
        }
        catch (VcsException e) {
            if (commits2.isEmpty()) {
                throw e;
            }
            LOG.warn("Error during loading details, returning partially loaded commits\n", (Throwable)e);
        }
        ArrayList arrayList = commits2;
        if (arrayList == null) {
            GitLogUtil.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    @Nullable
    public static VcsLogObjectsFactory getObjectsFactoryWithDisposeCheck(@NotNull Project project) {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(25);
        }
        return (VcsLogObjectsFactory)ReadAction.compute(() -> {
            if (project == null) {
                GitLogUtil.$$$reportNull$$$0(87);
            }
            if (!project.isDisposed()) {
                return (VcsLogObjectsFactory)ServiceManager.getService((Project)project, VcsLogObjectsFactory.class);
            }
            return null;
        });
    }

    @NotNull
    private static GitCommit createCommit(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<GitLogRecord> records, @NotNull VcsLogObjectsFactory factory) {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(26);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(27);
        }
        if (records == null) {
            GitLogUtil.$$$reportNull$$$0(28);
        }
        if (factory == null) {
            GitLogUtil.$$$reportNull$$$0(29);
        }
        GitCommit gitCommit = GitLogUtil.createCommit(project, root, records, factory, DiffRenameLimit.GIT_CONFIG);
        if (gitCommit == null) {
            GitLogUtil.$$$reportNull$$$0(30);
        }
        return gitCommit;
    }

    @NotNull
    private static GitCommit createCommit(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<GitLogRecord> records, @NotNull VcsLogObjectsFactory factory, @NotNull DiffRenameLimit renameLimit) {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(31);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(32);
        }
        if (records == null) {
            GitLogUtil.$$$reportNull$$$0(33);
        }
        if (factory == null) {
            GitLogUtil.$$$reportNull$$$0(34);
        }
        if (renameLimit == null) {
            GitLogUtil.$$$reportNull$$$0(35);
        }
        GitLogRecord record = (GitLogRecord)ObjectUtils.notNull((Object)ContainerUtil.getLastItem(records));
        List<Hash> parents = GitLogUtil.getParentHashes(factory, record);
        GitCommit gitCommit = new GitCommit(project, HashImpl.build((String)record.getHash()), parents, record.getCommitTime(), root, record.getSubject(), factory.createUser(record.getAuthorName(), record.getAuthorEmail()), record.getFullMessage(), factory.createUser(record.getCommitterName(), record.getCommitterEmail()), record.getAuthorTimeStamp(), ContainerUtil.map(records, GitLogRecord::getStatusInfos), renameLimit);
        if (gitCommit == null) {
            GitLogUtil.$$$reportNull$$$0(36);
        }
        return gitCommit;
    }

    @NotNull
    public static List<Hash> getParentHashes(@NotNull VcsLogObjectsFactory factory, @NotNull GitLogRecord record) {
        if (factory == null) {
            GitLogUtil.$$$reportNull$$$0(37);
        }
        if (record == null) {
            GitLogUtil.$$$reportNull$$$0(38);
        }
        List list = ContainerUtil.map((Object[])record.getParentsHashes(), arg_0 -> ((VcsLogObjectsFactory)factory).createHash(arg_0));
        if (list == null) {
            GitLogUtil.$$$reportNull$$$0(39);
        }
        return list;
    }

    @NotNull
    public static List<GitCommit> collectFullDetails(@NotNull Project project, @NotNull VirtualFile root, String ... parameters) throws VcsException {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(40);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(41);
        }
        ArrayList commits2 = ContainerUtil.newArrayList();
        try {
            GitLogUtil.readFullDetails(project, root, (Consumer<? super GitCommit>)((Consumer)commits2::add), true, true, false, parameters);
        }
        catch (VcsException e) {
            if (commits2.isEmpty()) {
                throw e;
            }
            LOG.warn("Error during loading details, returning partially loaded commits\n", (Throwable)e);
        }
        ArrayList arrayList = commits2;
        if (arrayList == null) {
            GitLogUtil.$$$reportNull$$$0(42);
        }
        return arrayList;
    }

    public static void readFullDetails(@NotNull Project project, @NotNull VirtualFile root, @NotNull Consumer<? super GitCommit> commitConsumer, boolean includeRootChanges, boolean preserverOrder, boolean lowPriorityProcess, String ... parameters) throws VcsException {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(43);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(44);
        }
        if (commitConsumer == null) {
            GitLogUtil.$$$reportNull$$$0(45);
        }
        if (parameters == null) {
            GitLogUtil.$$$reportNull$$$0(46);
        }
        DiffRenameLimit renameLimit = DiffRenameLimit.REGISTRY;
        GitLineHandler handler = GitLogUtil.createGitHandler(project, root, GitLogUtil.createConfigParameters(true, includeRootChanges, renameLimit), lowPriorityProcess);
        GitLogUtil.readFullDetailsFromHandler(project, root, commitConsumer, renameLimit, handler, preserverOrder, parameters);
    }

    private static void readFullDetailsFromHandler(@NotNull Project project, @NotNull VirtualFile root, @NotNull Consumer<? super GitCommit> commitConsumer, @NotNull DiffRenameLimit renameLimit, @NotNull GitLineHandler handler, boolean preserverOrder, String ... parameters) throws VcsException {
        VcsLogObjectsFactory factory;
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(47);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(48);
        }
        if (commitConsumer == null) {
            GitLogUtil.$$$reportNull$$$0(49);
        }
        if (renameLimit == null) {
            GitLogUtil.$$$reportNull$$$0(50);
        }
        if (handler == null) {
            GitLogUtil.$$$reportNull$$$0(51);
        }
        if (parameters == null) {
            GitLogUtil.$$$reportNull$$$0(52);
        }
        if ((factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project)) == null) {
            return;
        }
        Consumer consumer = records -> {
            GitLogRecord firstRecord;
            String[] parents;
            if (commitConsumer == null) {
                GitLogUtil.$$$reportNull$$$0(83);
            }
            if (project == null) {
                GitLogUtil.$$$reportNull$$$0(84);
            }
            if (root == null) {
                GitLogUtil.$$$reportNull$$$0(85);
            }
            if (renameLimit == null) {
                GitLogUtil.$$$reportNull$$$0(86);
            }
            LOG.assertTrue((parents = (firstRecord = (GitLogRecord)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem((List)records))).getParentsHashes()).length == 0 || parents.length == records.size(), (Object)("Not enough records for commit " + firstRecord.getHash() + " expected " + parents.length + " records, but got " + records.size()));
            commitConsumer.consume((Object)GitLogUtil.createCommit(project, root, records, factory, renameLimit));
        };
        GitLogRecordCollector recordCollector = preserverOrder ? new GitLogRecordCollector(project, root, (Consumer<List<GitLogRecord>>)consumer) : new GitLogUnorderedRecordCollector(project, root, (Consumer<List<GitLogRecord>>)consumer);
        GitLogUtil.readRecordsFromHandler(project, root, false, true, recordCollector, handler, parameters);
        recordCollector.finish();
    }

    private static void readRecordsFromHandler(@NotNull Project project, @NotNull VirtualFile root, boolean withRefs, boolean withChanges, @NotNull Consumer<GitLogRecord> converter, @NotNull GitLineHandler handler, String ... parameters) throws VcsException {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(53);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(54);
        }
        if (converter == null) {
            GitLogUtil.$$$reportNull$$$0(55);
        }
        if (handler == null) {
            GitLogUtil.$$$reportNull$$$0(56);
        }
        if (parameters == null) {
            GitLogUtil.$$$reportNull$$$0(57);
        }
        GitLogParser parser = GitLogUtil.createParserForDetails(handler, project, withRefs, withChanges, parameters);
        StopWatch sw = StopWatch.start((String)("loading details in [" + root.getName() + "]"));
        GitLogOutputSplitter handlerListener = new GitLogOutputSplitter(handler, parser, converter);
        Git.getInstance().runCommandWithoutCollectingOutput(handler).throwOnError(new int[0]);
        handlerListener.reportErrors();
        sw.report();
    }

    @NotNull
    private static GitLogParser createParserForDetails(@NotNull GitTextHandler h, @NotNull Project project, boolean withRefs, boolean withChanges, String ... parameters) {
        if (h == null) {
            GitLogUtil.$$$reportNull$$$0(58);
        }
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(59);
        }
        GitLogParser.NameStatus status = withChanges ? GitLogParser.NameStatus.STATUS : GitLogParser.NameStatus.NONE;
        GitLogParser.GitLogOption[] options = new GitLogParser.GitLogOption[]{GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_TIME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY};
        if (withRefs) {
            options = (GitLogParser.GitLogOption[])ArrayUtil.append((Object[])options, (Object)((Object)GitLogParser.GitLogOption.REF_NAMES));
        }
        GitLogParser parser = new GitLogParser(project, status, options);
        h.setStdoutSuppressed(true);
        h.addParameters(parameters);
        h.addParameters(parser.getPretty(), "--encoding=UTF-8");
        if (withRefs) {
            h.addParameters("--decorate=full");
        }
        if (withChanges) {
            h.addParameters("-M", "--name-status", "-m");
        }
        h.endOptions();
        GitLogParser gitLogParser = parser;
        if (gitLogParser == null) {
            GitLogUtil.$$$reportNull$$$0(60);
        }
        return gitLogParser;
    }

    public static void readFullDetailsForHashes(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitVcs vcs, @NotNull Consumer<? super GitCommit> commitConsumer, @NotNull List<String> hashes2, boolean includeRootChanges, boolean lowPriorityProcess, @NotNull DiffRenameLimit renameLimit) throws VcsException {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(61);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(62);
        }
        if (vcs == null) {
            GitLogUtil.$$$reportNull$$$0(63);
        }
        if (commitConsumer == null) {
            GitLogUtil.$$$reportNull$$$0(64);
        }
        if (hashes2 == null) {
            GitLogUtil.$$$reportNull$$$0(65);
        }
        if (renameLimit == null) {
            GitLogUtil.$$$reportNull$$$0(66);
        }
        GitLineHandler handler = GitLogUtil.createGitHandler(project, root, GitLogUtil.createConfigParameters(true, includeRootChanges, renameLimit), lowPriorityProcess);
        GitLogUtil.sendHashesToStdin(vcs, hashes2, handler);
        GitLogUtil.readFullDetailsFromHandler(project, root, commitConsumer, renameLimit, handler, false, GitLogUtil.getNoWalkParameter(vcs), STDIN);
    }

    public static void sendHashesToStdin(@NotNull GitVcs vcs, @NotNull Collection<String> hashes2, @NotNull GitHandler handler) {
        if (vcs == null) {
            GitLogUtil.$$$reportNull$$$0(67);
        }
        if (hashes2 == null) {
            GitLogUtil.$$$reportNull$$$0(68);
        }
        if (handler == null) {
            GitLogUtil.$$$reportNull$$$0(69);
        }
        String separator = GitVersionSpecialty.LF_SEPARATORS_IN_STDIN.existsIn(vcs.getVersion()) ? "\n" : System.lineSeparator();
        handler.setInputProcessor(GitHandlerInputProcessorUtil.writeLines(hashes2, separator, handler.getCharset(), true));
    }

    @NotNull
    public static String getNoWalkParameter(@NotNull GitVcs vcs) {
        if (vcs == null) {
            GitLogUtil.$$$reportNull$$$0(70);
        }
        String string = GitVersionSpecialty.NO_WALK_UNSORTED.existsIn(vcs.getVersion()) ? "--no-walk=unsorted" : "--no-walk";
        if (string == null) {
            GitLogUtil.$$$reportNull$$$0(71);
        }
        return string;
    }

    @NotNull
    public static GitLineHandler createGitHandler(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(72);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(73);
        }
        GitLineHandler gitLineHandler = GitLogUtil.createGitHandler(project, root, Collections.emptyList(), false);
        if (gitLineHandler == null) {
            GitLogUtil.$$$reportNull$$$0(74);
        }
        return gitLineHandler;
    }

    @NotNull
    private static GitLineHandler createGitHandler(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> configParameters, boolean lowPriorityProcess) {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(75);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(76);
        }
        if (configParameters == null) {
            GitLogUtil.$$$reportNull$$$0(77);
        }
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.LOG, configParameters);
        if (lowPriorityProcess) {
            handler.withLowPriority();
        }
        handler.setWithMediator(false);
        GitLineHandler gitLineHandler = handler;
        if (gitLineHandler == null) {
            GitLogUtil.$$$reportNull$$$0(78);
        }
        return gitLineHandler;
    }

    @NotNull
    private static List<String> createConfigParameters(boolean withChanges, boolean includeRootChanges, @NotNull DiffRenameLimit renameLimit) {
        if (renameLimit == null) {
            GitLogUtil.$$$reportNull$$$0(79);
        }
        if (!withChanges) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                GitLogUtil.$$$reportNull$$$0(80);
            }
            return list;
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        switch (renameLimit) {
            case INFINITY: {
                result2.add(GitLogUtil.renameLimit(0));
                break;
            }
            case REGISTRY: {
                result2.add(GitLogUtil.renameLimit(Registry.intValue((String)"git.diff.renameLimit")));
                break;
            }
        }
        if (!includeRootChanges) {
            result2.add("log.showRoot=false");
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            GitLogUtil.$$$reportNull$$$0(81);
        }
        return arrayList;
    }

    @NotNull
    private static String renameLimit(int limit) {
        String string = "diff.renameLimit=" + limit;
        if (string == null) {
            GitLogUtil.$$$reportNull$$$0(82);
        }
        return string;
    }

    private static /* synthetic */ VcsCommitMetadata lambda$collectMetadata$4(@NotNull Project project, @NotNull VirtualFile root, VcsLogObjectsFactory factory, Set refs, GitLogRecord record) {
        if (project == null) {
            GitLogUtil.$$$reportNull$$$0(89);
        }
        if (root == null) {
            GitLogUtil.$$$reportNull$$$0(90);
        }
        GitCommit commit2 = GitLogUtil.createCommit(project, root, Collections.singletonList(record), factory);
        Collection<VcsRef> refsInRecord = GitLogUtil.parseRefs(record.getRefs(), commit2.getId(), factory, root);
        for (VcsRef ref : refsInRecord) {
            if (refs.add(ref)) continue;
            VcsRef otherRef = (VcsRef)ContainerUtil.find((Iterable)refs, r -> GitLogProvider.DONT_CONSIDER_SHA.equals(r, (Object)ref));
            LOG.error("Adding duplicate element " + ref + " to the set containing " + otherRef);
        }
        return commit2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 16: 
            case 19: 
            case 20: 
            case 24: 
            case 30: 
            case 36: 
            case 39: 
            case 42: 
            case 60: 
            case 71: 
            case 74: 
            case 78: 
            case 80: 
            case 81: 
            case 82: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 16: 
            case 19: 
            case 20: 
            case 24: 
            case 30: 
            case 36: 
            case 39: 
            case 42: 
            case 60: 
            case 71: 
            case 74: 
            case 78: 
            case 80: 
            case 81: 
            case 82: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 63: 
            case 67: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 2: 
            case 7: 
            case 15: 
            case 18: 
            case 22: 
            case 27: 
            case 32: 
            case 41: 
            case 44: 
            case 48: 
            case 54: 
            case 62: 
            case 73: 
            case 76: 
            case 85: 
            case 90: 
            case 93: 
            case 95: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: 
            case 65: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashes";
                break;
            }
            case 4: 
            case 5: 
            case 16: 
            case 19: 
            case 20: 
            case 24: 
            case 30: 
            case 36: 
            case 39: 
            case 42: 
            case 60: 
            case 71: 
            case 74: 
            case 78: 
            case 80: 
            case 81: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/history/GitLogUtil";
                break;
            }
            case 8: 
            case 46: 
            case 52: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 9: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userConsumer";
                break;
            }
            case 10: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refConsumer";
                break;
            }
            case 11: 
            case 45: 
            case 49: 
            case 64: 
            case 83: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitConsumer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 13: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 14: 
            case 29: 
            case 34: 
            case 37: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 23: 
            case 55: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 28: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "records";
                break;
            }
            case 35: 
            case 50: 
            case 66: 
            case 79: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renameLimit";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "record";
                break;
            }
            case 51: 
            case 56: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "h";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/history/GitLogUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectShortDetails";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRefs";
                break;
            }
            case 19: 
            case 20: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "collectMetadata";
                break;
            }
            case 30: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommit";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentHashes";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFullDetails";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "createParserForDetails";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "getNoWalkParameter";
                break;
            }
            case 74: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "createGitHandler";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigParameters";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "renameLimit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectShortDetails";
                break;
            }
            case 4: 
            case 5: 
            case 16: 
            case 19: 
            case 20: 
            case 24: 
            case 30: 
            case 36: 
            case 39: 
            case 42: 
            case 60: 
            case 71: 
            case 74: 
            case 78: 
            case 80: 
            case 81: 
            case 82: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readTimedCommits";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseRefs";
                break;
            }
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "collectMetadata";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getObjectsFactoryWithDisposeCheck";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createCommit";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getParentHashes";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "collectFullDetails";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "readFullDetails";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "readFullDetailsFromHandler";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "readRecordsFromHandler";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "createParserForDetails";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "readFullDetailsForHashes";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "sendHashesToStdin";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getNoWalkParameter";
                break;
            }
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "createGitHandler";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "createConfigParameters";
                break;
            }
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "lambda$readFullDetailsFromHandler$7";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getObjectsFactoryWithDisposeCheck$6";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectMetadata$5";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectMetadata$4";
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "lambda$parseRefs$2";
                break;
            }
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "lambda$readTimedCommits$1";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectShortDetails$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 16: 
            case 19: 
            case 20: 
            case 24: 
            case 30: 
            case 36: 
            case 39: 
            case 42: 
            case 60: 
            case 71: 
            case 74: 
            case 78: 
            case 80: 
            case 81: 
            case 82: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum DiffRenameLimit {
        INFINITY,
        REGISTRY,
        GIT_CONFIG;

    }
}

