/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.descriptor;

import com.google.common.base.Joiner;
import com.intellij.lang.documentation.DocumentationUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.descriptor.BrowserVersion;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.descriptor.CssElementDescriptor;
import com.intellij.psi.css.impl.descriptor.CssCommonDescriptorData;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CssElementDescriptorBase
implements CssElementDescriptor {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ").skipNulls();
    @NotNull
    private final CssCommonDescriptorData myCommonData;

    protected CssElementDescriptorBase(@NotNull CssCommonDescriptorData commonDescriptorData) {
        if (commonDescriptorData == null) {
            CssElementDescriptorBase.$$$reportNull$$$0(0);
        }
        this.myCommonData = commonDescriptorData;
    }

    @NotNull
    public CssElementDescriptor.CssVersion getCssVersion() {
        CssElementDescriptor.CssVersion cssVersion = this.myCommonData.cssVersion;
        if (cssVersion == null) {
            CssElementDescriptorBase.$$$reportNull$$$0(1);
        }
        return cssVersion;
    }

    @NotNull
    public CssContextType[] getAllowedContextTypes() {
        if (this.myCommonData.allowedInRules == null) {
            CssElementDescriptorBase.$$$reportNull$$$0(2);
        }
        return this.myCommonData.allowedInRules;
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @NotNull
    public String getId() {
        String string = this.myCommonData.id;
        if (string == null) {
            CssElementDescriptorBase.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.myCommonData.presentableName;
        if (string == null) {
            CssElementDescriptorBase.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public BrowserVersion[] getBrowsers() {
        if (this.myCommonData.browsers == null) {
            CssElementDescriptorBase.$$$reportNull$$$0(5);
        }
        return this.myCommonData.browsers;
    }

    @Nullable
    public String getSpecificationUrl() {
        return this.myCommonData.specificationUrl;
    }

    @NotNull
    public String getDescription() {
        String string = this.myCommonData.description;
        if (string == null) {
            CssElementDescriptorBase.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getElementTypeName() {
        String string = CssBundle.message((String)"css.element", (Object[])new Object[0]);
        if (string == null) {
            CssElementDescriptorBase.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean isAllowedInContextType(@NotNull CssContextType contextType) {
        if (contextType == null) {
            CssElementDescriptorBase.$$$reportNull$$$0(8);
        }
        if (contextType == CssContextType.ANY || contextType == CssContextType.UNKNOWN) {
            return true;
        }
        for (CssContextType rule : this.myCommonData.allowedInRules) {
            if (rule != contextType && (!contextType.isSubsetOfAny() || rule != CssContextType.ANY)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public String getDocumentationString(@Nullable PsiElement context) {
        StringBuilder builder = new StringBuilder();
        DocumentationUtil.formatEntityName((String)this.getElementTypeName(), (String)this.getPresentableName(), (StringBuilder)builder);
        this.fillWithAttributesDescription(builder);
        String description = this.getDescription();
        if (!description.isEmpty()) {
            builder.append("<br/>").append(description);
        }
        return builder.toString();
    }

    protected void fillWithAttributesDescription(@NotNull StringBuilder builder) {
        if (builder == null) {
            CssElementDescriptorBase.$$$reportNull$$$0(9);
        }
        this.fillSpecificationString(builder).append("<br/>");
        builder.append("Allowed in: ").append(COMMA_JOINER.join((Object[])this.myCommonData.allowedInRules)).append("<br/>");
        if (this.myCommonData.browsers.length > 0) {
            builder.append("Supported browsers: ").append(COMMA_JOINER.join((Object[])this.myCommonData.browsers)).append("<br/>");
        }
    }

    private StringBuilder fillSpecificationString(StringBuilder builder) {
        CssElementDescriptor.CssVersion cssVersion = this.getCssVersion();
        if (cssVersion == CssElementDescriptor.CssVersion.UNKNOWN && this.myCommonData.specificationUrl == null) {
            return builder;
        }
        builder.append("Specification: ");
        if (this.myCommonData.specificationUrl != null) {
            String linkName = cssVersion == CssElementDescriptor.CssVersion.UNKNOWN ? "link" : cssVersion.getPresentableName();
            builder.append("<a href=\"").append(this.myCommonData.specificationUrl).append("\">").append(linkName).append("</a>");
        } else {
            builder.append(cssVersion.getPresentableName());
        }
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CssElementDescriptorBase)) {
            return false;
        }
        CssElementDescriptorBase base = (CssElementDescriptorBase)o;
        return this.myCommonData.equals(base.myCommonData);
    }

    public int hashCode() {
        return this.myCommonData.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonDescriptorData";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/descriptor/CssElementDescriptorBase";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/descriptor/CssElementDescriptorBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCssVersion";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllowedContextTypes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrowsers";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementTypeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAllowedInContextType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fillWithAttributesDescription";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

