// Copyright 2000-2018 JetBrains s.r.o.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.psi.resolve;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import org.jetbrains.annotations.ApiStatus;

import java.util.Collection;

/**
 * Extension point will be called during global resolve for Class, Function and Constant references. 
 * @since 2017.3
 * EXPERIMENTAL - this particular EP may change significantly during next 3-6 months as we what chan be achieved/problems we run in
 */
@ApiStatus.Experimental
public interface PhpReferenceResolver2 {

  ExtensionPointName<PhpReferenceResolver2> EP_NAME = ExtensionPointName.create("com.jetbrains.php.referenceResolver2");

  /**
   * Called in case if reference multi resolved (candidates.size>1) 
   * @param reference original reference - always check exact ref type - eg instanceof PhpClass
   * @param candidates targets to choose from - may be empty
   * @return filtered candidates (most beneficially leave one, so we have direct jump, or add variant for unresolved code)
   */
  Collection<? extends PhpNamedElement> resolve(PhpReference reference, Collection<? extends PhpNamedElement> candidates);
}
