/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.spi.search.SearchFilterDefinition;
import org.netbeans.spi.search.SearchInfoDefinition;
import org.netbeans.spi.search.impl.CompoundSearchInfoDefinition;
import org.netbeans.spi.search.impl.FlatSearchInfoDefinition;
import org.netbeans.spi.search.impl.SharabilityFilter;
import org.netbeans.spi.search.impl.SimpleSearchInfoDefinition;
import org.netbeans.spi.search.impl.SubnodesSearchInfoDefinition;
import org.netbeans.spi.search.impl.VisibilityFilter;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Children;
import org.openide.util.Parameters;

public final class SearchInfoDefinitionFactory {
    public static final SearchFilterDefinition SHARABILITY_FILTER = SharabilityFilter.getInstance();
    public static final SearchFilterDefinition VISIBILITY_FILTER = VisibilityFilter.getInstance();
    private static final SearchFilterDefinition[] DEFAULT_FILTERS = new SearchFilterDefinition[]{SHARABILITY_FILTER, VISIBILITY_FILTER};
    public static final List<SearchFilterDefinition> DEFAULT_FILTER_DEFS = SearchInfoDefinitionFactory.createDefaultFilterDefList();

    private SearchInfoDefinitionFactory() {
    }

    @NonNull
    public static SearchInfoDefinition createSearchInfo(@NonNull FileObject fileObject, @NonNull SearchFilterDefinition[] searchFilterDefinitionArray) {
        Parameters.notNull((CharSequence)"root", (Object)fileObject);
        return new SimpleSearchInfoDefinition(fileObject, searchFilterDefinitionArray);
    }

    @NonNull
    public static SearchInfoDefinition createFlatSearchInfo(@NonNull FileObject fileObject, @NonNull SearchFilterDefinition[] searchFilterDefinitionArray) {
        Parameters.notNull((CharSequence)"root", (Object)fileObject);
        return new FlatSearchInfoDefinition(fileObject, searchFilterDefinitionArray);
    }

    @NonNull
    public static SearchInfoDefinition createFlatSearchInfo(@NonNull FileObject fileObject) {
        return SearchInfoDefinitionFactory.createFlatSearchInfo(fileObject, DEFAULT_FILTERS);
    }

    @NonNull
    public static SearchInfoDefinition createSearchInfo(@NonNull FileObject fileObject) {
        return SearchInfoDefinitionFactory.createSearchInfo(fileObject, DEFAULT_FILTERS);
    }

    @NonNull
    public static SearchInfoDefinition createSearchInfo(@NonNull FileObject[] fileObjectArray, @NonNull SearchFilterDefinition[] searchFilterDefinitionArray) {
        Parameters.notNull((CharSequence)"roots", (Object)fileObjectArray);
        if (fileObjectArray.length == 0) {
            return SimpleSearchInfoDefinition.EMPTY_SEARCH_INFO;
        }
        if (fileObjectArray.length == 1) {
            return SearchInfoDefinitionFactory.createSearchInfo(fileObjectArray[0], searchFilterDefinitionArray);
        }
        SearchInfoDefinition[] searchInfoDefinitionArray = new SearchInfoDefinition[fileObjectArray.length];
        for (int i = 0; i < fileObjectArray.length; ++i) {
            searchInfoDefinitionArray[i] = SearchInfoDefinitionFactory.createSearchInfo(fileObjectArray[i], searchFilterDefinitionArray);
        }
        return new CompoundSearchInfoDefinition(searchInfoDefinitionArray);
    }

    @NonNull
    public static SearchInfoDefinition createSearchInfo(@NonNull FileObject[] fileObjectArray) {
        return SearchInfoDefinitionFactory.createSearchInfo(fileObjectArray, DEFAULT_FILTERS);
    }

    @NonNull
    public static SearchInfoDefinition createSearchInfoBySubnodes(@NonNull Children children) {
        Parameters.notNull((CharSequence)"children", (Object)children);
        return new SubnodesSearchInfoDefinition(children);
    }

    private static List<SearchFilterDefinition> createDefaultFilterDefList() {
        ArrayList<SearchFilterDefinition> arrayList = new ArrayList<SearchFilterDefinition>(2);
        arrayList.add(SHARABILITY_FILTER);
        arrayList.add(VISIBILITY_FILTER);
        return Collections.unmodifiableList(arrayList);
    }
}

