/* -*- Mode: C; c-file-style: "gnu" -*-
   alloc.h -- our own version of *alloc() and strdup() with exceptions
   Created: Petter Reinholdtsen <pere@td.org.uit.no>, 1998-07-16
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _alloc_h
#define _alloc_h

#ifdef __cplusplus
extern "C" {
#endif

#include "jni.h"

  /*
   * These are wrappers for the native methods.  They throw exception on
   * allocation error.
   */
  void *jmalloc(JNIEnv *env, size_t size);
  void *jcalloc(JNIEnv *env, size_t nmemb, size_t size);
  void jfree(JNIEnv *env, void *ptr);
  void *jrealloc(JNIEnv *env, void *ptr, size_t size);

  char *jstrdup(JNIEnv *env, const char *str);

#ifdef __cplusplus
};
#endif

#endif /* _alloc_h */





