/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.IndexExpression;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.filter.ExtendedFilter;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.FBUtilities;

public abstract class SecondaryIndexSearcher {
    protected final SecondaryIndexManager indexManager;
    protected final Set<ByteBuffer> columns;
    protected final ColumnFamilyStore baseCfs;

    public SecondaryIndexSearcher(SecondaryIndexManager indexManager, Set<ByteBuffer> columns) {
        this.indexManager = indexManager;
        this.columns = columns;
        this.baseCfs = indexManager.baseCfs;
    }

    public SecondaryIndex highestSelectivityIndex(List<IndexExpression> clause) {
        IndexExpression expr = this.highestSelectivityPredicate(clause, false);
        return expr == null ? null : this.indexManager.getIndexForColumn(expr.column);
    }

    public abstract List<Row> search(ExtendedFilter var1);

    public boolean canHandleIndexClause(List<IndexExpression> clause) {
        for (IndexExpression expression : clause) {
            SecondaryIndex index;
            if (!this.columns.contains(expression.column) || (index = this.indexManager.getIndexForColumn(expression.column)) == null || index.getIndexCfs() == null || !index.supportsOperator(expression.operator)) continue;
            return true;
        }
        return false;
    }

    public void validate(IndexExpression indexExpression) throws InvalidRequestException {
    }

    protected IndexExpression highestSelectivityPredicate(List<IndexExpression> clause, boolean includeInTrace) {
        IndexExpression best = null;
        int bestMeanCount = Integer.MAX_VALUE;
        HashMap<SecondaryIndex, Integer> candidates = new HashMap<SecondaryIndex, Integer>();
        for (IndexExpression expression : clause) {
            SecondaryIndex index;
            if (!this.columns.contains(expression.column) || (index = this.indexManager.getIndexForColumn(expression.column)) == null || index.getIndexCfs() == null || !index.supportsOperator(expression.operator)) continue;
            int columns = index.getIndexCfs().getMeanColumns();
            candidates.put(index, columns);
            if (columns >= bestMeanCount) continue;
            best = expression;
            bestMeanCount = columns;
        }
        if (includeInTrace) {
            if (best == null) {
                Tracing.trace("No applicable indexes found");
            } else if (Tracing.isTracing()) {
                Tracing.trace("Candidate index mean cardinalities are {}. Scanning with {}.", (Object)FBUtilities.toString(candidates), (Object)this.indexManager.getIndexForColumn(best.column).getIndexName());
            }
        }
        return best;
    }

    public boolean requiresScanningAllRanges(List<IndexExpression> clause) {
        return false;
    }

    public List<Row> postReconciliationProcessing(List<IndexExpression> clause, List<Row> rows) {
        return rows;
    }
}

