/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress;

import com.google.common.util.concurrent.RateLimiter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.stress.WorkManager;
import org.apache.cassandra.stress.generate.Distribution;
import org.apache.cassandra.stress.generate.PartitionGenerator;
import org.apache.cassandra.stress.generate.PartitionIterator;
import org.apache.cassandra.stress.generate.RatioDistribution;
import org.apache.cassandra.stress.generate.Seed;
import org.apache.cassandra.stress.generate.SeedManager;
import org.apache.cassandra.stress.settings.SettingsLog;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.stress.util.JavaDriverClient;
import org.apache.cassandra.stress.util.ThriftClient;
import org.apache.cassandra.stress.util.Timer;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.transport.SimpleClient;

public abstract class Operation {
    public final StressSettings settings;
    public final Timer timer;
    protected final DataSpec spec;
    private final List<PartitionIterator> partitionCache = new ArrayList<PartitionIterator>();
    protected List<PartitionIterator> partitions;

    public Operation(Timer timer, StressSettings settings, DataSpec spec) {
        this.timer = timer;
        this.settings = settings;
        this.spec = spec;
    }

    boolean ready(WorkManager permits, RateLimiter rateLimiter) {
        int i;
        int partitionCount = (int)this.spec.partitionCount.next();
        if (partitionCount <= 0) {
            return false;
        }
        if ((partitionCount = permits.takePermits(partitionCount)) <= 0) {
            return false;
        }
        boolean success = true;
        for (i = 0; i < partitionCount && success; ++i) {
            Seed seed;
            if (i >= this.partitionCache.size()) {
                this.partitionCache.add(PartitionIterator.get(this.spec.partitionGenerator, this.spec.seedManager));
            }
            success = false;
            while (!success && (seed = this.spec.seedManager.next(this)) != null) {
                success = this.reset(seed, this.partitionCache.get(i));
            }
        }
        partitionCount = i;
        if (rateLimiter != null) {
            rateLimiter.acquire(partitionCount);
        }
        this.partitions = this.partitionCache.subList(0, partitionCount);
        return !this.partitions.isEmpty();
    }

    protected boolean reset(Seed seed, PartitionIterator iterator) {
        if (this.spec.useRatio == null) {
            return iterator.reset(seed, this.spec.targetCount, this.isWrite());
        }
        return iterator.reset(seed, this.spec.useRatio.next(), this.isWrite());
    }

    public boolean isWrite() {
        return false;
    }

    public abstract void run(ThriftClient var1) throws IOException;

    public void run(SimpleClient client) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void run(JavaDriverClient client) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void timeWithRetry(RunOp run) throws IOException {
        int tries;
        this.timer.start();
        boolean success = false;
        String exceptionMessage = null;
        for (tries = 0; tries < this.settings.errors.tries; ++tries) {
            try {
                success = run.run();
                break;
            }
            catch (Exception e) {
                switch (this.settings.log.level) {
                    case MINIMAL: {
                        break;
                    }
                    case NORMAL: {
                        System.err.println(e);
                        break;
                    }
                    case VERBOSE: {
                        e.printStackTrace(System.err);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                exceptionMessage = this.getExceptionMessage(e);
                continue;
            }
        }
        this.timer.stop(run.partitionCount(), run.rowCount(), !success);
        if (!success) {
            this.error(String.format("Operation x%d on key(s) %s: %s%n", tries, this.key(), exceptionMessage == null ? "Data returned was not validated" : "Error executing: " + exceptionMessage));
        }
    }

    private String key() {
        ArrayList<String> keys = new ArrayList<String>();
        for (PartitionIterator partition : this.partitions) {
            keys.add(partition.getKeyAsString());
        }
        return ((Object)keys).toString();
    }

    protected String getExceptionMessage(Exception e) {
        String className = e.getClass().getSimpleName();
        String message = e instanceof InvalidRequestException ? ((InvalidRequestException)e).getWhy() : e.getMessage();
        return message == null ? "(" + className + ")" : String.format("(%s): %s", className, message);
    }

    protected void error(String message) throws IOException {
        if (!this.settings.errors.ignore) {
            throw new IOException(message);
        }
        if (this.settings.log.level.compareTo(SettingsLog.Level.MINIMAL) > 0) {
            System.err.println(message);
        }
    }

    public static interface RunOp {
        public boolean run() throws Exception;

        public int partitionCount();

        public int rowCount();
    }

    public static final class DataSpec {
        public final PartitionGenerator partitionGenerator;
        final SeedManager seedManager;
        final Distribution partitionCount;
        final RatioDistribution useRatio;
        final Integer targetCount;

        public DataSpec(PartitionGenerator partitionGenerator, SeedManager seedManager, Distribution partitionCount, Integer targetCount) {
            this(partitionGenerator, seedManager, partitionCount, null, targetCount);
        }

        public DataSpec(PartitionGenerator partitionGenerator, SeedManager seedManager, Distribution partitionCount, RatioDistribution useRatio) {
            this(partitionGenerator, seedManager, partitionCount, useRatio, null);
        }

        private DataSpec(PartitionGenerator partitionGenerator, SeedManager seedManager, Distribution partitionCount, RatioDistribution useRatio, Integer targetCount) {
            this.partitionGenerator = partitionGenerator;
            this.seedManager = seedManager;
            this.partitionCount = partitionCount;
            this.useRatio = useRatio;
            this.targetCount = targetCount;
        }
    }
}

