/*
 * Decompiled with CFR 0.152.
 */
package com.gokgs.client.swing;

import com.gokgs.client.KCProposal;
import com.gokgs.client.swing.LitRulesWidget;
import com.gokgs.shared.KGameType;
import com.gokgs.shared.KProposal;
import com.gokgs.shared.KRole;
import java.awt.GridLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.igoweb.go.Rules;
import org.igoweb.go.swing.StoneIcon;
import org.igoweb.igoweb.client.CChallenge;
import org.igoweb.igoweb.client.Client;
import org.igoweb.igoweb.client.swing.ChallengePlayer;
import org.igoweb.igoweb.shared.GameAction;
import org.igoweb.igoweb.shared.GameType;
import org.igoweb.igoweb.shared.Proposal;
import org.igoweb.igoweb.shared.Role;
import org.igoweb.igoweb.shared.User;
import org.igoweb.util.Defs;
import org.igoweb.util.EventListener;
import org.igoweb.util.swing.LabelPair;

public class KChallengePlayer
extends ChallengePlayer<KProposal.KUserRole<User>, KCProposal> {
    private static final Proposal<?, ?, ?> dummy = null;
    private LitRulesWidget extraRules;

    public KChallengePlayer(Client client, EventListener listener, boolean isCreator, KCProposal proposal, int playerNum, CChallenge<KCProposal> chal) {
        super(client, listener, isCreator, proposal, playerNum, chal);
    }

    @Override
    protected Icon buildIcon(KCProposal rawProposal, boolean isLeft) {
        KCProposal proposal = rawProposal;
        Role role = ((KProposal.KUserRole)proposal.getUserRole(this.playerNum)).getRole();
        int iconType = role == KRole.OWNER ? (isLeft ? 1 : 0) : (role == KRole.WHITE || role == KRole.WHITE_2 ? 1 : 0);
        if (proposal.isUseNigiri()) {
            StoneIcon icon = new StoneIcon(1, this.playerNum * 2 + (isLeft ? 1 : 0), 2, "?", 2.0);
            icon.setNigiri(true);
            return icon;
        }
        return new StoneIcon(iconType, this.playerNum * 2 + (isLeft ? 1 : 0), 0, null, 2.0);
    }

    @Override
    protected boolean isRoleFixed(KCProposal proposal) {
        GameType gt = proposal.getGameType();
        return gt == KGameType.SIMUL || gt == KGameType.DEMONSTRATION || !this.isCreator && this.getChallenge().getAction() != null;
    }

    @Override
    protected boolean isPlayerFixed() {
        return this.playerNum == 0 || !this.isCreator && this.getChallenge().getAction() != null;
    }

    @Override
    protected JComponent buildExtraWidget(KCProposal proposal) {
        if (proposal.getGameType() != KGameType.SIMUL || this.playerNum == 0) {
            return null;
        }
        JPanel panel = new JPanel(new GridLayout(1, 2));
        this.extraRules = new LitRulesWidget(new Rules(), true);
        LabelPair.Group group = new LabelPair.Group();
        panel.add(new LabelPair(Defs.getString(-809883776), this.extraRules.getWidget(2), group));
        panel.add(new LabelPair(Defs.getString(-809883775), this.extraRules.getWidget(3), group));
        return panel;
    }

    @Override
    protected boolean isRoleLit(KCProposal rawExpected, KCProposal rawFound) {
        KCProposal expected = rawExpected;
        KCProposal found = rawFound;
        return expected != null && expected.isUseNigiri() != found.isUseNigiri() || super.isRoleLit(expected, found);
    }

    @Override
    public void updateGui(KCProposal proposal, GameAction action, boolean isCurrent) {
        super.updateGui(proposal, action, isCurrent);
        KProposal.KUserRole userRole = (KProposal.KUserRole)proposal.getUserRole(this.playerNum);
        if (this.extraRules != null) {
            Rules rules = this.extraRules.getRules();
            rules.setHandicap(userRole.getHandicap());
            rules.setKomi(userRole.getKomi());
            this.extraRules.setRules(rules);
            this.extraRules.setHcapEditable(this.getUser() != null && (action == GameAction.CHALLENGE_SETUP || action == GameAction.CHALLENGE_ACCEPT && this.isCreator || action == null));
        }
    }

    @Override
    public void highlightChanges(KCProposal rawExpected, KCProposal rawProposal) {
        KCProposal expected = rawExpected;
        KCProposal proposal = rawProposal;
        if (this.playerNum >= proposal.getUserRoles().size()) {
            return;
        }
        super.highlightChanges(expected, proposal);
        if (this.extraRules == null) {
            return;
        }
        if (expected != null) {
            for (int i = 0; i < expected.getUserRoles().size(); ++i) {
                KProposal.KUserRole expectedUserRole = (KProposal.KUserRole)expected.getUserRole(i);
                if (expectedUserRole.getUser() != this.getUser()) continue;
                Rules expectedRules = new Rules(expected.getRules());
                expectedRules.setHandicap(expectedUserRole.getHandicap());
                expectedRules.setKomi(expectedUserRole.getKomi());
                KProposal.KUserRole userRole = (KProposal.KUserRole)proposal.getUserRole(this.playerNum);
                this.extraRules.getRules().setHandicap(userRole.getHandicap());
                this.extraRules.getRules().setKomi(userRole.getKomi());
                this.extraRules.highlightChanges(expectedRules);
                return;
            }
        }
        this.extraRules.highlightChanges(null);
    }

    @Override
    public boolean isPlayerValid() {
        return super.isPlayerValid() && (this.extraRules == null || this.extraRules.verifyInput());
    }

    @Override
    public void read(KCProposal rawProposal) {
        KCProposal proposal = rawProposal;
        super.read(proposal);
        KProposal.KUserRole userRole = (KProposal.KUserRole)proposal.getUserRole(this.playerNum);
        if (this.extraRules == null) {
            userRole.setHandicap(0);
            userRole.setKomi(0.0f);
        } else {
            Rules rules = this.extraRules.getRules();
            userRole.setHandicap(rules.getHandicap());
            userRole.setKomi(rules.getKomi());
        }
    }

    @Override
    protected boolean isRoleEnabled(KCProposal rawProp, GameAction action) {
        KCProposal prop = rawProp;
        GameType gt = prop.getGameType();
        if (gt == KGameType.SIMUL || gt == KGameType.DEMONSTRATION) {
            return false;
        }
        if (gt == KGameType.RENGO) {
            return super.isRoleEnabled(prop, action);
        }
        return this.isCreator ? ((KProposal.KUserRole)prop.getUserRole(true)).getUser() != null && super.isRoleEnabled(prop, action) : action == null;
    }

    public boolean isSimul() {
        return this.extraRules != null;
    }
}

