/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.policy.parser.processors;

import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.policy.PrimitiveAssertion;
import org.apache.ws.security.policy.model.Header;
import org.apache.ws.security.policy.model.PolicyEngineData;
import org.apache.ws.security.policy.model.SignedEncryptedElements;
import org.apache.ws.security.policy.model.SignedEncryptedParts;
import org.apache.ws.security.policy.model.SupportingToken;
import org.apache.ws.security.policy.parser.SecurityPolicy;
import org.apache.ws.security.policy.parser.SecurityPolicyToken;
import org.apache.ws.security.policy.parser.SecurityProcessorContext;

public class SignedPartsElementsProcessor {
    private Log log = LogFactory.getLog(this.getClass());
    private boolean initializedSignedParts = false;
    private boolean initializedSignedElements = false;

    private void initializeSignedParts(SecurityPolicyToken spt) throws NoSuchMethodException {
        SecurityPolicyToken tmpSpt = SecurityPolicy.body.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.header.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
    }

    private void initializeSignedElements(SecurityPolicyToken spt) throws NoSuchMethodException {
        SecurityPolicyToken tmpSpt = SecurityPolicy.xPath.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
    }

    public Object doSignedParts(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        SecurityPolicyToken spt = spc.readCurrentSecurityToken();
        switch (spc.getAction()) {
            case 1: {
                if (!this.initializedSignedParts) {
                    try {
                        this.initializeSignedParts(spt);
                        SignedEncryptedParts parts = (SignedEncryptedParts)spc.readCurrentPolicyEngineData();
                        PolicyEngineData parent = spc.readPreviousPolicyEngineData();
                        if (parent instanceof SupportingToken) {
                            ((SupportingToken)parent).setSignedParts(parts);
                        }
                        this.initializedSignedParts = true;
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                        return new Boolean(false);
                    }
                }
                this.log.debug((Object)spt.getTokenName());
                PrimitiveAssertion pa = spc.getAssertion();
                String text = pa.getStrValue();
                if (text != null) {
                    text = text.trim();
                    this.log.debug((Object)("Value: '" + text.toString() + "'"));
                }
            }
            case 2: {
                break;
            }
        }
        return new Boolean(true);
    }

    public Object doSignedElements(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        SecurityPolicyToken spt = spc.readCurrentSecurityToken();
        switch (spc.getAction()) {
            case 1: {
                if (!this.initializedSignedElements) {
                    try {
                        this.initializeSignedElements(spt);
                        SignedEncryptedElements elements = (SignedEncryptedElements)spc.readCurrentPolicyEngineData();
                        PolicyEngineData parent = spc.readPreviousPolicyEngineData();
                        if (parent instanceof SupportingToken) {
                            ((SupportingToken)parent).setSignedElements(elements);
                        }
                        this.initializedSignedElements = true;
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                        return new Boolean(false);
                    }
                }
                this.log.debug((Object)spt.getTokenName());
                PrimitiveAssertion pa = spc.getAssertion();
                String text = pa.getStrValue();
                if (text != null) {
                    text = text.trim();
                    this.log.debug((Object)("Value: '" + text.toString() + "'"));
                }
            }
            case 2: {
                break;
            }
        }
        return new Boolean(true);
    }

    public Object doBody(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        if (spc.getAction() == 1) {
            ((SignedEncryptedParts)spc.readCurrentPolicyEngineData()).setBody(true);
        }
        return new Boolean(true);
    }

    public Object doHeader(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        if (spc.getAction() == 1) {
            Header header = new Header();
            header.setName(spc.getAssertion().getAttribute(new QName("Name")));
            header.setNamespace(spc.getAssertion().getAttribute(new QName("Namespace")));
            ((SignedEncryptedParts)spc.readCurrentPolicyEngineData()).addHeader(header);
        }
        return new Boolean(true);
    }

    public Object doXPath(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        if (spc.getAction() == 1) {
            ((SignedEncryptedElements)spc.readCurrentPolicyEngineData()).addXPathExpression(spc.getAssertion().getStrValue());
        }
        return new Boolean(true);
    }
}

