/*
 * Decompiled with CFR 0.152.
 */
package jmapps.jmstudio;

import com.sun.media.ui.AudioFormatChooser;
import com.sun.media.ui.VideoFormatChooser;
import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.DataSource;
import jmapps.ui.JMDialog;
import jmapps.ui.JMPanel;
import jmapps.util.JMAppsCfg;
import jmapps.util.JMFUtils;

public class CaptureDialog
extends JMDialog
implements ItemListener {
    private JMAppsCfg cfgJMApps;
    private Vector vectorDevices = null;
    private Vector vectorAudioDevices = null;
    private Vector vectorVideoDevices = null;
    private Panel panelDevices;
    private Checkbox checkUseVideo = null;
    private Checkbox checkUseAudio = null;
    private Choice comboVideoDevice = null;
    private Choice comboAudioDevice = null;
    private Panel panelVideoFormat = null;
    private Panel panelAudioFormat = null;
    private AudioFormatChooser chooserAudio = null;
    private VideoFormatChooser chooserVideo = null;
    private Button buttonOK;
    private Button buttonCancel;

    public CaptureDialog(Frame parentFrame, JMAppsCfg cfgJMApps) {
        super(parentFrame, JMFI18N.getResource("jmstudio.capture.title"), true);
        this.cfgJMApps = cfgJMApps;
        try {
            this.init();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public boolean isVideoDeviceUsed() {
        boolean boolUsed = false;
        if (this.checkUseVideo != null) {
            boolUsed = this.checkUseVideo.getState();
        }
        return boolUsed;
    }

    public boolean isAudioDeviceUsed() {
        boolean boolUsed = false;
        if (this.checkUseAudio != null) {
            boolUsed = this.checkUseAudio.getState();
        }
        return boolUsed;
    }

    public CaptureDeviceInfo getVideoDevice() {
        CaptureDeviceInfo infoCaptureDevice = null;
        if (this.comboVideoDevice != null && this.isVideoDeviceUsed()) {
            int i2 = this.comboVideoDevice.getSelectedIndex();
            infoCaptureDevice = (CaptureDeviceInfo)this.vectorVideoDevices.elementAt(i2);
        }
        return infoCaptureDevice;
    }

    public CaptureDeviceInfo getAudioDevice() {
        CaptureDeviceInfo infoCaptureDevice = null;
        if (this.comboAudioDevice != null && this.isAudioDeviceUsed()) {
            int i2 = this.comboAudioDevice.getSelectedIndex();
            infoCaptureDevice = (CaptureDeviceInfo)this.vectorAudioDevices.elementAt(i2);
        }
        return infoCaptureDevice;
    }

    public VideoFormat getVideoFormat() {
        VideoFormat format = null;
        if (this.chooserVideo != null && this.isVideoDeviceUsed()) {
            format = (VideoFormat)this.chooserVideo.getFormat();
        }
        return format;
    }

    public AudioFormat getAudioFormat() {
        AudioFormat format = null;
        if (this.chooserAudio != null && this.isAudioDeviceUsed()) {
            format = (AudioFormat)this.chooserAudio.getFormat();
        }
        return format;
    }

    public DataSource createCaptureDataSource() {
        DataSource dataSource = null;
        String audioDeviceName = null;
        String videoDeviceName = null;
        CaptureDeviceInfo cdi = this.getAudioDevice();
        if (cdi != null && this.isAudioDeviceUsed()) {
            audioDeviceName = cdi.getName();
        }
        if ((cdi = this.getVideoDevice()) != null && this.isVideoDeviceUsed()) {
            videoDeviceName = cdi.getName();
        }
        dataSource = JMFUtils.createCaptureDataSource(audioDeviceName, this.getAudioFormat(), videoDeviceName, this.getVideoFormat());
        return dataSource;
    }

    private void init() throws Exception {
        Panel panel;
        this.setLayout(new BorderLayout());
        JMPanel panelContent = new JMPanel(new BorderLayout());
        panelContent.setEmptyBorder(6, 6, 6, 6);
        panelContent.setBackground(Color.lightGray);
        this.add((Component)panelContent, "Center");
        this.vectorDevices = CaptureDeviceManager.getDeviceList(null);
        if (this.vectorDevices == null || this.vectorDevices.size() < 1) {
            Label label = new Label(JMFI18N.getResource("jmstudio.capture.nodevices"));
            panelContent.add((Component)label, "Center");
        } else {
            this.panelDevices = new Panel(new GridLayout(1, 0, 6, 6));
            panelContent.add((Component)this.panelDevices, "Center");
            panel = this.createVideoPanel();
            if (panel != null) {
                this.panelDevices.add(panel);
            }
            if ((panel = this.createAudioPanel()) != null) {
                this.panelDevices.add(panel);
            }
        }
        panel = new JMPanel(new FlowLayout(1));
        panelContent.add((Component)panel, "South");
        JMPanel panelButtons = this.vectorDevices != null && this.vectorDevices.size() > 0 ? this.createButtonPanel(new String[]{JMDialog.ACTION_OK, JMDialog.ACTION_CANCEL}) : this.createButtonPanel(new String[]{JMDialog.ACTION_OK});
        panel.add(panelButtons);
        this.pack();
        this.setResizable(false);
    }

    private Panel createVideoPanel() throws Exception {
        CaptureDeviceInfo infoCaptureDevice;
        boolean boolState = true;
        VideoFormat formatDefault = null;
        JMAppsCfg.CaptureDeviceData dataCapture = null;
        int nCount = this.vectorDevices.size();
        this.vectorVideoDevices = new Vector();
        int i2 = 0;
        while (i2 < nCount) {
            infoCaptureDevice = (CaptureDeviceInfo)this.vectorDevices.elementAt(i2);
            Format[] arrFormats = infoCaptureDevice.getFormats();
            int j2 = 0;
            while (j2 < arrFormats.length) {
                if (arrFormats[j2] instanceof VideoFormat) {
                    this.vectorVideoDevices.addElement(infoCaptureDevice);
                    break;
                }
                ++j2;
            }
            ++i2;
        }
        if (this.vectorVideoDevices.isEmpty()) {
            return null;
        }
        if (this.cfgJMApps != null) {
            dataCapture = this.cfgJMApps.getLastCaptureVideoData();
        }
        if (dataCapture != null) {
            boolState = dataCapture.boolUse;
            if (dataCapture.format instanceof VideoFormat) {
                formatDefault = (VideoFormat)dataCapture.format;
            }
        }
        JMPanel panelVideo = new JMPanel(new BorderLayout(6, 6));
        panelVideo.setEtchedBorder();
        JMPanel panelContent = new JMPanel(new BorderLayout(6, 6));
        panelContent.setEmptyBorder(6, 6, 6, 6);
        panelVideo.add((Component)panelContent, "Center");
        Panel panel = panelContent;
        Panel panelTemp = new Panel(new BorderLayout(6, 6));
        panel.add((Component)panelTemp, "North");
        this.checkUseVideo = new Checkbox(JMFI18N.getResource("jmstudio.capture.video.usedevice"), boolState);
        this.checkUseVideo.addItemListener(this);
        panelTemp.add((Component)this.checkUseVideo, "West");
        panelTemp = new Panel(new BorderLayout(6, 6));
        panel.add((Component)panelTemp, "Center");
        panel = panelTemp;
        panelTemp = new Panel(new BorderLayout(6, 6));
        panel.add((Component)panelTemp, "North");
        this.comboVideoDevice = new Choice();
        panelTemp.add((Component)this.comboVideoDevice, "Center");
        nCount = this.vectorVideoDevices.size();
        boolean boolContains = false;
        i2 = 0;
        while (i2 < nCount) {
            infoCaptureDevice = (CaptureDeviceInfo)this.vectorVideoDevices.elementAt(i2);
            String strDeviceName = infoCaptureDevice.getName();
            this.comboVideoDevice.addItem(strDeviceName);
            if (!boolContains && dataCapture != null && dataCapture.strDeviceName != null) {
                boolContains = dataCapture.strDeviceName.equals(strDeviceName);
            }
            ++i2;
        }
        if (boolContains) {
            this.comboVideoDevice.select(dataCapture.strDeviceName);
        }
        this.comboVideoDevice.addItemListener(this);
        this.comboVideoDevice.setEnabled(boolState);
        this.panelVideoFormat = new Panel(new BorderLayout(6, 6));
        panel.add((Component)this.panelVideoFormat, "Center");
        this.createVideoChooser(formatDefault);
        if (this.chooserVideo != null) {
            this.chooserVideo.setEnabled(boolState);
        }
        return panelVideo;
    }

    private void createVideoChooser(VideoFormat formatDefault) {
        if (this.panelVideoFormat == null) {
            return;
        }
        this.panelVideoFormat.removeAll();
        int i2 = this.comboVideoDevice.getSelectedIndex();
        CaptureDeviceInfo infoCaptureDevice = (CaptureDeviceInfo)this.vectorVideoDevices.elementAt(i2);
        Format[] arrFormats = infoCaptureDevice.getFormats();
        this.chooserVideo = new VideoFormatChooser(arrFormats, formatDefault, false, null, true);
        this.panelVideoFormat.add((Component)this.chooserVideo, "Center");
    }

    private Panel createAudioPanel() throws Exception {
        CaptureDeviceInfo infoCaptureDevice;
        boolean boolState = true;
        AudioFormat formatDefault = null;
        JMAppsCfg.CaptureDeviceData dataCapture = null;
        int nCount = this.vectorDevices.size();
        this.vectorAudioDevices = new Vector();
        int i2 = 0;
        while (i2 < nCount) {
            infoCaptureDevice = (CaptureDeviceInfo)this.vectorDevices.elementAt(i2);
            Format[] arrFormats = infoCaptureDevice.getFormats();
            int j2 = 0;
            while (j2 < arrFormats.length) {
                if (arrFormats[j2] instanceof AudioFormat) {
                    this.vectorAudioDevices.addElement(infoCaptureDevice);
                    break;
                }
                ++j2;
            }
            ++i2;
        }
        if (this.vectorAudioDevices.isEmpty()) {
            return null;
        }
        if (this.cfgJMApps != null) {
            dataCapture = this.cfgJMApps.getLastCaptureAudioData();
        }
        if (dataCapture != null) {
            boolState = dataCapture.boolUse;
            if (dataCapture.format instanceof AudioFormat) {
                formatDefault = (AudioFormat)dataCapture.format;
            }
        }
        JMPanel panelAudio = new JMPanel(new BorderLayout(6, 6));
        panelAudio.setEtchedBorder();
        JMPanel panelContent = new JMPanel(new BorderLayout(6, 6));
        panelContent.setEmptyBorder(6, 6, 6, 6);
        panelAudio.add((Component)panelContent, "Center");
        Panel panel = panelContent;
        Panel panelTemp = new Panel(new BorderLayout(6, 6));
        panel.add((Component)panelTemp, "North");
        this.checkUseAudio = new Checkbox(JMFI18N.getResource("jmstudio.capture.audio.usedevice"), boolState);
        this.checkUseAudio.addItemListener(this);
        panelTemp.add((Component)this.checkUseAudio, "West");
        panelTemp = new Panel(new BorderLayout(6, 6));
        panel.add((Component)panelTemp, "Center");
        panel = panelTemp;
        panelTemp = new Panel(new BorderLayout(6, 6));
        panel.add((Component)panelTemp, "North");
        this.comboAudioDevice = new Choice();
        panelTemp.add((Component)this.comboAudioDevice, "Center");
        nCount = this.vectorAudioDevices.size();
        boolean boolContains = false;
        i2 = 0;
        while (i2 < nCount) {
            infoCaptureDevice = (CaptureDeviceInfo)this.vectorAudioDevices.elementAt(i2);
            String strDeviceName = infoCaptureDevice.getName();
            this.comboAudioDevice.addItem(strDeviceName);
            if (!boolContains && dataCapture != null && dataCapture.strDeviceName != null) {
                boolContains = dataCapture.strDeviceName.equals(strDeviceName);
            }
            ++i2;
        }
        if (boolContains) {
            this.comboAudioDevice.select(dataCapture.strDeviceName);
        }
        this.comboAudioDevice.addItemListener(this);
        this.comboAudioDevice.setEnabled(boolState);
        this.panelAudioFormat = new Panel(new BorderLayout(6, 6));
        panel.add((Component)this.panelAudioFormat, "Center");
        this.createAudioChooser(formatDefault);
        if (this.chooserAudio != null) {
            this.chooserAudio.setEnabled(boolState);
        }
        return panelAudio;
    }

    private void createAudioChooser(AudioFormat formatDefault) {
        if (this.panelAudioFormat == null) {
            return;
        }
        this.panelAudioFormat.removeAll();
        int i2 = this.comboAudioDevice.getSelectedIndex();
        CaptureDeviceInfo infoCaptureDevice = (CaptureDeviceInfo)this.vectorAudioDevices.elementAt(i2);
        Format[] arrFormats = infoCaptureDevice.getFormats();
        this.chooserAudio = new AudioFormatChooser(arrFormats, formatDefault, false, null);
        this.panelAudioFormat.add((Component)this.chooserAudio, "Center");
    }

    private void saveCfgData() {
        if (this.cfgJMApps == null) {
            return;
        }
        JMAppsCfg.CaptureDeviceData dataCapture = this.cfgJMApps.createCaptureDeviceDataObject();
        dataCapture.boolUse = this.isAudioDeviceUsed();
        if (this.comboAudioDevice != null) {
            dataCapture.strDeviceName = this.comboAudioDevice.getSelectedItem();
        }
        if (this.chooserAudio != null) {
            dataCapture.format = this.chooserAudio.getFormat();
        }
        this.cfgJMApps.setLastCaptureAudioData(dataCapture);
        dataCapture = this.cfgJMApps.createCaptureDeviceDataObject();
        dataCapture.boolUse = this.isVideoDeviceUsed();
        if (this.comboVideoDevice != null) {
            dataCapture.strDeviceName = this.comboVideoDevice.getSelectedItem();
        }
        if (this.chooserVideo != null) {
            dataCapture.format = this.chooserVideo.getFormat();
        }
        this.cfgJMApps.setLastCaptureVideoData(dataCapture);
    }

    public void actionPerformed(ActionEvent event) {
        String strCmd = event.getActionCommand();
        if (strCmd.equals(JMDialog.ACTION_OK)) {
            this.setAction(JMDialog.ACTION_OK);
            this.saveCfgData();
        } else {
            this.setAction(JMDialog.ACTION_CANCEL);
        }
        this.dispose();
    }

    public void itemStateChanged(ItemEvent event) {
        Object objectSource = event.getSource();
        if (objectSource == this.checkUseVideo) {
            boolean boolEnable = this.checkUseVideo.getState();
            this.comboVideoDevice.setEnabled(boolEnable);
            this.chooserVideo.setEnabled(boolEnable);
        } else if (objectSource == this.checkUseAudio) {
            boolean boolEnable = this.checkUseAudio.getState();
            this.comboAudioDevice.setEnabled(boolEnable);
            this.chooserAudio.setEnabled(boolEnable);
        } else if (objectSource == this.comboVideoDevice) {
            this.createVideoChooser(null);
            this.validate();
        } else if (objectSource == this.comboAudioDevice) {
            this.createAudioChooser(null);
            this.validate();
        }
    }

    public void windowClosing(WindowEvent event) {
        this.setAction(JMDialog.ACTION_CANCEL);
        this.dispose();
    }

    public String toString() {
        CaptureDeviceInfo cdiVideo;
        MediaLocator deviceURL;
        String strValue = "";
        CaptureDeviceInfo cdiAudio = this.getAudioDevice();
        if (cdiAudio != null && this.isAudioDeviceUsed()) {
            deviceURL = cdiAudio.getLocator();
            if (strValue.length() > 0) {
                strValue = strValue + " & ";
            }
            strValue = strValue + deviceURL.toString();
        }
        if ((cdiVideo = this.getVideoDevice()) != null && this.isVideoDeviceUsed()) {
            deviceURL = cdiVideo.getLocator();
            if (strValue.length() > 0) {
                strValue = strValue + " & ";
            }
            strValue = strValue + deviceURL.toString();
        }
        return strValue;
    }
}

