/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.demos.raw;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import org.flexdock.demos.util.DemoUtility;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.defaults.AbstractDockable;
import org.flexdock.docking.defaults.DefaultDockingPort;

public class TabbedPaneDemo
extends JPanel
implements DockingConstants {
    private JLabel titlebar;
    private Dockable dockableImpl;

    public TabbedPaneDemo(String title) {
        this.titlebar = this.createTitlebar(" " + title);
        this.add(this.titlebar);
        this.setBorder(new LineBorder(Color.black));
        this.dockableImpl = new DockableImpl();
    }

    private JLabel createTitlebar(String title) {
        JLabel lbl = new JLabel(title);
        lbl.setForeground(Color.white);
        lbl.setBackground(Color.blue);
        lbl.setOpaque(true);
        return lbl;
    }

    public String getTitle() {
        return this.titlebar.getText().trim();
    }

    public void doLayout() {
        Insets in = this.getInsets();
        this.titlebar.setBounds(in.left, in.top, this.getWidth() - in.left - in.right, 25);
    }

    private Dockable getDockable() {
        return this.dockableImpl;
    }

    private static JPanel createContentPane() {
        JPanel p = new JPanel(new BorderLayout(5, 5));
        p.add((Component)TabbedPaneDemo.buildDockingPort("North"), "North");
        p.add((Component)TabbedPaneDemo.buildDockingPort("South"), "South");
        p.add((Component)TabbedPaneDemo.buildDockingPort("East"), "East");
        p.add((Component)TabbedPaneDemo.buildDockingPort("West"), "West");
        p.add((Component)TabbedPaneDemo.createDockingPort("Center"), "Center");
        return p;
    }

    private static DefaultDockingPort buildDockingPort(String desc) {
        DefaultDockingPort port = TabbedPaneDemo.createDockingPort(desc);
        TabbedPaneDemo cd = new TabbedPaneDemo(desc);
        DockingManager.registerDockable(cd.getDockable());
        port.dock(cd.getDockable(), "CENTER");
        return port;
    }

    private static int getTabPosition(String desc) {
        if ("North".equals(desc)) {
            return 1;
        }
        if ("South".equals(desc)) {
            return 3;
        }
        if ("East".equals(desc)) {
            return 4;
        }
        if ("West".equals(desc)) {
            return 2;
        }
        return 1;
    }

    private static DefaultDockingPort createDockingPort(String desc) {
        DefaultDockingPort port = new DefaultDockingPort();
        port.setBackground(Color.gray);
        port.setPreferredSize(new Dimension(200, 100));
        port.getDockingProperties().setTabPlacement(TabbedPaneDemo.getTabPosition(desc));
        return port;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("Custom Conatainers Docking Demo");
        f.setContentPane(TabbedPaneDemo.createContentPane());
        f.setSize(600, 400);
        DemoUtility.setCloseOperation(f);
        f.setVisible(true);
    }

    private class DockableImpl
    extends AbstractDockable {
        private DockableImpl() {
            super("dockable." + TabbedPaneDemo.this.getTitle());
            this.getDragSources().add(TabbedPaneDemo.this.titlebar);
            this.setTabText(TabbedPaneDemo.this.getTitle());
        }

        public Component getComponent() {
            return TabbedPaneDemo.this;
        }
    }
}

