/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.plaf.theme;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import org.flexdock.plaf.IFlexViewComponentUI;
import org.flexdock.plaf.PropertySet;
import org.flexdock.plaf.icons.IconResource;
import org.flexdock.view.Button;
import org.flexdock.view.Titlebar;

public class ButtonUI
extends BasicButtonUI
implements IFlexViewComponentUI {
    public static final String BORDER = "border";
    public static final String BORDER_HOVER = "border.hover";
    public static final String BORDER_ACTIVE = "border.active";
    public static final String BORDER_ACTIVE_HOVER = "border.active.hover";
    public static final String BORDER_PRESSED = "border.pressed";
    protected PropertySet creationParameters;
    protected Border borderDefault;
    protected Border borderDefaultHover;
    protected Border borderActive;
    protected Border borderActiveHover;
    protected Border borderPressed;

    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        this.updateTooltip(b);
        boolean active = this.isParentActive(b);
        boolean pressed = this.isPressed(b);
        boolean hover = pressed || model.isRollover();
        this.paintBackground(g, b, active, hover, pressed);
        this.paintIcon(g, b);
        this.paintBorder(g, b);
    }

    protected void paintBackground(Graphics g, AbstractButton b, boolean active, boolean hover, boolean pressed) {
    }

    protected void paintBorder(Graphics g, AbstractButton b) {
        Border border = this.getBorder(b);
        if (border != null) {
            border.paintBorder(b, g, 0, 0, b.getWidth(), b.getHeight());
        }
    }

    protected Border getBorder(AbstractButton button) {
        if (this.isPressed(button)) {
            return this.getPressedBorder(button);
        }
        boolean active = this.isParentActive(button);
        if (button.getModel().isRollover()) {
            return this.getHoverBorder(button, active);
        }
        return this.getDefaultBorder(button, active);
    }

    protected Border getPressedBorder(AbstractButton button) {
        Border border = this.borderPressed;
        if (border == null) {
            border = this.getHoverBorder(button, true);
        }
        return border;
    }

    protected Border getHoverBorder(AbstractButton button, boolean active) {
        Border border;
        Border border2 = border = active ? this.borderActiveHover : this.borderDefaultHover;
        if (border == null) {
            border = this.getDefaultBorder(button, active);
        }
        return border;
    }

    protected Border getDefaultBorder(AbstractButton button, boolean active) {
        return active ? this.borderActive : this.borderDefault;
    }

    protected void paintIcon(Graphics g, AbstractButton b) {
        Icon icon = this.getIcon(b);
        if (icon == null) {
            return;
        }
        int h = icon.getIconHeight();
        int w = icon.getIconWidth();
        int x = b.getWidth() / 2 - w / 2;
        int y = b.getHeight() / 2 - h / 2;
        icon.paintIcon(b, g, x, y);
    }

    protected Icon getIcon(AbstractButton button) {
        boolean active = this.isParentActive(button);
        if (!button.isEnabled() || !button.getModel().isEnabled()) {
            return this.getDisabledIcon(button, active);
        }
        if (this.isPressed(button)) {
            return this.getPressedIcon(button);
        }
        if (button.getModel().isRollover()) {
            return this.getHoverIcon(button, active);
        }
        return this.getDefaultIcon(button, active);
    }

    protected Icon getDisabledIcon(AbstractButton button, boolean active) {
        Icon icon = button.getDisabledIcon();
        if (icon == null) {
            icon = this.getActionIcon(button, false, active, false);
        }
        if (icon == null) {
            icon = this.getDefaultIcon(button, active);
        }
        return icon;
    }

    protected Icon getPressedIcon(AbstractButton button) {
        Icon icon = button.getPressedIcon();
        if (icon == null) {
            icon = this.getActionIcon(button, true, true, true);
        }
        if (icon == null) {
            icon = this.getHoverIcon(button, true);
        }
        return icon;
    }

    protected Icon getHoverIcon(AbstractButton button, boolean active) {
        Icon icon = button.getRolloverIcon();
        if (icon == null) {
            icon = this.getActionIcon(button, false, active, true);
        }
        if (icon == null) {
            icon = this.getDefaultIcon(button, active);
        }
        return icon;
    }

    protected Icon getDefaultIcon(AbstractButton button, boolean active) {
        Icon icon = button.getIcon();
        if (icon == null) {
            icon = this.getActionIcon(button, false, active, false);
        }
        return icon;
    }

    protected Icon getActionIcon(AbstractButton button, boolean pressed, boolean active, boolean hover) {
        Icon icon;
        IconResource resource;
        Action action = button.getAction();
        IconResource iconResource = resource = action == null ? null : (IconResource)action.getValue("flexdock.button.icon.resource");
        if (resource == null) {
            return null;
        }
        boolean disabled = !button.isEnabled() || !button.getModel().isEnabled();
        boolean selected = button.isSelected();
        if (pressed && !disabled) {
            Icon icon2;
            Icon icon3 = icon2 = selected ? resource.getIconSelectedPressed() : null;
            if (icon2 == null) {
                icon2 = resource.getIconPressed();
            }
            return icon2;
        }
        if (active) {
            Icon icon4;
            if (disabled) {
                Icon icon5;
                Icon icon6 = icon5 = selected ? resource.getIconSelectedActiveDisabled() : null;
                if (icon5 == null) {
                    icon5 = resource.getIconActiveDisabled();
                }
                return icon5 == null ? resource.getIconActive() : icon5;
            }
            if (hover) {
                Icon icon7;
                Icon icon8 = icon7 = selected ? resource.getIconSelectedActiveHover() : null;
                if (icon7 == null) {
                    icon7 = resource.getIconActiveHover();
                }
                return icon7;
            }
            Icon icon9 = icon4 = selected ? resource.getIconSelectedActive() : null;
            if (icon4 == null) {
                icon4 = resource.getIconActive();
            }
            return icon4;
        }
        if (disabled) {
            Icon icon10;
            Icon icon11 = icon10 = selected ? resource.getIconSelectedDisabled() : null;
            if (icon10 == null) {
                icon10 = resource.getIconDisabled();
            }
            return icon10 == null ? resource.getIcon() : icon10;
        }
        if (hover) {
            Icon icon12;
            Icon icon13 = icon12 = selected ? resource.getIconSelectedHover() : null;
            if (icon12 == null) {
                icon12 = resource.getIconHover();
            }
            return icon12;
        }
        Icon icon14 = icon = selected ? resource.getIconSelected() : null;
        if (icon == null) {
            icon = resource.getIcon();
        }
        return icon;
    }

    protected boolean isPressed(AbstractButton button) {
        ButtonModel model = button.getModel();
        return model.isArmed() && model.isPressed();
    }

    protected boolean isParentActive(AbstractButton button) {
        Container parent = button.getParent();
        return parent instanceof Titlebar ? ((Titlebar)parent).isActive() : false;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        AbstractButton button = (AbstractButton)c;
        button.setRolloverEnabled(true);
        button.setRequestFocusEnabled(false);
        button.setOpaque(false);
        button.setBorder(null);
        button.addItemListener(new ToggleListener());
        this.updateTooltip(button);
    }

    public void uninstallUI(JComponent c) {
        AbstractButton button = (AbstractButton)c;
        super.uninstallUI(c);
    }

    protected void installKeyboardActions(AbstractButton b) {
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new ButtonListener(b);
    }

    public void setBorderActive(Border borderActive) {
        this.borderActive = borderActive;
    }

    public void setBorderActiveHover(Border borderActiveHover) {
        this.borderActiveHover = borderActiveHover;
    }

    public void setBorderDefault(Border borderDefault) {
        this.borderDefault = borderDefault;
    }

    public void setBorderDefaultHover(Border borderDefaultHover) {
        this.borderDefaultHover = borderDefaultHover;
    }

    public void setBorderPressed(Border borderPressed) {
        this.borderPressed = borderPressed;
    }

    public PropertySet getCreationParameters() {
        return this.creationParameters;
    }

    public void setCreationParameters(PropertySet creationParameters) {
        this.creationParameters = creationParameters;
        this.initializeCreationParameters();
    }

    public void initializeCreationParameters() {
        this.setBorderDefault(this.creationParameters.getBorder(BORDER));
        this.setBorderDefaultHover(this.creationParameters.getBorder(BORDER_HOVER));
        this.setBorderActive(this.creationParameters.getBorder(BORDER_ACTIVE));
        this.setBorderActiveHover(this.creationParameters.getBorder(BORDER_ACTIVE_HOVER));
        this.setBorderPressed(this.creationParameters.getBorder(BORDER_PRESSED));
    }

    private void updateTooltip(AbstractButton button) {
        IconResource resource;
        Action action = button.getAction();
        if (action == null) {
            return;
        }
        String toolTip = (String)action.getValue("ShortDescription");
        if (toolTip != null) {
            return;
        }
        IconResource iconResource = resource = action == null ? null : (IconResource)action.getValue("flexdock.button.icon.resource");
        if (resource == null) {
            return;
        }
        String string = toolTip = button.isSelected() ? resource.getTooltipSelected() : resource.getTooltip();
        if (toolTip == null) {
            toolTip = resource.getTooltip();
        }
        if (toolTip != null) {
            button.setToolTipText(toolTip);
        }
    }

    private class ToggleListener
    implements ItemListener {
        private ToggleListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() != 1 && e.getStateChange() != 2) {
                return;
            }
            Button button = (Button)e.getSource();
            ButtonUI.this.updateTooltip(button);
        }
    }

    protected static class ButtonListener
    extends BasicButtonListener {
        protected ButtonListener(AbstractButton b) {
            super(b);
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
        }
    }
}

