"""Generated client library for admin version directory_v1."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.admin.v1 import admin_v1_messages as messages


class AdminDirectoryV1(base_api.BaseApiClient):
  """Generated client library for service admin version directory_v1."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://www.googleapis.com/admin/directory/v1/'

  _PACKAGE = u'admin'
  _SCOPES = [
      u'https://www.googleapis.com/auth/admin.directory.customer',
      u'https://www.googleapis.com/auth/admin.directory.customer.readonly',
      u'https://www.googleapis.com/auth/admin.directory.device.chromeos',
      u'https://www.googleapis.com/auth/admin.directory.device.chromeos.readonly',
      u'https://www.googleapis.com/auth/admin.directory.device.mobile',
      u'https://www.googleapis.com/auth/admin.directory.device.mobile.action',
      u'https://www.googleapis.com/auth/admin.directory.device.mobile.readonly',
      u'https://www.googleapis.com/auth/admin.directory.domain',
      u'https://www.googleapis.com/auth/admin.directory.domain.readonly',
      u'https://www.googleapis.com/auth/admin.directory.group',
      u'https://www.googleapis.com/auth/admin.directory.group.member',
      u'https://www.googleapis.com/auth/admin.directory.group.member.readonly',
      u'https://www.googleapis.com/auth/admin.directory.group.readonly',
      u'https://www.googleapis.com/auth/admin.directory.notifications',
      u'https://www.googleapis.com/auth/admin.directory.orgunit',
      u'https://www.googleapis.com/auth/admin.directory.orgunit.readonly',
      u'https://www.googleapis.com/auth/admin.directory.resource.calendar',
      u'https://www.googleapis.com/auth/admin.directory.resource.calendar.readonly',
      u'https://www.googleapis.com/auth/admin.directory.rolemanagement',
      u'https://www.googleapis.com/auth/admin.directory.rolemanagement.readonly',
      u'https://www.googleapis.com/auth/admin.directory.user',
      u'https://www.googleapis.com/auth/admin.directory.user.alias',
      u'https://www.googleapis.com/auth/admin.directory.user.alias.readonly',
      u'https://www.googleapis.com/auth/admin.directory.user.readonly',
      u'https://www.googleapis.com/auth/admin.directory.user.security',
      u'https://www.googleapis.com/auth/admin.directory.userschema',
      u'https://www.googleapis.com/auth/admin.directory.userschema.readonly',
      u'https://www.googleapis.com/auth/cloud-platform'
  ]
  _VERSION = u'directory_v1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = u'google-cloud-sdk'
  _CLIENT_CLASS_NAME = u'AdminDirectoryV1'
  _URL_VERSION = u'directory_v1'
  _API_KEY = None

  def __init__(self,
               url='',
               credentials=None,
               get_credentials=True,
               http=None,
               model=None,
               log_request=False,
               log_response=False,
               credentials_args=None,
               default_global_params=None,
               additional_http_headers=None,
               response_encoding=None):
    """Create a new admin handle."""
    url = url or self.BASE_URL
    super(AdminDirectoryV1, self).__init__(
        url,
        credentials=credentials,
        get_credentials=get_credentials,
        http=http,
        model=model,
        log_request=log_request,
        log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.asps = self.AspsService(self)
    self.channels = self.ChannelsService(self)
    self.chromeosdevices = self.ChromeosdevicesService(self)
    self.customers = self.CustomersService(self)
    self.domainAliases = self.DomainAliasesService(self)
    self.domains = self.DomainsService(self)
    self.groups_aliases = self.GroupsAliasesService(self)
    self.groups = self.GroupsService(self)
    self.members = self.MembersService(self)
    self.mobiledevices = self.MobiledevicesService(self)
    self.notifications = self.NotificationsService(self)
    self.orgunits = self.OrgunitsService(self)
    self.privileges = self.PrivilegesService(self)
    self.resolvedAppAccessSettings = self.ResolvedAppAccessSettingsService(self)
    self.resources_buildings = self.ResourcesBuildingsService(self)
    self.resources_calendars = self.ResourcesCalendarsService(self)
    self.resources_features = self.ResourcesFeaturesService(self)
    self.resources = self.ResourcesService(self)
    self.roleAssignments = self.RoleAssignmentsService(self)
    self.roles = self.RolesService(self)
    self.schemas = self.SchemasService(self)
    self.tokens = self.TokensService(self)
    self.users_aliases = self.UsersAliasesService(self)
    self.users_photos = self.UsersPhotosService(self)
    self.users = self.UsersService(self)
    self.verificationCodes = self.VerificationCodesService(self)

  class AspsService(base_api.BaseApiService):
    """Service class for the asps resource."""

    _NAME = u'asps'

    def __init__(self, client):
      super(AdminDirectoryV1.AspsService, self).__init__(client)
      self._upload_configs = {}

    def Delete(self, request, global_params=None):
      r"""Delete an ASP issued by a user.

      Args:
        request: (DirectoryAspsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (DirectoryAspsDeleteResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'directory.asps.delete',
        ordered_params=[u'userKey', u'codeId'],
        path_params=[u'codeId', u'userKey'],
        query_params=[],
        relative_path=u'users/{userKey}/asps/{codeId}',
        request_field='',
        request_type_name=u'DirectoryAspsDeleteRequest',
        response_type_name=u'DirectoryAspsDeleteResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Get information about an ASP issued by a user.

      Args:
        request: (DirectoryAspsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Asp) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.asps.get',
        ordered_params=[u'userKey', u'codeId'],
        path_params=[u'codeId', u'userKey'],
        query_params=[],
        relative_path=u'users/{userKey}/asps/{codeId}',
        request_field='',
        request_type_name=u'DirectoryAspsGetRequest',
        response_type_name=u'Asp',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List the ASPs issued by a user.

      Args:
        request: (DirectoryAspsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Asps) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.asps.list',
        ordered_params=[u'userKey'],
        path_params=[u'userKey'],
        query_params=[],
        relative_path=u'users/{userKey}/asps',
        request_field='',
        request_type_name=u'DirectoryAspsListRequest',
        response_type_name=u'Asps',
        supports_download=False,
    )

  class ChannelsService(base_api.BaseApiService):
    """Service class for the channels resource."""

    _NAME = u'channels'

    def __init__(self, client):
      super(AdminDirectoryV1.ChannelsService, self).__init__(client)
      self._upload_configs = {}

    def Stop(self, request, global_params=None):
      r"""Stop watching resources through this channel.

      Args:
        request: (Channel) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (AdminChannelsStopResponse) The response message.
      """
      config = self.GetMethodConfig('Stop')
      return self._RunMethod(config, request, global_params=global_params)

    Stop.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'admin.channels.stop',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'/admin/directory_v1/channels/stop',
        request_field='<request>',
        request_type_name=u'Channel',
        response_type_name=u'AdminChannelsStopResponse',
        supports_download=False,
    )

  class ChromeosdevicesService(base_api.BaseApiService):
    """Service class for the chromeosdevices resource."""

    _NAME = u'chromeosdevices'

    def __init__(self, client):
      super(AdminDirectoryV1.ChromeosdevicesService, self).__init__(client)
      self._upload_configs = {}

    def Action(self, request, global_params=None):
      r"""Take action on Chrome OS Device.

      Args:
        request: (DirectoryChromeosdevicesActionRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (DirectoryChromeosdevicesActionResponse) The response message.
      """
      config = self.GetMethodConfig('Action')
      return self._RunMethod(config, request, global_params=global_params)

    Action.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'directory.chromeosdevices.action',
        ordered_params=[u'customerId', u'resourceId'],
        path_params=[u'customerId', u'resourceId'],
        query_params=[],
        relative_path=u'customer/{customerId}/devices/chromeos/{resourceId}/action',
        request_field=u'chromeOsDeviceAction',
        request_type_name=u'DirectoryChromeosdevicesActionRequest',
        response_type_name=u'DirectoryChromeosdevicesActionResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieve Chrome OS Device.

      Args:
        request: (DirectoryChromeosdevicesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (ChromeOsDevice) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.chromeosdevices.get',
        ordered_params=[u'customerId', u'deviceId'],
        path_params=[u'customerId', u'deviceId'],
        query_params=[u'projection'],
        relative_path=u'customer/{customerId}/devices/chromeos/{deviceId}',
        request_field='',
        request_type_name=u'DirectoryChromeosdevicesGetRequest',
        response_type_name=u'ChromeOsDevice',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieve all Chrome OS Devices of a customer (paginated).

      Args:
        request: (DirectoryChromeosdevicesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (ChromeOsDevices) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.chromeosdevices.list',
        ordered_params=[u'customerId'],
        path_params=[u'customerId'],
        query_params=[
            u'maxResults', u'orderBy', u'orgUnitPath', u'pageToken',
            u'projection', u'query', u'sortOrder'
        ],
        relative_path=u'customer/{customerId}/devices/chromeos',
        request_field='',
        request_type_name=u'DirectoryChromeosdevicesListRequest',
        response_type_name=u'ChromeOsDevices',
        supports_download=False,
    )

    def MoveDevicesToOu(self, request, global_params=None):
      r"""Move or insert multiple Chrome OS Devices to organizational unit.

      Args:
        request: (DirectoryChromeosdevicesMoveDevicesToOuRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (DirectoryChromeosdevicesMoveDevicesToOuResponse) The response message.
      """
      config = self.GetMethodConfig('MoveDevicesToOu')
      return self._RunMethod(config, request, global_params=global_params)

    MoveDevicesToOu.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'directory.chromeosdevices.moveDevicesToOu',
        ordered_params=[u'customerId', u'orgUnitPath'],
        path_params=[u'customerId'],
        query_params=[u'orgUnitPath'],
        relative_path=u'customer/{customerId}/devices/chromeos/moveDevicesToOu',
        request_field=u'chromeOsMoveDevicesToOu',
        request_type_name=u'DirectoryChromeosdevicesMoveDevicesToOuRequest',
        response_type_name=u'DirectoryChromeosdevicesMoveDevicesToOuResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Update Chrome OS Device.

      This method supports patch semantics.

      Args:
        request: (DirectoryChromeosdevicesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (ChromeOsDevice) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'directory.chromeosdevices.patch',
        ordered_params=[u'customerId', u'deviceId'],
        path_params=[u'customerId', u'deviceId'],
        query_params=[u'projection'],
        relative_path=u'customer/{customerId}/devices/chromeos/{deviceId}',
        request_field=u'chromeOsDevice',
        request_type_name=u'DirectoryChromeosdevicesPatchRequest',
        response_type_name=u'ChromeOsDevice',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Update Chrome OS Device.

      Args:
        request: (DirectoryChromeosdevicesUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (ChromeOsDevice) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PUT',
        method_id=u'directory.chromeosdevices.update',
        ordered_params=[u'customerId', u'deviceId'],
        path_params=[u'customerId', u'deviceId'],
        query_params=[u'projection'],
        relative_path=u'customer/{customerId}/devices/chromeos/{deviceId}',
        request_field=u'chromeOsDevice',
        request_type_name=u'DirectoryChromeosdevicesUpdateRequest',
        response_type_name=u'ChromeOsDevice',
        supports_download=False,
    )

  class CustomersService(base_api.BaseApiService):
    """Service class for the customers resource."""

    _NAME = u'customers'

    def __init__(self, client):
      super(AdminDirectoryV1.CustomersService, self).__init__(client)
      self._upload_configs = {}

    def Get(self, request, global_params=None):
      r"""Retrieves a customer.

      Args:
        request: (DirectoryCustomersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Customer) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.customers.get',
        ordered_params=[u'customerKey'],
        path_params=[u'customerKey'],
        query_params=[],
        relative_path=u'customers/{customerKey}',
        request_field='',
        request_type_name=u'DirectoryCustomersGetRequest',
        response_type_name=u'Customer',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a customer.

      This method supports patch semantics.

      Args:
        request: (DirectoryCustomersPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Customer) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'directory.customers.patch',
        ordered_params=[u'customerKey'],
        path_params=[u'customerKey'],
        query_params=[],
        relative_path=u'customers/{customerKey}',
        request_field=u'customer',
        request_type_name=u'DirectoryCustomersPatchRequest',
        response_type_name=u'Customer',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a customer.

      Args:
        request: (DirectoryCustomersUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Customer) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PUT',
        method_id=u'directory.customers.update',
        ordered_params=[u'customerKey'],
        path_params=[u'customerKey'],
        query_params=[],
        relative_path=u'customers/{customerKey}',
        request_field=u'customer',
        request_type_name=u'DirectoryCustomersUpdateRequest',
        response_type_name=u'Customer',
        supports_download=False,
    )

  class DomainAliasesService(base_api.BaseApiService):
    """Service class for the domainAliases resource."""

    _NAME = u'domainAliases'

    def __init__(self, client):
      super(AdminDirectoryV1.DomainAliasesService, self).__init__(client)
      self._upload_configs = {}

    def Delete(self, request, global_params=None):
      r"""Deletes a Domain Alias of the customer.

      Args:
        request: (DirectoryDomainAliasesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (DirectoryDomainAliasesDeleteResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'directory.domainAliases.delete',
        ordered_params=[u'customer', u'domainAliasName'],
        path_params=[u'customer', u'domainAliasName'],
        query_params=[],
        relative_path=u'customer/{customer}/domainaliases/{domainAliasName}',
        request_field='',
        request_type_name=u'DirectoryDomainAliasesDeleteRequest',
        response_type_name=u'DirectoryDomainAliasesDeleteResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves a domain alias of the customer.

      Args:
        request: (DirectoryDomainAliasesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (DomainAlias) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.domainAliases.get',
        ordered_params=[u'customer', u'domainAliasName'],
        path_params=[u'customer', u'domainAliasName'],
        query_params=[],
        relative_path=u'customer/{customer}/domainaliases/{domainAliasName}',
        request_field='',
        request_type_name=u'DirectoryDomainAliasesGetRequest',
        response_type_name=u'DomainAlias',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Inserts a Domain alias of the customer.

      Args:
        request: (DirectoryDomainAliasesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (DomainAlias) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'directory.domainAliases.insert',
        ordered_params=[u'customer'],
        path_params=[u'customer'],
        query_params=[],
        relative_path=u'customer/{customer}/domainaliases',
        request_field=u'domainAlias',
        request_type_name=u'DirectoryDomainAliasesInsertRequest',
        response_type_name=u'DomainAlias',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the domain aliases of the customer.

      Args:
        request: (DirectoryDomainAliasesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (DomainAliases) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.domainAliases.list',
        ordered_params=[u'customer'],
        path_params=[u'customer'],
        query_params=[u'parentDomainName'],
        relative_path=u'customer/{customer}/domainaliases',
        request_field='',
        request_type_name=u'DirectoryDomainAliasesListRequest',
        response_type_name=u'DomainAliases',
        supports_download=False,
    )

  class DomainsService(base_api.BaseApiService):
    """Service class for the domains resource."""

    _NAME = u'domains'

    def __init__(self, client):
      super(AdminDirectoryV1.DomainsService, self).__init__(client)
      self._upload_configs = {}

    def Delete(self, request, global_params=None):
      r"""Deletes a domain of the customer.

      Args:
        request: (DirectoryDomainsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (DirectoryDomainsDeleteResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'directory.domains.delete',
        ordered_params=[u'customer', u'domainName'],
        path_params=[u'customer', u'domainName'],
        query_params=[],
        relative_path=u'customer/{customer}/domains/{domainName}',
        request_field='',
        request_type_name=u'DirectoryDomainsDeleteRequest',
        response_type_name=u'DirectoryDomainsDeleteResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves a domain of the customer.

      Args:
        request: (DirectoryDomainsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Domains) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.domains.get',
        ordered_params=[u'customer', u'domainName'],
        path_params=[u'customer', u'domainName'],
        query_params=[],
        relative_path=u'customer/{customer}/domains/{domainName}',
        request_field='',
        request_type_name=u'DirectoryDomainsGetRequest',
        response_type_name=u'Domains',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Inserts a domain of the customer.

      Args:
        request: (DirectoryDomainsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Domains) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'directory.domains.insert',
        ordered_params=[u'customer'],
        path_params=[u'customer'],
        query_params=[],
        relative_path=u'customer/{customer}/domains',
        request_field=u'domains',
        request_type_name=u'DirectoryDomainsInsertRequest',
        response_type_name=u'Domains',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the domains of the customer.

      Args:
        request: (DirectoryDomainsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Domains2) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.domains.list',
        ordered_params=[u'customer'],
        path_params=[u'customer'],
        query_params=[],
        relative_path=u'customer/{customer}/domains',
        request_field='',
        request_type_name=u'DirectoryDomainsListRequest',
        response_type_name=u'Domains2',
        supports_download=False,
    )

  class GroupsAliasesService(base_api.BaseApiService):
    """Service class for the groups_aliases resource."""

    _NAME = u'groups_aliases'

    def __init__(self, client):
      super(AdminDirectoryV1.GroupsAliasesService, self).__init__(client)
      self._upload_configs = {}

    def Delete(self, request, global_params=None):
      r"""Remove a alias for the group.

      Args:
        request: (DirectoryGroupsAliasesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (DirectoryGroupsAliasesDeleteResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'directory.groups.aliases.delete',
        ordered_params=[u'groupKey', u'alias'],
        path_params=[u'alias', u'groupKey'],
        query_params=[],
        relative_path=u'groups/{groupKey}/aliases/{alias}',
        request_field='',
        request_type_name=u'DirectoryGroupsAliasesDeleteRequest',
        response_type_name=u'DirectoryGroupsAliasesDeleteResponse',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Add a alias for the group.

      Args:
        request: (DirectoryGroupsAliasesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Alias) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'directory.groups.aliases.insert',
        ordered_params=[u'groupKey'],
        path_params=[u'groupKey'],
        query_params=[],
        relative_path=u'groups/{groupKey}/aliases',
        request_field=u'alias',
        request_type_name=u'DirectoryGroupsAliasesInsertRequest',
        response_type_name=u'Alias',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List all aliases for a group.

      Args:
        request: (DirectoryGroupsAliasesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Aliases) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.groups.aliases.list',
        ordered_params=[u'groupKey'],
        path_params=[u'groupKey'],
        query_params=[],
        relative_path=u'groups/{groupKey}/aliases',
        request_field='',
        request_type_name=u'DirectoryGroupsAliasesListRequest',
        response_type_name=u'Aliases',
        supports_download=False,
    )

  class GroupsService(base_api.BaseApiService):
    """Service class for the groups resource."""

    _NAME = u'groups'

    def __init__(self, client):
      super(AdminDirectoryV1.GroupsService, self).__init__(client)
      self._upload_configs = {}

    def Delete(self, request, global_params=None):
      r"""Delete Group.

      Args:
        request: (DirectoryGroupsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (DirectoryGroupsDeleteResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'directory.groups.delete',
        ordered_params=[u'groupKey'],
        path_params=[u'groupKey'],
        query_params=[],
        relative_path=u'groups/{groupKey}',
        request_field='',
        request_type_name=u'DirectoryGroupsDeleteRequest',
        response_type_name=u'DirectoryGroupsDeleteResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieve Group.

      Args:
        request: (DirectoryGroupsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Group) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.groups.get',
        ordered_params=[u'groupKey'],
        path_params=[u'groupKey'],
        query_params=[],
        relative_path=u'groups/{groupKey}',
        request_field='',
        request_type_name=u'DirectoryGroupsGetRequest',
        response_type_name=u'Group',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Create Group.

      Args:
        request: (Group) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Group) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'directory.groups.insert',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'groups',
        request_field='<request>',
        request_type_name=u'Group',
        response_type_name=u'Group',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieve all groups of a domain or of a user given a userKey (paginated).

      Args:
        request: (DirectoryGroupsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Groups) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.groups.list',
        ordered_params=[],
        path_params=[],
        query_params=[
            u'customer', u'domain', u'maxResults', u'orderBy', u'pageToken',
            u'query', u'sortOrder', u'userKey'
        ],
        relative_path=u'groups',
        request_field='',
        request_type_name=u'DirectoryGroupsListRequest',
        response_type_name=u'Groups',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Update Group.

      This method supports patch semantics.

      Args:
        request: (DirectoryGroupsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Group) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'directory.groups.patch',
        ordered_params=[u'groupKey'],
        path_params=[u'groupKey'],
        query_params=[],
        relative_path=u'groups/{groupKey}',
        request_field=u'group',
        request_type_name=u'DirectoryGroupsPatchRequest',
        response_type_name=u'Group',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Update Group.

      Args:
        request: (DirectoryGroupsUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Group) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PUT',
        method_id=u'directory.groups.update',
        ordered_params=[u'groupKey'],
        path_params=[u'groupKey'],
        query_params=[],
        relative_path=u'groups/{groupKey}',
        request_field=u'group',
        request_type_name=u'DirectoryGroupsUpdateRequest',
        response_type_name=u'Group',
        supports_download=False,
    )

  class MembersService(base_api.BaseApiService):
    """Service class for the members resource."""

    _NAME = u'members'

    def __init__(self, client):
      super(AdminDirectoryV1.MembersService, self).__init__(client)
      self._upload_configs = {}

    def Delete(self, request, global_params=None):
      r"""Remove membership.

      Args:
        request: (DirectoryMembersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (DirectoryMembersDeleteResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'directory.members.delete',
        ordered_params=[u'groupKey', u'memberKey'],
        path_params=[u'groupKey', u'memberKey'],
        query_params=[],
        relative_path=u'groups/{groupKey}/members/{memberKey}',
        request_field='',
        request_type_name=u'DirectoryMembersDeleteRequest',
        response_type_name=u'DirectoryMembersDeleteResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieve Group Member.

      Args:
        request: (DirectoryMembersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Member) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.members.get',
        ordered_params=[u'groupKey', u'memberKey'],
        path_params=[u'groupKey', u'memberKey'],
        query_params=[],
        relative_path=u'groups/{groupKey}/members/{memberKey}',
        request_field='',
        request_type_name=u'DirectoryMembersGetRequest',
        response_type_name=u'Member',
        supports_download=False,
    )

    def HasMember(self, request, global_params=None):
      r"""Checks whether the given user is a member of the group.

      Membership can be direct or nested.

      Args:
        request: (DirectoryMembersHasMemberRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (MembersHasMember) The response message.
      """
      config = self.GetMethodConfig('HasMember')
      return self._RunMethod(config, request, global_params=global_params)

    HasMember.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.members.hasMember',
        ordered_params=[u'groupKey', u'memberKey'],
        path_params=[u'groupKey', u'memberKey'],
        query_params=[],
        relative_path=u'groups/{groupKey}/hasMember/{memberKey}',
        request_field='',
        request_type_name=u'DirectoryMembersHasMemberRequest',
        response_type_name=u'MembersHasMember',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Add user to the specified group.

      Args:
        request: (DirectoryMembersInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Member) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'directory.members.insert',
        ordered_params=[u'groupKey'],
        path_params=[u'groupKey'],
        query_params=[],
        relative_path=u'groups/{groupKey}/members',
        request_field=u'member',
        request_type_name=u'DirectoryMembersInsertRequest',
        response_type_name=u'Member',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieve all members in a group (paginated).

      Args:
        request: (DirectoryMembersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Members) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.members.list',
        ordered_params=[u'groupKey'],
        path_params=[u'groupKey'],
        query_params=[
            u'includeDerivedMembership', u'maxResults', u'pageToken', u'roles'
        ],
        relative_path=u'groups/{groupKey}/members',
        request_field='',
        request_type_name=u'DirectoryMembersListRequest',
        response_type_name=u'Members',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Update membership of a user in the specified group.

      This method supports patch semantics.

      Args:
        request: (DirectoryMembersPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Member) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'directory.members.patch',
        ordered_params=[u'groupKey', u'memberKey'],
        path_params=[u'groupKey', u'memberKey'],
        query_params=[],
        relative_path=u'groups/{groupKey}/members/{memberKey}',
        request_field=u'member',
        request_type_name=u'DirectoryMembersPatchRequest',
        response_type_name=u'Member',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Update membership of a user in the specified group.

      Args:
        request: (DirectoryMembersUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Member) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PUT',
        method_id=u'directory.members.update',
        ordered_params=[u'groupKey', u'memberKey'],
        path_params=[u'groupKey', u'memberKey'],
        query_params=[],
        relative_path=u'groups/{groupKey}/members/{memberKey}',
        request_field=u'member',
        request_type_name=u'DirectoryMembersUpdateRequest',
        response_type_name=u'Member',
        supports_download=False,
    )

  class MobiledevicesService(base_api.BaseApiService):
    """Service class for the mobiledevices resource."""

    _NAME = u'mobiledevices'

    def __init__(self, client):
      super(AdminDirectoryV1.MobiledevicesService, self).__init__(client)
      self._upload_configs = {}

    def Action(self, request, global_params=None):
      r"""Take action on Mobile Device.

      Args:
        request: (DirectoryMobiledevicesActionRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (DirectoryMobiledevicesActionResponse) The response message.
      """
      config = self.GetMethodConfig('Action')
      return self._RunMethod(config, request, global_params=global_params)

    Action.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'directory.mobiledevices.action',
        ordered_params=[u'customerId', u'resourceId'],
        path_params=[u'customerId', u'resourceId'],
        query_params=[],
        relative_path=u'customer/{customerId}/devices/mobile/{resourceId}/action',
        request_field=u'mobileDeviceAction',
        request_type_name=u'DirectoryMobiledevicesActionRequest',
        response_type_name=u'DirectoryMobiledevicesActionResponse',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Delete Mobile Device.

      Args:
        request: (DirectoryMobiledevicesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (DirectoryMobiledevicesDeleteResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'directory.mobiledevices.delete',
        ordered_params=[u'customerId', u'resourceId'],
        path_params=[u'customerId', u'resourceId'],
        query_params=[],
        relative_path=u'customer/{customerId}/devices/mobile/{resourceId}',
        request_field='',
        request_type_name=u'DirectoryMobiledevicesDeleteRequest',
        response_type_name=u'DirectoryMobiledevicesDeleteResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieve Mobile Device.

      Args:
        request: (DirectoryMobiledevicesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (MobileDevice) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.mobiledevices.get',
        ordered_params=[u'customerId', u'resourceId'],
        path_params=[u'customerId', u'resourceId'],
        query_params=[u'projection'],
        relative_path=u'customer/{customerId}/devices/mobile/{resourceId}',
        request_field='',
        request_type_name=u'DirectoryMobiledevicesGetRequest',
        response_type_name=u'MobileDevice',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieve all Mobile Devices of a customer (paginated).

      Args:
        request: (DirectoryMobiledevicesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (MobileDevices) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.mobiledevices.list',
        ordered_params=[u'customerId'],
        path_params=[u'customerId'],
        query_params=[
            u'maxResults', u'orderBy', u'pageToken', u'projection', u'query',
            u'sortOrder'
        ],
        relative_path=u'customer/{customerId}/devices/mobile',
        request_field='',
        request_type_name=u'DirectoryMobiledevicesListRequest',
        response_type_name=u'MobileDevices',
        supports_download=False,
    )

  class NotificationsService(base_api.BaseApiService):
    """Service class for the notifications resource."""

    _NAME = u'notifications'

    def __init__(self, client):
      super(AdminDirectoryV1.NotificationsService, self).__init__(client)
      self._upload_configs = {}

    def Delete(self, request, global_params=None):
      r"""Deletes a notification.

      Args:
        request: (DirectoryNotificationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (DirectoryNotificationsDeleteResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'directory.notifications.delete',
        ordered_params=[u'customer', u'notificationId'],
        path_params=[u'customer', u'notificationId'],
        query_params=[],
        relative_path=u'customer/{customer}/notifications/{notificationId}',
        request_field='',
        request_type_name=u'DirectoryNotificationsDeleteRequest',
        response_type_name=u'DirectoryNotificationsDeleteResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves a notification.

      Args:
        request: (DirectoryNotificationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Notification) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.notifications.get',
        ordered_params=[u'customer', u'notificationId'],
        path_params=[u'customer', u'notificationId'],
        query_params=[],
        relative_path=u'customer/{customer}/notifications/{notificationId}',
        request_field='',
        request_type_name=u'DirectoryNotificationsGetRequest',
        response_type_name=u'Notification',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of notifications.

      Args:
        request: (DirectoryNotificationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Notifications) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.notifications.list',
        ordered_params=[u'customer'],
        path_params=[u'customer'],
        query_params=[u'language', u'maxResults', u'pageToken'],
        relative_path=u'customer/{customer}/notifications',
        request_field='',
        request_type_name=u'DirectoryNotificationsListRequest',
        response_type_name=u'Notifications',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a notification.

      This method supports patch semantics.

      Args:
        request: (DirectoryNotificationsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Notification) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'directory.notifications.patch',
        ordered_params=[u'customer', u'notificationId'],
        path_params=[u'customer', u'notificationId'],
        query_params=[],
        relative_path=u'customer/{customer}/notifications/{notificationId}',
        request_field=u'notification',
        request_type_name=u'DirectoryNotificationsPatchRequest',
        response_type_name=u'Notification',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a notification.

      Args:
        request: (DirectoryNotificationsUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Notification) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PUT',
        method_id=u'directory.notifications.update',
        ordered_params=[u'customer', u'notificationId'],
        path_params=[u'customer', u'notificationId'],
        query_params=[],
        relative_path=u'customer/{customer}/notifications/{notificationId}',
        request_field=u'notification',
        request_type_name=u'DirectoryNotificationsUpdateRequest',
        response_type_name=u'Notification',
        supports_download=False,
    )

  class OrgunitsService(base_api.BaseApiService):
    """Service class for the orgunits resource."""

    _NAME = u'orgunits'

    def __init__(self, client):
      super(AdminDirectoryV1.OrgunitsService, self).__init__(client)
      self._upload_configs = {}

    def Delete(self, request, global_params=None):
      r"""Remove organizational unit.

      Args:
        request: (DirectoryOrgunitsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (DirectoryOrgunitsDeleteResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'directory.orgunits.delete',
        ordered_params=[u'customerId', u'orgUnitPath'],
        path_params=[u'customerId', u'orgUnitPath'],
        query_params=[],
        relative_path=u'customer/{customerId}/orgunits{/orgUnitPath*}',
        request_field='',
        request_type_name=u'DirectoryOrgunitsDeleteRequest',
        response_type_name=u'DirectoryOrgunitsDeleteResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieve organizational unit.

      Args:
        request: (DirectoryOrgunitsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (OrgUnit) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.orgunits.get',
        ordered_params=[u'customerId', u'orgUnitPath'],
        path_params=[u'customerId', u'orgUnitPath'],
        query_params=[],
        relative_path=u'customer/{customerId}/orgunits{/orgUnitPath*}',
        request_field='',
        request_type_name=u'DirectoryOrgunitsGetRequest',
        response_type_name=u'OrgUnit',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Add organizational unit.

      Args:
        request: (DirectoryOrgunitsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (OrgUnit) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'directory.orgunits.insert',
        ordered_params=[u'customerId'],
        path_params=[u'customerId'],
        query_params=[],
        relative_path=u'customer/{customerId}/orgunits',
        request_field=u'orgUnit',
        request_type_name=u'DirectoryOrgunitsInsertRequest',
        response_type_name=u'OrgUnit',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieve all organizational units.

      Args:
        request: (DirectoryOrgunitsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (OrgUnits) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.orgunits.list',
        ordered_params=[u'customerId'],
        path_params=[u'customerId'],
        query_params=[u'orgUnitPath', u'type'],
        relative_path=u'customer/{customerId}/orgunits',
        request_field='',
        request_type_name=u'DirectoryOrgunitsListRequest',
        response_type_name=u'OrgUnits',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Update organizational unit.

      This method supports patch semantics.

      Args:
        request: (DirectoryOrgunitsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (OrgUnit) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'directory.orgunits.patch',
        ordered_params=[u'customerId', u'orgUnitPath'],
        path_params=[u'customerId', u'orgUnitPath'],
        query_params=[],
        relative_path=u'customer/{customerId}/orgunits{/orgUnitPath*}',
        request_field=u'orgUnit',
        request_type_name=u'DirectoryOrgunitsPatchRequest',
        response_type_name=u'OrgUnit',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Update organizational unit.

      Args:
        request: (DirectoryOrgunitsUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (OrgUnit) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PUT',
        method_id=u'directory.orgunits.update',
        ordered_params=[u'customerId', u'orgUnitPath'],
        path_params=[u'customerId', u'orgUnitPath'],
        query_params=[],
        relative_path=u'customer/{customerId}/orgunits{/orgUnitPath*}',
        request_field=u'orgUnit',
        request_type_name=u'DirectoryOrgunitsUpdateRequest',
        response_type_name=u'OrgUnit',
        supports_download=False,
    )

  class PrivilegesService(base_api.BaseApiService):
    """Service class for the privileges resource."""

    _NAME = u'privileges'

    def __init__(self, client):
      super(AdminDirectoryV1.PrivilegesService, self).__init__(client)
      self._upload_configs = {}

    def List(self, request, global_params=None):
      r"""Retrieves a paginated list of all privileges for a customer.

      Args:
        request: (DirectoryPrivilegesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Privileges) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.privileges.list',
        ordered_params=[u'customer'],
        path_params=[u'customer'],
        query_params=[],
        relative_path=u'customer/{customer}/roles/ALL/privileges',
        request_field='',
        request_type_name=u'DirectoryPrivilegesListRequest',
        response_type_name=u'Privileges',
        supports_download=False,
    )

  class ResolvedAppAccessSettingsService(base_api.BaseApiService):
    """Service class for the resolvedAppAccessSettings resource."""

    _NAME = u'resolvedAppAccessSettings'

    def __init__(self, client):
      super(AdminDirectoryV1.ResolvedAppAccessSettingsService,
            self).__init__(client)
      self._upload_configs = {}

    def GetSettings(self, request, global_params=None):
      r"""Retrieves resolved app access settings of the logged in user.

      Args:
        request: (DirectoryResolvedAppAccessSettingsGetSettingsRequest) input
          message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (AppAccessCollections) The response message.
      """
      config = self.GetMethodConfig('GetSettings')
      return self._RunMethod(config, request, global_params=global_params)

    GetSettings.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.resolvedAppAccessSettings.GetSettings',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'resolvedappaccesssettings',
        request_field='',
        request_type_name=u'DirectoryResolvedAppAccessSettingsGetSettingsRequest',
        response_type_name=u'AppAccessCollections',
        supports_download=False,
    )

    def ListTrustedApps(self, request, global_params=None):
      r"""Retrieves the list of apps trusted by the admin of the logged in user.

      Args:
        request: (DirectoryResolvedAppAccessSettingsListTrustedAppsRequest)
          input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (TrustedApps) The response message.
      """
      config = self.GetMethodConfig('ListTrustedApps')
      return self._RunMethod(config, request, global_params=global_params)

    ListTrustedApps.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.resolvedAppAccessSettings.ListTrustedApps',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'trustedapps',
        request_field='',
        request_type_name=u'DirectoryResolvedAppAccessSettingsListTrustedAppsRequest',
        response_type_name=u'TrustedApps',
        supports_download=False,
    )

  class ResourcesBuildingsService(base_api.BaseApiService):
    """Service class for the resources_buildings resource."""

    _NAME = u'resources_buildings'

    def __init__(self, client):
      super(AdminDirectoryV1.ResourcesBuildingsService, self).__init__(client)
      self._upload_configs = {}

    def Delete(self, request, global_params=None):
      r"""Deletes a building.

      Args:
        request: (DirectoryResourcesBuildingsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (DirectoryResourcesBuildingsDeleteResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'directory.resources.buildings.delete',
        ordered_params=[u'customer', u'buildingId'],
        path_params=[u'buildingId', u'customer'],
        query_params=[],
        relative_path=u'customer/{customer}/resources/buildings/{buildingId}',
        request_field='',
        request_type_name=u'DirectoryResourcesBuildingsDeleteRequest',
        response_type_name=u'DirectoryResourcesBuildingsDeleteResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves a building.

      Args:
        request: (DirectoryResourcesBuildingsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Building) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.resources.buildings.get',
        ordered_params=[u'customer', u'buildingId'],
        path_params=[u'buildingId', u'customer'],
        query_params=[],
        relative_path=u'customer/{customer}/resources/buildings/{buildingId}',
        request_field='',
        request_type_name=u'DirectoryResourcesBuildingsGetRequest',
        response_type_name=u'Building',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Inserts a building.

      Args:
        request: (DirectoryResourcesBuildingsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Building) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'directory.resources.buildings.insert',
        ordered_params=[u'customer'],
        path_params=[u'customer'],
        query_params=[u'coordinatesSource'],
        relative_path=u'customer/{customer}/resources/buildings',
        request_field=u'building',
        request_type_name=u'DirectoryResourcesBuildingsInsertRequest',
        response_type_name=u'Building',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of buildings for an account.

      Args:
        request: (DirectoryResourcesBuildingsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Buildings) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.resources.buildings.list',
        ordered_params=[u'customer'],
        path_params=[u'customer'],
        query_params=[u'maxResults', u'pageToken'],
        relative_path=u'customer/{customer}/resources/buildings',
        request_field='',
        request_type_name=u'DirectoryResourcesBuildingsListRequest',
        response_type_name=u'Buildings',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a building.

      This method supports patch semantics.

      Args:
        request: (DirectoryResourcesBuildingsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Building) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'directory.resources.buildings.patch',
        ordered_params=[u'customer', u'buildingId'],
        path_params=[u'buildingId', u'customer'],
        query_params=[u'coordinatesSource'],
        relative_path=u'customer/{customer}/resources/buildings/{buildingId}',
        request_field=u'building',
        request_type_name=u'DirectoryResourcesBuildingsPatchRequest',
        response_type_name=u'Building',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a building.

      Args:
        request: (DirectoryResourcesBuildingsUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Building) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PUT',
        method_id=u'directory.resources.buildings.update',
        ordered_params=[u'customer', u'buildingId'],
        path_params=[u'buildingId', u'customer'],
        query_params=[u'coordinatesSource'],
        relative_path=u'customer/{customer}/resources/buildings/{buildingId}',
        request_field=u'building',
        request_type_name=u'DirectoryResourcesBuildingsUpdateRequest',
        response_type_name=u'Building',
        supports_download=False,
    )

  class ResourcesCalendarsService(base_api.BaseApiService):
    """Service class for the resources_calendars resource."""

    _NAME = u'resources_calendars'

    def __init__(self, client):
      super(AdminDirectoryV1.ResourcesCalendarsService, self).__init__(client)
      self._upload_configs = {}

    def Delete(self, request, global_params=None):
      r"""Deletes a calendar resource.

      Args:
        request: (DirectoryResourcesCalendarsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (DirectoryResourcesCalendarsDeleteResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'directory.resources.calendars.delete',
        ordered_params=[u'customer', u'calendarResourceId'],
        path_params=[u'calendarResourceId', u'customer'],
        query_params=[],
        relative_path=u'customer/{customer}/resources/calendars/{calendarResourceId}',
        request_field='',
        request_type_name=u'DirectoryResourcesCalendarsDeleteRequest',
        response_type_name=u'DirectoryResourcesCalendarsDeleteResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves a calendar resource.

      Args:
        request: (DirectoryResourcesCalendarsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (CalendarResource) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.resources.calendars.get',
        ordered_params=[u'customer', u'calendarResourceId'],
        path_params=[u'calendarResourceId', u'customer'],
        query_params=[],
        relative_path=u'customer/{customer}/resources/calendars/{calendarResourceId}',
        request_field='',
        request_type_name=u'DirectoryResourcesCalendarsGetRequest',
        response_type_name=u'CalendarResource',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Inserts a calendar resource.

      Args:
        request: (DirectoryResourcesCalendarsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (CalendarResource) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'directory.resources.calendars.insert',
        ordered_params=[u'customer'],
        path_params=[u'customer'],
        query_params=[],
        relative_path=u'customer/{customer}/resources/calendars',
        request_field=u'calendarResource',
        request_type_name=u'DirectoryResourcesCalendarsInsertRequest',
        response_type_name=u'CalendarResource',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of calendar resources for an account.

      Args:
        request: (DirectoryResourcesCalendarsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (CalendarResources) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.resources.calendars.list',
        ordered_params=[u'customer'],
        path_params=[u'customer'],
        query_params=[u'maxResults', u'orderBy', u'pageToken', u'query'],
        relative_path=u'customer/{customer}/resources/calendars',
        request_field='',
        request_type_name=u'DirectoryResourcesCalendarsListRequest',
        response_type_name=u'CalendarResources',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a calendar resource.

This method supports patch semantics, meaning you only need to include the
fields you wish to update. Fields that are not present in the request will be
preserved. This method supports patch semantics.

      Args:
        request: (DirectoryResourcesCalendarsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (CalendarResource) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'directory.resources.calendars.patch',
        ordered_params=[u'customer', u'calendarResourceId'],
        path_params=[u'calendarResourceId', u'customer'],
        query_params=[],
        relative_path=u'customer/{customer}/resources/calendars/{calendarResourceId}',
        request_field=u'calendarResource',
        request_type_name=u'DirectoryResourcesCalendarsPatchRequest',
        response_type_name=u'CalendarResource',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a calendar resource.

This method supports patch semantics, meaning you only need to include the
fields you wish to update. Fields that are not present in the request will be
preserved.

      Args:
        request: (DirectoryResourcesCalendarsUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (CalendarResource) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PUT',
        method_id=u'directory.resources.calendars.update',
        ordered_params=[u'customer', u'calendarResourceId'],
        path_params=[u'calendarResourceId', u'customer'],
        query_params=[],
        relative_path=u'customer/{customer}/resources/calendars/{calendarResourceId}',
        request_field=u'calendarResource',
        request_type_name=u'DirectoryResourcesCalendarsUpdateRequest',
        response_type_name=u'CalendarResource',
        supports_download=False,
    )

  class ResourcesFeaturesService(base_api.BaseApiService):
    """Service class for the resources_features resource."""

    _NAME = u'resources_features'

    def __init__(self, client):
      super(AdminDirectoryV1.ResourcesFeaturesService, self).__init__(client)
      self._upload_configs = {}

    def Delete(self, request, global_params=None):
      r"""Deletes a feature.

      Args:
        request: (DirectoryResourcesFeaturesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (DirectoryResourcesFeaturesDeleteResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'directory.resources.features.delete',
        ordered_params=[u'customer', u'featureKey'],
        path_params=[u'customer', u'featureKey'],
        query_params=[],
        relative_path=u'customer/{customer}/resources/features/{featureKey}',
        request_field='',
        request_type_name=u'DirectoryResourcesFeaturesDeleteRequest',
        response_type_name=u'DirectoryResourcesFeaturesDeleteResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves a feature.

      Args:
        request: (DirectoryResourcesFeaturesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Feature) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.resources.features.get',
        ordered_params=[u'customer', u'featureKey'],
        path_params=[u'customer', u'featureKey'],
        query_params=[],
        relative_path=u'customer/{customer}/resources/features/{featureKey}',
        request_field='',
        request_type_name=u'DirectoryResourcesFeaturesGetRequest',
        response_type_name=u'Feature',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Inserts a feature.

      Args:
        request: (DirectoryResourcesFeaturesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Feature) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'directory.resources.features.insert',
        ordered_params=[u'customer'],
        path_params=[u'customer'],
        query_params=[],
        relative_path=u'customer/{customer}/resources/features',
        request_field=u'feature',
        request_type_name=u'DirectoryResourcesFeaturesInsertRequest',
        response_type_name=u'Feature',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of features for an account.

      Args:
        request: (DirectoryResourcesFeaturesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Features) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.resources.features.list',
        ordered_params=[u'customer'],
        path_params=[u'customer'],
        query_params=[u'maxResults', u'pageToken'],
        relative_path=u'customer/{customer}/resources/features',
        request_field='',
        request_type_name=u'DirectoryResourcesFeaturesListRequest',
        response_type_name=u'Features',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a feature.

      This method supports patch semantics.

      Args:
        request: (DirectoryResourcesFeaturesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Feature) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'directory.resources.features.patch',
        ordered_params=[u'customer', u'featureKey'],
        path_params=[u'customer', u'featureKey'],
        query_params=[],
        relative_path=u'customer/{customer}/resources/features/{featureKey}',
        request_field=u'feature',
        request_type_name=u'DirectoryResourcesFeaturesPatchRequest',
        response_type_name=u'Feature',
        supports_download=False,
    )

    def Rename(self, request, global_params=None):
      r"""Renames a feature.

      Args:
        request: (DirectoryResourcesFeaturesRenameRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (DirectoryResourcesFeaturesRenameResponse) The response message.
      """
      config = self.GetMethodConfig('Rename')
      return self._RunMethod(config, request, global_params=global_params)

    Rename.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'directory.resources.features.rename',
        ordered_params=[u'customer', u'oldName'],
        path_params=[u'customer', u'oldName'],
        query_params=[],
        relative_path=u'customer/{customer}/resources/features/{oldName}/rename',
        request_field=u'featureRename',
        request_type_name=u'DirectoryResourcesFeaturesRenameRequest',
        response_type_name=u'DirectoryResourcesFeaturesRenameResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a feature.

      Args:
        request: (DirectoryResourcesFeaturesUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Feature) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PUT',
        method_id=u'directory.resources.features.update',
        ordered_params=[u'customer', u'featureKey'],
        path_params=[u'customer', u'featureKey'],
        query_params=[],
        relative_path=u'customer/{customer}/resources/features/{featureKey}',
        request_field=u'feature',
        request_type_name=u'DirectoryResourcesFeaturesUpdateRequest',
        response_type_name=u'Feature',
        supports_download=False,
    )

  class ResourcesService(base_api.BaseApiService):
    """Service class for the resources resource."""

    _NAME = u'resources'

    def __init__(self, client):
      super(AdminDirectoryV1.ResourcesService, self).__init__(client)
      self._upload_configs = {}

  class RoleAssignmentsService(base_api.BaseApiService):
    """Service class for the roleAssignments resource."""

    _NAME = u'roleAssignments'

    def __init__(self, client):
      super(AdminDirectoryV1.RoleAssignmentsService, self).__init__(client)
      self._upload_configs = {}

    def Delete(self, request, global_params=None):
      r"""Deletes a role assignment.

      Args:
        request: (DirectoryRoleAssignmentsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (DirectoryRoleAssignmentsDeleteResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'directory.roleAssignments.delete',
        ordered_params=[u'customer', u'roleAssignmentId'],
        path_params=[u'customer', u'roleAssignmentId'],
        query_params=[],
        relative_path=u'customer/{customer}/roleassignments/{roleAssignmentId}',
        request_field='',
        request_type_name=u'DirectoryRoleAssignmentsDeleteRequest',
        response_type_name=u'DirectoryRoleAssignmentsDeleteResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieve a role assignment.

      Args:
        request: (DirectoryRoleAssignmentsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (RoleAssignment) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.roleAssignments.get',
        ordered_params=[u'customer', u'roleAssignmentId'],
        path_params=[u'customer', u'roleAssignmentId'],
        query_params=[],
        relative_path=u'customer/{customer}/roleassignments/{roleAssignmentId}',
        request_field='',
        request_type_name=u'DirectoryRoleAssignmentsGetRequest',
        response_type_name=u'RoleAssignment',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a role assignment.

      Args:
        request: (DirectoryRoleAssignmentsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (RoleAssignment) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'directory.roleAssignments.insert',
        ordered_params=[u'customer'],
        path_params=[u'customer'],
        query_params=[],
        relative_path=u'customer/{customer}/roleassignments',
        request_field=u'roleAssignment',
        request_type_name=u'DirectoryRoleAssignmentsInsertRequest',
        response_type_name=u'RoleAssignment',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a paginated list of all roleAssignments.

      Args:
        request: (DirectoryRoleAssignmentsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (RoleAssignments) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.roleAssignments.list',
        ordered_params=[u'customer'],
        path_params=[u'customer'],
        query_params=[u'maxResults', u'pageToken', u'roleId', u'userKey'],
        relative_path=u'customer/{customer}/roleassignments',
        request_field='',
        request_type_name=u'DirectoryRoleAssignmentsListRequest',
        response_type_name=u'RoleAssignments',
        supports_download=False,
    )

  class RolesService(base_api.BaseApiService):
    """Service class for the roles resource."""

    _NAME = u'roles'

    def __init__(self, client):
      super(AdminDirectoryV1.RolesService, self).__init__(client)
      self._upload_configs = {}

    def Delete(self, request, global_params=None):
      r"""Deletes a role.

      Args:
        request: (DirectoryRolesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (DirectoryRolesDeleteResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'directory.roles.delete',
        ordered_params=[u'customer', u'roleId'],
        path_params=[u'customer', u'roleId'],
        query_params=[],
        relative_path=u'customer/{customer}/roles/{roleId}',
        request_field='',
        request_type_name=u'DirectoryRolesDeleteRequest',
        response_type_name=u'DirectoryRolesDeleteResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves a role.

      Args:
        request: (DirectoryRolesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Role) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.roles.get',
        ordered_params=[u'customer', u'roleId'],
        path_params=[u'customer', u'roleId'],
        query_params=[],
        relative_path=u'customer/{customer}/roles/{roleId}',
        request_field='',
        request_type_name=u'DirectoryRolesGetRequest',
        response_type_name=u'Role',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a role.

      Args:
        request: (DirectoryRolesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Role) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'directory.roles.insert',
        ordered_params=[u'customer'],
        path_params=[u'customer'],
        query_params=[],
        relative_path=u'customer/{customer}/roles',
        request_field=u'role',
        request_type_name=u'DirectoryRolesInsertRequest',
        response_type_name=u'Role',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a paginated list of all the roles in a domain.

      Args:
        request: (DirectoryRolesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Roles) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.roles.list',
        ordered_params=[u'customer'],
        path_params=[u'customer'],
        query_params=[u'maxResults', u'pageToken'],
        relative_path=u'customer/{customer}/roles',
        request_field='',
        request_type_name=u'DirectoryRolesListRequest',
        response_type_name=u'Roles',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a role.

      This method supports patch semantics.

      Args:
        request: (DirectoryRolesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Role) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'directory.roles.patch',
        ordered_params=[u'customer', u'roleId'],
        path_params=[u'customer', u'roleId'],
        query_params=[],
        relative_path=u'customer/{customer}/roles/{roleId}',
        request_field=u'role',
        request_type_name=u'DirectoryRolesPatchRequest',
        response_type_name=u'Role',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a role.

      Args:
        request: (DirectoryRolesUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Role) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PUT',
        method_id=u'directory.roles.update',
        ordered_params=[u'customer', u'roleId'],
        path_params=[u'customer', u'roleId'],
        query_params=[],
        relative_path=u'customer/{customer}/roles/{roleId}',
        request_field=u'role',
        request_type_name=u'DirectoryRolesUpdateRequest',
        response_type_name=u'Role',
        supports_download=False,
    )

  class SchemasService(base_api.BaseApiService):
    """Service class for the schemas resource."""

    _NAME = u'schemas'

    def __init__(self, client):
      super(AdminDirectoryV1.SchemasService, self).__init__(client)
      self._upload_configs = {}

    def Delete(self, request, global_params=None):
      r"""Delete schema.

      Args:
        request: (DirectorySchemasDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (DirectorySchemasDeleteResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'directory.schemas.delete',
        ordered_params=[u'customerId', u'schemaKey'],
        path_params=[u'customerId', u'schemaKey'],
        query_params=[],
        relative_path=u'customer/{customerId}/schemas/{schemaKey}',
        request_field='',
        request_type_name=u'DirectorySchemasDeleteRequest',
        response_type_name=u'DirectorySchemasDeleteResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieve schema.

      Args:
        request: (DirectorySchemasGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Schema) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.schemas.get',
        ordered_params=[u'customerId', u'schemaKey'],
        path_params=[u'customerId', u'schemaKey'],
        query_params=[],
        relative_path=u'customer/{customerId}/schemas/{schemaKey}',
        request_field='',
        request_type_name=u'DirectorySchemasGetRequest',
        response_type_name=u'Schema',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Create schema.

      Args:
        request: (DirectorySchemasInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Schema) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'directory.schemas.insert',
        ordered_params=[u'customerId'],
        path_params=[u'customerId'],
        query_params=[],
        relative_path=u'customer/{customerId}/schemas',
        request_field=u'schema',
        request_type_name=u'DirectorySchemasInsertRequest',
        response_type_name=u'Schema',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieve all schemas for a customer.

      Args:
        request: (DirectorySchemasListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Schemas) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.schemas.list',
        ordered_params=[u'customerId'],
        path_params=[u'customerId'],
        query_params=[],
        relative_path=u'customer/{customerId}/schemas',
        request_field='',
        request_type_name=u'DirectorySchemasListRequest',
        response_type_name=u'Schemas',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Update schema.

      This method supports patch semantics.

      Args:
        request: (DirectorySchemasPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Schema) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'directory.schemas.patch',
        ordered_params=[u'customerId', u'schemaKey'],
        path_params=[u'customerId', u'schemaKey'],
        query_params=[],
        relative_path=u'customer/{customerId}/schemas/{schemaKey}',
        request_field=u'schema',
        request_type_name=u'DirectorySchemasPatchRequest',
        response_type_name=u'Schema',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Update schema.

      Args:
        request: (DirectorySchemasUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Schema) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PUT',
        method_id=u'directory.schemas.update',
        ordered_params=[u'customerId', u'schemaKey'],
        path_params=[u'customerId', u'schemaKey'],
        query_params=[],
        relative_path=u'customer/{customerId}/schemas/{schemaKey}',
        request_field=u'schema',
        request_type_name=u'DirectorySchemasUpdateRequest',
        response_type_name=u'Schema',
        supports_download=False,
    )

  class TokensService(base_api.BaseApiService):
    """Service class for the tokens resource."""

    _NAME = u'tokens'

    def __init__(self, client):
      super(AdminDirectoryV1.TokensService, self).__init__(client)
      self._upload_configs = {}

    def Delete(self, request, global_params=None):
      r"""Delete all access tokens issued by a user for an application.

      Args:
        request: (DirectoryTokensDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (DirectoryTokensDeleteResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'directory.tokens.delete',
        ordered_params=[u'userKey', u'clientId'],
        path_params=[u'clientId', u'userKey'],
        query_params=[],
        relative_path=u'users/{userKey}/tokens/{clientId}',
        request_field='',
        request_type_name=u'DirectoryTokensDeleteRequest',
        response_type_name=u'DirectoryTokensDeleteResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Get information about an access token issued by a user.

      Args:
        request: (DirectoryTokensGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Token) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.tokens.get',
        ordered_params=[u'userKey', u'clientId'],
        path_params=[u'clientId', u'userKey'],
        query_params=[],
        relative_path=u'users/{userKey}/tokens/{clientId}',
        request_field='',
        request_type_name=u'DirectoryTokensGetRequest',
        response_type_name=u'Token',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Returns the set of tokens specified user has issued to 3rd party applications.

      Args:
        request: (DirectoryTokensListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Tokens) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.tokens.list',
        ordered_params=[u'userKey'],
        path_params=[u'userKey'],
        query_params=[],
        relative_path=u'users/{userKey}/tokens',
        request_field='',
        request_type_name=u'DirectoryTokensListRequest',
        response_type_name=u'Tokens',
        supports_download=False,
    )

  class UsersAliasesService(base_api.BaseApiService):
    """Service class for the users_aliases resource."""

    _NAME = u'users_aliases'

    def __init__(self, client):
      super(AdminDirectoryV1.UsersAliasesService, self).__init__(client)
      self._upload_configs = {}

    def Delete(self, request, global_params=None):
      r"""Remove a alias for the user.

      Args:
        request: (DirectoryUsersAliasesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (DirectoryUsersAliasesDeleteResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'directory.users.aliases.delete',
        ordered_params=[u'userKey', u'alias'],
        path_params=[u'alias', u'userKey'],
        query_params=[],
        relative_path=u'users/{userKey}/aliases/{alias}',
        request_field='',
        request_type_name=u'DirectoryUsersAliasesDeleteRequest',
        response_type_name=u'DirectoryUsersAliasesDeleteResponse',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Add a alias for the user.

      Args:
        request: (DirectoryUsersAliasesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Alias) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'directory.users.aliases.insert',
        ordered_params=[u'userKey'],
        path_params=[u'userKey'],
        query_params=[],
        relative_path=u'users/{userKey}/aliases',
        request_field=u'alias',
        request_type_name=u'DirectoryUsersAliasesInsertRequest',
        response_type_name=u'Alias',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List all aliases for a user.

      Args:
        request: (DirectoryUsersAliasesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Aliases) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.users.aliases.list',
        ordered_params=[u'userKey'],
        path_params=[u'userKey'],
        query_params=[u'event'],
        relative_path=u'users/{userKey}/aliases',
        request_field='',
        request_type_name=u'DirectoryUsersAliasesListRequest',
        response_type_name=u'Aliases',
        supports_download=False,
    )

    def Watch(self, request, global_params=None):
      r"""Watch for changes in user aliases list.

      Args:
        request: (DirectoryUsersAliasesWatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Channel) The response message.
      """
      config = self.GetMethodConfig('Watch')
      return self._RunMethod(config, request, global_params=global_params)

    Watch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'directory.users.aliases.watch',
        ordered_params=[u'userKey'],
        path_params=[u'userKey'],
        query_params=[u'event'],
        relative_path=u'users/{userKey}/aliases/watch',
        request_field=u'channel',
        request_type_name=u'DirectoryUsersAliasesWatchRequest',
        response_type_name=u'Channel',
        supports_download=False,
    )

  class UsersPhotosService(base_api.BaseApiService):
    """Service class for the users_photos resource."""

    _NAME = u'users_photos'

    def __init__(self, client):
      super(AdminDirectoryV1.UsersPhotosService, self).__init__(client)
      self._upload_configs = {}

    def Delete(self, request, global_params=None):
      r"""Remove photos for the user.

      Args:
        request: (DirectoryUsersPhotosDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (DirectoryUsersPhotosDeleteResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'directory.users.photos.delete',
        ordered_params=[u'userKey'],
        path_params=[u'userKey'],
        query_params=[],
        relative_path=u'users/{userKey}/photos/thumbnail',
        request_field='',
        request_type_name=u'DirectoryUsersPhotosDeleteRequest',
        response_type_name=u'DirectoryUsersPhotosDeleteResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieve photo of a user.

      Args:
        request: (DirectoryUsersPhotosGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (UserPhoto) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.users.photos.get',
        ordered_params=[u'userKey'],
        path_params=[u'userKey'],
        query_params=[],
        relative_path=u'users/{userKey}/photos/thumbnail',
        request_field='',
        request_type_name=u'DirectoryUsersPhotosGetRequest',
        response_type_name=u'UserPhoto',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Add a photo for the user.

      This method supports patch semantics.

      Args:
        request: (DirectoryUsersPhotosPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (UserPhoto) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'directory.users.photos.patch',
        ordered_params=[u'userKey'],
        path_params=[u'userKey'],
        query_params=[],
        relative_path=u'users/{userKey}/photos/thumbnail',
        request_field=u'userPhoto',
        request_type_name=u'DirectoryUsersPhotosPatchRequest',
        response_type_name=u'UserPhoto',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Add a photo for the user.

      Args:
        request: (DirectoryUsersPhotosUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (UserPhoto) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PUT',
        method_id=u'directory.users.photos.update',
        ordered_params=[u'userKey'],
        path_params=[u'userKey'],
        query_params=[],
        relative_path=u'users/{userKey}/photos/thumbnail',
        request_field=u'userPhoto',
        request_type_name=u'DirectoryUsersPhotosUpdateRequest',
        response_type_name=u'UserPhoto',
        supports_download=False,
    )

  class UsersService(base_api.BaseApiService):
    """Service class for the users resource."""

    _NAME = u'users'

    def __init__(self, client):
      super(AdminDirectoryV1.UsersService, self).__init__(client)
      self._upload_configs = {}

    def Delete(self, request, global_params=None):
      r"""Delete user.

      Args:
        request: (DirectoryUsersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (DirectoryUsersDeleteResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'directory.users.delete',
        ordered_params=[u'userKey'],
        path_params=[u'userKey'],
        query_params=[],
        relative_path=u'users/{userKey}',
        request_field='',
        request_type_name=u'DirectoryUsersDeleteRequest',
        response_type_name=u'DirectoryUsersDeleteResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""retrieve user.

      Args:
        request: (DirectoryUsersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (User) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.users.get',
        ordered_params=[u'userKey'],
        path_params=[u'userKey'],
        query_params=[u'customFieldMask', u'projection', u'viewType'],
        relative_path=u'users/{userKey}',
        request_field='',
        request_type_name=u'DirectoryUsersGetRequest',
        response_type_name=u'User',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""create user.

      Args:
        request: (User) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (User) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'directory.users.insert',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'users',
        request_field='<request>',
        request_type_name=u'User',
        response_type_name=u'User',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieve either deleted users or all users in a domain (paginated).

      Args:
        request: (DirectoryUsersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Users) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.users.list',
        ordered_params=[],
        path_params=[],
        query_params=[
            u'customFieldMask', u'customer', u'domain', u'event', u'maxResults',
            u'orderBy', u'pageToken', u'projection', u'query', u'showDeleted',
            u'sortOrder', u'viewType'
        ],
        relative_path=u'users',
        request_field='',
        request_type_name=u'DirectoryUsersListRequest',
        response_type_name=u'Users',
        supports_download=False,
    )

    def MakeAdmin(self, request, global_params=None):
      r"""change admin status of a user.

      Args:
        request: (DirectoryUsersMakeAdminRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (DirectoryUsersMakeAdminResponse) The response message.
      """
      config = self.GetMethodConfig('MakeAdmin')
      return self._RunMethod(config, request, global_params=global_params)

    MakeAdmin.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'directory.users.makeAdmin',
        ordered_params=[u'userKey'],
        path_params=[u'userKey'],
        query_params=[],
        relative_path=u'users/{userKey}/makeAdmin',
        request_field=u'userMakeAdmin',
        request_type_name=u'DirectoryUsersMakeAdminRequest',
        response_type_name=u'DirectoryUsersMakeAdminResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""update user.

      This method supports patch semantics.

      Args:
        request: (DirectoryUsersPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (User) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'directory.users.patch',
        ordered_params=[u'userKey'],
        path_params=[u'userKey'],
        query_params=[],
        relative_path=u'users/{userKey}',
        request_field=u'user',
        request_type_name=u'DirectoryUsersPatchRequest',
        response_type_name=u'User',
        supports_download=False,
    )

    def Undelete(self, request, global_params=None):
      r"""Undelete a deleted user.

      Args:
        request: (DirectoryUsersUndeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (DirectoryUsersUndeleteResponse) The response message.
      """
      config = self.GetMethodConfig('Undelete')
      return self._RunMethod(config, request, global_params=global_params)

    Undelete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'directory.users.undelete',
        ordered_params=[u'userKey'],
        path_params=[u'userKey'],
        query_params=[],
        relative_path=u'users/{userKey}/undelete',
        request_field=u'userUndelete',
        request_type_name=u'DirectoryUsersUndeleteRequest',
        response_type_name=u'DirectoryUsersUndeleteResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""update user.

      Args:
        request: (DirectoryUsersUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (User) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PUT',
        method_id=u'directory.users.update',
        ordered_params=[u'userKey'],
        path_params=[u'userKey'],
        query_params=[],
        relative_path=u'users/{userKey}',
        request_field=u'user',
        request_type_name=u'DirectoryUsersUpdateRequest',
        response_type_name=u'User',
        supports_download=False,
    )

    def Watch(self, request, global_params=None):
      r"""Watch for changes in users list.

      Args:
        request: (DirectoryUsersWatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (Channel) The response message.
      """
      config = self.GetMethodConfig('Watch')
      return self._RunMethod(config, request, global_params=global_params)

    Watch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'directory.users.watch',
        ordered_params=[],
        path_params=[],
        query_params=[
            u'customFieldMask', u'customer', u'domain', u'event', u'maxResults',
            u'orderBy', u'pageToken', u'projection', u'query', u'showDeleted',
            u'sortOrder', u'viewType'
        ],
        relative_path=u'users/watch',
        request_field=u'channel',
        request_type_name=u'DirectoryUsersWatchRequest',
        response_type_name=u'Channel',
        supports_download=False,
    )

  class VerificationCodesService(base_api.BaseApiService):
    """Service class for the verificationCodes resource."""

    _NAME = u'verificationCodes'

    def __init__(self, client):
      super(AdminDirectoryV1.VerificationCodesService, self).__init__(client)
      self._upload_configs = {}

    def Generate(self, request, global_params=None):
      r"""Generate new backup verification codes for the user.

      Args:
        request: (DirectoryVerificationCodesGenerateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (DirectoryVerificationCodesGenerateResponse) The response message.
      """
      config = self.GetMethodConfig('Generate')
      return self._RunMethod(config, request, global_params=global_params)

    Generate.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'directory.verificationCodes.generate',
        ordered_params=[u'userKey'],
        path_params=[u'userKey'],
        query_params=[],
        relative_path=u'users/{userKey}/verificationCodes/generate',
        request_field='',
        request_type_name=u'DirectoryVerificationCodesGenerateRequest',
        response_type_name=u'DirectoryVerificationCodesGenerateResponse',
        supports_download=False,
    )

    def Invalidate(self, request, global_params=None):
      r"""Invalidate the current backup verification codes for the user.

      Args:
        request: (DirectoryVerificationCodesInvalidateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (DirectoryVerificationCodesInvalidateResponse) The response message.
      """
      config = self.GetMethodConfig('Invalidate')
      return self._RunMethod(config, request, global_params=global_params)

    Invalidate.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'directory.verificationCodes.invalidate',
        ordered_params=[u'userKey'],
        path_params=[u'userKey'],
        query_params=[],
        relative_path=u'users/{userKey}/verificationCodes/invalidate',
        request_field='',
        request_type_name=u'DirectoryVerificationCodesInvalidateRequest',
        response_type_name=u'DirectoryVerificationCodesInvalidateResponse',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Returns the current set of valid backup verification codes for the specified user.

      Args:
        request: (DirectoryVerificationCodesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments

      Returns:
        (VerificationCodes) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'directory.verificationCodes.list',
        ordered_params=[u'userKey'],
        path_params=[u'userKey'],
        query_params=[],
        relative_path=u'users/{userKey}/verificationCodes',
        request_field='',
        request_type_name=u'DirectoryVerificationCodesListRequest',
        response_type_name=u'VerificationCodes',
        supports_download=False,
    )
