/*
 * Decompiled with CFR 0.152.
 */
package com.zabbix.gateway;

import com.zabbix.gateway.ConfigurationManager;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ZabbixJMXConnectorFactory {
    private static final Logger logger = LoggerFactory.getLogger(ZabbixJMXConnectorFactory.class);
    private static final ExecutorService executor = Executors.newCachedThreadPool(new DaemonThreadFactory());

    ZabbixJMXConnectorFactory() {
    }

    static JMXConnector connect(final JMXServiceURL jMXServiceURL, final HashMap<String, Object> hashMap) throws IOException {
        Object e;
        logger.debug("connecting to JMX agent at '{}'", (Object)jMXServiceURL);
        final ArrayBlockingQueue<String> arrayBlockingQueue = new ArrayBlockingQueue<String>(1);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    logger.trace("making a call to JMXConnectorFactory.connect('{}')", (Object)jMXServiceURL);
                    JMXConnector jMXConnector = JMXConnectorFactory.connect(jMXServiceURL, hashMap);
                    logger.trace("call to JMXConnectorFactory.connect('{}') successful", (Object)jMXServiceURL);
                    if (!arrayBlockingQueue.offer(jMXConnector)) {
                        jMXConnector.close();
                    }
                }
                catch (Throwable throwable) {
                    logger.trace("call to JMXConnectorFactory.connect('{}') timed out", (Object)jMXServiceURL);
                    arrayBlockingQueue.offer(throwable);
                }
            }
        };
        executor.submit(runnable);
        try {
            int n = ConfigurationManager.getIntegerParameterValue("timeout");
            e = arrayBlockingQueue.poll(n, TimeUnit.SECONDS);
            if (null == e && !arrayBlockingQueue.offer("")) {
                e = arrayBlockingQueue.take();
            }
            if (null == e) {
                logger.trace("no connector after {} seconds", (Object)n);
            } else {
                logger.trace("connector acquired");
            }
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (InterruptedException interruptedException) {
            InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
            interruptedIOException.initCause(interruptedException);
            throw interruptedIOException;
        }
        if (null == e) {
            throw new SocketTimeoutException("Connection timed out");
        }
        if (e instanceof JMXConnector) {
            return (JMXConnector)e;
        }
        try {
            throw (Throwable)e;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable throwable) {
            throw new IOException(throwable.toString(), throwable);
        }
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private ThreadFactory f = Executors.defaultThreadFactory();

        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = this.f.newThread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    }
}

