/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.baseinfo;

import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.campagnelab.dl.varanalysis.protobuf.SegmentInformationRecords;
import org.campagnelab.goby.baseinfo.BasenameUtils;
import org.campagnelab.goby.compression.ChunkCodec;
import org.campagnelab.goby.compression.FastBufferedMessageChunksReader;
import org.campagnelab.goby.compression.MessageChunksReader;
import org.campagnelab.goby.compression.SequenceSegmentInfoCollectionHandler;
import org.campagnelab.goby.exception.GobyRuntimeException;
import org.campagnelab.goby.reads.ReadCodec;
import org.campagnelab.goby.util.FileExtensionHelper;

public class SequenceSegmentInformationReader
implements Iterator<SegmentInformationRecords.SegmentInformation>,
Iterable<SegmentInformationRecords.SegmentInformation>,
Closeable {
    private MessageChunksReader reader;
    private String basename;
    private String ssiPath;
    private SegmentInformationRecords.SegmentInformationCollection collection;
    private final Properties properties = new Properties();
    private int recordLoadedSoFar;
    private long totalRecords;
    private ReadCodec codec;

    public Properties getProperties() {
        return this.properties;
    }

    public SequenceSegmentInformationReader(String path) throws IOException {
        this(BasenameUtils.getBasename(path, FileExtensionHelper.COMPACT_SEQUENCE_SEGMENT_INFORMATION), FileUtils.openInputStream((File)new File(BasenameUtils.getBasename(path, FileExtensionHelper.COMPACT_SEQUENCE_SEGMENT_INFORMATION) + ".ssi")));
    }

    public SequenceSegmentInformationReader(File file) throws IOException {
        this(BasenameUtils.getBasename(file.getCanonicalPath(), FileExtensionHelper.COMPACT_SEQUENCE_SEGMENT_INFORMATION), FileUtils.openInputStream((File)file));
    }

    public SequenceSegmentInformationReader(String basename, InputStream stream) {
        this.basename = basename;
        this.ssiPath = basename + ".ssi";
        this.reset(basename, stream);
    }

    public SequenceSegmentInformationReader(long start, long end, String path) throws IOException {
        this(start, end, new FastBufferedInputStream((InputStream)FileUtils.openInputStream((File)new File(path))));
    }

    public SequenceSegmentInformationReader(long start, long end, FastBufferedInputStream stream) throws IOException {
        this.reader = new FastBufferedMessageChunksReader(start, end, stream);
        this.reader.setHandler(new SequenceSegmentInfoCollectionHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset(String basename, InputStream stream) {
        this.reader = new MessageChunksReader(stream);
        this.reader.setHandler(new SequenceSegmentInfoCollectionHandler());
        this.codec = null;
        this.collection = null;
        try {
            FileInputStream propertiesStream = new FileInputStream(basename + ".ssip");
            try {
                this.properties.load(propertiesStream);
                this.totalRecords = Integer.parseInt(this.properties.getProperty("numSegments"));
                if (this.properties.getProperty("maxNumOfFeatures") != null && this.properties.getProperty("genotypes.segments.numFeaturesPerBase") == null) {
                    this.properties.setProperty("genotypes.segments.numFeaturesPerBase", this.properties.getProperty("maxNumOfFeatures"));
                }
                if (this.properties.getProperty("maxNumOfBases") != null && this.properties.getProperty("genotypes.segments.maxSequenceLength") == null) {
                    this.properties.setProperty("genotypes.segments.maxSequenceLength", this.properties.getProperty("maxNumOfBases"));
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)propertiesStream);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load properties for " + basename, e);
        }
    }

    public long getRecordsLoadedSoFar() {
        return this.recordLoadedSoFar;
    }

    public long getTotalRecords() {
        return this.totalRecords;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public Iterator<SegmentInformationRecords.SegmentInformation> iterator() {
        try {
            IOUtils.closeQuietly((Closeable)this.reader);
            this.reset(this.basename, FileUtils.openInputStream((File)new File(this.ssiPath)));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to reset iterator", e);
        }
        return this;
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = this.reader.hasNext(this.collection, this.collection != null ? this.collection.getRecordsCount() : 0);
        byte[] compressedBytes = this.reader.getCompressedBytes();
        ChunkCodec chunkCodec = this.reader.getChunkCodec();
        try {
            if (compressedBytes != null) {
                this.collection = (SegmentInformationRecords.SegmentInformationCollection)chunkCodec.decode(compressedBytes);
                if (this.codec != null) {
                    this.codec.newChunk();
                }
                if (this.collection == null || this.collection.getRecordsCount() == 0) {
                    return false;
                }
            }
        }
        catch (IOException e) {
            throw new GobyRuntimeException(e);
        }
        return hasNext;
    }

    @Override
    public SegmentInformationRecords.SegmentInformation next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        SegmentInformationRecords.SegmentInformation record = this.collection.getRecords(this.reader.incrementEntryIndex());
        ++this.recordLoadedSoFar;
        return record;
    }

    public String getBasename(String filename) {
        return BasenameUtils.getBasename(filename, FileExtensionHelper.COMPACT_SEQUENCE_SEGMENT_INFORMATION);
    }
}

