/*
 * Decompiled with CFR 0.152.
 */
package free.util.zip;

import free.util.ChildClassLoader;
import free.util.zip.ZipURLStreamHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ZipClassLoader
extends ChildClassLoader {
    private final ZipFile zipFile;

    public ZipClassLoader(File file, ChildClassLoader childClassLoader) throws ZipException, IOException {
        super(childClassLoader);
        this.zipFile = new ZipFile(file);
    }

    public ZipClassLoader(File file) throws ZipException, IOException {
        this(file, null);
    }

    protected InputStream getResourceAsStreamImpl(String string) {
        try {
            ZipEntry zipEntry = this.zipFile.getEntry(string);
            if (zipEntry == null) {
                return null;
            }
            return this.zipFile.getInputStream(zipEntry);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected URL getResourceImpl(String string) {
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        if ("".equals(string) || this.zipFile.getEntry(string) != null) {
            return ZipURLStreamHandler.createURL(this.zipFile.getName(), string);
        }
        return null;
    }
}

