
package WSNotification::Attributes::id;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'http://www.w3.org/XML/1998/namespace' }

__PACKAGE__->__set_name('id');
__PACKAGE__->__set_ref();
use base qw(
    SOAP::WSDL::XSD::Typelib::Attribute
    SOAP::WSDL::XSD::Typelib::Builtin::ID
);

}

1;


=pod

=head1 NAME

WSNotification::Attributes::id

=head1 DESCRIPTION

Perl data type class for the XML Schema defined attribute
id from the namespace http://www.w3.org/XML/1998/namespace.

http://www.w3.org/TR/xml-id/ for information about this attribute. 





=head1 METHODS

=head2 new

 my $element = WSNotification::Attributes::id->new($data);

Constructor. The following data structure may be passed to new():

 { value => $value }

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

