/*
 * Decompiled with CFR 0.152.
 */
package phase;

import blbutil.BitList;
import java.util.Random;
import java.util.stream.IntStream;
import phase.FixedPhaseData;
import phase.PbwtRecPhaser;
import vcf.GT;

public class RevPbwtPhaser {
    private final GT targGT;
    private final int start;
    private final int end;
    private final int[] bitsPerAllele;
    private final BitList[] markerToBits;

    public RevPbwtPhaser(FixedPhaseData fixedPhaseData, int n2, int n3, long l) {
        if (n2 < 0 || n3 > fixedPhaseData.stage1TargGT().nMarkers() || n2 >= n3) {
            throw new IllegalArgumentException(String.valueOf(n2));
        }
        this.targGT = fixedPhaseData.stage1TargGT();
        this.start = n2;
        this.end = n3;
        this.bitsPerAllele = IntStream.range(n2, n3).map(n -> this.targGT.markers().marker(n).bitsPerAllele()).toArray();
        this.markerToBits = RevPbwtPhaser.phase(fixedPhaseData, n2, n3, l);
    }

    private static BitList[] phase(FixedPhaseData fixedPhaseData, int n, int n2, long l) {
        Random random = new Random(l);
        int n3 = fixedPhaseData.stage1Overlap();
        GT gT = fixedPhaseData.stage1TargGT();
        PbwtRecPhaser pbwtRecPhaser = new PbwtRecPhaser(fixedPhaseData);
        boolean[] blArray = new boolean[gT.nSamples()];
        boolean[] blArray2 = new boolean[gT.nSamples()];
        int[] nArray = new int[fixedPhaseData.nHaps()];
        BitList[] bitListArray = new BitList[n2 - n];
        int n4 = -1;
        int n5 = n2 - 1;
        while (n5 >= n) {
            int[] nArray2 = pbwtRecPhaser.phase(n4, nArray, n5, blArray, blArray2);
            if (n5 >= n3) {
                RevPbwtPhaser.finishPhasing(nArray, blArray2, nArray2, random);
            }
            bitListArray[n5 - n] = RevPbwtPhaser.storePhasing(gT, n5, nArray);
            n4 = n5--;
        }
        return bitListArray;
    }

    private static void finishPhasing(int[] nArray, boolean[] blArray, int[] nArray2, Random random) {
        for (int i = 0; i < blArray.length; ++i) {
            int n = i << 1;
            int n2 = n | 1;
            if (blArray[i]) {
                int n3 = nArray[n];
                int n4 = nArray[n2];
                if (random.nextBoolean()) {
                    nArray[n] = n4;
                    nArray[n2] = n3;
                }
                blArray[i] = false;
                continue;
            }
            if (nArray[n] == -1) {
                nArray[n] = RevPbwtPhaser.imputeAllele(nArray2, random);
            }
            if (nArray[n2] != -1) continue;
            nArray[n2] = RevPbwtPhaser.imputeAllele(nArray2, random);
        }
    }

    private static int imputeAllele(int[] nArray, Random random) {
        int n = random.nextInt(nArray[nArray.length - 1]);
        int n2 = 0;
        while (n >= nArray[n2]) {
            ++n2;
        }
        return n2;
    }

    private static BitList storePhasing(GT gT, int n, int[] nArray) {
        int n2 = gT.nHaps();
        int n3 = gT.markers().marker(n).bitsPerAllele();
        BitList bitList = new BitList(n2 * n3);
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5 = 1;
            int n6 = 0;
            while (n6 < n3) {
                if ((nArray[i] & n5) == n5) {
                    bitList.set(n4);
                }
                n5 <<= 1;
                ++n6;
                ++n4;
            }
        }
        return bitList;
    }

    public GT targGT() {
        return this.targGT;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public int bitsPerAllele(int n) {
        return this.bitsPerAllele[n - this.start];
    }

    public int allele(int n, int n2) {
        int n3 = this.bitsPerAllele[n - this.start];
        int n4 = n2 * n3;
        BitList bitList = this.markerToBits[n - this.start];
        if (n3 == 1) {
            return bitList.get(n4) ? 1 : 0;
        }
        int n5 = 0;
        int n6 = 1;
        int n7 = n4 + n3;
        for (int i = n4; i < n7; ++i) {
            if (bitList.get(i)) {
                n5 |= n6;
            }
            n6 <<= 1;
        }
        return n5;
    }
}

