/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import blbutil.BitList;
import java.util.stream.IntStream;
import vcf.GTRec;
import vcf.Marker;
import vcf.Markers;
import vcf.Samples;
import vcf.XRefGT;

public final class BitSetRefGTRec
implements GTRec {
    private final int bitsPerAllele;
    private final Marker marker;
    private final Samples samples;
    private final BitList alleles;

    public static BitSetRefGTRec[] toBitSetRefGTRecs(XRefGT xRefGT, int n2) {
        Markers markers = xRefGT.markers();
        Samples samples = xRefGT.samples();
        BitList[] bitListArray = xRefGT.toBitLists(n2);
        return (BitSetRefGTRec[])IntStream.range(0, bitListArray.length).parallel().mapToObj(n -> new BitSetRefGTRec(markers.marker(n), samples, bitListArray[n])).toArray(BitSetRefGTRec[]::new);
    }

    private BitSetRefGTRec(Marker marker, Samples samples, BitList bitList) {
        this.bitsPerAllele = marker.bitsPerAllele();
        this.marker = marker;
        this.samples = samples;
        this.alleles = bitList;
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public int size() {
        return this.samples.size() << 1;
    }

    @Override
    public Marker marker() {
        return this.marker;
    }

    @Override
    public boolean isPhased() {
        return true;
    }

    @Override
    public boolean isPhased(int n) {
        return true;
    }

    @Override
    public int allele1(int n) {
        return this.allele(n << 1);
    }

    @Override
    public int allele2(int n) {
        return this.allele(n << 1 | 1);
    }

    @Override
    public int get(int n) {
        return this.allele(n);
    }

    private int allele(int n) {
        int n2 = this.bitsPerAllele * n;
        int n3 = n2 + this.bitsPerAllele;
        int n4 = 0;
        int n5 = 1;
        for (int i = n2; i < n3; ++i) {
            if (this.alleles.get(i)) {
                n4 += n5;
            }
            n5 <<= 1;
        }
        return n4;
    }

    @Override
    public int[] alleles() {
        return IntStream.range(0, this.size()).map(n -> this.get(n)).toArray();
    }

    public String toString() {
        return GTRec.toVcfRec(this);
    }
}

