// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _TDocStd_Application_HeaderFile
#define _TDocStd_Application_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_TDocStd_Application.hxx>

#include <Handle_Resource_Manager.hxx>
#include <Standard_Boolean.hxx>
#include <CDF_Application.hxx>
#include <Standard_CString.hxx>
#include <Standard_Integer.hxx>
#include <Handle_TDocStd_Document.hxx>
#include <PCDM_ReaderStatus.hxx>
#include <PCDM_StoreStatus.hxx>
class Resource_Manager;
class Standard_NoSuchObject;
class TDocStd_Document;
class TColStd_SequenceOfExtendedString;
class TCollection_ExtendedString;



//! The abstract root class for all application classes.
//! They are in charge of:
//! -   Creating documents
//! -   Storing documents and retrieving them
//! -   Initializing document views.
//! To create a useful OCAF-based application, you
//! derive a class from Application and implement
//! the methods below. You will have to redefine the
//! deferred (virtual) methods Formats,
//! InitDocument, and Resources, and override others.
//! The application is a container for a document,
//! which in its turn is the container of the data
//! framework made up of labels and attributes.
//! Besides furnishing a container for documents,
//! TDocStd_Application provides the following
//! services for them:
//! -   Creation of new documents
//! -   Activation of documents in sessions of an application
//! -   Storage and retrieval of documents
//! -   Initialization of document views.
//! Note:
//! If a client needs detailed information concerning
//! the events during the Open/Store operation, MessageDriver
//! inherited from CDM_MessageDriver of the
//! corresponding application has to be implemented.
//! If the MessageDriver is not defined all messages
//! will be (by default) directed to
//! CDM_NullMessageDriver and will be lost.
class TDocStd_Application : public CDF_Application
{

public:

  
  //! Check if meta data driver was successfully loaded
  //! by the application constructor
  Standard_EXPORT   Standard_Boolean IsDriverLoaded()  const;
  
  //! create  (if  not done)  a Manager  using ResourcesName
  //! method.
  Standard_EXPORT virtual   Handle(Resource_Manager) Resources() ;
  
  //! Returns the name of the file containing the
  //! resources of this application.
  //! In a resource file, the application associates the schema name
  //! of the document with the storage and
  //! retrieval plug-ins that are to be loaded for each
  //! document. On retrieval, the application reads the
  //! schema name in the heading of the CSF file and
  //! loads the plug-in indicated in the resource file.
  //! This plug-in instantiates the actual driver for
  //! transient-persistent conversion.
  //! Your application can bring this process into play
  //! by defining a class which inherits
  //! CDF_Application and redefines the function
  //! which returns the appropriate resources file. At
  //! this point, the function Retrieve and the class
  //! CDF_Store can be called. This allows you to
  //! deal with storage and retrieval of - as well as
  //! copying and pasting - documents.
  //! To implement a class like this, several virtual
  //! functions should be redefined. In particular, you
  //! must redefine the abstract function Resources
  //! inherited from the superclass CDM_Application.
  Standard_EXPORT virtual   Standard_CString ResourcesName()  = 0;
  
  //! returns the number of documents handled by the current applicative session.
  Standard_EXPORT   Standard_Integer NbDocuments()  const;
  
  //! Constructs the new document aDoc.
  //! aDoc is identified by the index index which is
  //! any integer between 1 and n where n is the
  //! number of documents returned by NbDocument.
  //! Example
  //! Handle(TDocStd_Application)
  //! anApp;
  //! if (!CafTest::Find(A)) return 1;
  //! Handle(TDocStd) aDoc;
  //! Standard_Integer nbdoc = anApp->NbDocuments();
  //! for (Standard_Integer i = 1; i <= nbdoc; i++) {
  //! aApp->GetDocument(i,aDoc);
  Standard_EXPORT   void GetDocument (const Standard_Integer index, Handle(TDocStd_Document)& aDoc)  const;
  

  //! Returns the format name Formats
  //! representing the format supported for
  //! application documents.
  //! This virtual function is to be redefined for each
  //! specific application.
  Standard_EXPORT virtual   void Formats (TColStd_SequenceOfExtendedString& Formats)  = 0;
  
  //! Constructs the empty new document aDoc.
  //! This document will have the format format.
  //! If InitDocument is redefined for a specific
  //! application, the new document is handled by the
  //! applicative session.
  Standard_EXPORT virtual   void NewDocument (const TCollection_ExtendedString& format, Handle(TDocStd_Document)& aDoc) ;
  
  //! Initialize the document aDoc for the applicative session.
  //! This virtual function is called by NewDocument
  //! and is to be redefined for each specific application.
  //! Modified flag (different of disk version)
  //! =============
  //! to open/save a document
  //! =======================
  Standard_EXPORT virtual   void InitDocument (const Handle(TDocStd_Document)& aDoc)  const;
  
  //! Close the given document. the document is not any more
  //! handled by the applicative session.
  Standard_EXPORT   void Close (const Handle(TDocStd_Document)& aDoc) ;
  
  //! Returns an index for the document found in the
  //! path path in this applicative session.
  //! If the returned value is 0, the document is not
  //! present in the applicative session.
  //! This method can be used for the interactive part
  //! of an application. For instance, on a call to
  //! Open, the document to be opened may already
  //! be in memory. IsInSession checks to see if this
  //! is the case. Open can be made to depend on
  //! the value of the index returned: if IsInSession
  //! returns 0, the document is opened; if it returns
  //! another value, a message is displayed asking the
  //! user if he wants to override the version of the
  //! document in memory.
  //! Example:
  //! Standard_Integer insession = A->IsInSession(aDoc);
  //! if (insession > 0) {
  //! cout << "document " << insession << " is already in session" << endl;
  //! return 0;
  //! }
  Standard_EXPORT   Standard_Integer IsInSession (const TCollection_ExtendedString& path)  const;
  
  //! Retrieves the document aDoc stored under the
  //! name aName in the directory directory.
  //! In order not to override a version of aDoc which
  //! is already in memory, this method can be made
  //! to depend on the value returned by IsInSession.
  Standard_EXPORT   PCDM_ReaderStatus Open (const TCollection_ExtendedString& path, Handle(TDocStd_Document)& aDoc) ;
  
  //! Save the  active document  in the file  <name> in the
  //! path <path> ; o verwrites  the file  if  it already exists.
  Standard_EXPORT   PCDM_StoreStatus SaveAs (const Handle(TDocStd_Document)& aDoc, const TCollection_ExtendedString& path) ;
  
  //! Save aDoc active document.
  //! Exceptions:
  //! Standard_NotImplemented if the document
  //! was not retrieved in the applicative session by using Open.
  Standard_EXPORT   PCDM_StoreStatus Save (const Handle(TDocStd_Document)& aDoc) ;
  
  //! Save the  active document  in the file  <name> in the
  //! path <path>  .  overwrite  the file  if  it
  //! already exist.
  Standard_EXPORT   PCDM_StoreStatus SaveAs (const Handle(TDocStd_Document)& aDoc, const TCollection_ExtendedString& path, TCollection_ExtendedString& theStatusMessage) ;
  
  //! Save the document overwriting the previous file
  Standard_EXPORT   PCDM_StoreStatus Save (const Handle(TDocStd_Document)& aDoc, TCollection_ExtendedString& theStatusMessage) ;


friend class TDocStd_Document;


  DEFINE_STANDARD_RTTI(TDocStd_Application)

protected:

  
  Standard_EXPORT TDocStd_Application();
  
  //! Notification that is fired at each OpenTransaction event.
  Standard_EXPORT virtual   void OnOpenTransaction (const Handle(TDocStd_Document)& theDoc) ;
  
  //! Notification that is fired at each CommitTransaction event.
  Standard_EXPORT virtual   void OnCommitTransaction (const Handle(TDocStd_Document)& theDoc) ;
  
  //! Notification that is fired at each AbortTransaction event.
  Standard_EXPORT virtual   void OnAbortTransaction (const Handle(TDocStd_Document)& theDoc) ;

  Handle(Resource_Manager) myResources;
  Standard_Boolean myIsDriverLoaded;


private: 




};







#endif // _TDocStd_Application_HeaderFile
