/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.NullManagerParameters;
import gnu.javax.net.ssl.StaticTrustAnchors;
import gnu.javax.net.ssl.provider.Util;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;
import javax.net.ssl.X509TrustManager;

public class X509TrustManagerFactory
extends TrustManagerFactorySpi {
    private static final String JSSE_CERTS = Util.getProperty("java.home") + Util.getProperty("file.separator") + "lib" + Util.getProperty("file.separator") + "security" + Util.getProperty("file.separator") + "jssecerts";
    private static final String CA_CERTS = Util.getProperty("java.home") + Util.getProperty("file.separator") + "lib" + Util.getProperty("file.separator") + "security" + Util.getProperty("file.separator") + "cacerts";
    private Manager current;

    protected TrustManager[] engineGetTrustManagers() {
        if (this.current == null) {
            throw new IllegalStateException("not initialized");
        }
        return new TrustManager[]{this.current};
    }

    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
        if (managerFactoryParameters instanceof StaticTrustAnchors) {
            this.current = new Manager(((StaticTrustAnchors)managerFactoryParameters).getCertificates());
        } else if (managerFactoryParameters instanceof NullManagerParameters) {
            this.current = new Manager(new X509Certificate[0]);
        } else {
            throw new InvalidAlgorithmParameterException();
        }
    }

    protected void engineInit(KeyStore keyStore) throws KeyStoreException {
        String string;
        Object object;
        Object object2;
        if (keyStore == null) {
            object2 = Util.getProperty("javax.net.ssl.trustStoreType");
            if (object2 == null) {
                object2 = KeyStore.getDefaultType();
            }
            keyStore = KeyStore.getInstance((String)object2);
            try {
                object2 = Util.getProperty("javax.net.ssl.trustStore");
                object = null;
                if (object2 == null) {
                    try {
                        object = new FileInputStream(JSSE_CERTS);
                    }
                    catch (IOException iOException) {
                        object = new FileInputStream(CA_CERTS);
                    }
                } else {
                    object = new FileInputStream((String)object2);
                }
                keyStore.load((InputStream)object, (string = Util.getProperty("javax.net.ssl.trustStorePassword")) != null ? string.toCharArray() : null);
            }
            catch (IOException iOException) {
                throw new KeyStoreException(iOException.toString());
            }
            catch (CertificateException certificateException) {
                throw new KeyStoreException(certificateException.toString());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new KeyStoreException(noSuchAlgorithmException.toString());
            }
        }
        object2 = new LinkedList();
        object = keyStore.aliases();
        while (object.hasMoreElements()) {
            Certificate certificate;
            string = (String)object.nextElement();
            if (!keyStore.isCertificateEntry(string) || !((certificate = keyStore.getCertificate(string)) instanceof X509Certificate)) continue;
            ((LinkedList)object2).add(certificate);
        }
        this.current = new Manager((X509Certificate[])((LinkedList)object2).toArray(new X509Certificate[((LinkedList)object2).size()]));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Manager
    implements X509TrustManager {
        private final X509Certificate[] trusted;

        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            this.checkTrusted(x509CertificateArray, string);
        }

        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            this.checkTrusted(x509CertificateArray, string);
        }

        public X509Certificate[] getAcceptedIssuers() {
            if (this.trusted == null) {
                return new X509Certificate[0];
            }
            return (X509Certificate[])this.trusted.clone();
        }

        private final void checkTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            x509CertificateArray[0].checkValidity();
            int n = 1;
            while (n < x509CertificateArray.length) {
                x509CertificateArray[n].checkValidity();
                try {
                    x509CertificateArray[n - 1].verify(x509CertificateArray[n].getPublicKey());
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new CertificateException(noSuchAlgorithmException.toString());
                }
                catch (NoSuchProviderException noSuchProviderException) {
                    throw new CertificateException(noSuchProviderException.toString());
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new CertificateException(invalidKeyException.toString());
                }
                catch (SignatureException signatureException) {
                    throw new CertificateException(signatureException.toString());
                }
                ++n;
            }
            if (this.trusted == null || this.trusted.length == 0) {
                throw new CertificateException("no trust anchors");
            }
            n = 0;
            while (n < this.trusted.length) {
                try {
                    this.trusted[n].checkValidity();
                    x509CertificateArray[x509CertificateArray.length - 1].verify(this.trusted[n].getPublicKey());
                    return;
                }
                catch (Exception exception) {
                    ++n;
                }
            }
            throw new CertificateException();
        }

        Manager(X509Certificate[] x509CertificateArray) {
            this.trusted = x509CertificateArray;
        }
    }
}

