/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.security.auth.callback;

import gnu.javax.security.auth.callback.AbstractCallbackHandler;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Locale;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.LanguageCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;

public class AWTCallbackHandler
extends AbstractCallbackHandler
implements ActionListener,
WindowListener {
    private static final String ACTION_CANCEL = "CANCEL";
    private static final String ACTION_NO = "NO";
    private static final String ACTION_NONE = "NONE";
    private static final String ACTION_OK = "OK";
    private static final String ACTION_YES = "YES";
    protected String actionCommand = "NONE";

    protected synchronized void handleChoice(ChoiceCallback choiceCallback) {
        Frame frame = new Frame();
        Dialog dialog = new Dialog(frame);
        String[] stringArray = choiceCallback.getChoices();
        dialog.setTitle(choiceCallback.getPrompt());
        Label label = new Label(choiceCallback.getPrompt());
        List list2 = new List(Math.min(5, stringArray.length), choiceCallback.allowMultipleSelections());
        Panel panel = new Panel();
        Button button = new Button(this.messages.getString("callback.ok"));
        button.setActionCommand(ACTION_OK);
        button.addActionListener(this);
        Button button2 = new Button(this.messages.getString("callback.cancel"));
        button2.setActionCommand(ACTION_CANCEL);
        button2.addActionListener(this);
        int n = 0;
        while (n < stringArray.length) {
            list2.add(stringArray[n]);
            ++n;
        }
        if (choiceCallback.getDefaultChoice() >= 0 && choiceCallback.getDefaultChoice() < stringArray.length) {
            list2.select(choiceCallback.getDefaultChoice());
        }
        dialog.setLayout(new BorderLayout());
        dialog.add((Component)label, "North");
        dialog.add((Component)list2, "Center");
        panel.setLayout(new FlowLayout(2));
        panel.add(button2);
        panel.add(button);
        dialog.add((Component)panel, "South");
        dialog.pack();
        dialog.show();
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {}
        if (this.actionCommand.equals(ACTION_OK)) {
            if (choiceCallback.allowMultipleSelections()) {
                choiceCallback.setSelectedIndexes(list2.getSelectedIndexes());
            } else {
                choiceCallback.setSelectedIndex(list2.getSelectedIndex());
            }
        }
        dialog.dispose();
        frame.dispose();
    }

    protected synchronized void handleConfirmation(ConfirmationCallback confirmationCallback) {
        int n;
        Frame frame = new Frame();
        Dialog dialog = new Dialog(frame);
        switch (confirmationCallback.getMessageType()) {
            case 2: {
                dialog.setTitle(this.messages.getString("callback.error"));
                break;
            }
            case 0: {
                dialog.setTitle(this.messages.getString("callback.information"));
                break;
            }
            case 1: {
                dialog.setTitle(this.messages.getString("callback.warning"));
                break;
            }
            default: {
                dialog.setTitle("");
            }
        }
        dialog.setLayout(new GridLayout(2, 1));
        dialog.add(new Label(confirmationCallback.getPrompt()));
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(2));
        dialog.add(panel);
        String[] stringArray = null;
        int[] nArray = null;
        switch (confirmationCallback.getOptionType()) {
            case 2: {
                stringArray = new String[]{this.messages.getString("callback.cancel"), this.messages.getString("callback.ok")};
                nArray = new int[]{2, 3};
                break;
            }
            case 1: {
                stringArray = new String[]{this.messages.getString("callback.cancel"), this.messages.getString("callback.no"), this.messages.getString("callback.yes")};
                int[] nArray2 = new int[3];
                nArray2[0] = 2;
                nArray2[1] = 1;
                nArray = nArray2;
                break;
            }
            case 0: {
                stringArray = new String[]{this.messages.getString("callback.no"), this.messages.getString("callback.yes")};
                int[] nArray3 = new int[2];
                nArray3[0] = 1;
                nArray = nArray3;
                break;
            }
            case -1: {
                stringArray = confirmationCallback.getOptions();
                nArray = new int[stringArray.length];
                n = 0;
                while (n < nArray.length) {
                    nArray[n] = n;
                    ++n;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        n = 0;
        while (n < stringArray.length) {
            Button button = new Button(stringArray[n]);
            button.setActionCommand(stringArray[n]);
            button.addActionListener(this);
            panel.add(button);
            ++n;
        }
        dialog.pack();
        dialog.show();
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {}
        n = 0;
        while (n < stringArray.length) {
            if (this.actionCommand.equals(stringArray[n])) {
                confirmationCallback.setSelectedIndex(nArray[n]);
                break;
            }
            ++n;
        }
        dialog.dispose();
        frame.dispose();
    }

    protected synchronized void handleLanguage(LanguageCallback languageCallback) {
        int n;
        Locale[] localeArray = Locale.getAvailableLocales();
        String[] stringArray = new String[localeArray.length];
        Locale locale = Locale.getDefault();
        int n2 = 0;
        int n3 = 0;
        while (n3 < localeArray.length) {
            StringBuffer stringBuffer = new StringBuffer(localeArray[n3].getDisplayLanguage(localeArray[n3]));
            String string = localeArray[n3].getDisplayCountry(localeArray[n3]);
            String string2 = localeArray[n3].getDisplayVariant(localeArray[n3]);
            if (string.length() > 0 && string2.length() > 0) {
                stringBuffer.append(" (");
                stringBuffer.append(string);
                stringBuffer.append(", ");
                stringBuffer.append(string2);
                stringBuffer.append(")");
            } else if (string.length() > 0) {
                stringBuffer.append(" (");
                stringBuffer.append(string);
                stringBuffer.append(")");
            } else if (string2.length() > 0) {
                stringBuffer.append(" (");
                stringBuffer.append(string2);
                stringBuffer.append(")");
            }
            stringArray[n3] = stringBuffer.toString();
            if (localeArray[n3].equals(locale)) {
                n2 = n3;
            }
            ++n3;
        }
        ChoiceCallback choiceCallback = new ChoiceCallback(this.messages.getString("callback.language"), stringArray, n2, false);
        this.handleChoice(choiceCallback);
        languageCallback.setLocale(locale);
        if (choiceCallback.getSelectedIndexes() != null && choiceCallback.getSelectedIndexes().length > 0 && (n = choiceCallback.getSelectedIndexes()[0]) >= 0 && n < localeArray.length) {
            languageCallback.setLocale(localeArray[n]);
        }
    }

    protected synchronized void handleName(NameCallback nameCallback) {
        Frame frame = new Frame();
        Dialog dialog = new Dialog(frame);
        dialog.setTitle(nameCallback.getPrompt());
        dialog.setLayout(new GridLayout(3, 1));
        Label label = new Label(nameCallback.getPrompt());
        TextField textField = new TextField();
        if (nameCallback.getDefaultName() != null) {
            textField.setText(nameCallback.getDefaultName());
        }
        Panel panel = new Panel();
        Button button = new Button(this.messages.getString("callback.ok"));
        button.setActionCommand(ACTION_OK);
        button.addActionListener(this);
        Button button2 = new Button(this.messages.getString("callback.cancel"));
        button2.setActionCommand(ACTION_CANCEL);
        button2.addActionListener(this);
        dialog.add(label);
        dialog.add(textField);
        panel.setLayout(new FlowLayout(2));
        panel.add(button);
        panel.add(button2);
        dialog.add(panel);
        dialog.pack();
        dialog.show();
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {}
        if (this.actionCommand.equals(ACTION_OK)) {
            nameCallback.setName(textField.getText());
        }
        dialog.dispose();
        frame.dispose();
    }

    protected synchronized void handlePassword(PasswordCallback passwordCallback) {
        Frame frame = new Frame();
        Dialog dialog = new Dialog(frame);
        dialog.setTitle(passwordCallback.getPrompt());
        dialog.setLayout(new GridLayout(3, 1));
        Label label = new Label(passwordCallback.getPrompt());
        TextField textField = new TextField();
        if (!passwordCallback.isEchoOn()) {
            textField.setEchoChar('*');
        }
        Panel panel = new Panel();
        Button button = new Button(this.messages.getString("callback.ok"));
        button.setActionCommand(ACTION_OK);
        button.addActionListener(this);
        Button button2 = new Button(this.messages.getString("callback.cancel"));
        button2.setActionCommand(ACTION_CANCEL);
        button2.addActionListener(this);
        dialog.add(label);
        dialog.add(textField);
        panel.setLayout(new FlowLayout(2));
        panel.add(button);
        panel.add(button2);
        dialog.add(panel);
        dialog.pack();
        dialog.show();
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {}
        if (this.actionCommand.equals(ACTION_OK)) {
            passwordCallback.setPassword(textField.getText().toCharArray());
        }
        dialog.dispose();
        frame.dispose();
    }

    protected synchronized void handleTextInput(TextInputCallback textInputCallback) {
        Frame frame = new Frame();
        Dialog dialog = new Dialog(frame);
        dialog.setTitle(textInputCallback.getPrompt());
        dialog.setLayout(new BorderLayout());
        Label label = new Label(textInputCallback.getPrompt());
        TextArea textArea = new TextArea(10, 40);
        if (textInputCallback.getDefaultText() != null) {
            textArea.setText(textInputCallback.getDefaultText());
        }
        Panel panel = new Panel();
        Button button = new Button(this.messages.getString("callback.ok"));
        button.setActionCommand(ACTION_OK);
        button.addActionListener(this);
        Button button2 = new Button(this.messages.getString("callback.cancel"));
        button2.setActionCommand(ACTION_CANCEL);
        button2.addActionListener(this);
        dialog.add((Component)label, "North");
        dialog.add((Component)textArea, "Center");
        panel.setLayout(new FlowLayout(2));
        panel.add(button);
        panel.add(button2);
        dialog.add((Component)panel, "South");
        dialog.pack();
        dialog.show();
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {}
        if (this.actionCommand.equals(ACTION_OK)) {
            textInputCallback.setText(textArea.getText());
        }
        dialog.dispose();
        frame.dispose();
    }

    protected synchronized void handleTextOutput(TextOutputCallback textOutputCallback) {
        Frame frame = new Frame();
        Dialog dialog = new Dialog(frame);
        dialog.setLayout(new GridLayout(2, 1));
        switch (textOutputCallback.getMessageType()) {
            case 2: {
                dialog.setTitle(this.messages.getString("callback.error"));
                break;
            }
            case 0: {
                dialog.setTitle(this.messages.getString("callback.information"));
                break;
            }
            case 1: {
                dialog.setTitle(this.messages.getString("callback.warning"));
                break;
            }
            default: {
                dialog.setTitle("");
            }
        }
        Label label = new Label(textOutputCallback.getMessage());
        Panel panel = new Panel();
        Button button = new Button(this.messages.getString("callback.ok"));
        panel.setLayout(new FlowLayout(2));
        panel.add(button);
        button.addActionListener(this);
        dialog.add(label);
        dialog.add(panel);
        dialog.pack();
        dialog.show();
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {}
        dialog.dispose();
        frame.dispose();
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        this.actionCommand = actionEvent.getActionCommand();
        this.notifyAll();
    }

    public synchronized void windowClosing(WindowEvent windowEvent) {
        this.actionCommand = ACTION_NONE;
        this.notifyAll();
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public AWTCallbackHandler() {
        super("AWT");
    }
}

