/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled.file;

import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.file.AudioOutputStream;
import org.tritonus.share.sampled.file.TDataOutputStream;

public abstract class TAudioOutputStream
implements AudioOutputStream {
    private AudioFormat m_audioFormat;
    private long m_lLength;
    private long m_lCalculatedLength;
    private TDataOutputStream m_dataOutputStream;
    private boolean m_bDoBackPatching;
    private boolean m_bHeaderWritten;

    public AudioFormat getFormat() {
        return this.m_audioFormat;
    }

    public long getLength() {
        return this.m_lLength;
    }

    public long getCalculatedLength() {
        return this.m_lCalculatedLength;
    }

    protected TDataOutputStream getDataOutputStream() {
        return this.m_dataOutputStream;
    }

    public int write(byte[] byArray, int n, int n2) throws IOException {
        long l;
        if (TDebug.TraceAudioOutputStream) {
            TDebug.out("TAudioOutputStream.write(): wanted length: " + n2);
        }
        if (!this.m_bHeaderWritten) {
            this.writeHeader();
            this.m_bHeaderWritten = true;
        }
        if ((l = this.getLength()) != (long)-1 && this.m_lCalculatedLength + (long)n2 > l) {
            if (TDebug.TraceAudioOutputStream) {
                TDebug.out("TAudioOutputStream.write(): requested more bytes to write than possible.");
            }
            if ((n2 = (int)(l - this.m_lCalculatedLength)) < 0) {
                n2 = 0;
            }
        }
        if (n2 > 0) {
            this.m_dataOutputStream.write(byArray, n, n2);
            this.m_lCalculatedLength += (long)n2;
        }
        if (TDebug.TraceAudioOutputStream) {
            TDebug.out("TAudioOutputStream.write(): calculated (total) length: " + this.m_lCalculatedLength + " bytes = " + this.m_lCalculatedLength / (long)this.getFormat().getFrameSize() + " frames");
        }
        return n2;
    }

    protected abstract void writeHeader() throws IOException;

    public void close() throws IOException {
        if (TDebug.TraceAudioOutputStream) {
            TDebug.out("TAudioOutputStream.close(): called");
        }
        if (this.m_bDoBackPatching) {
            if (TDebug.TraceAudioOutputStream) {
                TDebug.out("TAudioOutputStream.close(): patching header");
            }
            this.patchHeader();
        }
        this.m_dataOutputStream.close();
    }

    protected void patchHeader() throws IOException {
        TDebug.out("TAudioOutputStream.patchHeader(): called");
    }

    protected void setLengthFromCalculatedLength() {
        this.m_lLength = this.m_lCalculatedLength;
    }

    protected TAudioOutputStream(AudioFormat audioFormat, long l, TDataOutputStream tDataOutputStream, boolean bl) {
        this.m_audioFormat = audioFormat;
        this.m_lLength = l;
        this.m_lCalculatedLength = 0L;
        this.m_dataOutputStream = tDataOutputStream;
        this.m_bDoBackPatching = bl;
        this.m_bHeaderWritten = false;
    }
}

