/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gtp;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.sf.gogui.gtp.GtpCommand;
import net.sf.gogui.gtp.GtpEngine;
import net.sf.gogui.utils.StringUtils;

class ReadThread
extends Thread {
    private boolean m_endOfFile;
    private final boolean m_log;
    private boolean m_waitCommand;
    private final BufferedReader m_in;
    private GtpCommand m_command;
    private final GtpEngine m_gtpServer;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ReadThread(GtpEngine gtpEngine, InputStream inputStream, boolean bl) {
        this.m_in = new BufferedReader(new InputStreamReader(inputStream));
        this.m_gtpServer = gtpEngine;
        this.m_log = bl;
    }

    public synchronized boolean endOfFile() {
        return this.m_endOfFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GtpCommand getCommand() {
        ReadThread readThread = this;
        synchronized (readThread) {
            if (!$assertionsDisabled && this.m_waitCommand) {
                throw new AssertionError();
            }
            this.m_waitCommand = true;
            this.notifyAll();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                System.err.println("Interrupted");
            }
            if (!$assertionsDisabled && !this.m_endOfFile && this.m_waitCommand) {
                throw new AssertionError();
            }
            GtpCommand gtpCommand = this.m_command;
            this.m_command = null;
            return gtpCommand;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (true) {
                ReadThread readThread;
                String string;
                if ((string = this.m_in.readLine()) == null) {
                    readThread = this;
                    synchronized (readThread) {
                        this.m_endOfFile = true;
                    }
                } else {
                    if (this.m_log) {
                        this.m_gtpServer.log(string);
                    }
                    if ((string = string.trim()).equals("# interrupt")) {
                        this.m_gtpServer.interruptCommand();
                    }
                    if (string.equals("") || string.charAt(0) == '#') continue;
                }
                readThread = this;
                synchronized (readThread) {
                    while (!this.m_waitCommand) {
                        this.wait();
                    }
                    this.m_command = string == null ? null : new GtpCommand(string);
                    this.notifyAll();
                    this.m_waitCommand = false;
                    if (this.m_command == null || this.m_command.isQuit()) {
                        return;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            StringUtils.printException(throwable);
            return;
        }
    }

    static {
        $assertionsDisabled = !ReadThread.class.desiredAssertionStatus();
    }
}

