/*
 * Decompiled with CFR 0.152.
 */
package estraier.pure;

import estraier.pure.Condition;
import estraier.pure.Document;
import estraier.pure.Node;
import estraier.pure.NodeResult;
import estraier.pure.ResultDocument;
import estraier.pure.Utility;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Call {
    private static final int SEARCHMAX = 10;
    private static final int SEARCHAUX = 32;
    private static final PrintStream stdout = System.out;
    private static final PrintStream stderr = System.err;
    private static String pxhost = null;
    private static int pxport = 0;
    private static int timeout = -1;
    private static String authname = null;
    private static String authpass = null;
    static /* synthetic */ Class class$estraier$pure$Call;

    public static void main(String[] stringArray) {
        int n = 0;
        if (stringArray.length < 1) {
            Call.usage();
        }
        if (stringArray[0].equals("put")) {
            n = Call.runput(stringArray);
        } else if (stringArray[0].equals("out")) {
            n = Call.runout(stringArray);
        } else if (stringArray[0].equals("edit")) {
            n = Call.runedit(stringArray);
        } else if (stringArray[0].equals("get")) {
            n = Call.runget(stringArray);
        } else if (stringArray[0].equals("etch")) {
            n = Call.runetch(stringArray);
        } else if (stringArray[0].equals("uriid")) {
            n = Call.runuriid(stringArray);
        } else if (stringArray[0].equals("inform")) {
            n = Call.runinform(stringArray);
        } else if (stringArray[0].equals("sync")) {
            n = Call.runsync(stringArray);
        } else if (stringArray[0].equals("optimize")) {
            n = Call.runoptimize(stringArray);
        } else if (stringArray[0].equals("search")) {
            n = Call.runsearch(stringArray);
        } else if (stringArray[0].equals("setuser")) {
            n = Call.runsetuser(stringArray);
        } else if (stringArray[0].equals("setlink")) {
            n = Call.runsetlink(stringArray);
        } else {
            Call.usage();
        }
        System.exit(n);
    }

    private static final void usage() {
        stderr.println("command line utility for the node API of Hyper Estraier");
        stderr.println("");
        stderr.println("synopsis:");
        StringBuffer stringBuffer = new StringBuffer("  java ");
        Class clazz = class$estraier$pure$Call;
        if (clazz == null) {
            clazz = class$estraier$pure$Call = Call.class("[Lestraier.pure.Call;", false);
        }
        stderr.println(stringBuffer.append(clazz.getName()).append(" arguments...").toString());
        stderr.println("");
        stderr.println("arguments:");
        stderr.println("  put [-proxy host:port] [-tout num] [-auth user pass] nurl [file]");
        stderr.println("  out [-proxy host:port] [-tout num] [-auth user pass] nurl expr");
        stderr.println("  edit [-proxy host:port] [-tout num] [-auth user pass] nurl expr name [value]");
        stderr.println("  get [-proxy host:port] [-tout num] [-auth user pass] nurl expr [attr]");
        stderr.println("  etch [-proxy host:port] [-tout num] [-auth user pass] nurl expr");
        stderr.println("  uriid [-proxy host:port] [-tout num] [-auth user pass] nurl uri");
        stderr.println("  inform [-proxy host:port] [-tout num] [-auth user pass] nurl");
        stderr.println("  sync [-proxy host:port] [-tout num] [-auth user pass] nurl");
        stderr.println("  optimize [-proxy host:port] [-tout num] [-auth user pass] nurl");
        stderr.println("  search [-proxy host:port] [-tout num] [-auth user pass] [-sf|-sfr|-sfu|-sfi] [-attr expr] [-ord expr] [-max num] [-sk num] [-aux num] [-dis name] [-dpt num] [-mask num] nurl [phrase]");
        stderr.println("  setuser [-proxy host:port] [-tout num] [-auth user pass] nurl name mode");
        stderr.println("  setlink [-proxy host:port] [-tout num] [-auth user pass] nurl url label credit");
        stderr.println("");
        System.exit(1);
    }

    private static final void printerror(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Class clazz = class$estraier$pure$Call;
        if (clazz == null) {
            clazz = class$estraier$pure$Call = Call.class("[Lestraier.pure.Call;", false);
        }
        stderr.println(stringBuffer.append(clazz.getName()).append(": ").append(string).toString());
        stderr.flush();
    }

    private static final int runput(String[] stringArray) {
        String string = null;
        String string2 = null;
        int n = 1;
        while (n < stringArray.length) {
            String string3 = stringArray[n];
            if (string == null && string3.startsWith("-")) {
                if (string3.equals("-proxy")) {
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    pxhost = stringArray[n];
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    pxport = Integer.parseInt(stringArray[n]);
                } else if (string3.equals("-tout")) {
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    timeout = Integer.parseInt(stringArray[n]);
                } else if (string3.equals("-auth")) {
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    authname = stringArray[n];
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    authpass = stringArray[n];
                } else {
                    Call.usage();
                }
            } else if (string == null) {
                string = string3;
            } else if (string2 == null) {
                string2 = string3;
            } else {
                Call.usage();
            }
            ++n;
        }
        if (string == null) {
            Call.usage();
        }
        return Call.procput(string, string2);
    }

    private static final int runout(String[] stringArray) {
        String string = null;
        String string2 = null;
        int n = 1;
        while (n < stringArray.length) {
            String string3 = stringArray[n];
            if (string == null && string3.startsWith("-")) {
                if (string3.equals("-proxy")) {
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    pxhost = stringArray[n];
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    pxport = Integer.parseInt(stringArray[n]);
                } else if (string3.equals("-tout")) {
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    timeout = Integer.parseInt(stringArray[n]);
                } else if (string3.equals("-auth")) {
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    authname = stringArray[n];
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    authpass = stringArray[n];
                } else {
                    Call.usage();
                }
            } else if (string == null) {
                string = string3;
            } else if (string2 == null) {
                string2 = string3;
            } else {
                Call.usage();
            }
            ++n;
        }
        if (string == null || string2 == null) {
            Call.usage();
        }
        return Call.procout(string, string2);
    }

    private static final int runedit(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = 1;
        while (n < stringArray.length) {
            String string5 = stringArray[n];
            if (string == null && string5.startsWith("-")) {
                if (string5.equals("-proxy")) {
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    pxhost = stringArray[n];
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    pxport = Integer.parseInt(stringArray[n]);
                } else if (string5.equals("-tout")) {
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    timeout = Integer.parseInt(stringArray[n]);
                } else if (string5.equals("-auth")) {
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    authname = stringArray[n];
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    authpass = stringArray[n];
                } else {
                    Call.usage();
                }
            } else if (string == null) {
                string = string5;
            } else if (string2 == null) {
                string2 = string5;
            } else if (string3 == null) {
                string3 = string5;
            } else if (string4 == null) {
                string4 = string5;
            } else {
                Call.usage();
            }
            ++n;
        }
        if (string == null || string2 == null || string3 == null) {
            Call.usage();
        }
        return Call.procedit(string, string2, string3, string4);
    }

    private static final int runget(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = 1;
        while (n < stringArray.length) {
            String string4 = stringArray[n];
            if (string == null && string4.startsWith("-")) {
                if (string4.equals("-proxy")) {
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    pxhost = stringArray[n];
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    pxport = Integer.parseInt(stringArray[n]);
                } else if (string4.equals("-tout")) {
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    timeout = Integer.parseInt(stringArray[n]);
                } else if (string4.equals("-auth")) {
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    authname = stringArray[n];
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    authpass = stringArray[n];
                } else {
                    Call.usage();
                }
            } else if (string == null) {
                string = string4;
            } else if (string2 == null) {
                string2 = string4;
            } else if (string3 == null) {
                string3 = string4;
            } else {
                Call.usage();
            }
            ++n;
        }
        if (string == null || string2 == null) {
            Call.usage();
        }
        return Call.procget(string, string2, string3);
    }

    private static final int runetch(String[] stringArray) {
        String string = null;
        String string2 = null;
        int n = 1;
        while (n < stringArray.length) {
            String string3 = stringArray[n];
            if (string == null && string3.startsWith("-")) {
                if (string3.equals("-proxy")) {
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    pxhost = stringArray[n];
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    pxport = Integer.parseInt(stringArray[n]);
                } else if (string3.equals("-tout")) {
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    timeout = Integer.parseInt(stringArray[n]);
                } else if (string3.equals("-auth")) {
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    authname = stringArray[n];
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    authpass = stringArray[n];
                } else {
                    Call.usage();
                }
            } else if (string == null) {
                string = string3;
            } else if (string2 == null) {
                string2 = string3;
            } else {
                Call.usage();
            }
            ++n;
        }
        if (string == null || string2 == null) {
            Call.usage();
        }
        return Call.procetch(string, string2);
    }

    private static final int runuriid(String[] stringArray) {
        String string = null;
        String string2 = null;
        int n = 1;
        while (n < stringArray.length) {
            String string3 = stringArray[n];
            if (string == null && string3.startsWith("-")) {
                if (string3.equals("-proxy")) {
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    pxhost = stringArray[n];
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    pxport = Integer.parseInt(stringArray[n]);
                } else if (string3.equals("-tout")) {
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    timeout = Integer.parseInt(stringArray[n]);
                } else if (string3.equals("-auth")) {
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    authname = stringArray[n];
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    authpass = stringArray[n];
                } else {
                    Call.usage();
                }
            } else if (string == null) {
                string = string3;
            } else if (string2 == null) {
                string2 = string3;
            } else {
                Call.usage();
            }
            ++n;
        }
        if (string == null || string2 == null) {
            Call.usage();
        }
        return Call.procuriid(string, string2);
    }

    private static final int runinform(String[] stringArray) {
        String string = null;
        int n = 1;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if (string == null && string2.startsWith("-")) {
                if (string2.equals("-proxy")) {
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    pxhost = stringArray[n];
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    pxport = Integer.parseInt(stringArray[n]);
                } else if (string2.equals("-tout")) {
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    timeout = Integer.parseInt(stringArray[n]);
                } else if (string2.equals("-auth")) {
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    authname = stringArray[n];
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    authpass = stringArray[n];
                } else {
                    Call.usage();
                }
            } else if (string == null) {
                string = string2;
            } else {
                Call.usage();
            }
            ++n;
        }
        if (string == null) {
            Call.usage();
        }
        return Call.procinform(string);
    }

    private static final int runsync(String[] stringArray) {
        String string = null;
        int n = 1;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if (string == null && string2.startsWith("-")) {
                if (string2.equals("-proxy")) {
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    pxhost = stringArray[n];
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    pxport = Integer.parseInt(stringArray[n]);
                } else if (string2.equals("-tout")) {
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    timeout = Integer.parseInt(stringArray[n]);
                } else if (string2.equals("-auth")) {
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    authname = stringArray[n];
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    authpass = stringArray[n];
                } else {
                    Call.usage();
                }
            } else if (string == null) {
                string = string2;
            } else {
                Call.usage();
            }
            ++n;
        }
        if (string == null) {
            Call.usage();
        }
        return Call.procsync(string);
    }

    private static final int runoptimize(String[] stringArray) {
        String string = null;
        int n = 1;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if (string == null && string2.startsWith("-")) {
                if (string2.equals("-proxy")) {
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    pxhost = stringArray[n];
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    pxport = Integer.parseInt(stringArray[n]);
                } else if (string2.equals("-tout")) {
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    timeout = Integer.parseInt(stringArray[n]);
                } else if (string2.equals("-auth")) {
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    authname = stringArray[n];
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    authpass = stringArray[n];
                } else {
                    Call.usage();
                }
            } else if (string == null) {
                string = string2;
            } else {
                Call.usage();
            }
            ++n;
        }
        if (string == null) {
            Call.usage();
        }
        return Call.procoptimize(string);
    }

    private static final int runsearch(String[] stringArray) {
        String string = null;
        String string2 = null;
        ArrayList<String> arrayList = new ArrayList<String>(3);
        String string3 = null;
        int n = 10;
        int n2 = 0;
        int n3 = 0;
        int n4 = 32;
        String string4 = null;
        int n5 = 0;
        int n6 = 0;
        int n7 = 1;
        while (n7 < stringArray.length) {
            String string5 = stringArray[n7];
            if (string == null && string5.startsWith("-")) {
                if (string5.equals("-proxy")) {
                    if (++n7 >= stringArray.length) {
                        Call.usage();
                    }
                    pxhost = stringArray[n7];
                    if (++n7 >= stringArray.length) {
                        Call.usage();
                    }
                    pxport = Integer.parseInt(stringArray[n7]);
                } else if (string5.equals("-tout")) {
                    if (++n7 >= stringArray.length) {
                        Call.usage();
                    }
                    timeout = Integer.parseInt(stringArray[n7]);
                } else if (string5.equals("-auth")) {
                    if (++n7 >= stringArray.length) {
                        Call.usage();
                    }
                    authname = stringArray[n7];
                    if (++n7 >= stringArray.length) {
                        Call.usage();
                    }
                    authpass = stringArray[n7];
                } else if (string5.equals("-sf")) {
                    n3 |= 0x400;
                } else if (string5.equals("-sfr")) {
                    n3 |= 0x800;
                } else if (string5.equals("-sfu")) {
                    n3 |= 0x8000;
                } else if (string5.equals("-sfi")) {
                    n3 |= 0x10000;
                } else if (string5.equals("-attr")) {
                    if (++n7 >= stringArray.length) {
                        Call.usage();
                    }
                    arrayList.add(stringArray[n7]);
                } else if (string5.equals("-ord")) {
                    if (++n7 >= stringArray.length) {
                        Call.usage();
                    }
                    string3 = stringArray[n7];
                } else if (string5.equals("-max")) {
                    if (++n7 >= stringArray.length) {
                        Call.usage();
                    }
                    n = Integer.parseInt(stringArray[n7]);
                } else if (string5.equals("-sk")) {
                    if (++n7 >= stringArray.length) {
                        Call.usage();
                    }
                    n2 = Integer.parseInt(stringArray[n7]);
                } else if (string5.equals("-aux")) {
                    if (++n7 >= stringArray.length) {
                        Call.usage();
                    }
                    n4 = Integer.parseInt(stringArray[n7]);
                } else if (string5.equals("-dis")) {
                    if (++n7 >= stringArray.length) {
                        Call.usage();
                    }
                    string4 = stringArray[n7];
                } else if (string5.equals("-dpt")) {
                    if (++n7 >= stringArray.length) {
                        Call.usage();
                    }
                    n5 = Integer.parseInt(stringArray[n7]);
                } else if (string5.equals("-mask")) {
                    if (++n7 >= stringArray.length) {
                        Call.usage();
                    }
                    n6 = Integer.parseInt(stringArray[n7]);
                } else {
                    Call.usage();
                }
            } else if (string == null) {
                string = string5;
            } else {
                string2 = string2 == null ? string5 : string2 + ' ' + string5;
            }
            ++n7;
        }
        if (string == null) {
            Call.usage();
        }
        return Call.procsearch(string, string2, arrayList, string3, n, n2, n3, n4, string4, n5, n6);
    }

    private static final int runsetuser(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = 1;
        while (n < stringArray.length) {
            String string4 = stringArray[n];
            if (string == null && string4.startsWith("-")) {
                if (string4.equals("-proxy")) {
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    pxhost = stringArray[n];
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    pxport = Integer.parseInt(stringArray[n]);
                } else if (string4.equals("-tout")) {
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    timeout = Integer.parseInt(stringArray[n]);
                } else if (string4.equals("-auth")) {
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    authname = stringArray[n];
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    authpass = stringArray[n];
                } else {
                    Call.usage();
                }
            } else if (string == null) {
                string = string4;
            } else if (string2 == null) {
                string2 = string4;
            } else if (string3 == null) {
                string3 = string4;
            } else {
                Call.usage();
            }
            ++n;
        }
        if (string == null || string2 == null || string3 == null) {
            Call.usage();
        }
        if ((n = Integer.parseInt(string3)) < 0) {
            Call.usage();
        }
        return Call.procsetuser(string, string2, n);
    }

    private static final int runsetlink(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = 1;
        while (n < stringArray.length) {
            String string5 = stringArray[n];
            if (string == null && string5.startsWith("-")) {
                if (string5.equals("-proxy")) {
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    pxhost = stringArray[n];
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    pxport = Integer.parseInt(stringArray[n]);
                } else if (string5.equals("-tout")) {
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    timeout = Integer.parseInt(stringArray[n]);
                } else if (string5.equals("-auth")) {
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    authname = stringArray[n];
                    if (++n >= stringArray.length) {
                        Call.usage();
                    }
                    authpass = stringArray[n];
                } else {
                    Call.usage();
                }
            } else if (string == null) {
                string = string5;
            } else if (string2 == null) {
                string2 = string5;
            } else if (string3 == null) {
                string3 = string5;
            } else if (string4 == null) {
                string4 = string5;
            } else {
                Call.usage();
            }
            ++n;
        }
        if (string == null || string2 == null || string3 == null || string4 == null) {
            Call.usage();
        }
        n = Integer.parseInt(string4);
        return Call.procsetlink(string, string2, string3, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final int procput(String string, String string2) {
        Node node;
        Object object;
        byte[] byArray;
        block17: {
            block18: {
                byArray = null;
                if (string2 == null) break block18;
                object = null;
                try {
                    try {
                        object = new FileInputStream(string2);
                        byArray = Utility.read_all((InputStream)object);
                    }
                    catch (IOException iOException) {
                        Call.printerror(iOException.toString());
                        int n = 1;
                        Object var5_7 = null;
                        try {
                            if (object == null) return n;
                            ((FileInputStream)object).close();
                            return n;
                        }
                        catch (IOException iOException2) {}
                        return n;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    try {}
                    catch (IOException iOException) {}
                    if (object == null) throw throwable;
                    ((FileInputStream)object).close();
                    throw throwable;
                    throw throwable;
                }
                {
                    node = null;
                    try {}
                    catch (IOException iOException) {}
                    if (object != null) {
                        ((FileInputStream)object).close();
                    }
                    break block17;
                }
                break block17;
            }
            try {
                byArray = Utility.read_all(System.in);
            }
            catch (IOException iOException) {
                Call.printerror(iOException.toString());
                return 1;
            }
        }
        object = null;
        try {
            object = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Call.printerror(unsupportedEncodingException.toString());
            return 1;
        }
        Document document = new Document((String)object);
        node = new Node();
        node.set_url(string);
        if (pxhost != null) {
            node.set_proxy(pxhost, pxport);
        }
        if (timeout > 0) {
            node.set_timeout(timeout);
        }
        if (authname != null) {
            node.set_auth(authname, authpass);
        }
        if (node.put_doc(document)) return 0;
        Call.printerror("failed: " + node.status());
        return 1;
    }

    private static final int procout(String string, String string2) {
        int n = -1;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        Node node = new Node();
        node.set_url(string);
        if (pxhost != null) {
            node.set_proxy(pxhost, pxport);
        }
        if (timeout > 0) {
            node.set_timeout(timeout);
        }
        if (authname != null) {
            node.set_auth(authname, authpass);
        }
        if (n > 0) {
            if (!node.out_doc(n)) {
                Call.printerror("failed: " + node.status());
                return 1;
            }
        } else if (!node.out_doc_by_uri(string2)) {
            Call.printerror("failed: " + node.status());
            return 1;
        }
        return 0;
    }

    private static final int procedit(String string, String string2, String string3, String string4) {
        Document document;
        int n = -1;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        Node node = new Node();
        node.set_url(string);
        if (pxhost != null) {
            node.set_proxy(pxhost, pxport);
        }
        if (timeout > 0) {
            node.set_timeout(timeout);
        }
        if (authname != null) {
            node.set_auth(authname, authpass);
        }
        Document document2 = document = n > 0 ? node.get_doc(n) : node.get_doc_by_uri(string2);
        if (document == null) {
            Call.printerror("failed: " + node.status());
            return 1;
        }
        document.add_attr(string3, string4);
        if (!node.edit_doc(document)) {
            Call.printerror("failed: " + node.status());
            return 1;
        }
        return 0;
    }

    private static final int procget(String string, String string2, String string3) {
        int n = -1;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        Node node = new Node();
        node.set_url(string);
        if (pxhost != null) {
            node.set_proxy(pxhost, pxport);
        }
        if (timeout > 0) {
            node.set_timeout(timeout);
        }
        if (authname != null) {
            node.set_auth(authname, authpass);
        }
        if (string3 != null) {
            String string4;
            String string5 = string4 = n > 0 ? node.get_doc_attr(n, string3) : node.get_doc_attr_by_uri(string2, string3);
            if (string4 == null) {
                Call.printerror("failed: " + node.status());
                return 1;
            }
            stdout.println(string4);
        } else {
            Document document;
            Document document2 = document = n > 0 ? node.get_doc(n) : node.get_doc_by_uri(string2);
            if (document == null) {
                Call.printerror("failed: " + node.status());
                return 1;
            }
            stdout.print(document.dump_draft());
        }
        return 0;
    }

    private static final int procetch(String string, String string2) {
        Map map;
        int n = -1;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        Node node = new Node();
        node.set_url(string);
        if (pxhost != null) {
            node.set_proxy(pxhost, pxport);
        }
        if (timeout > 0) {
            node.set_timeout(timeout);
        }
        if (authname != null) {
            node.set_auth(authname, authpass);
        }
        Map map2 = map = n > 0 ? node.etch_doc(n) : node.etch_doc_by_uri(string2);
        if (map == null) {
            Call.printerror("failed: " + node.status());
            return 1;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            stdout.println(string3 + '\t' + (String)map.get(string3));
        }
        return 0;
    }

    private static final int procuriid(String string, String string2) {
        int n;
        Node node = new Node();
        node.set_url(string);
        if (pxhost != null) {
            node.set_proxy(pxhost, pxport);
        }
        if (timeout > 0) {
            node.set_timeout(timeout);
        }
        if (authname != null) {
            node.set_auth(authname, authpass);
        }
        if ((n = node.uri_to_id(string2)) == -1) {
            Call.printerror("failed: " + node.status());
            return 1;
        }
        stdout.println(n);
        return 0;
    }

    private static final int procinform(String string) {
        Node node = new Node();
        node.set_url(string);
        if (pxhost != null) {
            node.set_proxy(pxhost, pxport);
        }
        if (timeout > 0) {
            node.set_timeout(timeout);
        }
        if (authname != null) {
            node.set_auth(authname, authpass);
        }
        String string2 = node.name();
        String string3 = node.name();
        int n = node.doc_num();
        int n2 = node.word_num();
        double d = node.size();
        double d2 = node.cache_usage();
        if (string2 == null || string3 == null || n < 0 || n2 < 0 || d < 0.0 || d2 < 0.0) {
            Call.printerror("failed: " + node.status());
            return 1;
        }
        stdout.println(string2 + '\t' + string3 + '\t' + n + '\t' + n2 + '\t' + (long)d + '\t' + d2);
        return 0;
    }

    private static final int procsync(String string) {
        Node node = new Node();
        node.set_url(string);
        if (pxhost != null) {
            node.set_proxy(pxhost, pxport);
        }
        if (timeout > 0) {
            node.set_timeout(timeout);
        }
        if (authname != null) {
            node.set_auth(authname, authpass);
        }
        if (!node.sync()) {
            Call.printerror("failed: " + node.status());
            return 1;
        }
        return 0;
    }

    private static final int procoptimize(String string) {
        Node node = new Node();
        node.set_url(string);
        if (pxhost != null) {
            node.set_proxy(pxhost, pxport);
        }
        if (timeout > 0) {
            node.set_timeout(timeout);
        }
        if (authname != null) {
            node.set_auth(authname, authpass);
        }
        if (!node.optimize()) {
            Call.printerror("failed: " + node.status());
            return 1;
        }
        return 0;
    }

    private static final int procsearch(String string, String string2, List list, String string3, int n, int n2, int n3, int n4, String string4, int n5, int n6) {
        Node node = new Node();
        node.set_url(string);
        if (pxhost != null) {
            node.set_proxy(pxhost, pxport);
        }
        if (timeout > 0) {
            node.set_timeout(timeout);
        }
        if (authname != null) {
            node.set_auth(authname, authpass);
        }
        Condition condition = new Condition();
        if (string2 != null) {
            condition.set_phrase(string2);
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            condition.add_attr((String)iterator.next());
        }
        if (string3 != null) {
            condition.set_order(string3);
        }
        if (n >= 0) {
            condition.set_max(n);
        }
        if (n2 >= 0) {
            condition.set_skip(n2);
        }
        condition.set_options(n3);
        condition.set_auxiliary(n4);
        if (string4 != null) {
            condition.set_distinct(string4);
        }
        condition.set_mask(n6);
        NodeResult nodeResult = node.search(condition, n5);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        String string5 = "--------[" + gregorianCalendar.getTimeInMillis() + "]--------";
        if (nodeResult != null) {
            Object object;
            stdout.println(string5);
            String string6 = nodeResult.hint("VERSION");
            if (string6 != null) {
                stdout.println("VERSION\t" + string6);
            }
            if ((string6 = nodeResult.hint("NODE")) != null) {
                stdout.println("NODE\t" + string6);
            }
            if ((string6 = nodeResult.hint("HIT")) != null) {
                stdout.println("HIT\t" + string6);
            }
            int n7 = 1;
            while ((string6 = nodeResult.hint((String)(object = "HINT#" + n7))) != null) {
                stdout.println((String)object + '\t' + string6);
                ++n7;
            }
            string6 = nodeResult.hint("DOCNUM");
            if (string6 != null) {
                stdout.println("DOCNUM\t" + string6);
            }
            if ((string6 = nodeResult.hint("WORDNUM")) != null) {
                stdout.println("WORDNUM\t" + string6);
            }
            if ((string6 = nodeResult.hint("TIME")) != null) {
                stdout.println("TIME\t" + string6);
            }
            if ((string6 = nodeResult.hint("TIME#i")) != null) {
                stdout.println("TIME#i\t" + string6);
            }
            n7 = 0;
            while ((string6 = nodeResult.hint((String)(object = "TIME#" + n7))) != null) {
                stdout.println((String)object + '\t' + string6);
                ++n7;
            }
            n7 = 0;
            while ((string6 = nodeResult.hint((String)(object = "LINK#" + n7))) != null) {
                stdout.println((String)object + '\t' + string6);
                ++n7;
            }
            string6 = nodeResult.hint("VIEW");
            if (string6 != null) {
                stdout.println("VIEW\t" + string6);
            }
            stdout.println("");
            n7 = 0;
            while (n7 < nodeResult.doc_num()) {
                String string7;
                stdout.println(string5);
                object = nodeResult.get_doc(n7);
                List list2 = ((ResultDocument)object).attr_names();
                Iterator iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    string7 = (String)iterator2.next();
                    stdout.println(string7 + '=' + ((ResultDocument)object).attr(string7));
                }
                string7 = ((ResultDocument)object).keywords();
                if (string7.length() > 0) {
                    stdout.println("%VECTOR\t" + string7);
                }
                stdout.println("");
                stdout.print(((ResultDocument)object).snippet());
                ++n7;
            }
        } else {
            Call.printerror("failed: " + node.status());
            return 1;
        }
        stdout.println(string5 + ":END");
        return 0;
    }

    private static final int procsetuser(String string, String string2, int n) {
        Node node = new Node();
        node.set_url(string);
        if (pxhost != null) {
            node.set_proxy(pxhost, pxport);
        }
        if (timeout > 0) {
            node.set_timeout(timeout);
        }
        if (authname != null) {
            node.set_auth(authname, authpass);
        }
        if (!node.set_user(string2, n)) {
            Call.printerror("failed: " + node.status());
            return 1;
        }
        return 0;
    }

    private static final int procsetlink(String string, String string2, String string3, int n) {
        Node node = new Node();
        node.set_url(string);
        if (pxhost != null) {
            node.set_proxy(pxhost, pxport);
        }
        if (timeout > 0) {
            node.set_timeout(timeout);
        }
        if (authname != null) {
            node.set_auth(authname, authpass);
        }
        if (!node.set_link(string2, string3, n)) {
            Call.printerror("failed: " + node.status());
            return 1;
        }
        return 0;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private Call() {
    }
}

