/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.classpath.Pointer;
import gnu.java.awt.peer.gtk.GdkGraphics;
import gnu.java.awt.peer.gtk.GdkPixbufDecoder;
import gnu.java.awt.peer.gtk.GtkImageConsumer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GtkImage
extends Image {
    static ColorModel nativeModel = new DirectColorModel(32, 255, 65280, 0xFF0000, -16777216);
    private static GtkImage errorImage;
    int width;
    int height;
    Hashtable props;
    boolean isLoaded;
    Pointer pixmap;
    Vector observers;
    boolean offScreen;
    boolean errorLoading;
    ImageProducer source;

    private final native int[] getPixels();

    private final native void setPixels(int[] var1);

    private final native boolean loadPixbuf(String var1);

    private final native boolean loadImageFromData(byte[] var1);

    private final native void createPixmap();

    private final native void freePixmap();

    private final native void createScaledPixmap(GtkImage var1, int var2);

    private final native void drawPixelsScaled(GdkGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9);

    private final native void drawPixelsScaledFlipped(GdkGraphics var1, int var2, int var3, int var4, boolean var5, boolean var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, boolean var15);

    static synchronized GtkImage getErrorImage() {
        if (errorImage == null) {
            errorImage = new GtkImage();
            GtkImage.errorImage.errorLoading = true;
        }
        return errorImage;
    }

    private final native void createFromPixbuf();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setImage(int n, int n2, int[] nArray, Hashtable hashtable) {
        this.width = n;
        this.height = n2;
        Hashtable hashtable2 = this.props = hashtable != null ? hashtable : new Hashtable();
        if (n <= 0 || n2 <= 0 || nArray == null) {
            this.errorLoading = true;
            return;
        }
        this.isLoaded = true;
        this.deliver();
        Object object = GdkPixbufDecoder.pixbufLock;
        synchronized (object) {
            this.createPixmap();
            this.setPixels(nArray);
            return;
        }
    }

    public synchronized int getWidth(ImageObserver imageObserver) {
        if (this.addObserver(imageObserver)) {
            return -1;
        }
        return this.width;
    }

    public synchronized int getHeight(ImageObserver imageObserver) {
        if (this.addObserver(imageObserver)) {
            return -1;
        }
        return this.height;
    }

    public synchronized Object getProperty(String string, ImageObserver imageObserver) {
        if (this.addObserver(imageObserver)) {
            return UndefinedProperty;
        }
        Object object = this.props.get(string);
        return object == null ? UndefinedProperty : object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ImageProducer getSource() {
        if (!this.isLoaded) {
            return null;
        }
        Object object = GdkPixbufDecoder.pixbufLock;
        synchronized (object) {
            int[] nArray = this.getPixels();
            return new MemoryImageSource(this.width, this.height, nativeModel, nArray, 0, this.width);
        }
    }

    public Graphics getGraphics() {
        if (!this.isLoaded) {
            return null;
        }
        if (this.offScreen) {
            return new GdkGraphics(this);
        }
        throw new IllegalAccessError("This method only works for off-screen Images.");
    }

    public Image getScaledInstance(int n, int n2, int n3) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("Width and height of scaled bitmapmust be >= 0");
        }
        return new GtkImage(this, n, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void flush() {
        if (!this.isLoaded || this.source == null) return;
        this.observers = new Vector();
        this.isLoaded = false;
        Object object = GdkPixbufDecoder.pixbufLock;
        synchronized (object) {
            this.freePixmap();
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1
            this.source.startProduction(new GtkImageConsumer(this, this.source));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void finalize() {
        if (!this.isLoaded) return;
        Object object = GdkPixbufDecoder.pixbufLock;
        synchronized (object) {
            this.freePixmap();
            return;
        }
    }

    public int checkImage(ImageObserver imageObserver) {
        if (this.addObserver(imageObserver)) {
            if (this.errorLoading) {
                return 64;
            }
            return 0;
        }
        return 35;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean drawImage(GdkGraphics gdkGraphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        int n9;
        if (this.addObserver(imageObserver)) {
            return false;
        }
        boolean bl = false;
        if (n > n3) {
            bl = true;
        }
        boolean bl2 = false;
        if (n5 > n7) {
            bl2 = true;
        }
        boolean bl3 = bl ^ bl2;
        boolean bl4 = false;
        if (n2 > n4) {
            bl4 = true;
        }
        boolean bl5 = false;
        if (n6 > n8) {
            bl5 = true;
        }
        boolean bl6 = bl4 ^ bl5;
        int n10 = Math.abs(n3 - n);
        int n11 = Math.abs(n4 - n2);
        int n12 = Math.abs(n7 - n5);
        int n13 = Math.abs(n8 - n6);
        int n14 = n5 < n7 ? n5 : n7;
        int n15 = n6 < n8 ? n6 : n8;
        int n16 = n < n3 ? n : n3;
        int n17 = n9 = n2 < n4 ? n2 : n4;
        if (n12 > this.width) {
            n10 = (int)((double)n10 * ((double)this.width / (double)n12));
            n12 = this.width - n14;
        }
        if (n13 > this.height) {
            n11 = (int)((double)n11 * ((double)this.height / (double)n13));
            n13 = this.height - n15;
        }
        if (n12 + n14 > this.width) {
            n10 = (int)((double)n10 * (double)(this.width - n14) / (double)n12);
            n12 = this.width - n14;
        }
        if (n13 + n15 > this.height) {
            n11 = (int)((double)n11 * (double)(this.width - n15) / (double)n13);
            n13 = this.height - n15;
        }
        if (n12 <= 0 || n13 <= 0 || n10 <= 0 || n11 <= 0) {
            return true;
        }
        Object object = GdkPixbufDecoder.pixbufLock;
        synchronized (object) {
            block14: {
                block13: {
                    if (color == null) break block13;
                    this.drawPixelsScaledFlipped(gdkGraphics, color.getRed(), color.getGreen(), color.getBlue(), bl3, bl6, n14, n15, n12, n13, n16, n9, n10, n11, true);
                    break block14;
                }
                this.drawPixelsScaledFlipped(gdkGraphics, 0, 0, 0, bl3, bl6, n14, n15, n12, n13, n16, n9, n10, n11, false);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean drawImage(GdkGraphics gdkGraphics, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        if (this.addObserver(imageObserver)) {
            return false;
        }
        Object object = GdkPixbufDecoder.pixbufLock;
        synchronized (object) {
            block5: {
                block4: {
                    if (color == null) break block4;
                    this.drawPixelsScaled(gdkGraphics, color.getRed(), color.getGreen(), color.getBlue(), n, n2, n3, n4, true);
                    break block5;
                }
                this.drawPixelsScaled(gdkGraphics, 0, 0, 0, n, n2, n3, n4, false);
            }
            return true;
        }
    }

    private final void deliver() {
        int n = 39;
        if (this.observers != null) {
            int n2 = 0;
            while (n2 < this.observers.size()) {
                ((ImageObserver)this.observers.elementAt(n2)).imageUpdate(this, n, 0, 0, this.width, this.height);
                ++n2;
            }
        }
        this.observers = null;
    }

    private final boolean addObserver(ImageObserver imageObserver) {
        if (!this.isLoaded) {
            if (imageObserver != null && !this.observers.contains(imageObserver)) {
                this.observers.addElement(imageObserver);
            }
            return true;
        }
        return false;
    }

    private final /* synthetic */ void this() {
        this.width = -1;
        this.height = -1;
    }

    public GtkImage(ImageProducer imageProducer) {
        this.this();
        this.isLoaded = false;
        this.observers = new Vector();
        this.source = imageProducer;
        this.errorLoading = false;
        this.source.startProduction(new GtkImageConsumer(this, this.source));
        this.offScreen = false;
    }

    public GtkImage() {
        this.this();
        this.isLoaded = true;
        this.observers = null;
        this.offScreen = false;
        this.props = new Hashtable();
        this.errorLoading = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GtkImage(String string) {
        this.this();
        File file = new File(string);
        try {
            String string2 = file.getCanonicalPath();
            Object object = GdkPixbufDecoder.pixbufLock;
            synchronized (object) {
                if (!this.loadPixbuf(file.getCanonicalPath())) {
                    throw new IllegalArgumentException("Couldn't load image: " + string);
                }
            }
        }
        catch (IOException iOException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Couldn't load image: " + string);
            illegalArgumentException.initCause(iOException);
            throw illegalArgumentException;
        }
        this.isLoaded = true;
        this.observers = null;
        this.offScreen = false;
        this.props = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GtkImage(byte[] byArray) {
        this.this();
        Object object = GdkPixbufDecoder.pixbufLock;
        synchronized (object) {
            if (!this.loadImageFromData(byArray)) {
                throw new IllegalArgumentException("Couldn't load image.");
            }
        }
        this.isLoaded = true;
        this.observers = null;
        this.offScreen = false;
        this.props = new Hashtable();
        this.errorLoading = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GtkImage(URL uRL) {
        Object object;
        Object object2;
        this.this();
        this.isLoaded = false;
        this.observers = new Vector();
        this.errorLoading = false;
        if (uRL == null) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(5000);
        try {
            object2 = new BufferedInputStream(uRL.openStream());
            object = new byte[5000];
            int n = 0;
            while (true) {
                if ((n = ((FilterInputStream)object2).read((byte[])object)) == -1) {
                    ((BufferedInputStream)object2).close();
                    break;
                }
                byteArrayOutputStream.write((byte[])object, 0, n);
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Couldn't load image.");
        }
        object2 = byteArrayOutputStream.toByteArray();
        Object object3 = GdkPixbufDecoder.pixbufLock;
        object = object3;
        synchronized (object3) {
            if (!this.loadImageFromData((byte[])object2)) {
                throw new IllegalArgumentException("Couldn't load image.");
            }
            this.isLoaded = true;
            this.observers = null;
            this.props = new Hashtable();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GtkImage(int n, int n2) {
        this.this();
        this.width = n;
        this.height = n2;
        this.props = new Hashtable();
        this.isLoaded = true;
        this.observers = null;
        this.offScreen = true;
        Object object = GdkPixbufDecoder.pixbufLock;
        synchronized (object) {
            this.createPixmap();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private GtkImage(GtkImage gtkImage, int n, int n2, int n3) {
        this.this();
        this.width = n;
        this.height = n2;
        this.props = new Hashtable();
        this.isLoaded = true;
        this.observers = null;
        this.offScreen = false;
        Object object = GdkPixbufDecoder.pixbufLock;
        synchronized (object) {
            this.createScaledPixmap(gtkImage, n3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    GtkImage(Pointer pointer) {
        this.this();
        this.pixmap = pointer;
        Object object = GdkPixbufDecoder.pixbufLock;
        synchronized (object) {
            this.createFromPixbuf();
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
            this.isLoaded = true;
            this.observers = null;
            this.offScreen = false;
            this.props = new Hashtable();
            return;
        }
    }
}

