/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class CRLFOutputStream
extends FilterOutputStream {
    static final String US_ASCII = "US-ASCII";
    public static final int CR = 13;
    public static final int LF = 10;
    public static final byte[] CRLF = new byte[]{13, 10};
    protected int last = -1;

    public void write(int n) throws IOException {
        if (n == 13) {
            this.out.write(CRLF);
        } else if (n == 10) {
            if (this.last != 13) {
                this.out.write(CRLF);
            }
        } else {
            this.out.write(n);
        }
        this.last = n;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n;
        n2 += n;
        int n4 = n;
        while (n4 < n2) {
            switch (byArray[n4]) {
                case 13: {
                    this.out.write(byArray, n3, n4 - n3);
                    this.out.write(CRLF, 0, 2);
                    n3 = n4 + 1;
                    break;
                }
                case 10: {
                    if (this.last != 13) {
                        this.out.write(byArray, n3, n4 - n3);
                        this.out.write(CRLF, 0, 2);
                    }
                    n3 = n4 + 1;
                    break;
                }
            }
            this.last = byArray[n4];
            ++n4;
        }
        if (n2 - n3 > 0) {
            this.out.write(byArray, n3, n2 - n3);
        }
    }

    public void write(String string) throws IOException {
        try {
            byte[] byArray = string.getBytes(US_ASCII);
            this.write(byArray, 0, byArray.length);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IOException("The US-ASCII encoding is not supported on this system");
        }
    }

    public void writeln() throws IOException {
        this.out.write(CRLF, 0, 2);
    }

    public CRLFOutputStream(OutputStream outputStream) {
        super(outputStream);
    }
}

