/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.print.ipp;

import gnu.classpath.debug.Component;
import gnu.classpath.debug.SystemLogger;
import gnu.javax.print.ipp.IppException;
import gnu.javax.print.ipp.IppResponse;
import gnu.javax.print.ipp.attribute.CharsetSyntax;
import gnu.javax.print.ipp.attribute.NaturalLanguageSyntax;
import gnu.javax.print.ipp.attribute.RequestedAttributes;
import gnu.javax.print.ipp.attribute.job.AttributesCharset;
import gnu.javax.print.ipp.attribute.job.AttributesNaturalLanguage;
import gnu.javax.print.ipp.attribute.job.JobId;
import gnu.javax.print.ipp.attribute.job.JobUri;
import gnu.javax.print.ipp.attribute.printer.DocumentFormat;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.DateTimeSyntax;
import javax.print.attribute.EnumSyntax;
import javax.print.attribute.HashAttributeSet;
import javax.print.attribute.IntegerSyntax;
import javax.print.attribute.ResolutionSyntax;
import javax.print.attribute.SetOfIntegerSyntax;
import javax.print.attribute.TextSyntax;
import javax.print.attribute.URISyntax;
import javax.print.attribute.standard.DocumentName;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.Finishings;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobOriginatingUserName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.PrinterURI;
import javax.print.attribute.standard.RequestingUserName;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class IppRequest {
    static final Logger logger = SystemLogger.SYSTEM;
    private static int requestIdCounter = 1;
    private static final short VERSION = 257;
    private boolean alreadySent;
    private short operation_id;
    private final int request_id;
    private AttributeSet operationAttributes;
    private AttributeSet printerAttributes;
    private AttributeSet jobAttributes;
    private Object data;
    private URI requestUri;
    private HttpURLConnection connection;
    static /* synthetic */ Class class$javax$print$attribute$standard$JobName;
    static /* synthetic */ Class class$javax$print$attribute$standard$Fidelity;
    static /* synthetic */ Class class$javax$print$attribute$standard$JobImpressions;
    static /* synthetic */ Class class$javax$print$attribute$standard$JobKOctets;
    static /* synthetic */ Class class$javax$print$attribute$standard$JobMediaSheets;
    static /* synthetic */ Class class$javax$print$attribute$standard$Compression;
    static /* synthetic */ Class class$javax$print$attribute$standard$DocumentName;
    static /* synthetic */ Class class$javax$print$attribute$standard$RequestingUserName;
    static /* synthetic */ Class class$javax$print$attribute$standard$JobPriority;
    static /* synthetic */ Class class$javax$print$attribute$standard$JobHoldUntil;
    static /* synthetic */ Class class$javax$print$attribute$standard$JobSheets;
    static /* synthetic */ Class class$javax$print$attribute$standard$MultipleDocumentHandling;
    static /* synthetic */ Class class$javax$print$attribute$standard$Copies;
    static /* synthetic */ Class class$javax$print$attribute$standard$Finishings;
    static /* synthetic */ Class class$javax$print$attribute$standard$PageRanges;
    static /* synthetic */ Class class$javax$print$attribute$standard$NumberUp;
    static /* synthetic */ Class class$javax$print$attribute$standard$OrientationRequested;
    static /* synthetic */ Class class$javax$print$attribute$standard$Media;
    static /* synthetic */ Class class$javax$print$attribute$standard$PrinterResolution;
    static /* synthetic */ Class class$javax$print$attribute$standard$PrintQuality;
    static /* synthetic */ Class class$javax$print$attribute$standard$SheetCollate;
    static /* synthetic */ Class class$javax$print$attribute$standard$Sides;
    static /* synthetic */ Class class$gnu$javax$print$ipp$attribute$job$AttributesCharset;
    static /* synthetic */ Class class$gnu$javax$print$ipp$attribute$job$AttributesNaturalLanguage;
    static /* synthetic */ Class class$javax$print$attribute$standard$PrinterURI;
    static /* synthetic */ Class class$gnu$javax$print$ipp$attribute$job$JobUri;
    static /* synthetic */ Class class$gnu$javax$print$ipp$attribute$job$JobId;

    private final synchronized int incrementRequestIdCounter() {
        return requestIdCounter++;
    }

    public int getRequestID() {
        return this.request_id;
    }

    public void setData(InputStream inputStream) {
        this.data = inputStream;
    }

    public void setData(byte[] byArray) {
        this.data = byArray;
    }

    public void setOperationID(short s) {
        this.operation_id = s;
    }

    public void setOperationAttributeDefaults() {
        if (this.operationAttributes == null) {
            this.operationAttributes = new HashAttributeSet();
        }
        this.operationAttributes.add(AttributesCharset.UTF8);
        this.operationAttributes.add(AttributesNaturalLanguage.EN);
    }

    public void addJobAttribute(Attribute attribute) {
        if (this.jobAttributes == null) {
            this.jobAttributes = new HashAttributeSet();
        }
        this.jobAttributes.add(attribute);
    }

    public void addPrinterAttributes(Attribute attribute) {
        if (this.printerAttributes == null) {
            this.printerAttributes = new HashAttributeSet();
        }
        this.printerAttributes.add(attribute);
    }

    public void addOperationAttribute(Attribute attribute) {
        if (this.operationAttributes == null) {
            this.operationAttributes = new HashAttributeSet();
        }
        this.operationAttributes.add(attribute);
    }

    public void addAndFilterJobOperationAttributes(AttributeSet attributeSet) {
        if (this.operationAttributes == null) {
            this.operationAttributes = new HashAttributeSet();
        }
        Attribute[] attributeArray = attributeSet.toArray();
        int n = 0;
        while (n < attributeArray.length) {
            block14: {
                block13: {
                    Class clazz = attributeArray[n].getCategory();
                    Class clazz2 = class$javax$print$attribute$standard$JobName;
                    if (clazz2 == null) {
                        clazz2 = IppRequest.class("[Ljavax.print.attribute.standard.JobName;", false);
                    }
                    if (clazz.equals(clazz2)) break block13;
                    Class clazz3 = attributeArray[n].getCategory();
                    Class clazz4 = class$javax$print$attribute$standard$Fidelity;
                    if (clazz4 == null) {
                        clazz4 = IppRequest.class("[Ljavax.print.attribute.standard.Fidelity;", false);
                    }
                    if (clazz3.equals(clazz4)) break block13;
                    Class clazz5 = attributeArray[n].getCategory();
                    Class clazz6 = class$javax$print$attribute$standard$JobImpressions;
                    if (clazz6 == null) {
                        clazz6 = IppRequest.class("[Ljavax.print.attribute.standard.JobImpressions;", false);
                    }
                    if (clazz5.equals(clazz6)) break block13;
                    Class clazz7 = attributeArray[n].getCategory();
                    Class clazz8 = class$javax$print$attribute$standard$JobKOctets;
                    if (clazz8 == null) {
                        clazz8 = IppRequest.class("[Ljavax.print.attribute.standard.JobKOctets;", false);
                    }
                    if (clazz7.equals(clazz8)) break block13;
                    Class clazz9 = attributeArray[n].getCategory();
                    Class clazz10 = class$javax$print$attribute$standard$JobMediaSheets;
                    if (clazz10 == null) {
                        clazz10 = IppRequest.class("[Ljavax.print.attribute.standard.JobMediaSheets;", false);
                    }
                    if (clazz9.equals(clazz10)) break block13;
                    Class clazz11 = attributeArray[n].getCategory();
                    Class clazz12 = class$javax$print$attribute$standard$Compression;
                    if (clazz12 == null) {
                        clazz12 = IppRequest.class("[Ljavax.print.attribute.standard.Compression;", false);
                    }
                    if (clazz11.equals(clazz12)) break block13;
                    Class clazz13 = attributeArray[n].getCategory();
                    Class clazz14 = class$javax$print$attribute$standard$DocumentName;
                    if (clazz14 == null) {
                        clazz14 = IppRequest.class("[Ljavax.print.attribute.standard.DocumentName;", false);
                    }
                    if (clazz13.equals(clazz14)) break block13;
                    Class clazz15 = attributeArray[n].getCategory();
                    Class clazz16 = class$javax$print$attribute$standard$RequestingUserName;
                    if (clazz16 == null) {
                        clazz16 = IppRequest.class("[Ljavax.print.attribute.standard.RequestingUserName;", false);
                    }
                    if (!clazz15.equals(clazz16)) break block14;
                }
                this.operationAttributes.add(attributeArray[n]);
            }
            ++n;
        }
    }

    public void addAndFilterJobTemplateAttributes(AttributeSet attributeSet) {
        if (this.jobAttributes == null) {
            this.jobAttributes = new HashAttributeSet();
        }
        Attribute[] attributeArray = attributeSet.toArray();
        int n = 0;
        while (n < attributeArray.length) {
            block20: {
                block19: {
                    Class clazz = attributeArray[n].getCategory();
                    Class clazz2 = class$javax$print$attribute$standard$JobPriority;
                    if (clazz2 == null) {
                        clazz2 = IppRequest.class("[Ljavax.print.attribute.standard.JobPriority;", false);
                    }
                    if (clazz.equals(clazz2)) break block19;
                    Class clazz3 = attributeArray[n].getCategory();
                    Class clazz4 = class$javax$print$attribute$standard$JobHoldUntil;
                    if (clazz4 == null) {
                        clazz4 = IppRequest.class("[Ljavax.print.attribute.standard.JobHoldUntil;", false);
                    }
                    if (clazz3.equals(clazz4)) break block19;
                    Class clazz5 = attributeArray[n].getCategory();
                    Class clazz6 = class$javax$print$attribute$standard$JobSheets;
                    if (clazz6 == null) {
                        clazz6 = IppRequest.class("[Ljavax.print.attribute.standard.JobSheets;", false);
                    }
                    if (clazz5.equals(clazz6)) break block19;
                    Class clazz7 = attributeArray[n].getCategory();
                    Class clazz8 = class$javax$print$attribute$standard$MultipleDocumentHandling;
                    if (clazz8 == null) {
                        clazz8 = IppRequest.class("[Ljavax.print.attribute.standard.MultipleDocumentHandling;", false);
                    }
                    if (clazz7.equals(clazz8)) break block19;
                    Class clazz9 = attributeArray[n].getCategory();
                    Class clazz10 = class$javax$print$attribute$standard$Copies;
                    if (clazz10 == null) {
                        clazz10 = IppRequest.class("[Ljavax.print.attribute.standard.Copies;", false);
                    }
                    if (clazz9.equals(clazz10)) break block19;
                    Class clazz11 = attributeArray[n].getCategory();
                    Class clazz12 = class$javax$print$attribute$standard$Finishings;
                    if (clazz12 == null) {
                        clazz12 = IppRequest.class("[Ljavax.print.attribute.standard.Finishings;", false);
                    }
                    if (clazz11.equals(clazz12)) break block19;
                    Class clazz13 = attributeArray[n].getCategory();
                    Class clazz14 = class$javax$print$attribute$standard$PageRanges;
                    if (clazz14 == null) {
                        clazz14 = IppRequest.class("[Ljavax.print.attribute.standard.PageRanges;", false);
                    }
                    if (clazz13.equals(clazz14)) break block19;
                    Class clazz15 = attributeArray[n].getCategory();
                    Class clazz16 = class$javax$print$attribute$standard$NumberUp;
                    if (clazz16 == null) {
                        clazz16 = IppRequest.class("[Ljavax.print.attribute.standard.NumberUp;", false);
                    }
                    if (clazz15.equals(clazz16)) break block19;
                    Class clazz17 = attributeArray[n].getCategory();
                    Class clazz18 = class$javax$print$attribute$standard$OrientationRequested;
                    if (clazz18 == null) {
                        clazz18 = IppRequest.class("[Ljavax.print.attribute.standard.OrientationRequested;", false);
                    }
                    if (clazz17.equals(clazz18)) break block19;
                    Class clazz19 = attributeArray[n].getCategory();
                    Class clazz20 = class$javax$print$attribute$standard$Media;
                    if (clazz20 == null) {
                        clazz20 = IppRequest.class("[Ljavax.print.attribute.standard.Media;", false);
                    }
                    if (clazz19.equals(clazz20)) break block19;
                    Class clazz21 = attributeArray[n].getCategory();
                    Class clazz22 = class$javax$print$attribute$standard$PrinterResolution;
                    if (clazz22 == null) {
                        clazz22 = IppRequest.class("[Ljavax.print.attribute.standard.PrinterResolution;", false);
                    }
                    if (clazz21.equals(clazz22)) break block19;
                    Class clazz23 = attributeArray[n].getCategory();
                    Class clazz24 = class$javax$print$attribute$standard$PrintQuality;
                    if (clazz24 == null) {
                        clazz24 = IppRequest.class("[Ljavax.print.attribute.standard.PrintQuality;", false);
                    }
                    if (clazz23.equals(clazz24)) break block19;
                    Class clazz25 = attributeArray[n].getCategory();
                    Class clazz26 = class$javax$print$attribute$standard$SheetCollate;
                    if (clazz26 == null) {
                        clazz26 = IppRequest.class("[Ljavax.print.attribute.standard.SheetCollate;", false);
                    }
                    if (clazz25.equals(clazz26)) break block19;
                    Class clazz27 = attributeArray[n].getCategory();
                    Class clazz28 = class$javax$print$attribute$standard$Sides;
                    if (clazz28 == null) {
                        clazz28 = IppRequest.class("[Ljavax.print.attribute.standard.Sides;", false);
                    }
                    if (!clazz27.equals(clazz28)) break block20;
                }
                this.jobAttributes.add(attributeArray[n]);
            }
            ++n;
        }
    }

    public IppResponse send() throws IppException, IOException {
        if (this.alreadySent) {
            throw new IllegalStateException("Request is already sent");
        }
        this.alreadySent = true;
        OutputStream outputStream = this.connection.getOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeShort(257);
        dataOutputStream.writeShort(this.operation_id);
        dataOutputStream.writeInt(this.request_id);
        logger.log(Component.IPP, "OperationID: " + Integer.toHexString(this.operation_id) + " RequestID: " + this.request_id);
        logger.log(Component.IPP, "Operation Attributes");
        RequestWriter requestWriter = new RequestWriter(dataOutputStream);
        requestWriter.writeOperationAttributes(this.operationAttributes);
        if (this.jobAttributes != null) {
            logger.log(Component.IPP, "Job Attributes");
            dataOutputStream.write(2);
            requestWriter.writeAttributes(this.jobAttributes);
        }
        if (this.printerAttributes != null) {
            logger.log(Component.IPP, "Printer Attributes");
            dataOutputStream.write(4);
            requestWriter.writeAttributes(this.printerAttributes);
        }
        dataOutputStream.write(3);
        if (this.data instanceof InputStream) {
            byte[] byArray = new byte[2048];
            int n = 0;
            while ((n = ((InputStream)this.data).read(byArray)) > 0) {
                dataOutputStream.write(byArray, 0, n);
            }
        } else if (this.data != null) {
            dataOutputStream.write((byte[])this.data);
        }
        dataOutputStream.flush();
        outputStream.flush();
        int n = this.connection.getResponseCode();
        if (n == 200) {
            IppResponse ippResponse = new IppResponse(this.requestUri, this.operation_id);
            ippResponse.setResponseData(this.connection.getInputStream());
            return ippResponse;
        }
        logger.log(Component.IPP, "HTTP-Statuscode: " + n);
        throw new IppException("Request failed got HTTP status code " + n);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.alreadySent = false;
    }

    public IppRequest(URI uRI, String string, String string2) {
        this.this();
        this.request_id = this.incrementRequestIdCounter();
        this.requestUri = uRI;
        try {
            URL uRL = new URL("http", string == null ? uRI.getHost() : string + ':' + string2 + '@' + uRI.getHost(), uRI.getPort(), uRI.getPath());
            this.connection = (HttpURLConnection)uRL.openConnection();
            this.connection.setRequestMethod("POST");
            this.connection.setDoOutput(true);
            this.connection.setRequestProperty("Content-type", "application/ipp");
            this.connection.setRequestProperty("Accept", "text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2");
        }
        catch (IOException iOException) {
            logger.log((Level)Component.IPP, "Unexpected IOException", iOException);
        }
        logger.log(Component.IPP, "[IppConnection] Host: " + uRI.getHost() + " Port: " + uRI.getPort() + " Path: " + uRI.getPath());
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class RequestWriter {
        private DataOutputStream out;

        private final void write(IntegerSyntax integerSyntax) throws IOException {
            String string = ((Attribute)((Object)integerSyntax)).getName();
            this.out.writeByte(33);
            this.out.writeShort(string.length());
            this.out.write(string.getBytes());
            this.out.writeShort(4);
            this.out.writeInt(integerSyntax.getValue());
        }

        private final void write(EnumSyntax enumSyntax) throws IOException {
            String string = ((Attribute)((Object)enumSyntax)).getName();
            if (enumSyntax instanceof Finishings || enumSyntax instanceof OrientationRequested || enumSyntax instanceof PrintQuality) {
                this.out.writeByte(35);
                this.out.writeShort(string.length());
                this.out.write(string.getBytes());
                this.out.writeShort(4);
                this.out.writeInt(enumSyntax.getValue());
            } else if (enumSyntax instanceof Fidelity) {
                this.out.writeByte(34);
                this.out.writeShort(string.length());
                this.out.write(string.getBytes());
                this.out.writeShort(1);
                int n = 0;
                if (enumSyntax.getValue() == 0) {
                    n = 1;
                }
                this.out.writeByte(1 - n);
            } else {
                String string2 = enumSyntax.toString();
                this.out.writeByte(68);
                this.out.writeShort(string.length());
                this.out.write(string.getBytes());
                this.out.writeShort(string2.length());
                this.out.write(string2.getBytes());
            }
        }

        private final void write(SetOfIntegerSyntax setOfIntegerSyntax) throws IOException {
            String string = ((Attribute)((Object)setOfIntegerSyntax)).getName();
            int[][] nArray = setOfIntegerSyntax.getMembers();
            int n = 0;
            while (n < nArray.length) {
                this.out.writeByte(51);
                if (n == 0) {
                    this.out.writeShort(string.length());
                    this.out.write(string.getBytes());
                } else {
                    this.out.writeShort(0);
                }
                this.out.writeShort(8);
                this.out.writeInt(nArray[n][0]);
                this.out.writeInt(nArray[n][1]);
                ++n;
            }
        }

        private final void write(ResolutionSyntax resolutionSyntax) throws IOException {
            String string = ((Attribute)((Object)resolutionSyntax)).getName();
            this.out.writeByte(50);
            this.out.writeShort(string.length());
            this.out.write(string.getBytes());
            this.out.writeShort(9);
            this.out.writeInt(resolutionSyntax.getCrossFeedResolution(100));
            this.out.writeInt(resolutionSyntax.getFeedResolution(100));
            this.out.writeByte(100);
        }

        private final void write(DateTimeSyntax dateTimeSyntax) throws IOException {
            String string = ((Attribute)((Object)dateTimeSyntax)).getName();
            this.out.writeByte(49);
            this.out.writeShort(string.length());
            this.out.write(string.getBytes());
            this.out.writeShort(11);
            Date date = dateTimeSyntax.getValue();
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
            this.out.writeShort(gregorianCalendar.get(1));
            this.out.writeByte(gregorianCalendar.get(2));
            this.out.writeByte(gregorianCalendar.get(5));
            this.out.writeByte(gregorianCalendar.get(11));
            this.out.writeByte(gregorianCalendar.get(12));
            int n = gregorianCalendar.get(13);
            this.out.writeByte(n == 0 ? 60 : n);
            this.out.writeByte(gregorianCalendar.get(14) / 100);
            int n2 = gregorianCalendar.get(15);
            int n3 = 43;
            if (n2 < 0) {
                n3 = 45;
                n2 *= -1;
            }
            this.out.writeByte(n3);
            this.out.writeByte(n2 / 3600000);
            this.out.writeByte(n2 % 3600000 / 60000);
        }

        private final void write(TextSyntax textSyntax) throws IOException {
            String string = ((Attribute)((Object)textSyntax)).getName();
            if (textSyntax instanceof RequestingUserName || textSyntax instanceof JobName || textSyntax instanceof DocumentName || textSyntax instanceof JobOriginatingUserName) {
                this.out.writeByte(66);
            } else if (textSyntax instanceof DocumentFormat) {
                this.out.writeByte(73);
            } else {
                this.out.writeByte(65);
            }
            this.out.writeShort(string.length());
            this.out.write(string.getBytes());
            this.out.writeShort(textSyntax.getValue().length());
            this.out.write(textSyntax.getValue().getBytes());
        }

        private final void write(URISyntax uRISyntax) throws IOException {
            String string = ((Attribute)((Object)uRISyntax)).getName();
            String string2 = uRISyntax.getURI().toASCIIString();
            this.out.writeByte(69);
            this.out.writeShort(string.length());
            this.out.write(string.getBytes());
            this.out.writeShort(string2.length());
            this.out.write(string2.getBytes());
        }

        private final void write(CharsetSyntax charsetSyntax) throws IOException {
            String string = ((Attribute)((Object)charsetSyntax)).getName();
            this.out.writeByte(71);
            this.out.writeShort(string.length());
            this.out.write(string.getBytes());
            this.out.writeShort(charsetSyntax.getValue().length());
            this.out.write(charsetSyntax.getValue().getBytes());
        }

        private final void write(NaturalLanguageSyntax naturalLanguageSyntax) throws IOException {
            String string = ((Attribute)((Object)naturalLanguageSyntax)).getName();
            this.out.writeByte(72);
            this.out.writeShort(string.length());
            this.out.write(string.getBytes());
            this.out.writeShort(naturalLanguageSyntax.getValue().length());
            this.out.write(naturalLanguageSyntax.getValue().getBytes());
        }

        private final void write(RequestedAttributes requestedAttributes) throws IOException {
            List list2 = requestedAttributes.getValues();
            String string = requestedAttributes.getName();
            this.out.writeByte(68);
            this.out.writeShort(string.length());
            this.out.write(string.getBytes());
            this.out.writeShort(((String)list2.get(0)).length());
            this.out.write(((String)list2.get(0)).getBytes());
            int n = 1;
            while (n < list2.size()) {
                this.out.writeByte(68);
                this.out.writeShort(0);
                this.out.writeShort(((String)list2.get(n)).length());
                this.out.write(((String)list2.get(n)).getBytes());
                ++n;
            }
        }

        public void writeOperationAttributes(AttributeSet attributeSet) throws IOException, IppException {
            this.out.write(1);
            Class clazz = class$gnu$javax$print$ipp$attribute$job$AttributesCharset;
            if (clazz == null) {
                clazz = class$gnu$javax$print$ipp$attribute$job$AttributesCharset = IppRequest.class("[Lgnu.javax.print.ipp.attribute.job.AttributesCharset;", false);
            }
            Attribute attribute = attributeSet.get(clazz);
            this.write((CharsetSyntax)((Object)attribute));
            logger.log(Component.IPP, "Attribute: Name: <" + attribute.getCategory().getName() + "> Value: <" + attribute.toString() + '>');
            Class clazz2 = class$gnu$javax$print$ipp$attribute$job$AttributesCharset;
            if (clazz2 == null) {
                clazz2 = class$gnu$javax$print$ipp$attribute$job$AttributesCharset = IppRequest.class("[Lgnu.javax.print.ipp.attribute.job.AttributesCharset;", false);
            }
            attributeSet.remove(clazz2);
            Class clazz3 = class$gnu$javax$print$ipp$attribute$job$AttributesNaturalLanguage;
            if (clazz3 == null) {
                clazz3 = class$gnu$javax$print$ipp$attribute$job$AttributesNaturalLanguage = IppRequest.class("[Lgnu.javax.print.ipp.attribute.job.AttributesNaturalLanguage;", false);
            }
            attribute = attributeSet.get(clazz3);
            this.write((NaturalLanguageSyntax)((Object)attribute));
            Class clazz4 = class$gnu$javax$print$ipp$attribute$job$AttributesNaturalLanguage;
            if (clazz4 == null) {
                clazz4 = class$gnu$javax$print$ipp$attribute$job$AttributesNaturalLanguage = IppRequest.class("[Lgnu.javax.print.ipp.attribute.job.AttributesNaturalLanguage;", false);
            }
            attributeSet.remove(clazz4);
            logger.log(Component.IPP, "Attribute: Name: <" + attribute.getCategory().getName() + "> Value: <" + attribute.toString() + '>');
            Class clazz5 = class$javax$print$attribute$standard$PrinterURI;
            if (clazz5 == null) {
                clazz5 = class$javax$print$attribute$standard$PrinterURI = IppRequest.class("[Ljavax.print.attribute.standard.PrinterURI;", false);
            }
            PrinterURI printerURI = (PrinterURI)attributeSet.get(clazz5);
            Class clazz6 = class$gnu$javax$print$ipp$attribute$job$JobUri;
            if (clazz6 == null) {
                clazz6 = class$gnu$javax$print$ipp$attribute$job$JobUri = IppRequest.class("[Lgnu.javax.print.ipp.attribute.job.JobUri;", false);
            }
            JobUri jobUri = (JobUri)attributeSet.get(clazz6);
            Class clazz7 = class$gnu$javax$print$ipp$attribute$job$JobId;
            if (clazz7 == null) {
                clazz7 = class$gnu$javax$print$ipp$attribute$job$JobId = IppRequest.class("[Lgnu.javax.print.ipp.attribute.job.JobId;", false);
            }
            JobId jobId = (JobId)attributeSet.get(clazz7);
            if (printerURI != null && jobId == null && jobUri == null) {
                this.write(printerURI);
                Class clazz8 = class$javax$print$attribute$standard$PrinterURI;
                if (clazz8 == null) {
                    clazz8 = class$javax$print$attribute$standard$PrinterURI = IppRequest.class("[Ljavax.print.attribute.standard.PrinterURI;", false);
                }
                attributeSet.remove(clazz8);
                logger.log(Component.IPP, "Attribute: Name: <" + printerURI.getCategory().getName() + "> Value: <" + printerURI.toString() + '>');
            } else if (jobUri != null && jobId == null && printerURI == null) {
                this.write(jobUri);
                Class clazz9 = class$gnu$javax$print$ipp$attribute$job$JobUri;
                if (clazz9 == null) {
                    clazz9 = class$gnu$javax$print$ipp$attribute$job$JobUri = IppRequest.class("[Lgnu.javax.print.ipp.attribute.job.JobUri;", false);
                }
                attributeSet.remove(clazz9);
                logger.log(Component.IPP, "Attribute: Name: <" + jobUri.getCategory().getName() + "> Value: <" + jobUri.toString() + '>');
            } else if (printerURI != null && jobId != null && jobUri == null) {
                this.write(printerURI);
                this.write(jobId);
                Class clazz10 = class$javax$print$attribute$standard$PrinterURI;
                if (clazz10 == null) {
                    clazz10 = class$javax$print$attribute$standard$PrinterURI = IppRequest.class("[Ljavax.print.attribute.standard.PrinterURI;", false);
                }
                attributeSet.remove(clazz10);
                Class clazz11 = class$gnu$javax$print$ipp$attribute$job$JobId;
                if (clazz11 == null) {
                    clazz11 = class$gnu$javax$print$ipp$attribute$job$JobId = IppRequest.class("[Lgnu.javax.print.ipp.attribute.job.JobId;", false);
                }
                attributeSet.remove(clazz11);
                logger.log(Component.IPP, "Attribute: Name: <" + printerURI.getCategory().getName() + "> Value: <" + printerURI.toString() + '>');
                logger.log(Component.IPP, "Attribute: Name: <" + jobId.getCategory().getName() + "> Value: <" + jobId.toString() + '>');
            } else if (jobUri != null && jobId != null) {
                this.write(jobUri);
                Class clazz12 = class$gnu$javax$print$ipp$attribute$job$JobUri;
                if (clazz12 == null) {
                    clazz12 = class$gnu$javax$print$ipp$attribute$job$JobUri = IppRequest.class("[Lgnu.javax.print.ipp.attribute.job.JobUri;", false);
                }
                attributeSet.remove(clazz12);
                Class clazz13 = class$gnu$javax$print$ipp$attribute$job$JobId;
                if (clazz13 == null) {
                    clazz13 = class$gnu$javax$print$ipp$attribute$job$JobId = IppRequest.class("[Lgnu.javax.print.ipp.attribute.job.JobId;", false);
                }
                attributeSet.remove(clazz13);
                logger.log(Component.IPP, "Attribute: Name: <" + jobUri.getCategory().getName() + "> Value: <" + jobUri.toString() + '>');
            } else {
                new IppException("Unknown target operation attribute combination.");
            }
            this.writeAttributes(attributeSet);
        }

        public void writeAttributes(AttributeSet attributeSet) throws IOException, IppException {
            Attribute[] attributeArray = attributeSet.toArray();
            int n = 0;
            while (n < attributeArray.length) {
                logger.log(Component.IPP, "Attribute: Name: <" + attributeArray[n].getCategory().getName() + "> Value: <" + attributeArray[n].toString() + '>');
                if (attributeArray[n] instanceof IntegerSyntax) {
                    this.write((IntegerSyntax)((Object)attributeArray[n]));
                } else if (attributeArray[n] instanceof TextSyntax) {
                    this.write((TextSyntax)((Object)attributeArray[n]));
                } else if (attributeArray[n] instanceof DateTimeSyntax) {
                    this.write((DateTimeSyntax)((Object)attributeArray[n]));
                } else if (attributeArray[n] instanceof ResolutionSyntax) {
                    this.write((ResolutionSyntax)((Object)attributeArray[n]));
                } else if (attributeArray[n] instanceof SetOfIntegerSyntax) {
                    this.write((SetOfIntegerSyntax)((Object)attributeArray[n]));
                } else if (attributeArray[n] instanceof EnumSyntax) {
                    this.write((EnumSyntax)((Object)attributeArray[n]));
                } else if (attributeArray[n] instanceof URISyntax) {
                    this.write((URISyntax)((Object)attributeArray[n]));
                } else if (attributeArray[n] instanceof CharsetSyntax) {
                    this.write((CharsetSyntax)((Object)attributeArray[n]));
                } else if (attributeArray[n] instanceof NaturalLanguageSyntax) {
                    this.write((NaturalLanguageSyntax)((Object)attributeArray[n]));
                } else if (attributeArray[n] instanceof RequestedAttributes) {
                    this.write((RequestedAttributes)attributeArray[n]);
                } else {
                    throw new IppException("Unknown syntax type");
                }
                ++n;
            }
        }

        RequestWriter(DataOutputStream dataOutputStream) {
            this.out = dataOutputStream;
        }
    }
}

