/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.util.zip.Adler32;
import java.util.zip.DeflaterConstants;
import java.util.zip.DeflaterHuffman;
import java.util.zip.DeflaterPending;

class DeflaterEngine
implements DeflaterConstants {
    private static final int TOO_FAR = 4096;
    private int ins_h;
    private short[] head;
    private short[] prev;
    private int matchStart;
    private int matchLen;
    private boolean prevAvailable;
    private int blockStart;
    private int strstart;
    private int lookahead;
    private byte[] window;
    private int strategy;
    private int max_chain;
    private int max_lazy;
    private int niceLength;
    private int goodLength;
    private int comprFunc;
    private byte[] inputBuf;
    private int totalIn;
    private int inputOff;
    private int inputEnd;
    private DeflaterPending pending;
    private DeflaterHuffman huffman;
    private Adler32 adler;

    public void reset() {
        this.huffman.reset();
        this.adler.reset();
        this.strstart = 1;
        this.blockStart = 1;
        this.lookahead = 0;
        this.totalIn = 0;
        this.prevAvailable = false;
        this.matchLen = 2;
        int n = 0;
        while (n < 32768) {
            this.head[n] = 0;
            ++n;
        }
        n = 0;
        while (n < 32768) {
            this.prev[n] = 0;
            ++n;
        }
    }

    public final void resetAdler() {
        this.adler.reset();
    }

    public final int getAdler() {
        int n = (int)this.adler.getValue();
        return n;
    }

    public final int getTotalIn() {
        return this.totalIn;
    }

    public final void setStrategy(int n) {
        this.strategy = n;
    }

    public void setLevel(int n) {
        this.goodLength = DeflaterConstants.GOOD_LENGTH[n];
        this.max_lazy = DeflaterConstants.MAX_LAZY[n];
        this.niceLength = DeflaterConstants.NICE_LENGTH[n];
        this.max_chain = DeflaterConstants.MAX_CHAIN[n];
        if (DeflaterConstants.COMPR_FUNC[n] != this.comprFunc) {
            switch (this.comprFunc) {
                case 0: {
                    if (this.strstart > this.blockStart) {
                        this.huffman.flushStoredBlock(this.window, this.blockStart, this.strstart - this.blockStart, false);
                        this.blockStart = this.strstart;
                    }
                    this.updateHash();
                    break;
                }
                case 1: {
                    if (this.strstart <= this.blockStart) break;
                    this.huffman.flushBlock(this.window, this.blockStart, this.strstart - this.blockStart, false);
                    this.blockStart = this.strstart;
                    break;
                }
                case 2: {
                    if (this.prevAvailable) {
                        this.huffman.tallyLit(this.window[this.strstart - 1] & 0xFF);
                    }
                    if (this.strstart > this.blockStart) {
                        this.huffman.flushBlock(this.window, this.blockStart, this.strstart - this.blockStart, false);
                        this.blockStart = this.strstart;
                    }
                    this.prevAvailable = false;
                    this.matchLen = 2;
                    break;
                }
            }
            this.comprFunc = COMPR_FUNC[n];
        }
    }

    private final void updateHash() {
        this.ins_h = this.window[this.strstart] << 5 ^ this.window[this.strstart + 1];
    }

    private final int insertString() {
        short s;
        int n = (this.ins_h << 5 ^ this.window[this.strstart + 2]) & Short.MAX_VALUE;
        this.prev[this.strstart & Short.MAX_VALUE] = s = this.head[n];
        this.head[n] = (short)this.strstart;
        this.ins_h = n;
        return s & (char)-1;
    }

    private final void slideWindow() {
        int n;
        System.arraycopy(this.window, 32768, this.window, 0, 32768);
        this.matchStart -= 32768;
        this.strstart -= 32768;
        this.blockStart -= 32768;
        int n2 = 0;
        while (n2 < 32768) {
            n = this.head[n2] & (char)-1;
            short s = 0;
            if (n >= 32768) {
                s = (short)(n - 32768);
            }
            this.head[n2] = s;
            ++n2;
        }
        n2 = 0;
        while (n2 < 32768) {
            n = this.prev[n2] & (char)-1;
            short s = 0;
            if (n >= 32768) {
                s = (short)(n - 32768);
            }
            this.prev[n2] = s;
            ++n2;
        }
    }

    private final void fillWindow() {
        if (this.strstart >= 65274) {
            this.slideWindow();
        }
        while (this.lookahead < 262 && this.inputOff < this.inputEnd) {
            int n = 65536 - this.lookahead - this.strstart;
            if (n > this.inputEnd - this.inputOff) {
                n = this.inputEnd - this.inputOff;
            }
            System.arraycopy(this.inputBuf, this.inputOff, this.window, this.strstart + this.lookahead, n);
            this.adler.update(this.inputBuf, this.inputOff, n);
            this.inputOff += n;
            this.totalIn += n;
            this.lookahead += n;
        }
        if (this.lookahead >= 3) {
            this.updateHash();
        }
    }

    private final boolean findLongestMatch(int n) {
        int n2 = this.max_chain;
        int n3 = this.niceLength;
        short[] sArray = this.prev;
        int n4 = this.strstart;
        int n5 = this.strstart + this.matchLen;
        int n6 = Math.max(this.matchLen, 2);
        int n7 = Math.max(this.strstart - 32506, 0);
        int n8 = n4 + 258 - 1;
        byte by = this.window[n5 - 1];
        byte by2 = this.window[n5];
        if (n6 >= this.goodLength) {
            n2 >>= 2;
        }
        if (n3 > this.lookahead) {
            n3 = this.lookahead;
        }
        do {
            if (this.window[n + n6] != by2 || this.window[n + n6 - 1] != by || this.window[n] != this.window[n4] || this.window[n + 1] != this.window[n4 + 1]) continue;
            int n9 = n + 2;
            n4 += 2;
            while (this.window[++n4] == this.window[++n9] && this.window[++n4] == this.window[++n9] && this.window[++n4] == this.window[++n9] && this.window[++n4] == this.window[++n9] && this.window[++n4] == this.window[++n9] && this.window[++n4] == this.window[++n9] && this.window[++n4] == this.window[++n9] && this.window[++n4] == this.window[++n9] && n4 < n8) {
            }
            if (n4 > n5) {
                this.matchStart = n;
                n5 = n4;
                n6 = n4 - this.strstart;
                if (n6 >= n3) break;
                by = this.window[n5 - 1];
                by2 = this.window[n5];
            }
            n4 = this.strstart;
        } while ((n = sArray[n & Short.MAX_VALUE] & (char)-1) > n7 && --n2 != 0);
        this.matchLen = Math.min(n6, this.lookahead);
        boolean bl = false;
        if (this.matchLen >= 3) {
            bl = true;
        }
        return bl;
    }

    void setDictionary(byte[] byArray, int n, int n2) {
        this.adler.update(byArray, n, n2);
        if (n2 < 3) {
            return;
        }
        if (n2 > 32506) {
            n += n2 - 32506;
            n2 = 32506;
        }
        System.arraycopy(byArray, n, this.window, this.strstart, n2);
        this.updateHash();
        --n2;
        while (--n2 > 0) {
            this.insertString();
            ++this.strstart;
        }
        this.strstart += 2;
        this.blockStart = this.strstart;
    }

    private final boolean deflateStored(boolean bl, boolean bl2) {
        if (!bl && this.lookahead == 0) {
            return false;
        }
        this.strstart += this.lookahead;
        this.lookahead = 0;
        int n = this.strstart - this.blockStart;
        if (n >= DeflaterConstants.MAX_BLOCK_SIZE || this.blockStart < 32768 && n >= 32506 || bl) {
            boolean bl3 = bl2;
            if (n > DeflaterConstants.MAX_BLOCK_SIZE) {
                n = DeflaterConstants.MAX_BLOCK_SIZE;
                bl3 = false;
            }
            this.huffman.flushStoredBlock(this.window, this.blockStart, n, bl3);
            this.blockStart += n;
            return bl3 ^ true;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private final boolean deflateFast(boolean var1_1, boolean var2_2) {
        if (this.lookahead >= 262 || var1_1) ** GOTO lbl38
        return false;
lbl-1000:
        // 1 sources

        {
            if (this.lookahead == 0) {
                this.huffman.flushBlock(this.window, this.blockStart, this.strstart - this.blockStart, var2_2);
                this.blockStart = this.strstart;
                return false;
            }
            if (this.strstart > 65274) {
                this.slideWindow();
            }
            if (this.lookahead >= 3 && (var3_3 = this.insertString()) != 0 && this.strategy != 2 && this.strstart - var3_3 <= 32506 && this.findLongestMatch(var3_3)) {
                this.huffman.tallyDist(this.strstart - this.matchStart, this.matchLen);
                this.lookahead -= this.matchLen;
                if (this.matchLen <= this.max_lazy && this.lookahead >= 3) {
                    while (--this.matchLen > 0) {
                        ++this.strstart;
                        this.insertString();
                    }
                    ++this.strstart;
                } else {
                    this.strstart += this.matchLen;
                    if (this.lookahead >= 2) {
                        this.updateHash();
                    }
                }
                this.matchLen = 2;
                continue;
            }
            this.huffman.tallyLit(this.window[this.strstart] & 255);
            ++this.strstart;
            --this.lookahead;
            if (!this.huffman.isFull()) continue;
            v0 = false;
            if (var2_2 && this.lookahead == 0) {
                v0 = true;
            }
            var4_4 = v0;
            this.huffman.flushBlock(this.window, this.blockStart, this.strstart - this.blockStart, var4_4);
            this.blockStart = this.strstart;
            return var4_4 ^ true;
lbl38:
            // 3 sources

            ** while (this.lookahead >= 262 || var1_1)
        }
lbl39:
        // 1 sources

        return true;
    }

    /*
     * Unable to fully structure code
     */
    private final boolean deflateSlow(boolean var1_1, boolean var2_2) {
        if (this.lookahead >= 262 || var1_1) ** GOTO lbl52
        return false;
lbl-1000:
        // 1 sources

        {
            if (this.lookahead == 0) {
                if (this.prevAvailable) {
                    this.huffman.tallyLit(this.window[this.strstart - 1] & 255);
                }
                this.prevAvailable = false;
                this.huffman.flushBlock(this.window, this.blockStart, this.strstart - this.blockStart, var2_2);
                this.blockStart = this.strstart;
                return false;
            }
            if (this.strstart >= 65274) {
                this.slideWindow();
            }
            var3_3 = this.matchStart;
            var4_4 = this.matchLen;
            if (this.lookahead >= 3) {
                var5_5 = this.insertString();
                if (this.strategy != 2 && var5_5 != 0 && this.strstart - var5_5 <= 32506 && this.findLongestMatch(var5_5) && this.matchLen <= 5 && (this.strategy == 1 || this.matchLen == 3 && this.strstart - this.matchStart > 4096)) {
                    this.matchLen = 2;
                }
            }
            if (var4_4 >= 3 && this.matchLen <= var4_4) {
                this.huffman.tallyDist(this.strstart - 1 - var3_3, var4_4);
                var4_4 -= 2;
                do {
                    ++this.strstart;
                    --this.lookahead;
                    if (this.lookahead < 3) continue;
                    this.insertString();
                } while (--var4_4 > 0);
                ++this.strstart;
                --this.lookahead;
                this.prevAvailable = false;
                this.matchLen = 2;
            } else {
                if (this.prevAvailable) {
                    this.huffman.tallyLit(this.window[this.strstart - 1] & 255);
                }
                this.prevAvailable = true;
                ++this.strstart;
                --this.lookahead;
            }
            if (!this.huffman.isFull()) continue;
            var5_5 = this.strstart - this.blockStart;
            if (this.prevAvailable) {
                --var5_5;
            }
            v0 = false;
            if (var2_2 && this.lookahead == 0 && !this.prevAvailable) {
                v0 = true;
            }
            var6_6 = v0;
            this.huffman.flushBlock(this.window, this.blockStart, var5_5, var6_6);
            this.blockStart += var5_5;
            return var6_6 ^ true;
lbl52:
            // 2 sources

            ** while (this.lookahead >= 262 || var1_1)
        }
lbl53:
        // 1 sources

        return true;
    }

    public boolean deflate(boolean bl, boolean bl2) {
        boolean bl3;
        do {
            this.fillWindow();
            boolean bl4 = false;
            if (bl && this.inputOff == this.inputEnd) {
                bl4 = true;
            }
            boolean bl5 = bl4;
            switch (this.comprFunc) {
                case 0: {
                    bl3 = this.deflateStored(bl5, bl2);
                    break;
                }
                case 1: {
                    bl3 = this.deflateFast(bl5, bl2);
                    break;
                }
                case 2: {
                    bl3 = this.deflateSlow(bl5, bl2);
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        } while (this.pending.isFlushed() && bl3);
        return bl3;
    }

    public void setInput(byte[] byArray, int n, int n2) {
        if (this.inputOff < this.inputEnd) {
            throw new IllegalStateException("Old input was not completely processed");
        }
        int n3 = n + n2;
        if (n < 0 || n > n3 || n3 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.inputBuf = byArray;
        this.inputOff = n;
        this.inputEnd = n3;
    }

    public final boolean needsInput() {
        boolean bl = false;
        if (this.inputEnd == this.inputOff) {
            bl = true;
        }
        return bl;
    }

    DeflaterEngine(DeflaterPending deflaterPending) {
        this.pending = deflaterPending;
        this.huffman = new DeflaterHuffman(deflaterPending);
        this.adler = new Adler32();
        this.window = new byte[65536];
        this.head = new short[32768];
        this.prev = new short[32768];
        this.strstart = 1;
        this.blockStart = 1;
    }
}

