require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&__HTM__)) {
    die("HTM instruction set not enabled");
}
unless(defined(&_HTMXLINTRIN_H)) {
    eval 'sub _HTMXLINTRIN_H () {1;}' unless defined(&_HTMXLINTRIN_H);
    require 'stdint.ph';
    require 'htmintrin.ph';
    if(defined(&__cplusplus)) {
    }
    eval 'sub _TEXASR_PTR {
        my($TM_BUF) = @_;
	    eval q((( &texasr_t *)(($TM_BUF)+0)));
    }' unless defined(&_TEXASR_PTR);
    eval 'sub _TEXASRU_PTR {
        my($TM_BUF) = @_;
	    eval q((( &texasru_t *)(($TM_BUF)+0)));
    }' unless defined(&_TEXASRU_PTR);
    eval 'sub _TEXASRL_PTR {
        my($TM_BUF) = @_;
	    eval q((( &texasrl_t *)(($TM_BUF)+4)));
    }' unless defined(&_TEXASRL_PTR);
    eval 'sub _TFIAR_PTR {
        my($TM_BUF) = @_;
	    eval q((( &tfiar_t *)(($TM_BUF)+8)));
    }' unless defined(&_TFIAR_PTR);
    eval 'sub _HTM_TBEGIN_STARTED () {1;}' unless defined(&_HTM_TBEGIN_STARTED);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &__TM_simple_begin ( &void) {  &if ( &__builtin_expect ( &__builtin_tbegin (0), 1))  &_HTM_TBEGIN_STARTED; 0; });
    }' unless defined(&__attribute__);
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &__TM_begin ( &void*  &const  &TM_buff) { * &_TEXASRL_PTR ( &TM_buff) = 0;  &if ( &__builtin_expect ( &__builtin_tbegin (0), 1))  &_HTM_TBEGIN_STARTED; * &_TFIAR_PTR ( &TM_buff) =  &__builtin_get_tfiar (); 0; });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &__TM_end ( &void) { my $status =  &_HTM_STATE ( &__builtin_tend (0));  &if ( &__builtin_expect ( $status,  &_HTM_TRANSACTIONAL)) 1; 0; });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &__TM_abort ( &void) {  &__builtin_tabort (0); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &__TM_named_abort  {  &__builtin_tabort ( &code); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &__TM_resume ( &void) {  &__builtin_tresume (); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &__TM_suspend ( &void) {  &__builtin_tsuspend (); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &__TM_is_user_abort ( &void*  &const  &TM_buff) {  &texasru_t  &texasru = * &_TEXASRU_PTR ( &TM_buff);  &_TEXASRU_ABORT ( &texasru); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &__TM_is_named_user_abort ( &void*  &const  &TM_buff, my $char * &code) {  &texasru_t  &texasru = * &_TEXASRU_PTR ( &TM_buff); * &code =  &_TEXASRU_FAILURE_CODE ( &texasru);  &_TEXASRU_ABORT ( &texasru); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &__TM_is_illegal ( &void*  &const  &TM_buff) {  &texasru_t  &texasru = * &_TEXASRU_PTR ( &TM_buff);  &_TEXASRU_DISALLOWED ( &texasru); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &__TM_is_footprint_exceeded ( &void*  &const  &TM_buff) {  &texasru_t  &texasru = * &_TEXASRU_PTR ( &TM_buff);  &_TEXASRU_FOOTPRINT_OVERFLOW ( &texasru); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &__TM_nesting_depth ( &void*  &const  &TM_buff) {  &texasrl_t  &texasrl;  &if ( &_HTM_STATE ( &__builtin_ttest ()) ==  &_HTM_NONTRANSACTIONAL) {  &texasrl = * &_TEXASRL_PTR ( &TM_buff);  &if (! &_TEXASR_FAILURE_SUMMARY ( &texasrl))  &texasrl = 0; }  &else  &texasrl = ( &texasrl_t)  &__builtin_get_texasr ();  &_TEXASR_TRANSACTION_LEVEL ( &texasrl); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &__TM_is_nested_too_deep( &void*  &const  &TM_buff) {  &texasru_t  &texasru = * &_TEXASRU_PTR ( &TM_buff);  &_TEXASRU_NESTING_OVERFLOW ( &texasru); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &__TM_is_conflict( &void*  &const  &TM_buff) {  &texasru_t  &texasru = * &_TEXASRU_PTR ( &TM_buff); ( &_TEXASRU_EXTRACT_BITS ( &texasru, 14, 4)) ? 1: 0; });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &__TM_is_failure_persistent( &void*  &const  &TM_buff) {  &texasru_t  &texasru = * &_TEXASRU_PTR ( &TM_buff);  &_TEXASRU_FAILURE_PERSISTENT ( &texasru); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &__TM_failure_address( &void*  &const  &TM_buff) { * &_TFIAR_PTR ( &TM_buff); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &__TM_failure_code( &void*  &const  &TM_buff) { * &_TEXASR_PTR ( &TM_buff); });
    }' unless defined(&__attribute__);
    if(defined(&__cplusplus)) {
    }
}
1;
